/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.authorization.validator;

import ch.systemsx.cisd.openbis.generic.server.authorization.validator.AbstractValidator;
import ch.systemsx.cisd.openbis.generic.shared.basic.ICodeHolder;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.RoleAssignmentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SpacePE;
import java.util.Set;

public class SimpleSpaceValidator
extends AbstractValidator<ICodeHolder> {
    @Override
    public boolean doValidation(PersonPE person, ICodeHolder value) {
        Set<RoleAssignmentPE> roleAssignments = person.getAllPersonRoles();
        String spaceCode = value.getCode();
        if (spaceCode == null && !roleAssignments.isEmpty()) {
            return true;
        }
        for (RoleAssignmentPE roleAssignment : roleAssignments) {
            if (roleAssignment.getRoleWithHierarchy().isInstanceLevel()) {
                return true;
            }
            SpacePE space = roleAssignment.getSpace();
            if (space == null || !space.getCode().equals(spaceCode)) continue;
            return true;
        }
        return false;
    }
}

