/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.batch;

import ch.systemsx.cisd.openbis.generic.server.batch.AbstractBatchOperation;
import ch.systemsx.cisd.openbis.generic.server.batch.IBatchOperationDelegate;
import ch.systemsx.cisd.openbis.generic.server.business.bo.IDataSetTable;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataSetBatchUpdatesDTO;
import java.util.List;

public class DataSetBatchUpdate
extends AbstractBatchOperation<DataSetBatchUpdatesDTO> {
    private final IDataSetTable businessTable;
    private final List<DataSetBatchUpdatesDTO> entities;

    public DataSetBatchUpdate(IDataSetTable businessTable, List<DataSetBatchUpdatesDTO> entities) {
        this(businessTable, entities, null);
    }

    public DataSetBatchUpdate(IDataSetTable businessTable, List<DataSetBatchUpdatesDTO> entities, IBatchOperationDelegate<DataSetBatchUpdatesDTO> delegate) {
        super(delegate);
        this.businessTable = businessTable;
        this.entities = entities;
    }

    @Override
    public void execute(List<DataSetBatchUpdatesDTO> updates) {
        this.businessTable.update(updates);
        this.batchOperationWillSave();
        this.businessTable.save();
        this.batchOperationDidSave();
    }

    @Override
    public List<DataSetBatchUpdatesDTO> getAllEntities() {
        return this.entities;
    }

    @Override
    public String getEntityName() {
        return "data set";
    }

    @Override
    public String getOperationName() {
        return "update";
    }
}

