/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.business;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.base.namedthread.NamingThreadPoolExecutor;
import ch.systemsx.cisd.common.concurrent.MonitoringProxy;
import ch.systemsx.cisd.common.logging.ISimpleLogger;
import ch.systemsx.cisd.common.logging.Log4jSimpleLogger;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.logging.LogLevel;
import ch.systemsx.cisd.common.spring.HttpInvokerUtils;
import ch.systemsx.cisd.common.time.TimingParameters;
import ch.systemsx.cisd.openbis.generic.server.business.IDataStoreServiceFactory;
import ch.systemsx.cisd.openbis.generic.shared.IDataStoreService;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.apache.log4j.Logger;
import org.springframework.remoting.RemoteAccessException;

public class DataStoreServiceFactory
implements IDataStoreServiceFactory {
    private static final int NUMBER_OF_CORE_THREADS = 10;
    private final Map<String, IDataStoreService> services = new HashMap<String, IDataStoreService>();
    private static final Logger machineLog = LogFactory.getLogger((LogCategory)LogCategory.MACHINE, IDataStoreService.class);
    private static final ExecutorService executorService = new NamingThreadPoolExecutor("Monitoring Proxy").corePoolSize(10).daemonize();

    @Override
    public IDataStoreService create(String serverURL) {
        return this.create(serverURL, 300000L);
    }

    @Override
    public IDataStoreService create(String serverURL, long timeout) {
        IDataStoreService service = this.services.get(serverURL);
        if (service == null) {
            service = (IDataStoreService)HttpInvokerUtils.createServiceStub(IDataStoreService.class, (String)(serverURL + "/" + "datastore_server/dss"), (long)timeout);
            this.services.put(serverURL, service);
        }
        return service;
    }

    @Override
    public IDataStoreService createMonitored(String serverURL, LogLevel logLevelForNotSuccessfulCalls) {
        try {
            return (IDataStoreService)MonitoringProxy.create(IDataStoreService.class, (Object)this.create(serverURL)).errorLog((ISimpleLogger)new Log4jSimpleLogger(machineLog)).logLevelForSuccessfulCalls(logLevelForNotSuccessfulCalls).logLevelForNotSuccessfulCalls(LogLevel.WARN).timing(TimingParameters.create((long)-1L, (int)5, (long)60000L)).exceptionClassSuitableForRetrying(RemoteAccessException.class).executorService(executorService).get();
        }
        catch (SecurityException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary((Exception)ex);
        }
    }
}

