/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.business;

import ch.systemsx.cisd.openbis.generic.server.authorization.annotation.AuthorizationGuard;
import ch.systemsx.cisd.openbis.generic.server.authorization.annotation.Capability;
import ch.systemsx.cisd.openbis.generic.server.authorization.annotation.RolesAllowed;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.DataPEPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.ExperimentPEOrNullPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.ExperimentPEPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.ProjectPEPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.SamplePEOrNullPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.SamplePEPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.SpacePEPredicate;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.RoleWithHierarchy;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.IAuthSession;
import ch.systemsx.cisd.openbis.generic.shared.dto.ProjectPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SamplePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SpacePE;
import java.util.Map;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public interface IRelationshipService {
    @Transactional(propagation=Propagation.MANDATORY)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ETL_SERVER, RoleWithHierarchy.PROJECT_POWER_USER})
    @Capability(value="ASSIGN_EXPERIMENT_TO_PROJECT")
    public void assignExperimentToProject(IAuthSession var1, @AuthorizationGuard(guardClass=ExperimentPEPredicate.class) ExperimentPE var2, @AuthorizationGuard(guardClass=ProjectPEPredicate.class) ProjectPE var3);

    @Transactional(propagation=Propagation.MANDATORY)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ETL_SERVER, RoleWithHierarchy.PROJECT_POWER_USER})
    @Capability(value="ASSIGN_SAMPLE_TO_PROJECT")
    public void assignSampleToProject(IAuthSession var1, @AuthorizationGuard(guardClass=SamplePEPredicate.class) SamplePE var2, @AuthorizationGuard(guardClass=ProjectPEPredicate.class) ProjectPE var3);

    @Transactional(propagation=Propagation.MANDATORY)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ETL_SERVER, RoleWithHierarchy.SPACE_POWER_USER})
    @Capability(value="ASSIGN_PROJECT_TO_SPACE")
    public void assignProjectToSpace(IAuthSession var1, @AuthorizationGuard(guardClass=ProjectPEPredicate.class) ProjectPE var2, @AuthorizationGuard(guardClass=SpacePEPredicate.class) SpacePE var3);

    @Transactional(propagation=Propagation.MANDATORY)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ETL_SERVER, RoleWithHierarchy.PROJECT_USER})
    @Capability(value="ASSIGN_SAMPLE_TO_EXPERIMENT")
    public void assignSampleToExperiment(IAuthSession var1, @AuthorizationGuard(guardClass=SamplePEPredicate.class) SamplePE var2, @AuthorizationGuard(guardClass=ExperimentPEPredicate.class) ExperimentPE var3);

    @Transactional(propagation=Propagation.MANDATORY)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ETL_SERVER, RoleWithHierarchy.PROJECT_POWER_USER})
    @Capability(value="UNASSIGN_SAMPLE_FROM_EXPERIMENT")
    public void checkCanUnassignSampleFromExperiment(IAuthSession var1, @AuthorizationGuard(guardClass=SamplePEPredicate.class) SamplePE var2);

    @Transactional(propagation=Propagation.MANDATORY)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ETL_SERVER, RoleWithHierarchy.PROJECT_POWER_USER})
    @Capability(value="UNASSIGN_SAMPLE_FROM_EXPERIMENT")
    public void unassignSampleFromExperiment(IAuthSession var1, @AuthorizationGuard(guardClass=SamplePEPredicate.class) SamplePE var2);

    @Transactional(propagation=Propagation.MANDATORY)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ETL_SERVER, RoleWithHierarchy.PROJECT_POWER_USER})
    @Capability(value="UNASSIGN_SAMPLE_FROM_PROJECT")
    public void unassignSampleFromProject(IAuthSession var1, @AuthorizationGuard(guardClass=SamplePEPredicate.class) SamplePE var2);

    @Transactional(propagation=Propagation.MANDATORY)
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_ETL_SERVER, RoleWithHierarchy.INSTANCE_ADMIN})
    @Capability(value="UNSHARE_SAMPLE")
    public void unshareSample(IAuthSession var1, @AuthorizationGuard(guardClass=SamplePEPredicate.class) SamplePE var2, @AuthorizationGuard(guardClass=SpacePEPredicate.class) SpacePE var3);

    @Transactional(propagation=Propagation.MANDATORY)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ETL_SERVER, RoleWithHierarchy.SPACE_POWER_USER})
    @Capability(value="ASSIGN_SAMPLE_TO_SPACE")
    public void assignSampleToSpace(IAuthSession var1, @AuthorizationGuard(guardClass=SamplePEPredicate.class) SamplePE var2, @AuthorizationGuard(guardClass=SpacePEPredicate.class) SpacePE var3);

    @Transactional(propagation=Propagation.MANDATORY)
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_ETL_SERVER, RoleWithHierarchy.INSTANCE_ADMIN})
    @Capability(value="SHARE_SAMPLE")
    public void shareSample(IAuthSession var1, @AuthorizationGuard(guardClass=SamplePEPredicate.class) SamplePE var2);

    @Transactional(propagation=Propagation.MANDATORY)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ETL_SERVER, RoleWithHierarchy.PROJECT_POWER_USER})
    @Capability(value="ASSIGN_DATASET_TO_EXPERIMENT")
    public void assignDataSetToExperiment(IAuthSession var1, @AuthorizationGuard(guardClass=DataPEPredicate.class) DataPE var2, @AuthorizationGuard(guardClass=ExperimentPEOrNullPredicate.class) ExperimentPE var3);

    @Transactional(propagation=Propagation.MANDATORY)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ETL_SERVER, RoleWithHierarchy.PROJECT_POWER_USER})
    @Capability(value="ASSIGN_DATASET_TO_SAMPLE")
    public void assignDataSetToSample(IAuthSession var1, @AuthorizationGuard(guardClass=DataPEPredicate.class) DataPE var2, @AuthorizationGuard(guardClass=SamplePEOrNullPredicate.class) SamplePE var3);

    @Transactional(propagation=Propagation.MANDATORY)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ETL_SERVER, RoleWithHierarchy.PROJECT_USER})
    @Capability(value="ADD_PARENT_TO_SAMPLE")
    public void addParentToSample(IAuthSession var1, @AuthorizationGuard(name="SAMPLE", guardClass=SamplePEPredicate.class) SamplePE var2, @AuthorizationGuard(name="PARENT", guardClass=SamplePEPredicate.class, rolesAllowed={RoleWithHierarchy.SPACE_ETL_SERVER, RoleWithHierarchy.PROJECT_USER}) SamplePE var3);

    @Transactional(propagation=Propagation.MANDATORY)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ETL_SERVER, RoleWithHierarchy.PROJECT_USER})
    @Capability(value="SET_SAMPLE_PARENT_CHILD_ANNOTATIONS")
    public void setSampleParentChildAnnotations(IAuthSession var1, @AuthorizationGuard(name="CHILD", guardClass=SamplePEPredicate.class) SamplePE var2, @AuthorizationGuard(name="PARENT", guardClass=SamplePEPredicate.class, rolesAllowed={RoleWithHierarchy.SPACE_ETL_SERVER, RoleWithHierarchy.PROJECT_USER}) SamplePE var3, Map<String, String> var4, Map<String, String> var5);

    @Transactional(propagation=Propagation.MANDATORY)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ETL_SERVER, RoleWithHierarchy.PROJECT_POWER_USER})
    @Capability(value="REMOVE_PARENT_FROM_SAMPLE")
    public void removeParentFromSample(IAuthSession var1, @AuthorizationGuard(name="SAMPLE", guardClass=SamplePEPredicate.class) SamplePE var2, @AuthorizationGuard(name="PARENT", guardClass=SamplePEPredicate.class, rolesAllowed={RoleWithHierarchy.SPACE_ETL_SERVER, RoleWithHierarchy.PROJECT_USER}) SamplePE var3);

    @Transactional(propagation=Propagation.MANDATORY)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ETL_SERVER, RoleWithHierarchy.PROJECT_POWER_USER})
    @Capability(value="ADD_CONTAINER_TO_SAMPLE")
    public void assignSampleToContainer(IAuthSession var1, @AuthorizationGuard(guardClass=SamplePEPredicate.class) SamplePE var2, @AuthorizationGuard(guardClass=SamplePEPredicate.class) SamplePE var3);

    @Transactional(propagation=Propagation.MANDATORY)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ETL_SERVER, RoleWithHierarchy.PROJECT_POWER_USER})
    @Capability(value="REMOVE_CONTAINER_FROM_SAMPLE")
    public void removeSampleFromContainer(IAuthSession var1, @AuthorizationGuard(guardClass=SamplePEPredicate.class) SamplePE var2);

    @Transactional(propagation=Propagation.MANDATORY)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ETL_SERVER, RoleWithHierarchy.PROJECT_POWER_USER})
    @Capability(value="ADD_PARENT_TO_DATASET")
    public void addParentToDataSet(IAuthSession var1, @AuthorizationGuard(guardClass=DataPEPredicate.class) DataPE var2, @AuthorizationGuard(guardClass=DataPEPredicate.class) DataPE var3);

    @Transactional(propagation=Propagation.MANDATORY)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ETL_SERVER, RoleWithHierarchy.PROJECT_POWER_USER})
    @Capability(value="REMOVE_PARENT_FROM_DATASET")
    public void removeParentFromDataSet(IAuthSession var1, @AuthorizationGuard(guardClass=DataPEPredicate.class) DataPE var2, @AuthorizationGuard(guardClass=DataPEPredicate.class) DataPE var3);

    @Transactional(propagation=Propagation.MANDATORY)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ETL_SERVER, RoleWithHierarchy.PROJECT_POWER_USER})
    @Capability(value="ADD_CONTAINER_TO_DATASET")
    public void assignDataSetToContainer(IAuthSession var1, @AuthorizationGuard(guardClass=DataPEPredicate.class) DataPE var2, @AuthorizationGuard(guardClass=DataPEPredicate.class) DataPE var3);

    @Transactional(propagation=Propagation.MANDATORY)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ETL_SERVER, RoleWithHierarchy.PROJECT_POWER_USER})
    @Capability(value="REMOVE_CONTAINER_FROM_DATASET")
    public void removeDataSetFromContainer(IAuthSession var1, @AuthorizationGuard(guardClass=DataPEPredicate.class) DataPE var2, @AuthorizationGuard(guardClass=DataPEPredicate.class) DataPE var3);
}

