/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.business;

import ch.systemsx.cisd.common.jython.evaluator.EvaluatorException;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ScriptPE;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class PropertiesBatchEvaluationErrors {
    static final int MAX_ERROR_DETAILS_KEPT = 10;
    static final int MAX_ERRORS_IN_USER_MESSAGE = 2;
    private PersonPE registrator;
    private Map<String, ErrorDetail> errorDetails = new HashMap<String, ErrorDetail>();
    private int totalRowsNumber;
    private int totalFailedRowsNumber;

    PropertiesBatchEvaluationErrors(PersonPE registrator, int totalRowsNumber) {
        this.registrator = registrator;
        this.totalRowsNumber = totalRowsNumber;
    }

    void accumulateError(int row, EvaluatorException evaluationError, String propertyCode, ScriptPE script) {
        ++this.totalFailedRowsNumber;
        String errorMessage = this.getErrorMessage(evaluationError);
        if (this.shouldSkipDetailsAccumulation(errorMessage)) {
            return;
        }
        ErrorDetail details = this.errorDetails.get(errorMessage);
        if (details == null) {
            details = new ErrorDetail();
            details.evaluationError = evaluationError;
            details.scriptPE = script;
            details.propertyCode = propertyCode;
        }
        details.rows.add(row);
        this.errorDetails.put(errorMessage, details);
    }

    private String getErrorMessage(EvaluatorException evaluationError) {
        String result = null;
        if (evaluationError.getCause() != null) {
            return evaluationError.getCause().getMessage();
        }
        result = evaluationError.getMessage();
        if (result == null) {
            return "";
        }
        return result;
    }

    boolean shouldSkipDetailsAccumulation(String errorMessage) {
        return !this.errorDetails.containsKey(errorMessage) && this.errorDetails.size() >= 10;
    }

    boolean hasErrors() {
        return this.totalFailedRowsNumber > 0;
    }

    String constructUserFailureMessage() {
        assert (this.hasErrors()) : "Cannot construct message when no errors were accumulated.";
        StringBuilder message = new StringBuilder();
        message.append("Script malfunction in ");
        message.append(this.totalFailedRowsNumber);
        message.append(" out of ");
        message.append(this.totalRowsNumber);
        message.append(" rows.");
        ArrayList<String> errorMessageLines = new ArrayList<String>();
        HashMap<String, ArrayList<Integer>> failedRows = new HashMap<String, ArrayList<Integer>>();
        for (ErrorDetail errDetails : this.errorDetails.values()) {
            String msgLine = this.createUserFailureMsgLine(errDetails);
            if (errorMessageLines.contains(msgLine)) {
                List accumulatedRows = (List)failedRows.get(msgLine);
                accumulatedRows.addAll(errDetails.rows);
                continue;
            }
            errorMessageLines.add(msgLine);
            failedRows.put(msgLine, new ArrayList<Integer>(errDetails.rows));
        }
        for (String msgLine : errorMessageLines) {
            message.append("\n");
            List rows = (List)failedRows.get(msgLine);
            message.append(this.formatRows(rows));
            message.append(msgLine);
        }
        message.append("\n");
        message.append("A detailed error report has been sent to your system administrator.");
        return message.toString();
    }

    String constructErrorReportEmail() {
        assert (this.hasErrors()) : "Cannot construct message when no errors were accumulated.";
        StringBuilder message = new StringBuilder();
        message.append("A batch operation initiated from user ");
        message.append(this.registrator);
        message.append("has failed due to a script malfunction in ");
        message.append(this.totalFailedRowsNumber);
        message.append(" out of ");
        message.append(this.totalRowsNumber);
        message.append(" rows.");
        message.append("\n");
        for (ErrorDetail errDetail : this.sortErrorDetailsByRow()) {
            message.append("\n\n- ");
            message.append(this.formatRows(errDetail.rows));
            this.appendErrorDetails(message, errDetail, true);
            message.append(":\n");
            StringWriter sw = new StringWriter();
            errDetail.evaluationError.printStackTrace(new PrintWriter(sw));
            message.append(sw.toString());
        }
        return message.toString();
    }

    private List<ErrorDetail> sortErrorDetailsByRow() {
        ArrayList<ErrorDetail> result = new ArrayList<ErrorDetail>(this.errorDetails.values());
        Collections.sort(result, new Comparator<ErrorDetail>(){

            @Override
            public int compare(ErrorDetail o1, ErrorDetail o2) {
                return o1.rows.get(0) - o2.rows.get(0);
            }
        });
        return result;
    }

    private String createUserFailureMsgLine(ErrorDetail details) {
        StringBuilder builder = new StringBuilder();
        this.appendErrorDetails(builder, details, false);
        return builder.toString();
    }

    private void appendErrorDetails(StringBuilder message, ErrorDetail errDetail, boolean includeFullRegistratorDetails) {
        message.append(" failed due to the property '");
        message.append(errDetail.propertyCode);
        message.append("' causing a malfuction in the script (name = '");
        message.append(errDetail.scriptPE.getName());
        message.append("', registrator = '");
        if (errDetail.scriptPE.getRegistrator() != null) {
            if (includeFullRegistratorDetails) {
                message.append(errDetail.scriptPE.getRegistrator());
            } else {
                message.append(errDetail.scriptPE.getRegistrator().getEmail());
            }
        }
        message.append("')");
    }

    private String formatRows(List<Integer> rows) {
        if (rows.size() == 1) {
            return "Row " + rows.get(0) + " has";
        }
        int displayRows = Math.min(rows.size(), 3);
        Collections.sort(rows);
        List<Integer> displayRowsList = rows.subList(0, displayRows);
        if (displayRows == rows.size()) {
            return "Rows " + displayRowsList + " have";
        }
        return rows.size() + " rows including " + displayRowsList + " have";
    }

    private class ErrorDetail {
        ScriptPE scriptPE;
        EvaluatorException evaluationError;
        String propertyCode;
        List<Integer> rows = new ArrayList<Integer>();

        private ErrorDetail() {
        }
    }
}

