/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.business;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.jython.evaluator.EvaluatorException;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.openbis.generic.server.business.IPropertiesBatchManager;
import ch.systemsx.cisd.openbis.generic.server.business.PropertiesBatchEvaluationErrors;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataTypeCode;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IEntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IPropertiesBean;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ManagedProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewBasicExperiment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewDataSet;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewMaterial;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewSample;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PropertyType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.api.IPerson;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.api.ValidationException;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataSetTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataSetTypePropertyTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.EntityTypePropertyTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentTypePropertyTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.MaterialTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.MaterialTypePropertyTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SampleTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SampleTypePropertyTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ScriptPE;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.IManagedPropertyEvaluatorFactory;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.ManagedPropertyFunctions;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.api.IManagedPropertyEvaluator;
import ch.systemsx.cisd.openbis.generic.shared.translator.PersonTranslator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class PropertiesBatchManager
implements IPropertiesBatchManager {
    private final Logger notificationLog = LogFactory.getLogger((LogCategory)LogCategory.NOTIFY, this.getClass());
    private final IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory;

    public PropertiesBatchManager(IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory) {
        this.managedPropertyEvaluatorFactory = managedPropertyEvaluatorFactory;
    }

    @Override
    public void manageProperties(SampleTypePE sampleType, List<NewSample> samples, PersonPE registrator) {
        Set<SampleTypePropertyTypePE> sampleTypePropertyTypes = sampleType.getSampleTypePropertyTypes();
        this.managePropertiesBeans(samples, sampleTypePropertyTypes, registrator);
    }

    @Override
    public void manageProperties(ExperimentTypePE experimentType, List<? extends NewBasicExperiment> experiments, PersonPE registrator) {
        Set<ExperimentTypePropertyTypePE> entityTypePropertyTypes = experimentType.getExperimentTypePropertyTypes();
        this.managePropertiesBeans(experiments, entityTypePropertyTypes, registrator);
    }

    @Override
    public void manageProperties(MaterialTypePE materialType, List<NewMaterial> materials, PersonPE registrator) {
        Set<MaterialTypePropertyTypePE> entityTypePropertyTypes = materialType.getMaterialTypePropertyTypes();
        this.managePropertiesBeans(materials, entityTypePropertyTypes, registrator);
    }

    @Override
    public void manageProperties(DataSetTypePE dataSetType, List<NewDataSet> dataSets, PersonPE registrator) {
        Set<DataSetTypePropertyTypePE> entityTypePropertyTypes = dataSetType.getDataSetTypePropertyTypes();
        this.managePropertiesBeans(dataSets, entityTypePropertyTypes, registrator);
    }

    private void managePropertiesBeans(List<? extends IPropertiesBean> propertiesBeans, Set<? extends EntityTypePropertyTypePE> entityTypePropertyTypes, PersonPE registrator) {
        Map<String, EvaluationContext> contexts = this.createEvaluationContexts(entityTypePropertyTypes);
        PropertiesBatchEvaluationErrors errors = new PropertiesBatchEvaluationErrors(registrator, propertiesBeans.size());
        IPerson person = PersonTranslator.translateToIPerson(registrator);
        int rowNumber = 0;
        for (IPropertiesBean iPropertiesBean : propertiesBeans) {
            List<IEntityProperty> newProperties = this.accumulateNewProperties(iPropertiesBean, person, ++rowNumber, contexts, errors);
            IEntityProperty[] newPropArray = newProperties.toArray(new IEntityProperty[newProperties.size()]);
            iPropertiesBean.setProperties(newPropArray);
        }
        if (errors.hasErrors()) {
            this.notificationLog.error((Object)errors.constructErrorReportEmail());
            throw new UserFailureException(errors.constructUserFailureMessage());
        }
    }

    private List<IEntityProperty> accumulateNewProperties(IPropertiesBean propertiesBean, IPerson person, int rowNumber, Map<String, EvaluationContext> contexts, PropertiesBatchEvaluationErrors errors) {
        ArrayList<IEntityProperty> newProperties = new ArrayList<IEntityProperty>();
        Map<String, Map<String, String>> subColumnBindings = this.createColumnBindingsMap(propertiesBean.getProperties(), contexts);
        for (Map.Entry<String, Map<String, String>> entry : subColumnBindings.entrySet()) {
            String code = entry.getKey();
            EvaluationContext evalContext = contexts.get(code);
            try {
                EntityProperty entityProperty = this.evaluateManagedProperty(code, person, entry.getValue(), evalContext);
                if (ManagedProperty.isSpecialValue(entityProperty.getValue())) continue;
                newProperties.add(entityProperty);
            }
            catch (EvaluatorException ex) {
                Throwable cause = ex.getCause();
                if (cause instanceof ValidationException) {
                    throw new UserFailureException("Error in row " + rowNumber + ": " + cause.getMessage());
                }
                errors.accumulateError(rowNumber, ex, code, evalContext.scriptPEorNull);
            }
        }
        return newProperties;
    }

    private EntityProperty evaluateManagedProperty(String code, IPerson person, Map<String, String> bindings, EvaluationContext evalContext) {
        EntityProperty entityProperty = this.createNewEntityProperty(code);
        if (evalContext == null) {
            entityProperty.setValue(bindings.get(""));
        } else {
            IManagedPropertyEvaluator evaluator = evalContext.evaluator;
            ManagedProperty managedProperty = new ManagedProperty();
            managedProperty.setPropertyTypeCode(code);
            evaluator.updateFromBatchInput(managedProperty, person, bindings);
            entityProperty.setValue(managedProperty.getValue());
        }
        return entityProperty;
    }

    private EntityProperty createNewEntityProperty(String code) {
        EntityProperty entityProperty = new EntityProperty();
        PropertyType propertyType = new PropertyType();
        propertyType.setCode(code);
        propertyType.setDataType(new DataType(DataTypeCode.VARCHAR));
        entityProperty.setPropertyType(propertyType);
        return entityProperty;
    }

    private Map<String, Map<String, String>> createColumnBindingsMap(IEntityProperty[] properties, Map<String, EvaluationContext> contexts) {
        HashMap<String, Map<String, String>> subColumnBindings = new HashMap<String, Map<String, String>>();
        HashMap<String, String> originalColumnBindings = new HashMap<String, String>();
        for (IEntityProperty property : properties) {
            HashMap<String, String> bindings;
            String code = property.getPropertyType().getCode().toUpperCase();
            String value = property.getValue();
            originalColumnBindings.put(ManagedPropertyFunctions.originalColumnNameBindingKey(code), value);
            int indexOfColon = code.indexOf(58);
            String propertyCode = code;
            String subColumn = "";
            if (indexOfColon >= 0) {
                propertyCode = code.substring(0, indexOfColon);
                subColumn = code.substring(indexOfColon + 1);
            }
            if ((bindings = (HashMap<String, String>)subColumnBindings.get(propertyCode)) == null) {
                bindings = new HashMap<String, String>();
                subColumnBindings.put(propertyCode, bindings);
            }
            bindings.put(subColumn, value);
        }
        for (Map map : subColumnBindings.values()) {
            for (Map.Entry originalColumnEntry : originalColumnBindings.entrySet()) {
                map.put((String)originalColumnEntry.getKey(), (String)originalColumnEntry.getValue());
            }
        }
        for (Map.Entry entry : contexts.entrySet()) {
            String code = ((String)entry.getKey()).toUpperCase();
            if (subColumnBindings.containsKey(code)) continue;
            subColumnBindings.put(code, new HashMap(originalColumnBindings));
        }
        return subColumnBindings;
    }

    private Map<String, EvaluationContext> createEvaluationContexts(Set<? extends EntityTypePropertyTypePE> entityTypePropertyTypes) {
        HashMap<String, EvaluationContext> result = new HashMap<String, EvaluationContext>();
        for (EntityTypePropertyTypePE entityTypePropertyTypePE : entityTypePropertyTypes) {
            if (!entityTypePropertyTypePE.isManaged()) continue;
            String propertyTypeCode = entityTypePropertyTypePE.getPropertyType().getCode();
            EvaluationContext context = new EvaluationContext();
            context.evaluator = this.managedPropertyEvaluatorFactory.createManagedPropertyEvaluator(entityTypePropertyTypePE);
            context.scriptPEorNull = entityTypePropertyTypePE.getScript();
            result.put(propertyTypeCode, context);
        }
        return result;
    }

    private static class EvaluationContext {
        IManagedPropertyEvaluator evaluator;
        ScriptPE scriptPEorNull;

        private EvaluationContext() {
        }
    }
}

