/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.business;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.server.business.IRelationshipService;
import ch.systemsx.cisd.openbis.generic.server.business.bo.util.SampleUtils;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.RelationshipUtils;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.DAOFactory;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataSetRelationshipPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.IAuthSession;
import ch.systemsx.cisd.openbis.generic.shared.dto.IModifierAndModificationDateBean;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ProjectPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.RelationshipTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SamplePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SampleRelationshipPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SpacePE;
import ch.systemsx.cisd.openbis.generic.shared.util.EntityHelper;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class RelationshipService
implements IRelationshipService,
ApplicationContextAware {
    private static final String ERR_SAMPLE_PARENT_RELATIONSHIP_NOT_FOUND = "Sample '%s' did not have parent '%s'";
    private static final String ERR_DATASET_PARENT_RELATIONSHIP_NOT_FOUND = "DataSet '%s' did not have parent '%s'";
    private static final String ERR_DATASET_CONTAINER_RELATIONSHIP_NOT_FOUND = "DataSet '%s' did not have container '%s'";
    private DAOFactory daoFactory;
    private IRelationshipService service;
    private ApplicationContext applicationContext;

    @PostConstruct
    private void init() {
        this.service = (IRelationshipService)this.applicationContext.getBean("relationship-service", IRelationshipService.class);
    }

    @Override
    public void assignExperimentToProject(IAuthSession session, ExperimentPE experiment, ProjectPE project) {
        Date timeStamp = this.getTransactionTimeStamp();
        SampleUtils.setSamplesSpace(experiment, project.getSpace());
        for (SamplePE sample : experiment.getSamples()) {
            ProjectPE sampleProject = sample.getProject();
            if (sampleProject == null || EntityHelper.equalEntities(sampleProject, project)) continue;
            sample.setProject(project);
            RelationshipUtils.updateModificationDateAndModifier((IModifierAndModificationDateBean)sample, session, timeStamp);
        }
        ProjectPE previousProject = experiment.getProject();
        RelationshipUtils.updateModificationDateAndModifier((IModifierAndModificationDateBean)previousProject, session, timeStamp);
        experiment.setProject(project);
        RelationshipUtils.updateModificationDateAndModifier((IModifierAndModificationDateBean)project, session, timeStamp);
        RelationshipUtils.updateModificationDateAndModifier((IModifierAndModificationDateBean)experiment, session, timeStamp);
    }

    @Override
    public void assignSampleToProject(IAuthSession session, SamplePE sample, ProjectPE project) {
        if (SamplePE.projectSamplesEnabled) {
            Date timeStamp = this.getTransactionTimeStamp();
            ProjectPE previousProject = sample.getProject();
            RelationshipUtils.updateModificationDateAndModifier((IModifierAndModificationDateBean)previousProject, session, timeStamp);
            sample.setProject(project);
            RelationshipUtils.updateModificationDateAndModifier((IModifierAndModificationDateBean)project, session, timeStamp);
            RelationshipUtils.updateModificationDateAndModifier((IModifierAndModificationDateBean)sample, session, timeStamp);
        } else if (!(project == null || sample.getExperiment() != null && sample.getExperiment().getProject().equals(project))) {
            SampleUtils.assertProjectSamplesEnabled(sample, project);
        }
    }

    @Override
    public void assignProjectToSpace(IAuthSession session, ProjectPE project, SpacePE space) {
        project.setSpace(space);
        for (ExperimentPE experiment : project.getExperiments()) {
            SampleUtils.setSamplesSpace(experiment, space);
        }
        List<SamplePE> samples = project.getSamples();
        for (SamplePE sample : samples) {
            sample.setSpace(space);
        }
    }

    @Override
    public void assignSampleToExperiment(IAuthSession session, SamplePE sample, ExperimentPE experiment) {
        Date timeStamp = this.getTransactionTimeStamp();
        ExperimentPE currentExperiment = sample.getExperiment();
        ProjectPE currentProject = sample.getProject();
        if (currentExperiment != null && !currentExperiment.equals(experiment)) {
            this.service.checkCanUnassignSampleFromExperiment(session, sample);
            currentProject = currentExperiment.getProject();
            RelationshipUtils.updateModificationDateAndModifierOfExperimentAndProject(currentExperiment, currentProject, session, timeStamp);
        }
        sample.setExperiment(experiment);
        RelationshipUtils.updateModificationDateAndModifier((IModifierAndModificationDateBean)sample, session, timeStamp);
        RelationshipUtils.updateModificationDateAndModifierOfExperimentAndProject(experiment, currentProject, session, timeStamp);
    }

    @Override
    public void checkCanUnassignSampleFromExperiment(IAuthSession session, SamplePE sample) {
    }

    @Override
    public void unassignSampleFromExperiment(IAuthSession session, SamplePE sample) {
        ExperimentPE experiment = sample.getExperiment();
        if (experiment != null) {
            Date timeStamp = this.getTransactionTimeStamp();
            experiment.removeSample(sample);
            RelationshipUtils.updateModificationDateAndModifier((IModifierAndModificationDateBean)sample, session, timeStamp);
            RelationshipUtils.updateModificationDateAndModifier((IModifierAndModificationDateBean)experiment, session, timeStamp);
        }
    }

    @Override
    public void unassignSampleFromProject(IAuthSession session, SamplePE sample) {
        ProjectPE project = sample.getProject();
        if (project != null) {
            Date timeStamp = this.getTransactionTimeStamp();
            sample.setProject(null);
            RelationshipUtils.updateModificationDateAndModifier((IModifierAndModificationDateBean)sample, session, timeStamp);
            RelationshipUtils.updateModificationDateAndModifier((IModifierAndModificationDateBean)project, session, timeStamp);
        }
    }

    @Override
    public void assignSampleToSpace(IAuthSession session, SamplePE sample, SpacePE space) {
        Date timeStamp = this.getTransactionTimeStamp();
        sample.setSpace(space);
        RelationshipUtils.updateModificationDateAndModifier((IModifierAndModificationDateBean)sample, session, timeStamp);
    }

    @Override
    public void unshareSample(IAuthSession session, SamplePE sample, SpacePE space) {
        this.assignSampleToSpace(session, sample, space);
    }

    @Override
    public void shareSample(IAuthSession session, SamplePE sample) {
        Date timeStamp = this.getTransactionTimeStamp();
        sample.setSpace(null);
        RelationshipUtils.updateModificationDateAndModifier((IModifierAndModificationDateBean)sample, session, timeStamp);
    }

    @Override
    public void assignDataSetToExperiment(IAuthSession session, DataPE data, ExperimentPE experimentOrNull) {
        Date timeStamp = this.getTransactionTimeStamp();
        RelationshipUtils.setExperimentForDataSet(data, experimentOrNull, session, timeStamp);
    }

    @Override
    public void assignDataSetToSample(IAuthSession session, DataPE data, SamplePE sample) {
        SamplePE currentSample = data.tryGetSample();
        if (EntityHelper.equalEntities(currentSample, sample)) {
            return;
        }
        Date timeStamp = this.getTransactionTimeStamp();
        RelationshipUtils.setSampleForDataSet(data, sample, session, timeStamp);
    }

    @Override
    public void addParentToSample(IAuthSession session, SamplePE sample, SamplePE parent) {
        PersonPE actor = session.tryGetPerson();
        RelationshipTypePE relationshipType = this.daoFactory.getRelationshipTypeDAO().tryFindRelationshipTypeByCode("$PARENT_CHILD");
        Date timeStamp = this.getTransactionTimeStamp();
        RelationshipUtils.updateModificationDateAndModifier((IModifierAndModificationDateBean)sample, session, timeStamp);
        RelationshipUtils.updateModificationDateAndModifier((IModifierAndModificationDateBean)parent, session, timeStamp);
        sample.addParentRelationship(new SampleRelationshipPE(parent, sample, relationshipType, actor));
    }

    @Override
    public void setSampleParentChildAnnotations(IAuthSession session, SamplePE child, SamplePE parent, Map<String, String> childAnnotations, Map<String, String> parentAnnotations) {
        Date timeStamp = this.getTransactionTimeStamp();
        RelationshipUtils.updateModificationDateAndModifier((IModifierAndModificationDateBean)child, session, timeStamp);
        RelationshipUtils.updateModificationDateAndModifier((IModifierAndModificationDateBean)parent, session, timeStamp);
        for (SampleRelationshipPE relationship : child.getParentRelationships()) {
            if (relationship.getParentSample() != parent) continue;
            relationship.setChildAnnotations(childAnnotations);
            relationship.setParentAnnotations(parentAnnotations);
        }
    }

    @Override
    public void removeParentFromSample(IAuthSession session, SamplePE sample, SamplePE parent) {
        for (SampleRelationshipPE relationship : sample.getParentRelationships()) {
            if (!relationship.getParentSample().equals(parent)) continue;
            Date timeStamp = this.getTransactionTimeStamp();
            RelationshipUtils.updateModificationDateAndModifier((IModifierAndModificationDateBean)relationship.getChildSample(), session, timeStamp);
            RelationshipUtils.updateModificationDateAndModifier((IModifierAndModificationDateBean)relationship.getParentSample(), session, timeStamp);
            sample.removeParentRelationship(relationship);
            return;
        }
        throw UserFailureException.fromTemplate((String)ERR_SAMPLE_PARENT_RELATIONSHIP_NOT_FOUND, (Object[])new Object[]{sample.getCode(), parent.getCode()});
    }

    @Override
    public void assignSampleToContainer(IAuthSession session, SamplePE sample, SamplePE container) {
        Date timeStamp = this.getTransactionTimeStamp();
        RelationshipUtils.setContainerForSample(sample, container, session, timeStamp);
    }

    @Override
    public void removeSampleFromContainer(IAuthSession session, SamplePE sample) {
        Date timeStamp = this.getTransactionTimeStamp();
        RelationshipUtils.setContainerForSample(sample, null, session, timeStamp);
    }

    @Override
    public void addParentToDataSet(IAuthSession session, DataPE data, DataPE parent) {
        this.assignGenericParentChild(session, data, parent, this.getParentChildRelationshipType(), null);
    }

    private void assignGenericParentChild(IAuthSession session, DataPE child, DataPE parent, RelationshipTypePE type, Integer ordinalOrNull) {
        PersonPE actor = session.tryGetPerson();
        DataSetRelationshipPE relationship = new DataSetRelationshipPE(parent, child, type, ordinalOrNull, actor);
        child.addParentRelationship(relationship);
        if (parent.isChildrenRelationshipsInitialized()) {
            parent.addChildRelationship(relationship);
        }
        Date timeStamp = this.getTransactionTimeStamp();
        RelationshipUtils.updateModificationDateAndModifier((IModifierAndModificationDateBean)child, session, timeStamp);
        RelationshipUtils.updateModificationDateAndModifier((IModifierAndModificationDateBean)parent, session, timeStamp);
    }

    @Override
    public void removeParentFromDataSet(IAuthSession session, DataPE data, DataPE parent) {
        this.releaseRelationship(session, "$PARENT_CHILD", data, parent, ERR_DATASET_PARENT_RELATIONSHIP_NOT_FOUND);
    }

    private void releaseRelationship(IAuthSession session, String relationshipTypeCode, DataPE child, DataPE parent, String errorTemplate) {
        DataSetRelationshipPE remove = null;
        for (DataSetRelationshipPE r : child.getParentRelationships()) {
            if (!r.getParentDataSet().equals(parent) || !r.getRelationshipType().getCode().equals(relationshipTypeCode)) continue;
            remove = r;
            break;
        }
        if (remove == null) {
            throw UserFailureException.fromTemplate((String)errorTemplate, (Object[])new Object[]{child.getCode(), parent.getCode()});
        }
        child.removeParentRelationship(remove);
        Date timeStamp = this.getTransactionTimeStamp();
        RelationshipUtils.updateModificationDateAndModifier((IModifierAndModificationDateBean)child, session, timeStamp);
        RelationshipUtils.updateModificationDateAndModifier((IModifierAndModificationDateBean)parent, session, timeStamp);
    }

    @Override
    public void assignDataSetToContainer(IAuthSession session, DataPE data, DataPE container) {
        int ordinal = RelationshipUtils.getContainerComponentRelationships(container.getChildRelationships()).size();
        RelationshipTypePE relationshipType = RelationshipUtils.getContainerComponentRelationshipType(this.daoFactory.getRelationshipTypeDAO());
        this.assignGenericParentChild(session, data, container, relationshipType, ordinal);
    }

    @Override
    public void removeDataSetFromContainer(IAuthSession session, DataPE data, DataPE container) {
        this.releaseRelationship(session, "$CONTAINER_COMPONENT", data, container, ERR_DATASET_CONTAINER_RELATIONSHIP_NOT_FOUND);
    }

    public void setDaoFactory(DAOFactory daoFactory) {
        this.daoFactory = daoFactory;
    }

    private RelationshipTypePE getParentChildRelationshipType() {
        return RelationshipUtils.getParentChildRelationshipType(this.daoFactory.getRelationshipTypeDAO());
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    private Date getTransactionTimeStamp() {
        return this.daoFactory.getTransactionTimestamp();
    }
}

