/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.business.bo;

import ch.systemsx.cisd.common.collection.CollectionUtils;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.server.business.IRelationshipService;
import ch.systemsx.cisd.openbis.generic.server.business.IServiceConversationClientManagerLocal;
import ch.systemsx.cisd.openbis.generic.server.business.bo.AbstractSampleIdentifierBusinessObject;
import ch.systemsx.cisd.openbis.generic.server.business.bo.util.DataSetTypeWithoutExperimentChecker;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDataDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IEntityPropertiesConverter;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataSetRelationshipPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExternalDataPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.FileFormatTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.IModifierAndModificationDateBean;
import ch.systemsx.cisd.openbis.generic.shared.dto.ProjectPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SamplePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.Session;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.properties.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.IManagedPropertyEvaluatorFactory;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.api.IEntityInformationProvider;
import ch.systemsx.cisd.openbis.generic.shared.util.HibernateUtils;
import ch.systemsx.cisd.openbis.generic.shared.util.RelationshipUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractDataSetBusinessObject
extends AbstractSampleIdentifierBusinessObject {
    private IServiceConversationClientManagerLocal conversationClient;

    public AbstractDataSetBusinessObject(IDAOFactory daoFactory, Session session, IRelationshipService relationshipService, IServiceConversationClientManagerLocal conversationClient, IEntityInformationProvider entityInformationProvider, IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory, DataSetTypeWithoutExperimentChecker dataSetTypeChecker) {
        super(daoFactory, session, EntityKind.DATA_SET, entityInformationProvider, managedPropertyEvaluatorFactory, dataSetTypeChecker, relationshipService);
        this.conversationClient = conversationClient;
    }

    public AbstractDataSetBusinessObject(IDAOFactory daoFactory, Session session, IEntityPropertiesConverter entityPropertiesConverter, IRelationshipService relationshipService, IServiceConversationClientManagerLocal conversationClient, IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory, DataSetTypeWithoutExperimentChecker dataSetTypeChecker) {
        super(daoFactory, session, entityPropertiesConverter, managedPropertyEvaluatorFactory, dataSetTypeChecker, relationshipService);
        this.conversationClient = conversationClient;
    }

    protected void enrichWithParentsAndExperiment(DataPE dataPE) {
        HibernateUtils.initialize(dataPE.getParents());
        HibernateUtils.initialize(dataPE.getExperiment());
    }

    protected void enrichWithChildren(DataPE dataPE) {
        HibernateUtils.initialize(dataPE.getChildRelationships());
    }

    protected void checkPropertiesBusinessRules(DataPE data) {
        this.entityPropertiesConverter.checkMandatoryProperties(data.getProperties(), data.getDataSetType());
    }

    protected void updateSample(DataPE data, SampleIdentifier sampleIdentifierOrNull) {
        assert (sampleIdentifierOrNull != null);
        SamplePE newSample = this.getSampleByIdentifier(sampleIdentifierOrNull);
        this.assignDataSetToSampleAndExperiment(data, newSample, newSample.getExperiment());
    }

    protected void updateExperiment(DataPE data, ExperimentIdentifier experimentIdentifier) {
        assert (experimentIdentifier != null);
        this.assignDataSetToSampleAndExperiment(data, null, this.getExperimentByIdentifier(experimentIdentifier));
    }

    private ExperimentPE getExperimentByIdentifier(ExperimentIdentifier identifier) {
        assert (identifier != null) : "Experiment identifier unspecified.";
        ProjectPE project = this.getProjectDAO().tryFindProject(identifier.getSpaceCode(), identifier.getProjectCode());
        if (project == null) {
            throw UserFailureException.fromTemplate((String)"Unkown %s because of unkown project: %s", (Object[])new Object[]{this.getExperimentText(), identifier});
        }
        return this.getExperimentDAO().tryFindByCodeAndProject(project, identifier.getExperimentCode());
    }

    protected void setContainedDataSets(DataPE container, List<String> modifiedContainedCodesOrNull) {
        if (modifiedContainedCodesOrNull == null) {
            return;
        }
        Set<DataPE> newComponents = this.findDataSetsByCodes(AbstractDataSetBusinessObject.asSet(modifiedContainedCodesOrNull));
        List<DataPE> oldComponents = container.getContainedDataSets();
        for (DataPE dataPE : oldComponents) {
            if (newComponents.remove(dataPE)) continue;
            this.relationshipService.removeDataSetFromContainer(this.session, dataPE, container);
        }
        for (DataPE dataPE : newComponents) {
            this.relationshipService.assignDataSetToContainer(this.session, dataPE, container);
            this.validateContainerContainedRelationshipGraph(container, dataPE);
        }
        HashMap<String, DataSetRelationshipPE> relationShipsByCode = new HashMap<String, DataSetRelationshipPE>();
        List<DataSetRelationshipPE> childRelationships = RelationshipUtils.getContainerComponentRelationships(container.getChildRelationships());
        for (DataSetRelationshipPE childRelationship : childRelationships) {
            DataPE childDataSet = childRelationship.getChildDataSet();
            relationShipsByCode.put(childDataSet.getCode(), childRelationship);
        }
        for (int i = 0; i < modifiedContainedCodesOrNull.size(); ++i) {
            String componentCode = modifiedContainedCodesOrNull.get(i);
            DataSetRelationshipPE dataSetRelationship = (DataSetRelationshipPE)relationShipsByCode.get(componentCode);
            dataSetRelationship.setOrdinal(i);
        }
    }

    protected void setParents(DataPE childPE, List<String> modifiedParentDatasetCodesOrNull) {
        if (modifiedParentDatasetCodesOrNull == null) {
            return;
        }
        for (String parentCode : modifiedParentDatasetCodesOrNull) {
            if (!parentCode.equals(childPE.getCode())) continue;
            throw new UserFailureException("Data set '" + childPE.getCode() + "' can not be its own parent.");
        }
        Set<DataPE> parentPEs = this.findDataSetsByCodes(AbstractDataSetBusinessObject.asSet(modifiedParentDatasetCodesOrNull));
        this.replaceParents(childPE, parentPEs, true);
    }

    protected void replaceParents(DataPE child, Set<DataPE> newParents, boolean validate) {
        for (DataPE dataPE : newParents) {
            this.checkParentDeletion(dataPE, child.getCode());
        }
        ArrayList<DataPE> oldParents = new ArrayList<DataPE>();
        for (DataSetRelationshipPE oldParentRelation : RelationshipUtils.getParentChildRelationships(child.getParentRelationships())) {
            oldParents.add(oldParentRelation.getParentDataSet());
        }
        HashSet<DataPE> hashSet = new HashSet<DataPE>();
        HashSet<DataPE> parentsToAdd = new HashSet<DataPE>();
        this.findToBeRemovedOrAdded(newParents, oldParents, hashSet, parentsToAdd);
        if (validate) {
            this.validateParentsRelationshipGraph(child, parentsToAdd);
        }
        for (DataPE parentToRemove : hashSet) {
            this.relationshipService.removeParentFromDataSet(this.session, child, parentToRemove);
        }
        for (DataPE parentToAdd : parentsToAdd) {
            this.relationshipService.addParentToDataSet(this.session, child, parentToAdd);
        }
    }

    protected void findToBeRemovedOrAdded(Collection<DataPE> newDataSets, Collection<DataPE> oldDataSets, Set<DataPE> toBeRemoved, Set<DataPE> toBeAdded) {
        for (DataPE newDataSet : newDataSets) {
            if (oldDataSets.contains(newDataSet)) continue;
            toBeAdded.add(newDataSet);
        }
        for (DataPE oldDataSet : oldDataSets) {
            if (newDataSets.contains(oldDataSet)) continue;
            toBeRemoved.add(oldDataSet);
        }
    }

    private void checkParentDeletion(DataPE parentPE, String child) {
        if (parentPE.getDeletion() != null) {
            throw UserFailureException.fromTemplate((String)"Data set '%s' has been deleted and can't become a parent of data set '%s'.", (Object[])new Object[]{parentPE.getIdentifier(), child});
        }
    }

    protected void validateParentsRelationshipGraph(DataPE data, Collection<DataPE> parentsToAdd) {
        for (DataPE parentToAdd : parentsToAdd) {
            this.validateParentsRelationshipGraph(data, parentToAdd);
        }
    }

    private void validateParentsRelationshipGraph(DataPE data, DataPE parentToAdd) {
        TechId updatedDataSetId = TechId.create((IIdHolder)data);
        HashSet<TechId> visited = new HashSet<TechId>();
        Set<TechId> toVisit = new HashSet<TechId>();
        toVisit.add(TechId.create((IIdHolder)parentToAdd));
        while (!toVisit.isEmpty()) {
            if (toVisit.contains(updatedDataSetId)) {
                throw UserFailureException.fromTemplate((String)"Data Set '%s' is an ancestor of Data Set '%s' and cannot be at the same time set as its child.", (Object[])new Object[]{data.getCode(), parentToAdd.getCode()});
            }
            Set<TechId> nextToVisit = this.findParentIds(toVisit);
            visited.addAll(toVisit);
            nextToVisit.removeAll(visited);
            toVisit = nextToVisit;
        }
    }

    private Set<TechId> findParentIds(Set<TechId> dataSetIds) {
        return this.getDataDAO().findParentIds(dataSetIds, this.getParentChildRelationshipType().getId());
    }

    protected Set<DataPE> findDataSetsByCodes(Collection<String> codes) {
        IDataDAO dao = this.getDataDAO();
        LinkedHashSet<DataPE> dataSets = new LinkedHashSet<DataPE>();
        ArrayList<String> missingDataSetCodes = new ArrayList<String>();
        for (String code : codes) {
            DataPE dataSetOrNull = dao.tryToFindDataSetByCode(code);
            if (dataSetOrNull == null) {
                missingDataSetCodes.add(code);
                continue;
            }
            dataSets.add(dataSetOrNull);
        }
        if (missingDataSetCodes.size() > 0) {
            throw UserFailureException.fromTemplate((String)"Data Sets with following codes do not exist: '%s'.", (Object[])new Object[]{CollectionUtils.abbreviate(missingDataSetCodes, (int)10)});
        }
        return dataSets;
    }

    protected void updateContainers(DataPE data, String containerCodes) {
        if (containerCodes == null) {
            return;
        }
        data.setModificationDate(this.getTransactionTimeStamp());
        List<String> codes = Arrays.asList(containerCodes.split(" *, *"));
        Map<String, DataPE> newContainers = this.getDataSets(codes);
        List<DataPE> oldContainers = data.getContainers();
        for (DataPE oldContainer : oldContainers) {
            if (newContainers.remove(oldContainer.getCode()) != null) continue;
            this.relationshipService.removeDataSetFromContainer(this.session, data, oldContainer);
        }
        for (DataPE newContainer : newContainers.values()) {
            if (!newContainer.isContainer()) {
                throw UserFailureException.fromTemplate((String)"Data Set with a following code is not a container: '%s'.", (Object[])new Object[]{newContainer.getCode()});
            }
            this.relationshipService.assignDataSetToContainer(this.session, data, newContainer);
            this.validateContainerContainedRelationshipGraph(newContainer, data);
        }
    }

    private Map<String, DataPE> getDataSets(List<String> codes) {
        Set<DataPE> dataSets = this.findDataSetsByCodes(codes);
        HashMap<String, DataPE> dataSetsByCode = new HashMap<String, DataPE>();
        for (DataPE dataSet : dataSets) {
            dataSetsByCode.put(dataSet.getCode(), dataSet);
        }
        return dataSetsByCode;
    }

    private void validateContainerContainedRelationshipGraph(DataPE container, DataPE contained) {
        if (container.getCode().equals(contained.getCode())) {
            throw new UserFailureException("Data set '" + container.getCode() + "' cannot contain itself as a component neither directly nor via subordinate components.");
        }
        Set<DataSetRelationshipPE> parentRelationships = container.getParentRelationships();
        for (DataSetRelationshipPE relationship : RelationshipUtils.getContainerComponentRelationships(parentRelationships)) {
            this.validateContainerContainedRelationshipGraph(relationship.getParentDataSet(), contained);
        }
    }

    protected void updateFileFormatType(DataPE data, String fileFormatTypeCode) {
        if (data.isExternalData()) {
            if (fileFormatTypeCode == null) {
                throw new UserFailureException("Data set '" + data.getCode() + "' cannot have empty file format.");
            }
            ExternalDataPE externalData = data.tryAsExternalData();
            FileFormatTypePE fileFormatTypeOrNull = this.getFileFormatTypeDAO().tryToFindFileFormatTypeByCode(fileFormatTypeCode);
            if (fileFormatTypeOrNull == null) {
                throw new UserFailureException(String.format("File type '%s' does not exist.", fileFormatTypeCode));
            }
            if (!this.equalFileFormatTypes(externalData.getFileFormatType(), fileFormatTypeOrNull)) {
                externalData.setFileFormatType(fileFormatTypeOrNull);
                RelationshipUtils.updateModificationDateAndModifier((IModifierAndModificationDateBean)data, this.session, this.getTransactionTimeStamp());
            }
        }
    }

    private boolean equalFileFormatTypes(FileFormatTypePE type1, FileFormatTypePE type2) {
        return type1 == null ? type1 == type2 : type1.equals(type2);
    }

    protected static Set<String> extractCodes(Collection<DataPE> parents) {
        HashSet<String> codes = new HashSet<String>(parents.size());
        for (DataPE parent : parents) {
            codes.add(parent.getCode());
        }
        return codes;
    }

    protected static Set<String> asSet(List<String> objects) {
        return new LinkedHashSet<String>(objects);
    }

    public IRelationshipService getRelationshipService() {
        return this.relationshipService;
    }

    public IServiceConversationClientManagerLocal getConversationClient() {
        return this.conversationClient;
    }
}

