/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.business.bo;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.server.business.IRelationshipService;
import ch.systemsx.cisd.openbis.generic.server.business.bo.AbstractBusinessObject;
import ch.systemsx.cisd.openbis.generic.server.business.bo.util.DataSetTypeWithoutExperimentChecker;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IEntityPropertiesConverter;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.dto.MaterialPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.Session;
import ch.systemsx.cisd.openbis.generic.shared.dto.properties.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.IManagedPropertyEvaluatorFactory;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.api.IEntityInformationProvider;

public class AbstractMaterialBusinessObject
extends AbstractBusinessObject {
    private static final String PROPERTY_TYPES = "materialType.materialTypePropertyTypesInternal";

    protected AbstractMaterialBusinessObject(IDAOFactory daoFactory, Session session, IEntityInformationProvider entityInformationProvider, IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory, DataSetTypeWithoutExperimentChecker dataSetTypeChecker, IRelationshipService relationshipService) {
        super(daoFactory, session, EntityKind.MATERIAL, entityInformationProvider, managedPropertyEvaluatorFactory, dataSetTypeChecker, relationshipService);
    }

    protected AbstractMaterialBusinessObject(IDAOFactory daoFactory, Session session, IEntityPropertiesConverter entityPropertiesConverter, IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory, DataSetTypeWithoutExperimentChecker dataSetTypeChecker, IRelationshipService relationshipService) {
        super(daoFactory, session, entityPropertiesConverter, managedPropertyEvaluatorFactory, dataSetTypeChecker, relationshipService);
    }

    protected MaterialPE getMaterialById(TechId materialId) {
        assert (materialId != null) : "Material technical id unspecified.";
        String[] connections = new String[]{PROPERTY_TYPES};
        MaterialPE result = (MaterialPE)this.getMaterialDAO().tryGetByTechId(materialId, connections);
        if (result == null) {
            throw new UserFailureException(String.format("Material with ID '%s' does not exist.", materialId));
        }
        return result;
    }
}

