/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.business.bo;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.server.business.IEntityOperationChecker;
import ch.systemsx.cisd.openbis.generic.server.business.IRelationshipService;
import ch.systemsx.cisd.openbis.generic.server.business.bo.AbstractSampleIdentifierBusinessObject;
import ch.systemsx.cisd.openbis.generic.server.business.bo.SampleGenericBusinessRules;
import ch.systemsx.cisd.openbis.generic.server.business.bo.util.DataSetTypeWithoutExperimentChecker;
import ch.systemsx.cisd.openbis.generic.server.business.bo.util.SampleOwner;
import ch.systemsx.cisd.openbis.generic.server.business.bo.util.SampleUtils;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDataDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IEntityPropertiesConverter;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.ISampleDAO;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IEntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewSample;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.EntityTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.EntityTypePropertyTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.IModifierAndModificationDateBean;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ProjectPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SamplePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SamplePropertyPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SampleRelationshipPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SampleTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.Session;
import ch.systemsx.cisd.openbis.generic.shared.dto.SpacePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifierFactory;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.IdentifierHelper;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ProjectIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ProjectIdentifierFactory;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifierFactory;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleOwnerIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.properties.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.IManagedPropertyEvaluatorFactory;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.api.IEntityInformationProvider;
import ch.systemsx.cisd.openbis.generic.shared.util.EntityHelper;
import ch.systemsx.cisd.openbis.generic.shared.util.RelationshipUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

abstract class AbstractSampleBusinessObject
extends AbstractSampleIdentifierBusinessObject {
    protected boolean onlyNewSamples = true;
    protected IEntityOperationChecker entityOperationChecker;

    AbstractSampleBusinessObject(IDAOFactory daoFactory, Session session, IRelationshipService relationshipService, IEntityOperationChecker entityOperationChecker, IEntityInformationProvider entityInformationProvider, IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory, DataSetTypeWithoutExperimentChecker dataSetTypeChecker) {
        super(daoFactory, session, EntityKind.SAMPLE, entityInformationProvider, managedPropertyEvaluatorFactory, dataSetTypeChecker, relationshipService);
        this.entityOperationChecker = entityOperationChecker;
    }

    AbstractSampleBusinessObject(IDAOFactory daoFactory, Session session, IEntityPropertiesConverter entityPropertiesConverter, IRelationshipService relationshipService, IEntityOperationChecker entityOperationChecker, IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory, DataSetTypeWithoutExperimentChecker dataSetTypeChecker) {
        super(daoFactory, session, entityPropertiesConverter, managedPropertyEvaluatorFactory, dataSetTypeChecker, relationshipService);
        this.entityOperationChecker = entityOperationChecker;
    }

    private final void defineSampleProperties(SamplePE sample, IEntityProperty[] sampleProperties) {
        String sampleTypeCode = sample.getSampleType().getCode();
        List properties = this.entityPropertiesConverter.convertProperties(sampleProperties, sampleTypeCode, sample.getRegistrator());
        for (SamplePropertyPE sampleProperty : properties) {
            sample.addProperty(sampleProperty);
        }
    }

    final SamplePE createSample(NewSample newSample, Map<String, SampleTypePE> sampleTypeCacheOrNull, Map<SampleOwnerIdentifier, SampleOwner> sampleOwnerCacheOrNull, Map<String, ExperimentPE> experimentCacheOrNull, PersonPE registratorOrNull) throws UserFailureException {
        SampleTypePE sampleTypePE;
        SampleIdentifier sampleIdentifier = SampleIdentifierFactory.parse(newSample);
        SampleOwner sampleOwner = this.getSampleOwner(sampleOwnerCacheOrNull, sampleIdentifier);
        SampleTypePE sampleTypePE2 = sampleTypePE = sampleTypeCacheOrNull != null ? sampleTypeCacheOrNull.get(newSample.getSampleType().getCode()) : null;
        if (sampleTypePE == null) {
            sampleTypePE = this.getSampleType(newSample.getSampleType().getCode());
            if (sampleTypeCacheOrNull != null) {
                sampleTypeCacheOrNull.put(newSample.getSampleType().getCode(), sampleTypePE);
            }
        }
        String experimentIdentifier = newSample.getExperimentIdentifier();
        ExperimentPE experimentPE = this.tryFindExperiment(experimentCacheOrNull, experimentIdentifier, newSample.getDefaultSpaceIdentifier());
        this.updateModifierAndModificationDate(experimentPE);
        SamplePE samplePE = new SamplePE();
        samplePE.setExperiment(experimentPE);
        samplePE.setCode(sampleIdentifier.getSampleSubCode());
        PersonPE registrator = registratorOrNull != null ? registratorOrNull : this.findPerson();
        samplePE.setRegistrator(registrator);
        samplePE.setSampleType(sampleTypePE);
        samplePE.setSpace(sampleOwner.tryGetSpace());
        this.setProject(samplePE, newSample);
        RelationshipUtils.updateModificationDateAndModifier((IModifierAndModificationDateBean)samplePE, registrator, this.getTransactionTimeStamp());
        this.defineSampleProperties(samplePE, newSample.getProperties());
        String containerIdentifier = newSample.getContainerIdentifierForNewSample();
        this.setContainer(sampleIdentifier, samplePE, containerIdentifier, newSample.getDefaultSpaceIdentifier());
        if (newSample.getParentsOrNull() != null) {
            String[] parents = newSample.getParentsOrNull();
            this.setParents(samplePE, parents, newSample.getDefaultSpaceIdentifier());
        }
        samplePE.setPermId(this.getOrCreatePermID(newSample));
        this.setMetaprojects(samplePE, newSample.getMetaprojectsOrNull());
        return samplePE;
    }

    private void setProject(SamplePE samplePE, NewSample newSample) {
        String projectIdentifier;
        SampleIdentifier sampleIdentifier = SampleIdentifierFactory.parse(newSample);
        if (sampleIdentifier.isProjectLevel()) {
            ProjectPE project = this.findProject(sampleIdentifier.getProjectLevel());
            this.setProjectAndSpace(samplePE, project);
        }
        if ((projectIdentifier = newSample.getProjectIdentifier()) != null) {
            ProjectPE project = this.findProject(new ProjectIdentifierFactory(projectIdentifier).createIdentifier());
            this.setProjectAndSpace(samplePE, project);
        }
    }

    private void setProjectAndSpace(SamplePE samplePE, ProjectPE project) {
        SampleUtils.assertProjectSamplesEnabled(samplePE, project);
        samplePE.setProject(project);
        samplePE.setSpace(project.getSpace());
    }

    private void updateModifierAndModificationDate(ExperimentPE experimentOrNull) {
        if (experimentOrNull != null) {
            Date timeStamp = this.getTransactionTimeStamp();
            RelationshipUtils.updateModificationDateAndModifierOfExperimentAndProject(experimentOrNull, null, this.session, timeStamp);
        }
    }

    protected SampleOwner getSampleOwner(Map<SampleOwnerIdentifier, SampleOwner> sampleOwnerCacheOrNull, SampleIdentifier sampleIdentifier) {
        SampleOwner sampleOwner;
        SampleOwnerIdentifier sampleOwnerIdentifier = sampleIdentifier.createSampleOwnerIdentifier();
        SampleOwner sampleOwner2 = sampleOwner = sampleOwnerCacheOrNull != null ? sampleOwnerCacheOrNull.get(sampleOwnerIdentifier) : null;
        if (sampleOwner == null) {
            sampleOwner = this.getSampleOwnerFinder().figureSampleOwner(sampleIdentifier);
            if (sampleOwnerCacheOrNull != null) {
                sampleOwnerCacheOrNull.put(sampleOwnerIdentifier, sampleOwner);
            }
        }
        return sampleOwner;
    }

    private ExperimentPE tryFindExperiment(Map<String, ExperimentPE> experimentCacheOrNull, String experimentIdentifier, String defaultSpace) {
        ExperimentPE experimentPE = null;
        if (experimentIdentifier != null) {
            ExperimentIdentifier expIdent = new ExperimentIdentifierFactory(experimentIdentifier).createIdentifier(defaultSpace);
            this.fillSpaceIdentifier(expIdent);
            ExperimentPE experimentPE2 = experimentPE = experimentCacheOrNull != null ? experimentCacheOrNull.get(expIdent.toString()) : null;
            if (experimentPE == null) {
                experimentPE = this.findExperiment(expIdent);
                if (experimentCacheOrNull != null) {
                    experimentCacheOrNull.put(expIdent.toString(), experimentPE);
                }
            }
        }
        return experimentPE;
    }

    private ProjectPE tryFindProject(Map<String, ProjectPE> projectCache, ProjectIdentifier projectIdentifier) {
        if (projectIdentifier == null) {
            return null;
        }
        return this.tryFindProject(projectCache, projectIdentifier.toString(), null);
    }

    private ProjectPE tryFindProject(Map<String, ProjectPE> projectCache, String projectIdentifier, String defaultSpace) {
        ProjectPE project;
        if (projectIdentifier == null) {
            return null;
        }
        ProjectIdentifier identifier = new ProjectIdentifierFactory(projectIdentifier).createIdentifier(defaultSpace);
        this.fillSpaceIdentifier(identifier);
        String key = identifier.toString();
        ProjectPE projectPE = project = projectCache == null ? null : projectCache.get(key);
        if (project == null) {
            project = this.findProject(identifier);
            if (projectCache != null) {
                projectCache.put(key, project);
            }
        }
        return project;
    }

    protected void setContainer(SampleIdentifier sampleIdentifier, SamplePE samplePE, String containerIdentifier, String defaultSpace) {
        SamplePE containerPE = this.tryGetValidNotContainedSample(containerIdentifier, sampleIdentifier, defaultSpace);
        if (samplePE.getContainer() == null && containerPE == null) {
            return;
        }
        if (samplePE.getContainer() != null && samplePE.getContainer().equals(containerPE)) {
            return;
        }
        this.checkIfCanBeContainer(samplePE, containerPE);
        if (containerPE == null) {
            this.relationshipService.removeSampleFromContainer(this.session, samplePE);
        } else {
            this.relationshipService.assignSampleToContainer(this.session, samplePE, containerPE);
        }
    }

    protected void setParents(SamplePE childPE, String[] parents, String defaultSpace) {
        String spaceCode;
        List<SampleIdentifier> parentIdentifiers = IdentifierHelper.extractSampleIdentifiers(parents, defaultSpace);
        SampleIdentifier childIdentifier = childPE.getSampleIdentifier();
        if (childIdentifier.isProjectLevel()) {
            spaceCode = childIdentifier.getProjectLevel().getSpaceCode();
            for (SampleIdentifier si : parentIdentifiers) {
                IdentifierHelper.fillSpaceIfNotSpecified(si, spaceCode);
            }
        } else if (childIdentifier.isSpaceLevel()) {
            spaceCode = childIdentifier.getSpaceLevel().getSpaceCode();
            for (SampleIdentifier si : parentIdentifiers) {
                IdentifierHelper.fillSpaceIfNotSpecified(si, spaceCode);
            }
        }
        HashSet<SamplePE> parentPEs = new HashSet<SamplePE>();
        for (SampleIdentifier si : parentIdentifiers) {
            SamplePE parent = this.getSampleByIdentifier(si);
            parentPEs.add(parent);
            this.checkIfCanBeParent(childPE, parent);
        }
        this.replaceParents(childPE, parentPEs);
    }

    private void checkIfCanBeContainer(SamplePE sample, SamplePE container) {
        for (SamplePE containerCandidate = container; containerCandidate != null; containerCandidate = containerCandidate.getContainer()) {
            if (!sample.equals(containerCandidate)) continue;
            throw UserFailureException.fromTemplate((String)"'%s' cannot be it's own container.", (Object[])new Object[]{sample.getIdentifier()});
        }
    }

    private void checkIfCanBeParent(SamplePE childPE, SamplePE parentCandidate) {
        HashSet<SamplePE> visitedCandidates = new HashSet<SamplePE>();
        Stack<SamplePE> candidates = new Stack<SamplePE>();
        candidates.add(parentCandidate);
        visitedCandidates.add(parentCandidate);
        while (!candidates.empty()) {
            SamplePE candidate = (SamplePE)candidates.pop();
            if (candidate == childPE) {
                throw UserFailureException.fromTemplate((String)"'%s' cannot be its own parent.", (Object[])new Object[]{childPE.getIdentifier()});
            }
            for (SamplePE parent : candidate.getParents()) {
                if (visitedCandidates.contains(parent)) continue;
                candidates.add(parent);
                visitedCandidates.add(parent);
            }
        }
    }

    private void replaceParents(SamplePE child, Set<SamplePE> newParents) {
        for (SamplePE parent : newParents) {
            this.checkParentDeletion(parent, child.getSampleIdentifier());
        }
        ArrayList<SampleRelationshipPE> oldParents = new ArrayList<SampleRelationshipPE>();
        for (SampleRelationshipPE r : child.getParentRelationships()) {
            if (!r.getRelationship().getCode().equals("$PARENT_CHILD")) continue;
            oldParents.add(r);
        }
        for (SampleRelationshipPE r : oldParents) {
            if (newParents.contains(r.getParentSample())) {
                newParents.remove(r.getParentSample());
                continue;
            }
            this.relationshipService.removeParentFromSample(this.session, child, r.getParentSample());
        }
        for (SamplePE newParent : newParents) {
            this.relationshipService.addParentToSample(this.session, child, newParent);
        }
    }

    private SamplePE tryGetValidParentSample(String parentIdentifierOrNull, SampleIdentifier childIdentifier, String defaultSpace) {
        if (parentIdentifierOrNull == null) {
            return null;
        }
        SamplePE parentPE = this.getSampleByIdentifier(SampleIdentifierFactory.parse(parentIdentifierOrNull, defaultSpace));
        this.checkParentDeletion(parentPE, childIdentifier);
        return parentPE;
    }

    private void checkParentDeletion(SamplePE parentPE, SampleIdentifier child) {
        if (parentPE.getDeletion() != null) {
            throw UserFailureException.fromTemplate((String)"Sample '%s' has been deleted and can't become a parent of sample '%s'.", (Object[])new Object[]{parentPE.getIdentifier(), child});
        }
    }

    private SamplePE tryGetValidNotContainedSample(String parentIdentifierOrNull, SampleIdentifier sampleIdentifier, String defaultSpace) {
        SamplePE sample = this.tryGetValidParentSample(parentIdentifierOrNull, sampleIdentifier, defaultSpace);
        if (sample != null && sample.getContainer() != null) {
            throw UserFailureException.fromTemplate((String)"Cannot register sample '%s': parent '%s' is part of another sample.", (Object[])new Object[]{sampleIdentifier, parentIdentifierOrNull});
        }
        return sample;
    }

    final SampleTypePE getSampleType(String code) throws UserFailureException {
        SampleTypePE sampleType = this.getSampleTypeDAO().tryFindSampleTypeByCode(code);
        if (sampleType == null) {
            throw UserFailureException.fromTemplate((String)"No sample type with code '%s' could be found in the database.", (Object[])new Object[]{code});
        }
        return sampleType;
    }

    protected ExperimentPE findExperiment(ExperimentIdentifier identifier) {
        ProjectPE project = this.findProject(identifier);
        String experimentCode = identifier.getExperimentCode();
        ExperimentPE experiment = this.getExperimentDAO().tryFindByCodeAndProject(project, experimentCode);
        if (experiment == null) {
            throw UserFailureException.fromTemplate((String)"No experiment '%s' could be found in the '%s/%s' project!", (Object[])new Object[]{experimentCode, identifier.getSpaceCode(), identifier.getProjectCode()});
        }
        return experiment;
    }

    protected ProjectPE findProject(ProjectIdentifier projectIdentifier) {
        String spaceCode = projectIdentifier.getSpaceCode();
        String projectCode = projectIdentifier.getProjectCode();
        ProjectPE project = this.getProjectDAO().tryFindProject(spaceCode, projectCode);
        if (project == null) {
            throw UserFailureException.fromTemplate((String)"No project '%s' could be found in the '%s' space!", (Object[])new Object[]{projectCode, spaceCode});
        }
        return project;
    }

    protected void checkAllBusinessRules(SamplePE sample, IDataDAO dataDAO, Map<EntityTypePE, List<EntityTypePropertyTypePE>> cacheOrNull, boolean spaceUpdated) {
        this.checkPropertiesBusinessRules(sample, cacheOrNull);
        this.checkExperimentBusinessRules(sample);
        this.checkParentBusinessRules(sample);
        this.checkContainerBusinessRules(sample);
    }

    protected void checkPropertiesBusinessRules(SamplePE sample, Map<EntityTypePE, List<EntityTypePropertyTypePE>> cacheOrNull) {
        if (cacheOrNull != null) {
            this.entityPropertiesConverter.checkMandatoryProperties(sample.getProperties(), sample.getSampleType(), cacheOrNull);
        } else {
            this.entityPropertiesConverter.checkMandatoryProperties(sample.getProperties(), sample.getSampleType());
        }
    }

    protected void checkExperimentBusinessRules(SamplePE sample) {
        ExperimentPE experiment = sample.getExperiment();
        if (experiment == null) {
            String sampleIdentifier = sample.getIdentifier();
            ArrayList<DataPE> dataSets = new ArrayList<DataPE>(sample.getDatasets());
            this.checkDataSetsDoNotNeedAnExperiment(sampleIdentifier, dataSets);
        }
        if (this.hasDatasets(sample) && sample.getSpace() == null) {
            throw UserFailureException.fromTemplate((String)"Cannot detach the sample '%s' from the space because there are already datasets attached to the sample.", (Object[])new Object[]{sample.getIdentifier()});
        }
        if (!(experiment == null || sample.getSpace() != null && experiment.getProject().getSpace().equals(sample.getSpace()))) {
            throw new UserFailureException("Sample space must be the same as experiment space. Shared samples cannot be attached to experiments. Sample: " + sample.getIdentifier() + ", Experiment: " + experiment.getIdentifier());
        }
    }

    protected void checkParentBusinessRules(SamplePE sample) {
        SampleGenericBusinessRules.assertValidParents(sample);
        SampleGenericBusinessRules.assertValidChildren(sample);
    }

    protected void checkContainerBusinessRules(SamplePE sample) {
        SampleGenericBusinessRules.assertValidContainer(sample);
        SampleGenericBusinessRules.assertValidComponents(sample);
    }

    private boolean hasDatasets(SamplePE sample) {
        return !this.onlyNewSamples && this.hasDatasets2(this.getDataDAO(), sample);
    }

    protected boolean updateSpace(SamplePE sample, SampleIdentifier sampleOwnerIdentifier, Map<SampleOwnerIdentifier, SampleOwner> sampleOwnerCacheOrNull) {
        if (sampleOwnerIdentifier != null) {
            SampleOwner sampleOwner = this.getSampleOwner(sampleOwnerCacheOrNull, sampleOwnerIdentifier);
            SpacePE space = sampleOwner.tryGetSpace();
            if (space == sample.getSpace() || space != null && space.equals(sample.getSpace())) {
                return false;
            }
            if (space == null) {
                this.relationshipService.shareSample(this.session, sample);
            } else if (sample.getSpace() == null) {
                this.relationshipService.unshareSample(this.session, sample, space);
            } else {
                this.relationshipService.assignSampleToSpace(this.session, sample, space);
            }
            return true;
        }
        return false;
    }

    protected void updateExperiment(SamplePE sample, ExperimentIdentifier expIdentifierOrNull, Map<String, ExperimentPE> experimentCacheOrNull) {
        ExperimentPE newExperiment;
        if (sample.getExperiment() == null && expIdentifierOrNull == null) {
            return;
        }
        ExperimentPE experimentPE = newExperiment = expIdentifierOrNull == null ? null : this.tryFindExperiment(experimentCacheOrNull, expIdentifierOrNull.toString(), null);
        if (EntityHelper.equalEntities(newExperiment, sample.getExperiment())) {
            return;
        }
        this.ensureExperimentIsValid(expIdentifierOrNull, newExperiment, sample);
        this.ensureSampleAttachableToExperiment(sample, newExperiment);
        this.assignSampleAndRelatedDataSetsToExperiment(sample, newExperiment);
    }

    protected void updateProject(SamplePE sample, ProjectIdentifier projectIdentifierOrNull, Map<String, ProjectPE> projectCache) {
        if (!SamplePE.projectSamplesEnabled || sample.getProject() == null && projectIdentifierOrNull == null) {
            return;
        }
        ProjectPE newProject = this.tryFindProject(projectCache, projectIdentifierOrNull);
        if (!EntityHelper.equalEntities(newProject, sample.getProject())) {
            this.ensureSampleAttachableToProject(sample, newProject);
            this.assignSampleToProject(sample, newProject);
        }
    }

    private void ensureSampleAttachableToProject(SamplePE sample, ProjectPE project) {
        if (sample.getSpace() == null && project != null) {
            throw UserFailureException.fromTemplate((String)"It is not allowed to connect a shared sample '%s' to a project.", (Object[])new Object[]{sample.getIdentifier()});
        }
    }

    private void ensureSampleAttachableToExperiment(SamplePE sample, ExperimentPE newExperiment) {
        if (sample.getSpace() == null && newExperiment != null) {
            throw UserFailureException.fromTemplate((String)"It is not allowed to connect a shared sample '%s' to the experiment.", (Object[])new Object[]{sample.getIdentifier()});
        }
    }

    private void ensureExperimentIsValid(ExperimentIdentifier identOrNull, ExperimentPE experimentOrNull, SamplePE sample) {
        if (experimentOrNull != null && experimentOrNull.getDeletion() != null) {
            throw UserFailureException.fromTemplate((String)"The sample '%s' cannot be assigned to the experiment '%s' because the experiment has been deleted.", (Object[])new Object[]{sample.getSampleIdentifier(), identOrNull});
        }
    }

    protected void validateRelationshipGraph(Collection<SamplePE> parents, TechId relationship, SamplePE sample) {
        for (SamplePE parentToAdd : parents) {
            this.validateRelationshipGraph(parentToAdd, relationship, sample);
        }
    }

    private void validateRelationshipGraph(SamplePE parentToAdd, TechId relationship, SamplePE sample) {
        TechId sampleId = TechId.create((IIdHolder)sample);
        HashSet<TechId> visited = new HashSet<TechId>();
        Set<TechId> toVisit = new HashSet<TechId>();
        toVisit.add(TechId.create((IIdHolder)parentToAdd));
        while (!toVisit.isEmpty()) {
            if (toVisit.contains(sampleId)) {
                throw UserFailureException.fromTemplate((String)"Sample '%s' is an ancestor of Sample '%s' and cannot be at the same time set as its child.", (Object[])new Object[]{sample.getIdentifier(), parentToAdd.getIdentifier()});
            }
            Set<TechId> nextToVisit = this.getSampleDAO().listSampleIdsByChildrenIds(toVisit, relationship);
            visited.addAll(toVisit);
            nextToVisit.removeAll(visited);
            toVisit = nextToVisit;
        }
    }

    protected List<SamplePE> listSamplesByIdentifiers(List<SampleIdentifier> sampleIdentifiers, Map<SampleOwnerIdentifier, SampleOwner> sampleOwnerCache) {
        SampleOwnerWithContainer owner;
        assert (sampleIdentifiers != null) : "Sample identifiers unspecified.";
        HashMap<SampleOwnerWithContainer, ArrayList<String>> samplesByOwner = new HashMap<SampleOwnerWithContainer, ArrayList<String>>();
        for (SampleIdentifier sampleIdentifier : sampleIdentifiers) {
            String containerCodeOrNull;
            SampleOwner sampleOwner = this.getSampleOwner(sampleOwnerCache, sampleIdentifier);
            owner = new SampleOwnerWithContainer(sampleOwner, containerCodeOrNull = sampleIdentifier.tryGetContainerCode());
            ArrayList<String> ownerSamples = (ArrayList<String>)samplesByOwner.get(owner);
            if (ownerSamples == null) {
                ownerSamples = new ArrayList<String>();
                samplesByOwner.put(owner, ownerSamples);
            }
            ownerSamples.add(sampleIdentifier.getSampleSubCode());
        }
        ISampleDAO sampleDAO = this.getSampleDAO();
        ArrayList<SamplePE> results = new ArrayList<SamplePE>();
        for (Map.Entry entry : samplesByOwner.entrySet()) {
            owner = (SampleOwnerWithContainer)entry.getKey();
            List sampleCodes = (List)entry.getValue();
            SampleOwner sampleOwner = owner.getSampleOwner();
            String containerCodeOrNull = owner.getContainerCodeOrNull();
            List<SamplePE> samples = null;
            if (sampleOwner.isDatabaseInstanceLevel()) {
                samples = sampleDAO.listByCodesAndDatabaseInstance(sampleCodes, containerCodeOrNull);
            } else if (sampleOwner.isProjectLevel()) {
                ProjectPE project = sampleOwner.tryGetProject();
                samples = sampleDAO.listByCodesAndProject(sampleCodes, containerCodeOrNull, project);
            } else {
                assert (sampleOwner.isSpaceLevel()) : "Must be of space level.";
                samples = sampleDAO.listByCodesAndSpace(sampleCodes, containerCodeOrNull, sampleOwner.tryGetSpace());
            }
            results.addAll(samples);
        }
        return results;
    }

    protected List<SamplePE> listSamplesByTechIds(List<TechId> sampleTechIds) {
        assert (sampleTechIds != null) : "Sample identifiers unspecified.";
        ISampleDAO sampleDAO = this.getSampleDAO();
        ArrayList<Long> ids = new ArrayList<Long>();
        for (TechId sampleTechId : sampleTechIds) {
            ids.add(sampleTechId.getId());
        }
        ArrayList<SamplePE> results = new ArrayList<SamplePE>();
        results.addAll(sampleDAO.listByIDs(ids));
        return results;
    }

    protected void assertInstanceSampleCreationAllowed(List<? extends NewSample> samples) {
        ArrayList<NewSample> instanceSamples = new ArrayList<NewSample>();
        for (NewSample newSample : samples) {
            SampleIdentifier sampleIdentifier = SampleIdentifierFactory.parse(newSample);
            if (!sampleIdentifier.isDatabaseInstanceLevel()) continue;
            instanceSamples.add(newSample);
        }
        if (!instanceSamples.isEmpty()) {
            this.entityOperationChecker.assertInstanceSampleCreationAllowed(this.session, instanceSamples);
        }
    }

    protected void assertInstanceSampleUpdateAllowed(List<? extends SamplePE> samples) {
        ArrayList<SampleIdentifier> instanceSamples = new ArrayList<SampleIdentifier>();
        for (SamplePE samplePE : samples) {
            SampleIdentifier sampleIdentifier = samplePE.getSampleIdentifier();
            if (!sampleIdentifier.isDatabaseInstanceLevel()) continue;
            instanceSamples.add(sampleIdentifier);
        }
        if (!instanceSamples.isEmpty()) {
            this.entityOperationChecker.assertInstanceSampleUpdateAllowed(this.session, instanceSamples);
        }
    }

    private static class SampleOwnerWithContainer {
        private final SampleOwner sampleOwner;
        private final String containerCodeOrNull;

        public SampleOwnerWithContainer(SampleOwner sampleOwner, String containerCodeOrNull) {
            assert (sampleOwner != null);
            this.sampleOwner = sampleOwner;
            this.containerCodeOrNull = containerCodeOrNull;
        }

        public SampleOwner getSampleOwner() {
            return this.sampleOwner;
        }

        public String getContainerCodeOrNull() {
            return this.containerCodeOrNull;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.containerCodeOrNull == null ? 0 : this.containerCodeOrNull.hashCode());
            result = 31 * result + this.sampleOwner.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof SampleOwnerWithContainer)) {
                return false;
            }
            SampleOwnerWithContainer other = (SampleOwnerWithContainer)obj;
            if (this.containerCodeOrNull == null ? other.containerCodeOrNull != null : !this.containerCodeOrNull.equals(other.containerCodeOrNull)) {
                return false;
            }
            return this.sampleOwner.equals(other.sampleOwner);
        }

        public String toString() {
            return "SampleOwnerWithContainer [sampleOwner=" + this.sampleOwner + ", containerCodeOrNull=" + this.containerCodeOrNull + "]";
        }
    }
}

