/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.business.bo;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.server.business.IRelationshipService;
import ch.systemsx.cisd.openbis.generic.server.business.bo.AbstractBusinessObject;
import ch.systemsx.cisd.openbis.generic.server.business.bo.util.DataSetTypeWithoutExperimentChecker;
import ch.systemsx.cisd.openbis.generic.server.business.bo.util.SampleOwner;
import ch.systemsx.cisd.openbis.generic.server.business.bo.util.SampleOwnerFinder;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IEntityPropertiesConverter;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.ISampleDAO;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.dto.SamplePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.Session;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.properties.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.IManagedPropertyEvaluatorFactory;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.api.IEntityInformationProvider;
import ch.systemsx.cisd.openbis.generic.shared.util.HibernateUtils;
import java.util.HashMap;
import java.util.Map;

abstract class AbstractSampleIdentifierBusinessObject
extends AbstractBusinessObject {
    private final Map<SampleIdentifier, SamplePE> sampleByIdentifierCache = new HashMap<SampleIdentifier, SamplePE>();
    private final SampleOwnerFinder sampleOwnerFinder;
    private static final String PROPERTY_TYPES = "sampleType.sampleTypePropertyTypesInternal";
    private static final String EXPERIMENT = "experimentInternal";

    AbstractSampleIdentifierBusinessObject(IDAOFactory daoFactory, Session session, EntityKind entityKind, IEntityInformationProvider entityInformationProvider, IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory, DataSetTypeWithoutExperimentChecker dataSetTypeChecker, IRelationshipService relationshipService) {
        super(daoFactory, session, entityKind, entityInformationProvider, managedPropertyEvaluatorFactory, dataSetTypeChecker, relationshipService);
        this.sampleOwnerFinder = new SampleOwnerFinder(daoFactory, this.findPerson());
    }

    public AbstractSampleIdentifierBusinessObject(IDAOFactory daoFactory, Session session, IEntityPropertiesConverter converter, IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory, DataSetTypeWithoutExperimentChecker dataSetTypeChecker, IRelationshipService relationshipService) {
        super(daoFactory, session, converter, managedPropertyEvaluatorFactory, dataSetTypeChecker, relationshipService);
        this.sampleOwnerFinder = new SampleOwnerFinder(daoFactory, this.findPerson());
    }

    final SampleOwnerFinder getSampleOwnerFinder() {
        return this.sampleOwnerFinder;
    }

    final SamplePE getSampleByIdentifier(SampleIdentifier sampleIdentifier) throws UserFailureException {
        SamplePE sample = this.tryToGetSampleByIdentifier(sampleIdentifier);
        if (sample == null) {
            throw UserFailureException.fromTemplate((String)"No sample could be found for identifier '%s'.", (Object[])new Object[]{sampleIdentifier});
        }
        return sample;
    }

    public void clearSampleCache() {
        this.sampleByIdentifierCache.clear();
    }

    protected SamplePE tryToGetSampleByIdentifier(SampleIdentifier sampleIdentifier) {
        SamplePE result;
        assert (sampleIdentifier != null) : "Sample identifier unspecified.";
        SamplePE cachedResult = this.sampleByIdentifierCache.get(sampleIdentifier);
        if (cachedResult != null) {
            return cachedResult;
        }
        SampleOwner sampleOwner = this.sampleOwnerFinder.figureSampleOwner(sampleIdentifier);
        String sampleCode = sampleIdentifier.getSampleCode();
        ISampleDAO sampleDAO = this.getSampleDAO();
        if (sampleOwner.isDatabaseInstanceLevel()) {
            result = sampleDAO.tryFindByCodeAndDatabaseInstance(sampleCode);
        } else if (sampleOwner.isProjectLevel()) {
            result = sampleDAO.tryfindByCodeAndProject(sampleCode, sampleOwner.tryGetProject());
        } else {
            assert (sampleOwner.isSpaceLevel()) : "Must be of space level.";
            result = sampleDAO.tryFindByCodeAndSpace(sampleCode, sampleOwner.tryGetSpace());
        }
        if (result != null) {
            HibernateUtils.initialize(result.getExperiment());
            HibernateUtils.initialize(result.getProject());
            this.sampleByIdentifierCache.put(sampleIdentifier, result);
        }
        return result;
    }

    final SamplePE getSampleByTechId(TechId sampleId) throws UserFailureException {
        SamplePE sample = this.tryToGetSampleByTechId(sampleId);
        if (sample == null) {
            throw UserFailureException.fromTemplate((String)"No sample could be found for ID '%s'.", (Object[])new Object[]{sampleId});
        }
        return sample;
    }

    protected SamplePE tryToGetSampleByTechId(TechId sampleId) {
        String[] connections = new String[]{PROPERTY_TYPES, EXPERIMENT};
        return (SamplePE)this.getSampleDAO().tryGetByTechId(sampleId, connections);
    }
}

