/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.business.bo;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.server.business.IRelationshipService;
import ch.systemsx.cisd.openbis.generic.server.business.bo.AbstractBusinessObject;
import ch.systemsx.cisd.openbis.generic.server.business.bo.IAttachmentBO;
import ch.systemsx.cisd.openbis.generic.server.business.bo.util.DataSetTypeWithoutExperimentChecker;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IAttachmentDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.RelationshipUtils;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Attachment;
import ch.systemsx.cisd.openbis.generic.shared.dto.AttachmentHolderPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.AttachmentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.IModifierAndModificationDateBean;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.Session;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.IManagedPropertyEvaluatorFactory;
import java.util.List;
import org.springframework.dao.DataAccessException;

public final class AttachmentBO
extends AbstractBusinessObject
implements IAttachmentBO {
    private AttachmentPE attachment;
    private boolean dataChanged;

    public AttachmentBO(IDAOFactory daoFactory, Session session, IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory, DataSetTypeWithoutExperimentChecker dataSetTypeChecker, IRelationshipService relationshipService) {
        super(daoFactory, session, managedPropertyEvaluatorFactory, dataSetTypeChecker, relationshipService);
    }

    @Override
    public void deleteHolderAttachments(AttachmentHolderPE holder, List<String> fileNames, String reason) {
        IAttachmentDAO attachmentDAO = this.getAttachmentDAO();
        attachmentDAO.deleteAttachments(holder, reason, fileNames, this.session.tryGetPerson());
        this.updateModificationDateAndModifier(holder);
    }

    @Override
    public void updateAttachment(AttachmentHolderPE holder, Attachment attachmentDTO) {
        this.load(holder, attachmentDTO.getFileName(), attachmentDTO.getVersion());
        this.attachment.setDescription(attachmentDTO.getDescription());
        this.attachment.setTitle(attachmentDTO.getTitle());
        this.dataChanged = true;
        this.updateModificationDateAndModifier(holder);
    }

    private void updateModificationDateAndModifier(AttachmentHolderPE holder) {
        if (holder instanceof IModifierAndModificationDateBean) {
            IModifierAndModificationDateBean entity = (IModifierAndModificationDateBean)((Object)holder);
            PersonPE user = this.findPerson();
            RelationshipUtils.updateModificationDateAndModifier(entity, user, this.getTransactionTimeStamp());
        }
    }

    @Override
    public final void save() {
        assert (this.attachment != null) : "Can not save an undefined attachment.";
        if (this.dataChanged) {
            try {
                this.getAttachmentDAO().persist(this.attachment);
            }
            catch (DataAccessException ex) {
                AttachmentBO.throwException(ex, "Attachment '" + this.attachment.getFileName() + "'");
            }
        }
    }

    private void load(AttachmentHolderPE holder, String fileName, int version) {
        this.attachment = this.getAttachmentDAO().tryFindAttachmentByOwnerAndFileNameAndVersion(holder, fileName, version);
        if (this.attachment == null) {
            throw new UserFailureException("Attachment not found");
        }
        this.dataChanged = false;
    }
}

