/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.business.bo;

import ch.systemsx.cisd.common.db.SQLStateUtils;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.shared.dto.properties.EntityKind;
import java.sql.SQLException;
import org.apache.commons.lang3.StringUtils;
import org.springframework.dao.DataAccessException;

public final class DataAccessExceptionTranslator {
    public static final String UNIQUE_VIOLATION_FORMAT = "%s already exists in the database and needs to be unique.";
    public static final String FOREIGN_KEY_VIOLATION_FORMAT = "%s is being used. Delete all connected data %s first.";
    public static final String DETAILED_FOREIGN_KEY_VIOLATION_FORMAT = "%s is being used. Delete all connected data %s first. To find out which exactly objects are connected to this object go to its Detail view or use Search.";

    private DataAccessExceptionTranslator() {
    }

    public static final void throwException(DataAccessException exception, String subject, EntityKind entityKindOrNull) throws UserFailureException {
        assert (StringUtils.isNotBlank((CharSequence)subject)) : "Given subject can not be blank.";
        DataAccessExceptionTranslator.throwExceptionWithMsg(exception, StringUtils.capitalize((String)subject), entityKindOrNull);
    }

    private static final void throwExceptionWithMsg(DataAccessException exception, String subject, EntityKind entityKindOrNull) throws UserFailureException {
        assert (exception != null) : "DataAccessException not specified.";
        SQLException sqlException = SQLStateUtils.tryGetNextExceptionWithNonNullState((Throwable)exception);
        Throwable throwable = exception;
        if (sqlException != null) {
            String sqlState = sqlException.getSQLState();
            assert (sqlState != null) : "SQL state is null";
            if (SQLStateUtils.isUniqueViolation((String)sqlState)) {
                throw new UserFailureException(String.format(UNIQUE_VIOLATION_FORMAT, subject), (Throwable)exception);
            }
            if (SQLStateUtils.isForeignKeyViolation((String)sqlState)) {
                DataAccessExceptionTranslator.throwForeignKeyViolationException(subject, entityKindOrNull, (Exception)((Object)exception));
            } else {
                throwable = sqlException;
            }
        }
        throw new UserFailureException(throwable.getMessage(), (Throwable)exception);
    }

    public static void throwForeignKeyViolationException(String subject, EntityKind entityKindOrNull) throws UserFailureException {
        DataAccessExceptionTranslator.throwForeignKeyViolationException(subject, entityKindOrNull, null);
    }

    private static void throwForeignKeyViolationException(String subject, EntityKind entityKindOrNull, Exception exception) throws UserFailureException {
        throw new UserFailureException(String.format(DataAccessExceptionTranslator.getForeignKeyViolationFormat(entityKindOrNull), subject, DataAccessExceptionTranslator.getForeignKeyViolationDetailedDescription(entityKindOrNull)), (Throwable)exception);
    }

    private static String getForeignKeyViolationFormat(EntityKind entityKindOrNull) {
        return entityKindOrNull == null ? FOREIGN_KEY_VIOLATION_FORMAT : DETAILED_FOREIGN_KEY_VIOLATION_FORMAT;
    }

    private static String getForeignKeyViolationDetailedDescription(EntityKind entityKindOrNull) {
        if (entityKindOrNull == null) {
            return "";
        }
        switch (entityKindOrNull) {
            case DATA_SET: {
                return "";
            }
            case EXPERIMENT: {
                return "(data sets, samples)";
            }
            case MATERIAL: {
                return "";
            }
            case SAMPLE: {
                return "(data sets, contained and generated samples)";
            }
        }
        return "";
    }
}

