/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.business.bo;

import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.common.collection.CollectionUtils;
import ch.systemsx.cisd.common.collection.IValidator;
import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.multiplexer.BatchHandlerAbstract;
import ch.systemsx.cisd.common.multiplexer.BatchesResults;
import ch.systemsx.cisd.common.multiplexer.IBatch;
import ch.systemsx.cisd.common.multiplexer.IBatchHandler;
import ch.systemsx.cisd.common.multiplexer.IBatchIdProvider;
import ch.systemsx.cisd.common.multiplexer.IBatchResults;
import ch.systemsx.cisd.common.multiplexer.IMultiplexer;
import ch.systemsx.cisd.openbis.generic.server.business.IDataStoreServiceFactory;
import ch.systemsx.cisd.openbis.generic.server.business.IRelationshipService;
import ch.systemsx.cisd.openbis.generic.server.business.IServiceConversationClientManagerLocal;
import ch.systemsx.cisd.openbis.generic.server.business.bo.AbstractBusinessObject;
import ch.systemsx.cisd.openbis.generic.server.business.bo.AbstractDataSetBusinessObject;
import ch.systemsx.cisd.openbis.generic.server.business.bo.IDataSetTable;
import ch.systemsx.cisd.openbis.generic.server.business.bo.exception.DataSetDeletionDisallowedTypesException;
import ch.systemsx.cisd.openbis.generic.server.business.bo.util.DataSetTypeWithoutExperimentChecker;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDataDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.event.DeleteDataSetEventBuilder;
import ch.systemsx.cisd.openbis.generic.shared.IDataStoreService;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdentifierHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.TableModelAppender;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Code;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetArchivingStatus;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetBatchUpdateDetails;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataStoreServiceKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.LinkModel;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Metaproject;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ReportingPluginType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModel;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataSetBatchUpdatesDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataSetUploadContext;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataStorePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataStoreServicePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatasetDescription;
import ch.systemsx.cisd.openbis.generic.shared.dto.EntityTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.EntityTypePropertyTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExternalDataPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SamplePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.Session;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.properties.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.IManagedPropertyEvaluatorFactory;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.api.IEntityInformationProvider;
import ch.systemsx.cisd.openbis.generic.shared.translator.DataSetTranslator;
import ch.systemsx.cisd.openbis.generic.shared.util.HibernateUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataIntegrityViolationException;

public final class DataSetTable
extends AbstractDataSetBusinessObject
implements IDataSetTable {
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, DataSetTable.class);
    @Private
    static final String UPLOAD_COMMENT_TEXT = "Uploaded zip file contains the following data sets:";
    @Private
    static final String NEW_LINE = "\n";
    @Private
    static final String AND_MORE_TEMPLATE = "and %d more.";
    private boolean dataChanged;
    private final IDataStoreServiceFactory dssFactory;
    private final IMultiplexer multiplexer;
    private List<DataPE> dataSets;

    @Private
    static String createUploadComment(List<? extends DataPE> dataSets) {
        StringBuilder builder = new StringBuilder(UPLOAD_COMMENT_TEXT);
        int n = dataSets.size();
        for (int i = 0; i < n; ++i) {
            builder.append(NEW_LINE);
            String code = dataSets.get(i).getCode();
            int length = builder.length() + code.length();
            if (i < n - 1) {
                length += NEW_LINE.length() + String.format(AND_MORE_TEMPLATE, n - i - 1).length();
            }
            if (length >= 1000) {
                builder.append(String.format(AND_MORE_TEMPLATE, n - i));
                break;
            }
            builder.append(code);
        }
        return builder.toString();
    }

    private static void assertDatasetsAreAvailable(List<DataPE> datasets) {
        ArrayList<String> notAvailableDatasets = new ArrayList<String>();
        for (DataPE dataSet : datasets) {
            if (!dataSet.isExternalData() || dataSet.isAvailable()) continue;
            notAvailableDatasets.add(dataSet.getCode());
        }
        DataSetTable.throwUnavailableOperationExceptionIfNecessary(notAvailableDatasets);
    }

    private static void throwUnavailableOperationExceptionIfNecessary(List<String> unavailableDatasets) {
        if (!unavailableDatasets.isEmpty()) {
            throw UserFailureException.fromTemplate((String)"Operation failed because following data sets are not available (they are archived or their status is pending): %s. Unarchive these data sets or filter them out using data set status before performing the operation once again.", (Object[])new Object[]{CollectionUtils.abbreviate(unavailableDatasets, (int)10)});
        }
    }

    public static void assertDatasetsAreDeletable(List<DataPE> datasets) {
        ArrayList<String> notDeletableDatasets = new ArrayList<String>();
        for (DataPE dataSet : datasets) {
            if (dataSet.isDeletable()) continue;
            notDeletableDatasets.add(dataSet.getCode());
        }
        if (!notDeletableDatasets.isEmpty()) {
            throw UserFailureException.fromTemplate((String)"Deletion failed because the following data sets are required by a background process (their status is pending): %s. ", (Object[])new Object[]{CollectionUtils.abbreviate(notDeletableDatasets, (int)10)});
        }
    }

    public static void assertDatasetsWithDisallowedTypes(List<DataPE> datasets, boolean forceDisallowedTypes) {
        if (forceDisallowedTypes) {
            return;
        }
        ArrayList<String> datasetsWithDisallowedTypes = new ArrayList<String>();
        for (DataPE dataSet : datasets) {
            if (!dataSet.getDataSetType().isDeletionDisallow()) continue;
            datasetsWithDisallowedTypes.add(dataSet.getCode());
        }
        if (!datasetsWithDisallowedTypes.isEmpty()) {
            throw new DataSetDeletionDisallowedTypesException(datasetsWithDisallowedTypes);
        }
    }

    public DataSetTable(IDAOFactory daoFactory, IDataStoreServiceFactory dssFactory, Session session, IRelationshipService relationshipService, IServiceConversationClientManagerLocal conversationClient, IEntityInformationProvider entityInformationProvider, IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory, IMultiplexer multiplexer, DataSetTypeWithoutExperimentChecker dataSetTypeChecker) {
        super(daoFactory, session, relationshipService, conversationClient, entityInformationProvider, managedPropertyEvaluatorFactory, dataSetTypeChecker);
        this.dssFactory = dssFactory;
        this.multiplexer = multiplexer;
    }

    @Override
    public final List<DataPE> getDataSets() {
        assert (this.dataSets != null) : "Data Sets not loaded.";
        return this.dataSets;
    }

    @Override
    public List<ExternalDataPE> getNonDeletableExternalDataSets() {
        ArrayList<ExternalDataPE> result = new ArrayList<ExternalDataPE>();
        for (DataPE dataSet : this.dataSets) {
            ExternalDataPE externalDataSet = dataSet.tryAsExternalData();
            if (externalDataSet == null || externalDataSet.isDeletable()) continue;
            result.add(externalDataSet);
        }
        return result;
    }

    @Override
    public final List<ExternalDataPE> getExternalData() {
        assert (this.dataSets != null) : "Data Sets not loaded.";
        ArrayList<ExternalDataPE> result = new ArrayList<ExternalDataPE>();
        for (DataPE dataSet : this.dataSets) {
            if (!dataSet.isExternalData()) continue;
            result.add(dataSet.tryAsExternalData());
        }
        return result;
    }

    @Override
    public void setDataSets(List<DataPE> dataSets) {
        this.dataSets = dataSets;
    }

    @Override
    public void loadByDataSetCodes(List<String> dataSetCodes, boolean withProperties, boolean lockForUpdate) {
        IDataDAO dataDAO = this.getDataDAO();
        this.dataSets = new ArrayList<DataPE>();
        this.dataSets.addAll(dataDAO.tryToFindFullDataSetsByCodes(dataSetCodes, withProperties, lockForUpdate));
    }

    @Override
    public void loadByIds(List<TechId> ids) {
        this.dataSets = new ArrayList<DataPE>();
        if (ids.isEmpty()) {
            return;
        }
        IDataDAO dataDAO = this.getDataDAO();
        this.dataSets.addAll(dataDAO.tryToFindFullDataSetsByIds(TechId.asLongs(ids), false, false));
    }

    @Override
    public final void loadBySampleTechId(TechId sampleId) {
        assert (sampleId != null) : "Unspecified sample id";
        SamplePE sample = (SamplePE)this.getSampleDAO().getByTechId(sampleId);
        this.dataSets = new ArrayList<DataPE>();
        this.dataSets.addAll(this.getDataDAO().listDataSets(sample));
    }

    @Override
    public final void loadBySampleTechIdWithoutRelationships(TechId sampleId) {
        assert (sampleId != null) : "Unspecified sample id";
        SamplePE sample = (SamplePE)this.getSampleDAO().getByTechId(sampleId);
        this.dataSets = new ArrayList<DataPE>();
        this.dataSets.addAll(this.getDataDAO().listDataSetsWithoutRelationships(sample));
    }

    @Override
    public void loadByExperimentTechId(TechId experimentId) {
        assert (experimentId != null) : "Unspecified experiment id";
        ExperimentPE experiment = (ExperimentPE)this.getExperimentDAO().getByTechId(experimentId);
        this.dataSets = new ArrayList<DataPE>();
        this.dataSets.addAll(this.getDataDAO().listDataSets(experiment));
    }

    @Override
    public void deleteLoadedDataSets(String reason, boolean forceDisallowedTypes) {
        DataSetTable.assertDatasetsAreDeletable(this.dataSets);
        DataSetTable.assertDatasetsWithDisallowedTypes(this.dataSets, forceDisallowedTypes);
        Map<DataStorePE, List<DataPE>> allToBeDeleted = this.groupDataSetsByDataStores();
        for (Map.Entry<DataStorePE, List<DataPE>> entry : allToBeDeleted.entrySet()) {
            List<DataPE> allDataSets = entry.getValue();
            for (DataPE dataSet : allDataSets) {
                this.deleteDataSetLocally(dataSet, reason);
            }
        }
    }

    private void deleteDataSetLocally(DataPE dataSet, String reason) throws UserFailureException {
        try {
            this.getDataDAO().delete(dataSet);
            DeleteDataSetEventBuilder builder = new DeleteDataSetEventBuilder(dataSet, this.session.tryGetPerson());
            builder.setReason(reason);
            this.getEventDAO().persist(builder.getEvent());
        }
        catch (DataIntegrityViolationException ex) {
            DataSetTable.throwEntityInUseException(String.format("Data Set '%s'", dataSet.getCode()), EntityKind.DATA_SET);
        }
        catch (DataAccessException ex) {
            DataSetTable.throwException(ex, String.format("Data Set '%s'", dataSet.getCode()), EntityKind.DATA_SET);
        }
    }

    @Override
    public String uploadLoadedDataSetsToCIFEX(DataSetUploadContext uploadContext) {
        DataSetTable.assertDatasetsAreAvailable(this.dataSets);
        Map<DataStorePE, List<DataPE>> map = this.groupDataByDataStores();
        uploadContext.setUserEMail(this.session.getPrincipal().getEmail());
        uploadContext.setSessionUserID(this.session.getUserName());
        if (StringUtils.isBlank((CharSequence)uploadContext.getComment())) {
            uploadContext.setComment(DataSetTable.createUploadComment(this.dataSets));
        }
        ArrayList<DataPE> dataSetsWithUnknownDSS = new ArrayList<DataPE>();
        for (Map.Entry<DataStorePE, List<DataPE>> entry : map.entrySet()) {
            DataStorePE dataStore = entry.getKey();
            List<DataPE> dataSetsOfStore = entry.getValue();
            for (DataPE dataSet : dataSetsOfStore) {
                HibernateUtils.initialize(dataSet.getParents());
                HibernateUtils.initialize(dataSet.getProperties());
                ExperimentPE experiment = this.getExperimentOrNull(dataSet);
                if (experiment == null) continue;
                HibernateUtils.initialize(experiment.getProject().getSpace());
                HibernateUtils.initialize(experiment.getProperties());
            }
            if (StringUtils.isBlank((CharSequence)dataStore.getRemoteUrl())) {
                dataSetsWithUnknownDSS.addAll(dataSetsOfStore);
                continue;
            }
            this.uploadDataSetsToCIFEX(dataStore, dataSetsOfStore, uploadContext);
        }
        StringBuilder builder = new StringBuilder();
        if (!dataSetsWithUnknownDSS.isEmpty()) {
            builder.append("The following data sets couldn't been uploaded because of unkown data store:");
            for (DataPE dataSet : dataSetsWithUnknownDSS) {
                builder.append(' ').append(dataSet.getCode());
            }
        }
        return builder.toString();
    }

    private ExperimentPE getExperimentOrNull(DataPE dataSet) {
        SamplePE sampleOrNull = dataSet.tryGetSample();
        return sampleOrNull != null ? sampleOrNull.getExperiment() : dataSet.getExperiment();
    }

    private Map<DataStorePE, List<DataPE>> groupDataByDataStores() {
        LinkedHashMap<DataStorePE, List<DataPE>> map = new LinkedHashMap<DataStorePE, List<DataPE>>();
        for (DataPE dataSet : this.dataSets) {
            DataStorePE dataStore = dataSet.getDataStore();
            ArrayList<DataPE> list = (ArrayList<DataPE>)map.get(dataStore);
            if (list == null) {
                list = new ArrayList<DataPE>();
                map.put(dataStore, list);
            }
            list.add(dataSet);
        }
        return map;
    }

    private Map<DataStorePE, List<ExternalDataPE>> groupExternalDataByDataStores() {
        LinkedHashMap<DataStorePE, List<ExternalDataPE>> map = new LinkedHashMap<DataStorePE, List<ExternalDataPE>>();
        for (DataPE dataSet : this.dataSets) {
            if (!dataSet.isExternalData()) continue;
            DataStorePE dataStore = dataSet.getDataStore();
            ArrayList<ExternalDataPE> list = (ArrayList<ExternalDataPE>)map.get(dataStore);
            if (list == null) {
                list = new ArrayList<ExternalDataPE>();
                map.put(dataStore, list);
            }
            list.add(dataSet.tryAsExternalData());
        }
        return map;
    }

    private Map<DataStorePE, List<DataPE>> groupDataSetsByDataStores() {
        LinkedHashMap<DataStorePE, List<DataPE>> map = new LinkedHashMap<DataStorePE, List<DataPE>>();
        for (DataPE dataSet : this.dataSets) {
            DataStorePE dataStore = dataSet.getDataStore();
            ArrayList<DataPE> list = (ArrayList<DataPE>)map.get(dataStore);
            if (list == null) {
                list = new ArrayList<DataPE>();
                map.put(dataStore, list);
            }
            list.add(dataSet);
        }
        return map;
    }

    private void uploadDataSetsToCIFEX(DataStorePE dataStore, List<DataPE> list, DataSetUploadContext context) {
        IDataStoreService service = this.getConversationClient().getDataStoreService(dataStore.getRemoteUrl(), this.session.getSessionToken());
        String sessionToken = dataStore.getSessionToken();
        List<AbstractExternalData> cleanDataSets = DataSetTranslator.translate(list, "?", "?", new HashMap<Long, Set<Metaproject>>(), this.managedPropertyEvaluatorFactory, new IValidator<IIdentifierHolder>(){

            public boolean isValid(IIdentifierHolder object) {
                return false;
            }
        });
        service.uploadDataSetsToCIFEX(sessionToken, cleanDataSets, context);
    }

    @Override
    public void processDatasets(String datastoreServiceKey, String datastoreCode, List<String> datasetCodes, Map<String, String> parameterBindings) {
        DataStorePE dataStore = this.findDataStore(datastoreCode);
        IDataStoreService service = DataSetTable.tryGetDataStoreService(dataStore, this.dssFactory);
        if (service == null) {
            throw this.createUnknownDataStoreServerException();
        }
        List<DatasetDescription> locations = this.loadAvailableDatasetDescriptions(datasetCodes);
        String sessionToken = dataStore.getSessionToken();
        String userSessionToken = this.session.getSessionToken();
        this.validateParameterBindings(datastoreServiceKey, parameterBindings);
        this.validateProcessingServiceKey(dataStore, datastoreServiceKey, datastoreCode);
        parameterBindings.put("user", this.session.tryGetPerson().getUserId());
        service.processDatasets(sessionToken, userSessionToken, datastoreServiceKey, locations, parameterBindings, this.tryGetLoggedUserId(), this.tryGetLoggedUserEmail());
    }

    @Override
    public void processDatasets(final String datastoreServiceKey, List<String> datasetCodes, final Map<String, String> parameterBindings) {
        List<DatasetDescription> locations = this.loadAvailableDatasetDescriptions(datasetCodes);
        IBatchIdProvider<DatasetDescription, String> batchIdProvider = new IBatchIdProvider<DatasetDescription, String>(){

            public String getBatchId(DatasetDescription object) {
                return object.getDataStoreCode();
            }
        };
        BatchHandlerAbstract<DatasetDescription, String, Void> batchHandler = new BatchHandlerAbstract<DatasetDescription, String, Void>(){

            public void validateBatch(IBatch<DatasetDescription, String> batch) {
                DataSetTable.this.validateParameterBindings(datastoreServiceKey, parameterBindings);
                DataStorePE dataStore = DataSetTable.this.findDataStore((String)batch.getId());
                DataSetTable.this.validateProcessingServiceKey(dataStore, datastoreServiceKey, (String)batch.getId());
            }

            public List<Void> processBatch(IBatch<DatasetDescription, String> batch) {
                DataStorePE dataStore = DataSetTable.this.findDataStore((String)batch.getId());
                String sessionToken = dataStore.getSessionToken();
                String userSessionToken = DataSetTable.this.session.getSessionToken();
                IDataStoreService service = AbstractBusinessObject.tryGetDataStoreService(dataStore, DataSetTable.this.dssFactory);
                parameterBindings.put("user", DataSetTable.this.session.tryGetPerson().getUserId());
                service.processDatasets(sessionToken, userSessionToken, datastoreServiceKey, batch.getObjects(), parameterBindings, DataSetTable.this.tryGetLoggedUserId(), DataSetTable.this.tryGetLoggedUserEmail());
                return Collections.emptyList();
            }
        };
        this.multiplexer.process(locations, (IBatchIdProvider)batchIdProvider, (IBatchHandler)batchHandler);
    }

    private void validateParameterBindings(String datastoreServiceKey, Map<String, String> parameterBindings) {
        String value = parameterBindings.get("user");
        if (value != null) {
            throw new UserFailureException("Couldn't execute processing plugin '" + datastoreServiceKey + "' because parameter '" + "user" + "' has already be bound to the value '" + value + "'. Note, that parameter '" + "user" + "' is a reserved parameter used internally.");
        }
    }

    private void validateProcessingServiceKey(DataStorePE dataStore, String datastoreServiceKey, String dataStoreCode) {
        for (DataStoreServicePE service : dataStore.getServices()) {
            if (!service.getKey().equals(datastoreServiceKey) || !service.getKind().equals(DataStoreServiceKind.PROCESSING)) continue;
            return;
        }
        throw new UserFailureException("Data store '" + dataStoreCode + "' does not have '" + datastoreServiceKey + "' processing plugin configured.");
    }

    private void validateReportingServiceKey(DataStorePE dataStore, String datastoreServiceKey, String dataStoreCode) {
        for (DataStoreServicePE service : dataStore.getServices()) {
            if (!service.getKey().equals(datastoreServiceKey) || !service.isTableReport()) continue;
            return;
        }
        throw new UserFailureException("Data store '" + dataStoreCode + "' does not have '" + datastoreServiceKey + "' reporting plugin configured.");
    }

    private void validateAggregationServiceKey(DataStorePE dataStore, String datastoreServiceKey, String dataStoreCode) {
        for (DataStoreServicePE service : dataStore.getServices()) {
            if (!service.getKey().equals(datastoreServiceKey) || !ReportingPluginType.AGGREGATION_TABLE_MODEL.equals(service.getReportingPluginTypeOrNull())) continue;
            return;
        }
        throw new UserFailureException("Data store '" + dataStoreCode + "' does not have '" + datastoreServiceKey + "' aggregation plugin configured.");
    }

    private String tryGetLoggedUserEmail() {
        return this.session.tryGetPerson() == null ? null : this.session.tryGetPerson().getEmail();
    }

    private String tryGetLoggedUserId() {
        return this.session.tryGetPerson() == null ? null : this.session.tryGetPerson().getUserId();
    }

    private ConfigurationFailureException createUnknownDataStoreServerException() {
        return new ConfigurationFailureException("Connection to Data Store Server has not been configured. Conntact your administrator.");
    }

    @Override
    public TableModel createReportFromDatasets(String datastoreServiceKey, String datastoreCode, List<String> datasetCodes) {
        DataStorePE dataStore = this.findDataStore(datastoreCode);
        if (StringUtils.isBlank((CharSequence)dataStore.getRemoteUrl())) {
            throw this.createUnknownDataStoreServerException();
        }
        this.validateReportingServiceKey(dataStore, datastoreServiceKey, datastoreCode);
        IDataStoreService service = this.getConversationClient().getDataStoreService(dataStore.getRemoteUrl(), this.session.getSessionToken());
        List<DatasetDescription> locations = this.loadAvailableDatasetDescriptions(datasetCodes);
        String sessionToken = dataStore.getSessionToken();
        String userSessionToken = this.session.getSessionToken();
        return service.createReportFromDatasets(sessionToken, userSessionToken, datastoreServiceKey, locations, this.tryGetLoggedUserId(), this.tryGetLoggedUserEmail());
    }

    @Override
    public TableModel createReportFromDatasets(final String datastoreServiceKey, List<String> datasetCodes) {
        List<DatasetDescription> locations = this.loadAvailableDatasetDescriptions(datasetCodes);
        IBatchIdProvider<DatasetDescription, String> batchIdProvider = new IBatchIdProvider<DatasetDescription, String>(){

            public String getBatchId(DatasetDescription object) {
                return object.getDataStoreCode();
            }
        };
        BatchHandlerAbstract<DatasetDescription, String, TableModel> batchHandler = new BatchHandlerAbstract<DatasetDescription, String, TableModel>(){

            public void validateBatch(IBatch<DatasetDescription, String> batch) {
                DataStorePE dataStore = DataSetTable.this.findDataStore((String)batch.getId());
                DataSetTable.this.validateReportingServiceKey(dataStore, datastoreServiceKey, (String)batch.getId());
            }

            public List<TableModel> processBatch(IBatch<DatasetDescription, String> batch) {
                DataStorePE dataStore = DataSetTable.this.findDataStore((String)batch.getId());
                String sessionToken = DataSetTable.this.session.getSessionToken();
                String storeSessionToken = dataStore.getSessionToken();
                IDataStoreService service = DataSetTable.this.getConversationClient().getDataStoreService(dataStore.getRemoteUrl(), sessionToken);
                TableModel tableModel = service.createReportFromDatasets(storeSessionToken, sessionToken, datastoreServiceKey, batch.getObjects(), DataSetTable.this.tryGetLoggedUserId(), DataSetTable.this.tryGetLoggedUserEmail());
                return Collections.singletonList(tableModel);
            }
        };
        BatchesResults batchesResults = this.multiplexer.process(locations, (IBatchIdProvider)batchIdProvider, (IBatchHandler)batchHandler);
        TableModelAppender tableModelAppender = new TableModelAppender();
        for (IBatchResults batchResults : batchesResults.getBatchResults()) {
            try {
                tableModelAppender.append((TableModel)batchResults.getResults().get(0));
            }
            catch (TableModelAppender.TableModelWithDifferentColumnCountException e) {
                throw new UserFailureException("Could not merge reports from multiple data stores because '" + (String)batchResults.getBatchId() + "' data store returned a table with an incorrect number of columns (expected: " + e.getExpectedColumnCount() + ", got: " + e.getAppendedColumnCount() + ")");
            }
            catch (TableModelAppender.TableModelWithDifferentColumnIdsException e) {
                throw new UserFailureException("Could not merge reports from multiple data stores because '" + (String)batchResults.getBatchId() + "' data store returned a table with different column ids (expected: " + e.getExpectedColumnIds() + ", got: " + e.getAppendedColumnIds() + ")");
            }
            catch (TableModelAppender.TableModelWithIncompatibleColumnTypesException e) {
                throw new UserFailureException("Could not merge reports from multiple data stores because '" + (String)batchResults.getBatchId() + "' data store returned a table with incompatible types of columns (expected: " + e.getExpectedColumnTypes() + ", got: " + e.getAppendedColumnTypes() + ")");
            }
        }
        return tableModelAppender.toTableModel();
    }

    private List<DatasetDescription> loadAvailableDatasetDescriptions(List<String> dataSetCodes) {
        IDataDAO dataDAO = this.getDataDAO();
        ArrayList<DatasetDescription> result = new ArrayList<DatasetDescription>();
        ArrayList<String> notAvailableDatasets = new ArrayList<String>();
        List<DataPE> data = dataDAO.tryToFindFullDataSetsByCodes(dataSetCodes, false, false);
        for (DataPE dataSet : data) {
            if (dataSet.isExternalData()) {
                ExternalDataPE externalData = dataSet.tryAsExternalData();
                if (externalData.getStatus().isAvailable()) {
                    result.add(DataSetTranslator.translateToDescription(externalData));
                    continue;
                }
                notAvailableDatasets.add(dataSet.getCode());
                continue;
            }
            result.add(DataSetTranslator.translateToDescription(dataSet));
        }
        DataSetTable.throwUnavailableOperationExceptionIfNecessary(notAvailableDatasets);
        return result;
    }

    private DataStorePE findDataStore(String datastoreCode) {
        DataStorePE dataStore = this.getDataStoreDAO().tryToFindDataStoreByCode(datastoreCode);
        if (dataStore == null) {
            throw new UserFailureException("Cannot find the data store " + datastoreCode);
        }
        return dataStore;
    }

    @Override
    public void loadByDataStore(DataStorePE dataStore) {
        assert (dataStore != null) : "Unspecified data store";
        assert (this.dataSets == null) : "Data already loaded";
        this.dataSets = new ArrayList<DataPE>();
        this.dataSets.addAll(this.getDataDAO().listExternalData(dataStore));
    }

    @Override
    public int archiveDatasets(boolean removeFromDataStore, Map<String, String> options) {
        Map<DataStorePE, List<ExternalDataPE>> datasetsByStore = this.groupExternalDataByDataStores();
        Map<DataStoreWithService, List<ExternalDataPE>> datasetsWithService = this.removeDataStoresWhereArchivingIsCurrentlyNotPossible(this.enrichWithService(datasetsByStore));
        DataSetArchivingStatus pendingStatus = removeFromDataStore ? DataSetArchivingStatus.ARCHIVE_PENDING : DataSetArchivingStatus.BACKUP_PENDING;
        int result = this.filterByStatusAndUpdate(this.remap(datasetsWithService), DataSetArchivingStatus.AVAILABLE, pendingStatus);
        this.performArchiving(datasetsWithService, removeFromDataStore, options);
        return result;
    }

    private Map<DataStorePE, List<ExternalDataPE>> remap(Map<DataStoreWithService, List<ExternalDataPE>> datasetsWithService) {
        HashMap<DataStorePE, List<ExternalDataPE>> result = new HashMap<DataStorePE, List<ExternalDataPE>>();
        for (Map.Entry<DataStoreWithService, List<ExternalDataPE>> entry : datasetsWithService.entrySet()) {
            result.put(entry.getKey().dataStore, entry.getValue());
        }
        return result;
    }

    private Map<DataStoreWithService, List<ExternalDataPE>> removeDataStoresWhereArchivingIsCurrentlyNotPossible(Map<DataStoreWithService, List<ExternalDataPE>> datasetsWithService) {
        HashMap<DataStoreWithService, List<ExternalDataPE>> result = new HashMap<DataStoreWithService, List<ExternalDataPE>>();
        for (Map.Entry<DataStoreWithService, List<ExternalDataPE>> entry : datasetsWithService.entrySet()) {
            DataStoreWithService storeWithService = entry.getKey();
            if (storeWithService.service.isArchivingPossible(storeWithService.dataStore.getSessionToken())) {
                result.put(storeWithService, entry.getValue());
                continue;
            }
            operationLog.warn((Object)("Archiving is currently not possible on Data Store " + storeWithService.dataStore.getCode()));
        }
        return result;
    }

    @Override
    public int unarchiveDatasets() {
        Map<DataStorePE, List<ExternalDataPE>> datasetsByStore = this.groupExternalDataByDataStores();
        Map<DataStoreWithService, List<ExternalDataPE>> datasetsWithService = this.enrichWithService(datasetsByStore);
        boolean needRefresh = this.prepareForUnarchiving(datasetsWithService);
        if (needRefresh) {
            datasetsByStore = this.groupExternalDataByDataStores();
            datasetsWithService = this.enrichWithService(datasetsByStore);
        }
        int result = this.filterByStatusAndUpdate(datasetsByStore, DataSetArchivingStatus.ARCHIVED, DataSetArchivingStatus.UNARCHIVE_PENDING);
        this.performUnarchiving(datasetsWithService);
        return result;
    }

    private boolean prepareForUnarchiving(Map<DataStoreWithService, List<ExternalDataPE>> datasetsWithService) {
        LinkedList<String> result = new LinkedList<String>();
        boolean enhancementsFound = false;
        for (Map.Entry<DataStoreWithService, List<ExternalDataPE>> entry : datasetsWithService.entrySet()) {
            DataStoreWithService dssws = entry.getKey();
            DataStorePE dataStore = dssws.dataStore;
            IDataStoreService service = dssws.service;
            List<ExternalDataPE> datasets = entry.getValue();
            if (datasets.isEmpty()) continue;
            LinkedList<String> dataSetCodes = new LinkedList<String>();
            for (ExternalDataPE data : datasets) {
                dataSetCodes.add(data.getCode());
            }
            List<String> enhancedCodes = service.getDataSetCodesForUnarchiving(dataStore.getSessionToken(), this.session.getSessionToken(), dataSetCodes, this.tryGetLoggedUserId());
            result.addAll(enhancedCodes);
            if (new HashSet<String>(dataSetCodes).containsAll(enhancedCodes)) continue;
            enhancementsFound = true;
        }
        if (enhancementsFound) {
            this.loadByDataSetCodes(result, false, true);
            return true;
        }
        return false;
    }

    @Override
    public int lockDatasets() {
        Map<DataStorePE, List<ExternalDataPE>> datasetsByStore = this.groupExternalDataByDataStores();
        return this.filterByStatusAndUpdate(datasetsByStore, DataSetArchivingStatus.AVAILABLE, DataSetArchivingStatus.LOCKED);
    }

    @Override
    public int unlockDatasets() {
        Map<DataStorePE, List<ExternalDataPE>> datasetsByStore = this.groupExternalDataByDataStores();
        return this.filterByStatusAndUpdate(datasetsByStore, DataSetArchivingStatus.LOCKED, DataSetArchivingStatus.AVAILABLE);
    }

    private int filterByStatusAndUpdate(Map<DataStorePE, List<ExternalDataPE>> datasetsByStore, DataSetArchivingStatus oldStatus, DataSetArchivingStatus newStatus) {
        ArrayList<String> codesToUpdate = new ArrayList<String>();
        IDataDAO dataDAO = this.getDataDAO();
        for (List<ExternalDataPE> data : datasetsByStore.values()) {
            Iterator<ExternalDataPE> iterator = data.iterator();
            while (iterator.hasNext()) {
                ExternalDataPE dataSet = iterator.next();
                if (dataSet.getStatus() != oldStatus) {
                    iterator.remove();
                    continue;
                }
                codesToUpdate.add(dataSet.getCode());
            }
        }
        dataDAO.updateDataSetStatuses(codesToUpdate, newStatus);
        return codesToUpdate.size();
    }

    private void performUnarchiving(Map<DataStoreWithService, List<ExternalDataPE>> datasetsByStore) {
        this.performArchivingAction(datasetsByStore, new IArchivingAction(){

            @Override
            public void execute(String sessionToken, IDataStoreService service, List<DatasetDescription> descriptions, String userId, String userEmailOrNull) {
                service.unarchiveDatasets(sessionToken, DataSetTable.this.session.getSessionToken(), descriptions, userId, userEmailOrNull);
            }

            @Override
            public DataSetArchivingStatus getStatusToRestoreOnFailure() {
                return DataSetArchivingStatus.ARCHIVED;
            }
        });
    }

    private void performArchiving(Map<DataStoreWithService, List<ExternalDataPE>> datasetsByStore, final boolean removeFromDataStore, final Map<String, String> options) {
        this.performArchivingAction(datasetsByStore, new IArchivingAction(){

            @Override
            public void execute(String sessionToken, IDataStoreService service, List<DatasetDescription> descriptions, String userId, String userEmailOrNull) {
                service.archiveDatasets(sessionToken, DataSetTable.this.session.getSessionToken(), descriptions, userId, userEmailOrNull, removeFromDataStore, options);
            }

            @Override
            public DataSetArchivingStatus getStatusToRestoreOnFailure() {
                return DataSetArchivingStatus.AVAILABLE;
            }
        });
    }

    private Map<DataStoreWithService, List<ExternalDataPE>> enrichWithService(Map<DataStorePE, List<ExternalDataPE>> datasetsByStore) {
        HashMap<DataStoreWithService, List<ExternalDataPE>> result = new HashMap<DataStoreWithService, List<ExternalDataPE>>();
        for (Map.Entry<DataStorePE, List<ExternalDataPE>> entry : datasetsByStore.entrySet()) {
            DataStorePE dataStore = entry.getKey();
            IDataStoreService service = DataSetTable.tryGetDataStoreService(dataStore, this.dssFactory);
            if (service == null) {
                throw this.createUnknownDataStoreServerException();
            }
            List<ExternalDataPE> datasets = entry.getValue();
            DataStoreWithService dataStoreWithService = new DataStoreWithService();
            dataStoreWithService.dataStore = dataStore;
            dataStoreWithService.service = service;
            result.put(dataStoreWithService, datasets);
        }
        return result;
    }

    private void performArchivingAction(Map<DataStoreWithService, List<ExternalDataPE>> datasetsByStore, IArchivingAction archivingAction) {
        Iterator<Map.Entry<DataStoreWithService, List<ExternalDataPE>>> iterator = datasetsByStore.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<DataStoreWithService, List<ExternalDataPE>> entry = iterator.next();
            DataStorePE dataStore = entry.getKey().dataStore;
            IDataStoreService service = entry.getKey().service;
            List<ExternalDataPE> datasets = entry.getValue();
            if (datasets.isEmpty()) continue;
            List<DatasetDescription> descriptions = DataSetTranslator.translateToDescriptions(datasets);
            String sessionToken = dataStore.getSessionToken();
            String userId = this.tryGetLoggedUserId();
            String userEmailOrNull = this.tryGetLoggedUserEmail();
            try {
                archivingAction.execute(sessionToken, service, descriptions, userId, userEmailOrNull);
            }
            catch (Exception e) {
                operationLog.error((Object)("Operation failed for the following data sets: " + CollectionUtils.abbreviate((Collection)Code.extractCodes(datasets), (int)10)), (Throwable)e);
                this.clearPendingStatuses(datasets, iterator, archivingAction.getStatusToRestoreOnFailure());
                throw UserFailureException.fromTemplate((Throwable)e, (String)"Operation couldn't be performed for following datasets: %s. Archiver may not be configured properly. Please contact your administrator.", (Object[])new Object[]{CollectionUtils.abbreviate((Collection)Code.extractCodes(datasets), (int)10)});
            }
        }
    }

    private void clearPendingStatuses(List<ExternalDataPE> datasets, Iterator<Map.Entry<DataStoreWithService, List<ExternalDataPE>>> iterator, DataSetArchivingStatus statusToRestoreOnFailure) {
        ArrayList<ExternalDataPE> datasetsWithPendingStatus = new ArrayList<ExternalDataPE>(datasets);
        while (iterator.hasNext()) {
            datasetsWithPendingStatus.addAll((Collection<ExternalDataPE>)iterator.next().getValue());
        }
        List codes = Code.extractCodes(datasetsWithPendingStatus);
        this.getDataDAO().updateDataSetStatuses(codes, statusToRestoreOnFailure);
    }

    @Override
    public void save() {
        assert (this.dataChanged) : "Data not changed";
        assert (this.dataSets != null) : "Undefined data sets.";
        try {
            this.checkMandatoryProperties();
            IDataDAO dataDAO = this.getDataDAO();
            dataDAO.updateDataSets(this.dataSets, this.findPerson());
        }
        catch (DataAccessException ex) {
            DataSetTable.throwException(ex, String.format("One of data sets", new Object[0]));
        }
        this.dataChanged = false;
        operationLog.info((Object)"State of data sets saved.");
        this.clearSampleCache();
    }

    private void checkMandatoryProperties() {
        HashMap<EntityTypePE, List<EntityTypePropertyTypePE>> cache = new HashMap<EntityTypePE, List<EntityTypePropertyTypePE>>();
        for (DataPE s : this.dataSets) {
            this.entityPropertiesConverter.checkMandatoryProperties(s.getProperties(), s.getDataSetType(), cache);
        }
    }

    @Override
    public void checkBeforeUpdate(List<DataSetBatchUpdatesDTO> updates) {
        if (updates == null) {
            throw new IllegalArgumentException("Data set updates list cannot be null.");
        }
        this.loadByDataSetCodes(Code.extractCodes(updates), true, true);
        HashMap<String, Integer> versionsMap = new HashMap<String, Integer>();
        for (DataPE dataSet : this.dataSets) {
            versionsMap.put(dataSet.getCode(), dataSet.getVersion());
        }
        for (DataSetBatchUpdatesDTO update : updates) {
            if (update.getCode() == null) {
                throw new UserFailureException("Data set doesn't have a specified code and therefore cannot be updated.");
            }
            Integer version = (Integer)versionsMap.get(update.getCode());
            if (version == null) {
                throw new UserFailureException("Data set with code " + update.getCode() + " is not in the database and therefore cannot be updated.");
            }
            if (version.equals(update.getVersion())) continue;
            StringBuffer sb = new StringBuffer();
            sb.append("Data set ");
            sb.append(update.getCode());
            sb.append(" has been updated since it was retrieved.\n");
            sb.append("[Current: " + version);
            sb.append(", Retrieved: " + update.getVersion());
            sb.append("]");
            throw new UserFailureException(sb.toString());
        }
    }

    @Override
    public void update(List<DataSetBatchUpdatesDTO> updates) {
        assert (updates != null) : "Unspecified updates.";
        this.setBatchUpdateMode(true);
        this.loadByDataSetCodes(Code.extractCodes(updates), true, true);
        HashMap<String, DataPE> dataSetsByCode = new HashMap<String, DataPE>();
        for (DataPE dataSet : this.dataSets) {
            dataSetsByCode.put(dataSet.getIdentifier(), dataSet);
        }
        for (DataSetBatchUpdatesDTO dataSetUpdates : updates) {
            DataPE dataSet = (DataPE)dataSetsByCode.get(dataSetUpdates.getCode());
            this.prepareBatchUpdate(dataSet, dataSetUpdates);
        }
        this.setBatchUpdateMode(false);
        this.dataChanged = true;
        operationLog.info((Object)"External data updated");
    }

    private DataPE prepareBatchUpdate(DataPE dataSet, DataSetBatchUpdatesDTO dataSetUpdates) {
        if (dataSet == null) {
            throw new UserFailureException(String.format("Data set with code '%s' does not exist.", dataSetUpdates.getCode()));
        }
        DataSetBatchUpdateDetails details = dataSetUpdates.getDetails();
        this.updateProperties(dataSet.getEntityType(), dataSetUpdates.getProperties(), details.getPropertiesToUpdate(), dataSet, dataSet);
        this.checkPropertiesBusinessRules(dataSet);
        if (details.isSampleUpdateRequested()) {
            SampleIdentifier sampleIdentifierOrNull = dataSetUpdates.getSampleIdentifierOrNull();
            if (sampleIdentifierOrNull != null) {
                this.updateSample(dataSet, sampleIdentifierOrNull);
            } else {
                this.updateExperiment(dataSet, dataSetUpdates.getExperimentIdentifierOrNull());
            }
        } else if (details.isExperimentUpdateRequested() && dataSetUpdates.getExperimentIdentifierOrNull() != null) {
            this.updateExperiment(dataSet, dataSetUpdates.getExperimentIdentifierOrNull());
        }
        if (details.isContainerUpdateRequested()) {
            if (dataSetUpdates.getModifiedContainedDatasetCodesOrNull() != null) {
                this.setContainedDataSets(dataSet, Arrays.asList(dataSetUpdates.getModifiedContainedDatasetCodesOrNull()));
            }
            if (dataSetUpdates.getModifiedContainerDatasetCodeOrNull() != null) {
                this.updateContainers(dataSet, dataSetUpdates.getModifiedContainerDatasetCodeOrNull());
            }
        }
        if (details.isParentsUpdateRequested()) {
            this.setParents(dataSet, Arrays.asList(dataSetUpdates.getModifiedParentDatasetCodesOrNull()));
        }
        if (details.isFileFormatUpdateRequested()) {
            this.updateFileFormatType(dataSet, dataSetUpdates.getFileFormatTypeCode());
        }
        return dataSet;
    }

    @Override
    public LinkModel retrieveLinkFromDataSet(String key, String datastoreCode, String dataSetCode) {
        DataStorePE dataStore = this.findDataStore(datastoreCode);
        IDataStoreService service = DataSetTable.tryGetDataStoreService(dataStore, this.dssFactory);
        if (service == null) {
            throw this.createUnknownDataStoreServerException();
        }
        List<DatasetDescription> locations = this.loadAvailableDatasetDescriptions(Collections.singletonList(dataSetCode));
        if (locations.size() < 1) {
            throw new UserFailureException(String.format("Data set with code '%s' does not exist.", dataSetCode));
        }
        DatasetDescription dataSet = locations.get(0);
        String sessionToken = dataStore.getSessionToken();
        return service.retrieveLinkFromDataSet(sessionToken, key, dataSet);
    }

    @Override
    public TableModel createReportFromAggregationService(String datastoreServiceKey, String datastoreCode, Map<String, Object> parameters) {
        DataStorePE dataStore = this.findDataStore(datastoreCode);
        if (StringUtils.isBlank((CharSequence)dataStore.getRemoteUrl())) {
            throw this.createUnknownDataStoreServerException();
        }
        this.validateAggregationServiceKey(dataStore, datastoreServiceKey, datastoreCode);
        IDataStoreService service = this.getConversationClient().getDataStoreService(dataStore.getRemoteUrl(), this.session.getSessionToken());
        String sessionToken = dataStore.getSessionToken();
        String userSessionToken = this.session.getSessionToken();
        return service.createReportFromAggregationService(sessionToken, userSessionToken, datastoreServiceKey, parameters, this.tryGetLoggedUserId(), this.tryGetLoggedUserEmail());
    }

    private static class DataStoreWithService {
        DataStorePE dataStore;
        IDataStoreService service;

        private DataStoreWithService() {
        }
    }

    private static interface IArchivingAction {
        public void execute(String var1, IDataStoreService var2, List<DatasetDescription> var3, String var4, String var5);

        public DataSetArchivingStatus getStatusToRestoreOnFailure();
    }
}

