/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.business.bo;

import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.openbis.generic.server.business.IDataStoreServiceFactory;
import ch.systemsx.cisd.openbis.generic.server.business.bo.IDataStoreBO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.shared.IDataStoreService;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.CustomImportFile;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataStorePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.Session;

public class DataStoreBO
implements IDataStoreBO {
    private IDAOFactory daoFactory;
    private Session session;
    private IDataStoreServiceFactory dssFactory;
    private DataStorePE dataStore;
    private String dataStoreCode;

    public DataStoreBO(IDAOFactory daoFactory, Session session, IDataStoreServiceFactory dssFactory) {
        this.daoFactory = daoFactory;
        this.session = session;
        this.dssFactory = dssFactory;
    }

    @Override
    public void loadByCode(String dssCode) {
        this.dataStoreCode = dssCode;
        this.dataStore = this.daoFactory.getDataStoreDAO().tryToFindDataStoreByCode(dssCode);
    }

    @Override
    public void uploadFile(String dropboxName, CustomImportFile customImportFile) {
        if (this.dataStore == null) {
            throw new ConfigurationFailureException("The data store " + this.dataStoreCode + " for custom import of a dropbox " + dropboxName + " doesn't exist.");
        }
        IDataStoreService service = this.dssFactory.create(this.dataStore.getRemoteUrl());
        service.putDataSet(this.session.getSessionToken(), dropboxName, customImportFile);
    }
}

