/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.business.bo;

import ch.systemsx.cisd.common.collection.CollectionUtils;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.server.business.IDataStoreServiceFactory;
import ch.systemsx.cisd.openbis.generic.server.business.IRelationshipService;
import ch.systemsx.cisd.openbis.generic.server.business.IServiceConversationClientManagerLocal;
import ch.systemsx.cisd.openbis.generic.server.business.bo.AbstractDataSetBusinessObject;
import ch.systemsx.cisd.openbis.generic.server.business.bo.IDeletedDataSetTable;
import ch.systemsx.cisd.openbis.generic.server.business.bo.exception.DataSetDeletionDisallowedTypesException;
import ch.systemsx.cisd.openbis.generic.server.business.bo.util.DataSetTypeWithoutExperimentChecker;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDataDAO;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataStorePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DeletedDataPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.Session;
import ch.systemsx.cisd.openbis.generic.shared.dto.properties.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.IManagedPropertyEvaluatorFactory;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.api.IEntityInformationProvider;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.springframework.dao.DataAccessException;

public final class DeletedDataSetTable
extends AbstractDataSetBusinessObject
implements IDeletedDataSetTable {
    private List<DeletedDataPE> deletedDataSets;

    private static void assertDatasetsAreDeletable(List<DeletedDataPE> datasets) {
        ArrayList<String> notDeletableDatasets = new ArrayList<String>();
        for (DeletedDataPE dataSet : datasets) {
            if (dataSet.isDeletable()) continue;
            notDeletableDatasets.add(dataSet.getCode());
        }
        if (!notDeletableDatasets.isEmpty()) {
            throw UserFailureException.fromTemplate((String)"Deletion failed because the following data sets are required by a background process (their status is pending): %s. ", (Object[])new Object[]{CollectionUtils.abbreviate(notDeletableDatasets, (int)10)});
        }
    }

    private static void assertDatasetsWithDisallowedTypes(List<DeletedDataPE> datasets, boolean forceDisallowedTypes) {
        if (forceDisallowedTypes) {
            return;
        }
        ArrayList<String> datasetsWithDisallowedTypes = new ArrayList<String>();
        for (DeletedDataPE dataSet : datasets) {
            if (!dataSet.getDataSetType().isDeletionDisallow()) continue;
            datasetsWithDisallowedTypes.add(dataSet.getCode());
        }
        if (!datasetsWithDisallowedTypes.isEmpty()) {
            throw new DataSetDeletionDisallowedTypesException(datasetsWithDisallowedTypes);
        }
    }

    public DeletedDataSetTable(IDAOFactory daoFactory, IDataStoreServiceFactory dssFactory, Session session, IRelationshipService relationshipService, IServiceConversationClientManagerLocal conversationClient, IEntityInformationProvider entityInformationProvider, IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory) {
        super(daoFactory, session, relationshipService, conversationClient, entityInformationProvider, managedPropertyEvaluatorFactory, new DataSetTypeWithoutExperimentChecker(new Properties()));
    }

    @Override
    public void loadByDataSetCodes(List<String> dataSetCodes) {
        IDataDAO dataDAO = this.getDataDAO();
        this.deletedDataSets = new ArrayList<DeletedDataPE>();
        this.deletedDataSets.addAll(dataDAO.tryToFindDeletedDataSetsByCodes(dataSetCodes));
    }

    @Override
    public void permanentlyDeleteLoadedDataSets(String reason, boolean forceDisallowedTypes) {
        DeletedDataSetTable.assertDatasetsAreDeletable(this.deletedDataSets);
        DeletedDataSetTable.assertDatasetsWithDisallowedTypes(this.deletedDataSets, forceDisallowedTypes);
        Map<DataStorePE, List<DeletedDataPE>> allToBeDeleted = this.groupDataSetsByDataStores();
        for (Map.Entry<DataStorePE, List<DeletedDataPE>> entry : allToBeDeleted.entrySet()) {
            List<DeletedDataPE> allDataSets = entry.getValue();
            this.deleteLocallyFromDB(reason, allDataSets);
        }
    }

    private void deleteLocallyFromDB(String reason, List<DeletedDataPE> dataSetsToDelete) {
        this.deleteByTechIds(TechId.createList(dataSetsToDelete), reason);
    }

    private void deleteByTechIds(List<TechId> dataSetIds, String reason) throws UserFailureException {
        try {
            this.getSessionFactory().getCurrentSession().flush();
            this.getSessionFactory().getCurrentSession().clear();
            this.getDataDAO().delete(dataSetIds, this.session.tryGetPerson(), reason);
        }
        catch (DataAccessException ex) {
            DeletedDataSetTable.throwException(ex, "Data Set", EntityKind.DATA_SET);
        }
    }

    private Map<DataStorePE, List<DeletedDataPE>> groupDataSetsByDataStores() {
        LinkedHashMap<DataStorePE, List<DeletedDataPE>> map = new LinkedHashMap<DataStorePE, List<DeletedDataPE>>();
        for (DeletedDataPE dataSet : this.deletedDataSets) {
            DataStorePE dataStore = dataSet.getDataStore();
            ArrayList<DeletedDataPE> list = (ArrayList<DeletedDataPE>)map.get(dataStore);
            if (list == null) {
                list = new ArrayList<DeletedDataPE>();
                map.put(dataStore, list);
            }
            list.add(dataSet);
        }
        return map;
    }
}

