/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.business.bo;

import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import java.util.Arrays;
import java.util.List;
import net.lemnik.eodsql.BaseQuery;
import net.lemnik.eodsql.QueryTool;
import net.lemnik.eodsql.Select;

public class EntityCodeGenerator {
    protected final IDAOFactory daoFactory;
    private final CountQuery countQuery;

    public EntityCodeGenerator(IDAOFactory daoFactory) {
        this.daoFactory = daoFactory;
        this.countQuery = (CountQuery)QueryTool.getManagedQuery(CountQuery.class);
    }

    public String generateCode(String codePrefix, EntityKind entityKind) {
        return this.generateCodes(codePrefix, entityKind, 1).get(0);
    }

    public List<String> generateCodes(String codePrefix, EntityKind entityKind, int numberOfCodes) {
        String[] codes = new String[numberOfCodes];
        for (int i = 0; i < numberOfCodes; ++i) {
            long sequenceValue;
            String code;
            do {
                sequenceValue = this.daoFactory.getCodeSequenceDAO().getNextCodeSequenceId(entityKind);
            } while (this.isCodeUsed(code = codePrefix + sequenceValue, entityKind));
            codes[i] = code;
        }
        return Arrays.asList(codes);
    }

    protected boolean isCodeUsed(String code, EntityKind entityKind) {
        int count;
        if (EntityKind.EXPERIMENT.equals((Object)entityKind)) {
            count = this.countQuery.getExperimentCount(code);
        } else if (EntityKind.SAMPLE.equals((Object)entityKind)) {
            count = this.countQuery.getSampleCount(code);
        } else if (EntityKind.DATA_SET.equals((Object)entityKind)) {
            count = this.countQuery.getDataSetCount(code);
        } else if (EntityKind.MATERIAL.equals((Object)entityKind)) {
            count = this.countQuery.getMaterialsCount(code);
        } else {
            throw new IllegalArgumentException("Unsupported entity kind: " + entityKind);
        }
        return count > 0;
    }

    public static interface CountQuery
    extends BaseQuery {
        public static final String PREFIX = "SELECT count(*) FROM ";
        public static final String SUFFIX = " WHERE code = ?{1}";

        @Select(sql="SELECT count(*) FROM experiments_all WHERE code = ?{1}")
        public int getExperimentCount(String var1);

        @Select(sql="SELECT count(*) FROM samples_all WHERE code = ?{1}")
        public int getSampleCount(String var1);

        @Select(sql="SELECT count(*) FROM data_all WHERE code = ?{1}")
        public int getDataSetCount(String var1);

        @Select(sql="SELECT count(*) FROM materials WHERE code = ?{1}")
        public int getMaterialsCount(String var1);
    }
}

