/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.business.bo;

import ch.systemsx.cisd.openbis.generic.server.business.bo.ICommonBusinessObjectFactory;
import ch.systemsx.cisd.openbis.generic.server.business.bo.IDataBO;
import ch.systemsx.cisd.openbis.generic.server.business.bo.IExperimentBO;
import ch.systemsx.cisd.openbis.generic.server.business.bo.IMaterialBO;
import ch.systemsx.cisd.openbis.generic.server.business.bo.ISampleBO;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.id.IObjectId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.id.dataset.IDataSetId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.id.experiment.IExperimentId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.id.material.IMaterialId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.id.sample.ISampleId;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.IEntityInformationHolderDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.MaterialPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SamplePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.Session;

public class EntityObjectIdHelper {
    protected final ICommonBusinessObjectFactory businessObjectFactory;

    public EntityObjectIdHelper(ICommonBusinessObjectFactory businessObjectFactory) {
        this.businessObjectFactory = businessObjectFactory;
    }

    public IEntityInformationHolderDTO getEntityById(Session session, IObjectId id) {
        if (id instanceof IExperimentId) {
            return this.getExperimentById(session, (IExperimentId)id);
        }
        if (id instanceof ISampleId) {
            return this.getSampleById(session, (ISampleId)id);
        }
        if (id instanceof IDataSetId) {
            return this.getDataSetById(session, (IDataSetId)id);
        }
        if (id instanceof IMaterialId) {
            return this.getMaterialById(session, (IMaterialId)id);
        }
        throw new IllegalArgumentException("The " + id.getClass() + " is not recognized as correct argument");
    }

    private MaterialPE getMaterialById(Session session, IMaterialId id) {
        IMaterialBO bo = this.businessObjectFactory.createMaterialBO(session);
        return bo.tryFindByMaterialId(id);
    }

    private DataPE getDataSetById(Session session, IDataSetId id) {
        IDataBO bo = this.businessObjectFactory.createDataBO(session);
        return bo.tryFindByDataSetId(id);
    }

    private SamplePE getSampleById(Session session, ISampleId id) {
        ISampleBO bo = this.businessObjectFactory.createSampleBO(session);
        return bo.tryFindBySampleId(id);
    }

    public ExperimentPE getExperimentById(Session session, IExperimentId id) {
        IExperimentBO bo = this.businessObjectFactory.createExperimentBO(session);
        return bo.tryFindByExperimentId(id);
    }
}

