/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.business.bo;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.server.business.IRelationshipService;
import ch.systemsx.cisd.openbis.generic.server.business.bo.AbstractBusinessObject;
import ch.systemsx.cisd.openbis.generic.server.business.bo.IEntityTypeBO;
import ch.systemsx.cisd.openbis.generic.server.business.bo.util.DataSetTypeWithoutExperimentChecker;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ExperimentType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MaterialType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleType;
import ch.systemsx.cisd.openbis.generic.shared.dto.AbstractTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataSetTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.EntityTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SampleTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ScriptPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.Session;
import ch.systemsx.cisd.openbis.generic.shared.dto.properties.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.IManagedPropertyEvaluatorFactory;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.springframework.dao.DataAccessException;

public final class EntityTypeBO
extends AbstractBusinessObject
implements IEntityTypeBO {
    private EntityTypePE entityTypePE;
    private EntityKind entityKind;

    public static void assertValidDataSetTypeMainPattern(String pattern) {
        if (pattern == null) {
            return;
        }
        try {
            Pattern.compile(pattern);
        }
        catch (PatternSyntaxException ex) {
            int index = ex.getIndex();
            throw new UserFailureException("The pattern '" + pattern + "' is invalid: " + ex.getDescription() + (index < 0 ? "" : " at position " + (index + 1) + "."));
        }
    }

    public EntityTypeBO(IDAOFactory daoFactory, Session session, IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory, DataSetTypeWithoutExperimentChecker dataSetTypeChecker, IRelationshipService relationshipService) {
        super(daoFactory, session, managedPropertyEvaluatorFactory, dataSetTypeChecker, relationshipService);
    }

    private ScriptPE getValidationScriptPE(EntityType entityType) {
        if (entityType.getValidationScript() == null || entityType.getValidationScript().getName() == null || entityType.getValidationScript().getName().equals("")) {
            return null;
        }
        ScriptPE script = this.getScriptDAO().tryFindByName(entityType.getValidationScript().getName());
        if (script != null && entityType.isEntityKind(script.getEntityKind())) {
            return script;
        }
        return null;
    }

    private EntityTypePE convertGeneric(EntityType entityType, EntityKind kind) throws UserFailureException {
        Object typePE = EntityTypePE.createEntityTypePE(kind);
        ((AbstractTypePE)typePE).setCode(entityType.getCode());
        ((AbstractTypePE)typePE).setDescription(entityType.getDescription());
        ((EntityTypePE)typePE).setValidationScript(this.getValidationScriptPE(entityType));
        return typePE;
    }

    @Override
    public final void save() throws UserFailureException {
        assert (this.entityTypePE != null) : "Entity type not defined.";
        assert (this.entityKind != null) : "Entity kind not defined.";
        try {
            this.getEntityTypeDAO(this.entityKind).createOrUpdateEntityType(this.entityTypePE);
        }
        catch (DataAccessException e) {
            EntityTypeBO.throwException(e, String.format("Entity type '%s' ", this.entityTypePE.getCode()));
        }
    }

    @Override
    public void define(SampleType entityType) {
        SampleTypePE sampleTypePE = new SampleTypePE();
        sampleTypePE.setCode(entityType.getCode());
        sampleTypePE.setDescription(entityType.getDescription());
        sampleTypePE.setContainerHierarchyDepth(entityType.getContainerHierarchyDepth());
        sampleTypePE.setGeneratedFromHierarchyDepth(entityType.getGeneratedFromHierarchyDepth());
        sampleTypePE.setListable(entityType.isListable());
        sampleTypePE.setSubcodeUnique(entityType.isSubcodeUnique());
        sampleTypePE.setAutoGeneratedCode(entityType.isAutoGeneratedCode());
        sampleTypePE.setShowParentMetadata(entityType.isShowParentMetadata());
        sampleTypePE.setGeneratedCodePrefix(entityType.getGeneratedCodePrefix());
        sampleTypePE.setValidationScript(this.getValidationScriptPE(entityType));
        this.entityKind = EntityKind.SAMPLE;
        this.entityTypePE = sampleTypePE;
    }

    @Override
    public void define(MaterialType entityType) {
        this.entityKind = EntityKind.MATERIAL;
        this.entityTypePE = this.convertGeneric(entityType, this.entityKind);
    }

    @Override
    public void define(ExperimentType entityType) {
        this.entityKind = EntityKind.EXPERIMENT;
        this.entityTypePE = this.convertGeneric(entityType, this.entityKind);
    }

    @Override
    public void define(DataSetType entityType) {
        DataSetTypePE dataSetTypePE = new DataSetTypePE();
        dataSetTypePE.setCode(entityType.getCode());
        dataSetTypePE.setDescription(entityType.getDescription());
        dataSetTypePE.setMainDataSetPath(entityType.getMainDataSetPath());
        String mainDataSetPattern = entityType.getMainDataSetPattern();
        EntityTypeBO.assertValidDataSetTypeMainPattern(mainDataSetPattern);
        dataSetTypePE.setMainDataSetPattern(mainDataSetPattern);
        dataSetTypePE.setDeletionDisallow(entityType.isDeletionDisallow());
        dataSetTypePE.setValidationScript(this.getValidationScriptPE(entityType));
        this.entityKind = EntityKind.DATA_SET;
        this.entityTypePE = dataSetTypePE;
    }

    @Override
    public void load(EntityKind kind, String code) {
        this.entityKind = kind;
        this.entityTypePE = this.getEntityTypeDAO(this.entityKind).tryToFindEntityTypeByCode(code);
        if (this.entityTypePE == null) {
            throw new UserFailureException(String.format("'%s' not found.", code));
        }
    }

    @Override
    public void delete() {
        assert (this.entityKind != null);
        assert (this.entityTypePE != null) : "Type not loaded";
        try {
            List<TechId> entitiesInTrash = this.getDeletionDAO().listDeletedEntitiesForType(this.entityKind, new TechId(this.entityTypePE.getId()));
            if (!entitiesInTrash.isEmpty()) {
                throw UserFailureException.fromTemplate((String)"'%s' is referred from entities in the trash can. Please empty the trash can and try deleting it again.", (Object[])new Object[]{this.entityTypePE.getCode()});
            }
            this.getEntityTypeDAO(this.entityKind).deleteEntityType(this.entityTypePE);
        }
        catch (DataAccessException e) {
            EntityTypeBO.throwException(e, String.format("'%s'", this.entityTypePE.getCode()));
        }
    }
}

