/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.business.bo;

import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.openbis.generic.server.business.IRelationshipService;
import ch.systemsx.cisd.openbis.generic.server.business.bo.AbstractBusinessObject;
import ch.systemsx.cisd.openbis.generic.server.business.bo.IEntityTypePropertyTypeBO;
import ch.systemsx.cisd.openbis.generic.server.business.bo.InternalPropertyTypeAuthorization;
import ch.systemsx.cisd.openbis.generic.server.business.bo.util.DataSetTypeWithoutExperimentChecker;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.EntityPropertiesConverter;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IEntityPropertiesConverter;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IEntityPropertyTypeDAO;
import ch.systemsx.cisd.openbis.generic.shared.basic.BasicConstant;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewETPTAssignment;
import ch.systemsx.cisd.openbis.generic.shared.dto.EntityPropertyPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.EntityTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.EntityTypePropertyTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.HibernateAbstractRegistrationHolder;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.PropertyTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ScriptPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.Session;
import ch.systemsx.cisd.openbis.generic.shared.dto.properties.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.IManagedPropertyEvaluatorFactory;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.api.IEntityInformationProvider;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.log4j.Logger;
import org.springframework.dao.DataAccessException;

public class EntityTypePropertyTypeBO
extends AbstractBusinessObject
implements IEntityTypePropertyTypeBO {
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, EntityTypePropertyTypeBO.class);
    private EntityKind entityKind;
    private IEntityPropertiesConverter propertiesConverter;
    private EntityTypePropertyTypePE assignment;

    @Private
    EntityTypePropertyTypeBO(IDAOFactory daoFactory, Session session, EntityKind entityKind, IEntityPropertiesConverter converter, IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory, DataSetTypeWithoutExperimentChecker dataSetTypeChecker, IRelationshipService relationshipService) {
        super(daoFactory, session, managedPropertyEvaluatorFactory, dataSetTypeChecker, relationshipService);
        this.propertiesConverter = converter;
        this.entityKind = entityKind;
    }

    public EntityTypePropertyTypeBO(IDAOFactory daoFactory, Session session, EntityKind entityKind, IEntityInformationProvider entityInformationProvider, IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory, DataSetTypeWithoutExperimentChecker dataSetTypeChecker, IRelationshipService relationshipService) {
        super(daoFactory, session, managedPropertyEvaluatorFactory, dataSetTypeChecker, relationshipService);
        this.propertiesConverter = new EntityPropertiesConverter(entityKind, daoFactory, entityInformationProvider, managedPropertyEvaluatorFactory);
        this.entityKind = entityKind;
    }

    @Override
    public EntityTypePropertyTypePE getLoadedAssignment() {
        if (this.assignment == null) {
            throw new IllegalStateException("No assignment loaded.");
        }
        return this.assignment;
    }

    @Override
    public void deleteLoadedAssignment() {
        if (this.assignment == null) {
            return;
        }
        new InternalPropertyTypeAuthorization().canDeletePropertyAssignment(this.session, this.assignment.getPropertyType(), this.assignment);
        this.getEntityPropertyTypeDAO(this.entityKind).delete(this.assignment);
        this.assignment = null;
    }

    @Override
    public void loadAssignment(String propertyTypeCode, String entityTypeCode) {
        EntityTypePE entityType = this.findEntityType(entityTypeCode);
        PropertyTypePE propertyType = this.findPropertyType(propertyTypeCode);
        IEntityPropertyTypeDAO entityPropertyTypeDAO = this.getEntityPropertyTypeDAO(this.entityKind);
        this.assignment = entityPropertyTypeDAO.tryFindAssignment(entityType, propertyType);
    }

    @Override
    public int countAssignmentValues(String propertyTypeCode, String entityTypeCode) {
        IEntityPropertyTypeDAO entityPropertyTypeDAO = this.getEntityPropertyTypeDAO(this.entityKind);
        return entityPropertyTypeDAO.countAssignmentValues(entityTypeCode, propertyTypeCode);
    }

    @Override
    public void createAssignment(NewETPTAssignment newAssignment) {
        EntityTypePE entityType = this.findEntityType(newAssignment.getEntityTypeCode());
        PropertyTypePE propertyType = this.findPropertyType(newAssignment.getPropertyTypeCode());
        ScriptPE scriptOrNull = this.tryFindScript(newAssignment);
        this.assignment = this.createAssignment(newAssignment.isMandatory(), newAssignment.getSection(), newAssignment.getOrdinal(), entityType, propertyType, scriptOrNull, newAssignment.isShownInEditView(), newAssignment.getShowRawValue());
        String defaultValue = newAssignment.getDefaultValue();
        if (newAssignment.isDynamic()) {
            List<Long> entityIds = this.getAllEntityIds(entityType);
            this.addPropertyWithDefaultValue(entityType, propertyType, BasicConstant.DYNAMIC_PROPERTY_PLACEHOLDER_VALUE, entityIds, null);
        } else if (newAssignment.isManaged()) {
            List<Long> entityIds = this.getAllEntityIds(entityType);
            this.addPropertyWithDefaultValue(entityType, propertyType, BasicConstant.MANAGED_PROPERTY_PLACEHOLDER_VALUE, entityIds, null);
        } else if (newAssignment.isMandatory()) {
            String errorMsgTemplate = "Cannot create mandatory assignment. Please specify 'Initial Value', which will be used for %s %s%s of type '%s' already existing in the database.";
            List<Long> entityIds = this.getAllEntityIds(entityType);
            this.addPropertyWithDefaultValue(entityType, propertyType, defaultValue, entityIds, errorMsgTemplate);
        } else if (!StringUtils.isEmpty((CharSequence)defaultValue)) {
            List<Long> entityIds = this.getAllEntityIds(entityType);
            this.addPropertyWithDefaultValue(entityType, propertyType, defaultValue, entityIds, null);
        }
    }

    private ScriptPE tryFindScript(NewETPTAssignment newAssignment) {
        if (newAssignment.getScriptName() == null) {
            return null;
        }
        return this.getScriptDAO().tryFindByName(newAssignment.getScriptName());
    }

    private List<Long> getAllEntityIds(EntityTypePE entityType) {
        return this.getEntityPropertyTypeDAO(this.entityKind).listEntityIds(entityType);
    }

    private void addPropertyWithDefaultValue(EntityTypePE entityType, PropertyTypePE propertyType, String defaultValue, List<Long> entityIds, String errorMsgTemplate) {
        IEntityPropertyTypeDAO entityPropertyTypeDAO = this.getEntityPropertyTypeDAO(this.entityKind);
        int size = entityIds.size();
        if (size > 0) {
            if (operationLog.isDebugEnabled()) {
                operationLog.debug((Object)this.getMemoryUsageMessage());
            }
            if (StringUtils.isEmpty((CharSequence)defaultValue)) {
                throw new UserFailureException(String.format(errorMsgTemplate, size, this.entityKind.getLabel(), this.createPlural(size), entityType.getCode()));
            }
            PersonPE registrator = this.findPerson();
            String validatedValue = this.propertiesConverter.tryCreateValidatedPropertyValue(propertyType, this.assignment, defaultValue);
            if (validatedValue != null) {
                Object property = this.propertiesConverter.createValidatedProperty(propertyType, this.assignment, registrator, validatedValue);
                entityPropertyTypeDAO.createProperties((EntityPropertyPE)property, entityIds);
                entityPropertyTypeDAO.updateEntityModificationTimestamps(entityIds);
            }
            if (operationLog.isDebugEnabled()) {
                operationLog.debug((Object)this.getMemoryUsageMessage());
            }
        }
    }

    private String getMemoryUsageMessage() {
        Runtime runtime = Runtime.getRuntime();
        long mb = 0x100000L;
        long totalMemory = runtime.totalMemory() / mb;
        long freeMemory = runtime.freeMemory() / mb;
        long maxMemory = runtime.maxMemory() / mb;
        return "MEMORY (in MB): free:" + freeMemory + " total:" + totalMemory + " max:" + maxMemory;
    }

    @Override
    public void updateLoadedAssignment(NewETPTAssignment assignmentUpdates) {
        if (assignmentUpdates.getModificationDate() != null && !this.assignment.getModificationDate().equals(assignmentUpdates.getModificationDate())) {
            EntityTypePropertyTypeBO.throwModifiedEntityException("Property type assignment");
        }
        UpdateAuthorizationSnapshot snapshotBefore = new UpdateAuthorizationSnapshot(this.assignment);
        Long ordinal = assignmentUpdates.getOrdinal();
        Long currentOrdinal = (ordinal == null ? this.assignment.getOrdinal() : ordinal) + 1L;
        if (!this.assignment.getOrdinal().equals(currentOrdinal)) {
            this.increaseOrdinals(this.assignment.getEntityType(), currentOrdinal, 1);
        }
        this.assignment.setOrdinal(currentOrdinal);
        this.assignment.setSection(assignmentUpdates.getSection());
        if (assignmentUpdates.isMandatory() && !this.assignment.isMandatory()) {
            EntityTypePE entityType = this.assignment.getEntityType();
            PropertyTypePE propertyType = this.assignment.getPropertyType();
            String errorMsgTemplate = "Cannot change assignment to mandatory. Please specify 'Update Value', which will be used for %s %s%s of type '%s' already existing in the database without any value for this property.";
            List<Long> entityIds = this.getEntityPropertyTypeDAO(this.entityKind).listIdsOfEntitiesWithoutPropertyValue(this.assignment);
            this.addPropertyWithDefaultValue(entityType, propertyType, assignmentUpdates.getDefaultValue(), entityIds, errorMsgTemplate);
        }
        this.assignment.setMandatory(assignmentUpdates.isMandatory());
        if (assignmentUpdates.isDynamic() != this.assignment.isDynamic()) {
            throw new UserFailureException(String.format("Changing assignment from '%s' to '%s' for %s.%s is not allowed. Please create a new assignment.", EntityTypePropertyTypeBO.describeDynamic(this.assignment.isDynamic()), EntityTypePropertyTypeBO.describeDynamic(assignmentUpdates.isDynamic()), assignmentUpdates.getEntityTypeCode(), assignmentUpdates.getPropertyTypeCode()));
        }
        boolean scriptChanged = false;
        if ((this.assignment.isDynamic() || this.assignment.isManaged()) && !this.assignment.getScript().getName().equals(assignmentUpdates.getScriptName())) {
            scriptChanged = true;
            ScriptPE script = this.getScriptDAO().tryFindByName(assignmentUpdates.getScriptName());
            this.assignment.setScript(script);
        }
        this.assignment.setShownInEditView(assignmentUpdates.isShownInEditView());
        this.assignment.setShowRawValue(assignmentUpdates.getShowRawValue());
        UpdateAuthorizationSnapshot snapshotAfter = new UpdateAuthorizationSnapshot(this.assignment);
        if (!snapshotBefore.equals(snapshotAfter)) {
            new InternalPropertyTypeAuthorization().canUpdatePropertyAssignment(this.session, this.assignment.getPropertyType(), this.assignment);
        }
        this.validateAndSave();
        if (scriptChanged) {
            this.getEntityPropertyTypeDAO(this.entityKind).scheduleDynamicPropertiesEvaluation(this.assignment);
        }
    }

    private static String describeDynamic(boolean dynamic) {
        return (dynamic ? "" : "not ") + "dynamic";
    }

    private void validateAndSave() {
        this.getEntityPropertyTypeDAO(this.entityKind).validateAndSaveUpdatedEntity(this.assignment);
    }

    private String createPlural(int size) {
        return size == 1 ? "" : "s";
    }

    private EntityTypePropertyTypePE createAssignment(boolean mandatory, String section, Long previousETPTOrdinal, EntityTypePE entityType, PropertyTypePE propertyType, ScriptPE scriptOrNull, boolean shownInEditView, boolean showRawValue) {
        this.checkAssignmentDoesNotExist(entityType, propertyType);
        Long previousOrdinal = previousETPTOrdinal == null ? this.getEntityPropertyTypeDAO(this.entityKind).getMaxOrdinal(entityType) : previousETPTOrdinal;
        Long currentOrdinal = previousOrdinal + 1L;
        this.increaseOrdinals(entityType, currentOrdinal, 1);
        Object etpt = EntityTypePropertyTypePE.createEntityTypePropertyType(this.entityKind);
        ((EntityTypePropertyTypePE)etpt).setPropertyType(propertyType);
        ((HibernateAbstractRegistrationHolder)etpt).setRegistrator(this.findPerson());
        ((EntityTypePropertyTypePE)etpt).setEntityType(entityType);
        ((EntityTypePropertyTypePE)etpt).setMandatory(mandatory);
        ((EntityTypePropertyTypePE)etpt).setSection(section);
        ((EntityTypePropertyTypePE)etpt).setOrdinal(currentOrdinal);
        ((EntityTypePropertyTypePE)etpt).setScript(scriptOrNull);
        ((EntityTypePropertyTypePE)etpt).setShownInEditView(shownInEditView);
        ((EntityTypePropertyTypePE)etpt).setShowRawValue(showRawValue);
        new InternalPropertyTypeAuthorization().canCreatePropertyAssignment(this.session, ((EntityTypePropertyTypePE)etpt).getPropertyType(), (EntityTypePropertyTypePE)etpt);
        try {
            this.getEntityPropertyTypeDAO(this.entityKind).createEntityPropertyTypeAssignment((EntityTypePropertyTypePE)etpt);
        }
        catch (DataAccessException e) {
            EntityTypePropertyTypeBO.throwException(e, this.createExceptionMessage(entityType, propertyType));
        }
        return etpt;
    }

    private void increaseOrdinals(EntityTypePE entityType, Long startOrdinal, int increment) {
        this.getEntityPropertyTypeDAO(this.entityKind).increaseOrdinals(entityType, startOrdinal, increment);
    }

    private PropertyTypePE findPropertyType(String propertyTypeCode) {
        PropertyTypePE propertyType = this.getPropertyTypeDAO().tryFindPropertyTypeByCode(propertyTypeCode);
        if (propertyType == null) {
            throw new UserFailureException(String.format("Property type '%s' does not exist.", propertyTypeCode));
        }
        return propertyType;
    }

    private EntityTypePE findEntityType(String entityTypeCode) {
        EntityTypePE entityType = this.getEntityTypeDAO(this.entityKind).tryToFindEntityTypeByCode(entityTypeCode);
        if (entityType == null) {
            throw new UserFailureException(String.format("%s type '%s' does not exist.", StringUtils.capitalize((String)this.entityKind.getLabel()), entityTypeCode));
        }
        return entityType;
    }

    private void checkAssignmentDoesNotExist(EntityTypePE entityType, PropertyTypePE propertyType) {
        if (this.getEntityPropertyTypeDAO(this.entityKind).tryFindAssignment(entityType, propertyType) != null) {
            throw new UserFailureException(this.createExceptionMessage(entityType, propertyType));
        }
    }

    private String createExceptionMessage(EntityTypePE entityType, PropertyTypePE propertyType) {
        return String.format("Property type '%s' is already assigned to %s type '%s'.", propertyType.getCode(), this.entityKind.getLabel(), entityType.getCode());
    }

    private static class UpdateAuthorizationSnapshot {
        private boolean mandatory;
        private ScriptPE script;
        private boolean showInEditView;
        private boolean showRawValue;

        public UpdateAuthorizationSnapshot(EntityTypePropertyTypePE assignment) {
            this.mandatory = assignment.isMandatory();
            this.script = assignment.getScript();
            this.showInEditView = assignment.isShownInEditView();
            this.showRawValue = assignment.isShownInEditView();
        }

        public boolean equals(Object obj) {
            return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
        }
    }
}

