/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.business.bo;

import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.common.collection.CollectionUtils;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.server.business.IRelationshipService;
import ch.systemsx.cisd.openbis.generic.server.business.bo.AbstractBusinessObject;
import ch.systemsx.cisd.openbis.generic.server.business.bo.IExperimentBO;
import ch.systemsx.cisd.openbis.generic.server.business.bo.util.DataSetTypeWithoutExperimentChecker;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IEntityPropertiesConverter;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.ISampleDAO;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Code;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IEntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewAttachment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewExperiment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.api.IManagedProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.id.experiment.ExperimentIdentifierId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.id.experiment.ExperimentPermIdId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.id.experiment.ExperimentTechIdId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.id.experiment.IExperimentId;
import ch.systemsx.cisd.openbis.generic.shared.dto.AttachmentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.EntityTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.EventPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.EventType;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentPropertyPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentUpdatesDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.IModifierAndModificationDateBean;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ProjectPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SamplePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.Session;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifierFactory;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ProjectIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.properties.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.IManagedPropertyEvaluatorFactory;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.api.IEntityInformationProvider;
import ch.systemsx.cisd.openbis.generic.shared.util.HibernateUtils;
import ch.systemsx.cisd.openbis.generic.shared.util.RelationshipUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.dao.DataAccessException;

public final class ExperimentBO
extends AbstractBusinessObject
implements IExperimentBO {
    @Private
    static final String ERR_PROJECT_NOT_FOUND = "No project for experiment '%s' could be found in the database.";
    @Private
    static final String ERR_EXPERIMENT_TYPE_NOT_FOUND = "No experiment type with code '%s' could be found in the database.";
    private ExperimentPE experiment;
    private boolean dataChanged;
    private final List<AttachmentPE> attachments = new ArrayList<AttachmentPE>();
    @Private
    static final String PROPERTY_TYPES = "experimentType.experimentTypePropertyTypesInternal";

    public ExperimentBO(IDAOFactory daoFactory, Session session, IRelationshipService relationshipService, IEntityInformationProvider entityInformationProvider, IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory, DataSetTypeWithoutExperimentChecker dataSetTypeChecker) {
        super(daoFactory, session, EntityKind.EXPERIMENT, entityInformationProvider, managedPropertyEvaluatorFactory, dataSetTypeChecker, relationshipService);
    }

    ExperimentBO(IDAOFactory daoFactory, Session session, IEntityPropertiesConverter entityPropertiesConverter, IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory, DataSetTypeWithoutExperimentChecker dataSetTypeChecker, IRelationshipService relationshipService) {
        super(daoFactory, session, entityPropertiesConverter, managedPropertyEvaluatorFactory, dataSetTypeChecker, relationshipService);
    }

    private final ExperimentTypePE getExperimentType(String code) throws UserFailureException {
        EntityTypePE experimentType = this.getEntityTypeDAO(EntityKind.EXPERIMENT).tryToFindEntityTypeByCode(code);
        if (experimentType == null) {
            throw UserFailureException.fromTemplate((String)ERR_EXPERIMENT_TYPE_NOT_FOUND, (Object[])new Object[]{code});
        }
        return (ExperimentTypePE)experimentType;
    }

    @Override
    public final ExperimentPE getExperiment() {
        this.checkExperimentLoaded();
        return this.experiment;
    }

    private void checkExperimentLoaded() {
        if (this.experiment == null) {
            throw new IllegalStateException("Unloaded experiment.");
        }
    }

    @Override
    public void loadDataByTechId(TechId experimentId) {
        String[] connections = new String[]{PROPERTY_TYPES};
        this.experiment = (ExperimentPE)this.getExperimentDAO().tryGetByTechId(experimentId, connections);
        if (this.experiment == null) {
            throw new UserFailureException(String.format("Experiment with ID '%s' does not exist.", experimentId));
        }
        this.dataChanged = false;
        HibernateUtils.initialize(this.experiment.getExperimentType().getExperimentTypePropertyTypes());
    }

    @Override
    public final void loadByExperimentIdentifier(ExperimentIdentifier identifier) {
        this.experiment = this.getExperimentByIdentifier(identifier);
        this.dataChanged = false;
    }

    @Override
    public final ExperimentPE tryFindByExperimentIdentifier(ExperimentIdentifier identifier) {
        ProjectPE project = this.tryGetProject(identifier);
        if (project == null) {
            return null;
        }
        return this.tryGetExperiment(identifier, project);
    }

    @Override
    public ExperimentPE tryFindByExperimentId(IExperimentId experimentId) {
        if (experimentId == null) {
            throw new IllegalArgumentException("Experiment id cannot be null");
        }
        if (experimentId instanceof ExperimentIdentifierId) {
            ExperimentIdentifierId identifierId = (ExperimentIdentifierId)experimentId;
            ExperimentIdentifier identifier = new ExperimentIdentifierFactory(identifierId.getIdentifier()).createIdentifier();
            return this.tryFindByExperimentIdentifier(identifier);
        }
        if (experimentId instanceof ExperimentPermIdId) {
            ExperimentPermIdId permIdId = (ExperimentPermIdId)experimentId;
            return this.getExperimentDAO().tryGetByPermID(permIdId.getPermId());
        }
        if (experimentId instanceof ExperimentTechIdId) {
            ExperimentTechIdId techIdId = (ExperimentTechIdId)experimentId;
            return (ExperimentPE)this.getExperimentDAO().tryGetByTechId(new TechId(techIdId.getTechId()), new String[0]);
        }
        throw new IllegalArgumentException("Unsupported experiment id: " + experimentId);
    }

    private ExperimentPE getExperimentByIdentifier(ExperimentIdentifier identifier) {
        assert (identifier != null) : "Experiment identifier unspecified.";
        ProjectPE project = this.tryGetProject(identifier);
        if (project == null) {
            throw new UserFailureException("Unkown experiment because of unkown project: " + identifier);
        }
        ExperimentPE exp = this.tryGetExperiment(identifier, project);
        if (exp == null) {
            throw new UserFailureException("Unkown experiment: " + identifier);
        }
        return exp;
    }

    private ExperimentPE tryGetExperiment(ExperimentIdentifier identifier, ProjectPE project) {
        return this.getExperimentDAO().tryFindByCodeAndProject(project, identifier.getExperimentCode());
    }

    private ProjectPE tryGetProject(ExperimentIdentifier identifier) {
        return this.getProjectDAO().tryFindProject(identifier.getSpaceCode(), identifier.getProjectCode());
    }

    @Override
    public final void enrichWithProperties() {
        if (this.experiment != null) {
            HibernateUtils.initialize(this.experiment.getProperties());
        }
    }

    @Override
    public final void enrichWithAttachments() {
        if (this.experiment != null) {
            this.experiment.ensureAttachmentsLoaded();
        }
    }

    @Override
    public AttachmentPE tryGetExperimentFileAttachment(String filename, Integer versionOrNull) {
        AttachmentPE att;
        this.checkExperimentLoaded();
        this.experiment.ensureAttachmentsLoaded();
        AttachmentPE attachmentPE = att = versionOrNull == null ? this.getAttachment(filename) : this.getAttachment(filename, versionOrNull);
        if (att != null) {
            HibernateUtils.initialize(att.getAttachmentContent());
            return att;
        }
        return null;
    }

    @Override
    public AttachmentPE getExperimentFileAttachment(String filename, Integer versionOrNull) {
        AttachmentPE attachment = this.tryGetExperimentFileAttachment(filename, versionOrNull);
        if (attachment != null) {
            return attachment;
        }
        throw new UserFailureException("Attachment '" + filename + "' " + (versionOrNull == null ? "(latestaa version)" : "(version '" + versionOrNull + "')") + " not found in experiment '" + this.experiment.getIdentifier() + "'.");
    }

    private AttachmentPE getAttachment(String filename, int version) {
        Set<AttachmentPE> attachmentsSet = this.experiment.getAttachments();
        for (AttachmentPE att : attachmentsSet) {
            if (!att.getFileName().equals(filename) || att.getVersion() != version) continue;
            return att;
        }
        return null;
    }

    private AttachmentPE getAttachment(String filename) {
        AttachmentPE latest = null;
        Set<AttachmentPE> attachmentsSet = this.experiment.getAttachments();
        for (AttachmentPE att : attachmentsSet) {
            if (!att.getFileName().equals(filename) || latest != null && latest.getVersion() >= att.getVersion()) continue;
            latest = att;
        }
        return latest;
    }

    @Override
    public void deleteByTechIds(List<TechId> experimentIds, String reason) throws UserFailureException {
        try {
            this.getSessionFactory().getCurrentSession().flush();
            this.getSessionFactory().getCurrentSession().clear();
            this.getExperimentDAO().delete(experimentIds, this.session.tryGetPerson(), reason);
        }
        catch (DataAccessException ex) {
            ExperimentBO.throwException(ex, "Experiment", EntityKind.EXPERIMENT);
        }
    }

    public static EventPE createDeletionEvent(ExperimentPE experiment, PersonPE registrator, String reason) {
        EventPE event = new EventPE();
        event.setEventType(EventType.DELETION);
        event.setEntityType(EventPE.EntityType.EXPERIMENT);
        event.setIdentifiers(Collections.singletonList(experiment.getPermId()));
        event.setDescription(ExperimentBO.getDeletionDescription(experiment));
        event.setReason(reason);
        event.setRegistrator(registrator);
        return event;
    }

    private static String getDeletionDescription(ExperimentPE experiment) {
        return String.format("%s [%s]", experiment.getIdentifier(), experiment.getPermId());
    }

    @Override
    public void define(NewExperiment newExperiment) {
        assert (newExperiment != null) : "Unspecified new experiment.";
        ExperimentIdentifier experimentIdentifier = new ExperimentIdentifierFactory(newExperiment.getIdentifier()).createIdentifier();
        this.experiment = new ExperimentPE();
        PersonPE registrator = this.findPerson();
        this.experiment.setCode(experimentIdentifier.getExperimentCode());
        this.experiment.setRegistrator(registrator);
        this.defineExperimentType(newExperiment);
        this.defineExperimentProperties(newExperiment.getExperimentTypeCode(), newExperiment.getProperties(), registrator);
        this.defineExperimentProject(newExperiment, experimentIdentifier);
        this.experiment.setPermId(this.getOrCreatePermID(newExperiment));
        this.setMetaprojects(this.experiment, newExperiment.getMetaprojectsOrNull());
        this.addAttachments(this.experiment, newExperiment.getAttachments(), this.attachments);
        RelationshipUtils.updateModificationDateAndModifier((IModifierAndModificationDateBean)this.experiment, this.session, this.getTransactionTimeStamp());
        this.dataChanged = true;
    }

    @Override
    public void addAttachment(AttachmentPE attachment) {
        assert (this.experiment != null) : "no experiment has been loaded";
        this.prepareAttachment((IModifierAndModificationDateBean)this.experiment, attachment);
        this.attachments.add(attachment);
    }

    private void defineExperimentProject(NewExperiment newExperiment, ExperimentIdentifier experimentIdentifier) {
        ProjectPE project = this.tryGetProject(experimentIdentifier);
        if (project == null) {
            throw UserFailureException.fromTemplate((String)ERR_PROJECT_NOT_FOUND, (Object[])new Object[]{newExperiment});
        }
        this.experiment.setProject(project);
        RelationshipUtils.updateModificationDateAndModifier((IModifierAndModificationDateBean)project, this.session, this.getTransactionTimeStamp());
    }

    private void defineExperimentType(NewExperiment newExperiment) {
        String experimentTypeCode = newExperiment.getExperimentTypeCode();
        EntityTypePE experimentType = this.getEntityTypeDAO(EntityKind.EXPERIMENT).tryToFindEntityTypeByCode(experimentTypeCode);
        if (experimentType == null) {
            throw UserFailureException.fromTemplate((String)ERR_EXPERIMENT_TYPE_NOT_FOUND, (Object[])new Object[]{experimentTypeCode});
        }
        this.experiment.setExperimentType((ExperimentTypePE)experimentType);
    }

    @Override
    public void save() throws UserFailureException {
        if (this.dataChanged) {
            try {
                this.getExperimentDAO().createOrUpdateExperiment(this.experiment, this.findPerson());
            }
            catch (DataAccessException ex) {
                String projectCode = this.experiment.getProject().getCode();
                ExperimentIdentifier identifier = new ExperimentIdentifier(projectCode, this.experiment.getCode());
                ExperimentBO.throwException(ex, String.format("Experiment '%s'", identifier));
            }
            this.dataChanged = false;
        }
        this.saveAttachment(this.experiment, this.attachments);
        this.checkBusinessRules();
    }

    private void checkBusinessRules() {
        this.entityPropertiesConverter.checkMandatoryProperties(this.experiment.getProperties(), this.experiment.getExperimentType());
    }

    private final void defineExperimentProperties(String experimentTypeCode, IEntityProperty[] experimentProperties, PersonPE registrator) {
        List properties = this.entityPropertiesConverter.convertProperties(experimentProperties, experimentTypeCode, registrator);
        for (ExperimentPropertyPE experimentProperty : properties) {
            this.experiment.addProperty(experimentProperty);
        }
    }

    @Override
    public void update(ExperimentUpdatesDTO updates) {
        ProjectPE previousProject;
        ProjectPE project;
        this.loadDataByTechId(updates.getExperimentId());
        if (updates.getVersion() != this.experiment.getVersion()) {
            ExperimentBO.throwModifiedEntityException("Experiment");
        }
        this.updateProperties(this.experiment.getEntityType(), updates.getProperties(), this.extractPropertiesCodes(updates.getProperties()), this.experiment, this.experiment);
        if (updates.getProjectIdentifier() != null && !(project = this.findProject(updates.getProjectIdentifier())).equals(previousProject = this.experiment.getProject())) {
            this.relationshipService.assignExperimentToProject(this.session, this.experiment, project);
        }
        for (NewAttachment attachment : updates.getAttachments()) {
            this.attachments.add(this.prepareAttachment((IModifierAndModificationDateBean)this.experiment, attachment));
        }
        this.updateSamples(updates);
        this.setMetaprojects(this.experiment, updates.getMetaprojectsOrNull());
        this.dataChanged = true;
    }

    private void updateSamples(ExperimentUpdatesDTO updates) {
        String[] sampleCodes = updates.getSampleCodes();
        if (sampleCodes != null) {
            if (updates.isRegisterSamples()) {
                this.attachSamples(sampleCodes);
            } else {
                String[] originalSampleCodes = Code.extractCodesToArray(this.experiment.getSamples());
                this.updateSamples(originalSampleCodes, sampleCodes);
            }
        }
    }

    private void updateSamples(String[] originalSampleCodes, String[] sampleCodes) {
        Set<String> samplesToAdd = ExperimentBO.asSet(sampleCodes);
        samplesToAdd.removeAll(Arrays.asList(originalSampleCodes));
        this.addToExperiment(this.findSamplesByCodes(samplesToAdd, true));
        Set<String> samplesToRemove = ExperimentBO.asSet(originalSampleCodes);
        samplesToRemove.removeAll(Arrays.asList(sampleCodes));
        this.removeFromExperiment(this.findSamplesByCodes(samplesToRemove, false));
    }

    @Private
    void attachSamples(String[] sampleCodes) {
        List<SamplePE> samplesToAdd = this.findSamplesByCodes(ExperimentBO.asSet(sampleCodes), true);
        this.addToExperiment(samplesToAdd);
    }

    private List<SamplePE> findSamplesByCodes(Set<String> codesToAdd, boolean unassigned) {
        return ExperimentBO.findSamples(this.getSampleDAO(), codesToAdd, this.experiment.getProject(), unassigned);
    }

    private void removeFromExperiment(List<SamplePE> samples) {
        for (SamplePE sample : samples) {
            List<DataPE> dataSets = this.getDataDAO().listDataSets(sample);
            this.checkDataSetsDoNotNeedAnExperiment(sample.getIdentifier(), dataSets);
            this.relationshipService.unassignSampleFromExperiment(this.session, sample);
            for (DataPE dataSet : dataSets) {
                if (dataSet.getExperiment() == null) continue;
                this.relationshipService.assignDataSetToExperiment(this.session, dataSet, null);
            }
        }
    }

    private void addToExperiment(List<SamplePE> samples) {
        for (SamplePE sample : samples) {
            this.assignSampleAndRelatedDataSetsToExperiment(sample, this.experiment);
        }
    }

    private static List<SamplePE> findSamples(ISampleDAO sampleDAO, Set<String> sampleCodes, ProjectPE project, boolean unassigned) throws UserFailureException {
        ArrayList<SamplePE> samples = new ArrayList<SamplePE>();
        ArrayList<String> missingSamples = new ArrayList<String>();
        for (String code : sampleCodes) {
            SamplePE sample = sampleDAO.tryfindByCodeAndProject(code, project);
            if (sample == null) {
                sample = sampleDAO.tryFindByCodeAndSpace(code, project.getSpace(), true);
            }
            if (sample == null) {
                missingSamples.add(code);
                continue;
            }
            if (unassigned) {
                ExperimentBO.checkSampleUnassigned(sample.getIdentifier(), sample);
            }
            samples.add(sample);
        }
        if (missingSamples.size() > 0) {
            throw UserFailureException.fromTemplate((String)"Samples with following codes do not exist in the project '%s' nor in the space '%s': '%s'.", (Object[])new Object[]{project.getIdentifier(), project.getSpace().getCode(), CollectionUtils.abbreviate(missingSamples, (int)10)});
        }
        return samples;
    }

    private static void checkSampleUnassigned(String identifier, SamplePE sample) {
        if (sample.getExperiment() != null) {
            throw UserFailureException.fromTemplate((String)"Sample '%s' is already assigned to the experiment '%s'.", (Object[])new Object[]{identifier, sample.getExperiment().getIdentifier()});
        }
    }

    private static Set<String> asSet(String[] objects) {
        return new HashSet<String>(Arrays.asList(objects));
    }

    private ProjectPE findProject(ProjectIdentifier newProjectIdentifier) {
        ProjectPE project = this.getProjectDAO().tryFindProject(newProjectIdentifier.getSpaceCode(), newProjectIdentifier.getProjectCode());
        if (project == null) {
            throw UserFailureException.fromTemplate((String)ERR_PROJECT_NOT_FOUND, (Object[])new Object[]{newProjectIdentifier});
        }
        return project;
    }

    @Override
    public void updateManagedProperty(IManagedProperty managedProperty) {
        Set<ExperimentPropertyPE> existingProperties = this.experiment.getProperties();
        ExperimentTypePE type = this.experiment.getExperimentType();
        PersonPE registrator = this.findPerson();
        this.experiment.setProperties(this.entityPropertiesConverter.updateManagedProperty(existingProperties, type, managedProperty, registrator));
        this.dataChanged = true;
    }
}

