/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.business.bo;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.server.business.IRelationshipService;
import ch.systemsx.cisd.openbis.generic.server.business.bo.AbstractBusinessObject;
import ch.systemsx.cisd.openbis.generic.server.business.bo.IGridCustomFilterOrColumnBO;
import ch.systemsx.cisd.openbis.generic.server.business.bo.util.DataSetTypeWithoutExperimentChecker;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IExpressionUpdates;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewColumnOrFilter;
import ch.systemsx.cisd.openbis.generic.shared.dto.GridCustomFilterPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.Session;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.IManagedPropertyEvaluatorFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataRetrievalFailureException;

public class GridCustomFilterBO
extends AbstractBusinessObject
implements IGridCustomFilterOrColumnBO {
    private GridCustomFilterPE filter;

    public GridCustomFilterBO(IDAOFactory daoFactory, Session session, IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory, DataSetTypeWithoutExperimentChecker dataSetTypeChecker, IRelationshipService relationshipService) {
        super(daoFactory, session, managedPropertyEvaluatorFactory, dataSetTypeChecker, relationshipService);
    }

    @Override
    public void define(NewColumnOrFilter newFilter) throws UserFailureException {
        this.filter = new GridCustomFilterPE();
        this.filter.setDescription(newFilter.getDescription());
        this.filter.setExpression(newFilter.getExpression());
        this.filter.setGridId(newFilter.getGridId());
        this.filter.setName(newFilter.getName());
        this.filter.setPublic(newFilter.isPublic());
        this.filter.setRegistrator(this.findPerson());
    }

    @Override
    public void loadDataByTechId(TechId id) {
        try {
            this.filter = (GridCustomFilterPE)this.getGridCustomFilterDAO().getByTechId(id);
        }
        catch (DataRetrievalFailureException exception) {
            throw new UserFailureException(exception.getMessage());
        }
    }

    @Override
    public void deleteByTechId(TechId groupId) throws UserFailureException {
        this.loadDataByTechId(groupId);
        try {
            this.getGridCustomFilterDAO().delete(this.filter);
        }
        catch (DataAccessException ex) {
            GridCustomFilterBO.throwException(ex, String.format("Filter '%s'", this.filter.getName()));
        }
    }

    @Override
    public void save() throws UserFailureException {
        assert (this.filter != null) : "Filter not defined";
        try {
            this.getGridCustomFilterDAO().createFilter(this.filter);
        }
        catch (DataAccessException e) {
            GridCustomFilterBO.throwException(e, "Filter '" + this.filter + "'");
        }
    }

    @Override
    public void update(IExpressionUpdates updates) {
        this.loadDataByTechId(TechId.create((IIdHolder)updates));
        if (!this.filter.getModificationDate().equals(updates.getModificationDate())) {
            GridCustomFilterBO.throwModifiedEntityException("Custom filter");
        }
        this.filter.setName(updates.getName());
        this.filter.setDescription(updates.getDescription());
        this.filter.setExpression(updates.getExpression());
        this.filter.setPublic(updates.isPublic());
        this.validateAndSave();
    }

    private void validateAndSave() {
        assert (this.filter != null) : "Filter not defined";
        try {
            this.getGridCustomFilterDAO().validateAndSaveUpdatedEntity(this.filter);
        }
        catch (DataAccessException e) {
            GridCustomFilterBO.throwException(e, "Filter '" + this.filter + "'");
        }
    }
}

