/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.business.bo;

import ch.systemsx.cisd.common.exceptions.AuthorizationFailureException;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.Session;
import ch.systemsx.cisd.openbis.generic.shared.dto.VocabularyPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.VocabularyTermPE;

public class InternalVocabularyAuthorization {
    public void canCreateVocabulary(Session session, VocabularyPE vocabulary) {
        this.checkVocabulary(session, vocabulary);
    }

    public void canUpdateVocabulary(Session session, VocabularyPE vocabulary) {
        this.checkVocabulary(session, vocabulary);
    }

    public void canDeleteVocabulary(Session session, VocabularyPE vocabulary) {
        this.checkVocabulary(session, vocabulary);
    }

    public void canCreateTerm(Session session, VocabularyPE vocabulary, VocabularyTermPE term) {
    }

    public void canUpdateTerm(Session session, VocabularyPE vocabulary, VocabularyTermPE term) {
        this.checkTerm(session, vocabulary, term);
    }

    public void canDeleteTerm(Session session, VocabularyPE vocabulary, VocabularyTermPE term) {
        this.checkTerm(session, vocabulary, term);
    }

    private void checkVocabulary(Session session, VocabularyPE vocabulary) {
        if (vocabulary.isManagedInternally() && !this.isSystemUser(session)) {
            throw new AuthorizationFailureException("Internal vocabularies can be managed only by the system user.");
        }
    }

    private void checkTerm(Session session, VocabularyPE vocabulary, VocabularyTermPE term) {
        if (vocabulary.isManagedInternally() && this.isSystemTerm(term) && !this.isSystemUser(session)) {
            throw new AuthorizationFailureException("Terms created by the system user that belong to internal vocabularies can be managed only by the system user.");
        }
    }

    private boolean isSystemTerm(VocabularyTermPE term) {
        PersonPE registrator = term.getRegistrator();
        if (registrator == null) {
            throw new AuthorizationFailureException("Could not check access because the vocabulary term does not have any registrator assigned.");
        }
        return registrator.isSystemUser();
    }

    private boolean isSystemUser(Session session) {
        PersonPE user = session.tryGetPerson();
        if (user == null) {
            throw new AuthorizationFailureException("Could not check access because the current session does not have any user assigned.");
        }
        return user.isSystemUser();
    }
}

