/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.business.bo;

import ch.systemsx.cisd.common.exceptions.AuthorizationFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.server.authorization.AuthorizationServiceUtils;
import ch.systemsx.cisd.openbis.generic.server.business.IRelationshipService;
import ch.systemsx.cisd.openbis.generic.server.business.bo.AbstractBusinessObject;
import ch.systemsx.cisd.openbis.generic.server.business.bo.IDataBO;
import ch.systemsx.cisd.openbis.generic.server.business.bo.IExperimentBO;
import ch.systemsx.cisd.openbis.generic.server.business.bo.IMaterialBO;
import ch.systemsx.cisd.openbis.generic.server.business.bo.IMetaprojectBO;
import ch.systemsx.cisd.openbis.generic.server.business.bo.ISampleBO;
import ch.systemsx.cisd.openbis.generic.server.business.bo.util.DataSetTypeWithoutExperimentChecker;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.DynamicPropertyEvaluationOperation;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDynamicPropertyEvaluationScheduler;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IMetaprojectRegistration;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IMetaprojectUpdates;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MetaprojectIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.id.IObjectId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.id.dataset.IDataSetId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.id.experiment.IExperimentId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.id.material.IMaterialId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.id.metaproject.IMetaprojectId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.id.metaproject.MetaprojectIdentifierId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.id.metaproject.MetaprojectTechIdId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.id.sample.ISampleId;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.EventPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.EventType;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.IEntityWithMetaprojects;
import ch.systemsx.cisd.openbis.generic.shared.dto.MaterialPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.MetaprojectPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SamplePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.Session;
import ch.systemsx.cisd.openbis.generic.shared.dto.properties.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.IManagedPropertyEvaluatorFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.ObjectRetrievalFailureException;

public class MetaprojectBO
extends AbstractBusinessObject
implements IMetaprojectBO {
    private IExperimentBO experimentBO;
    private ISampleBO sampleBO;
    private IDataBO dataBO;
    private IMaterialBO materialBO;
    private MetaprojectPE metaproject;
    private Map<Class<? extends IEntityWithMetaprojects>, List<Long>> changedEntitiesIds;
    private List<IEntityWithMetaprojects> entitiesWithMetaproject = new ArrayList<IEntityWithMetaprojects>();
    private boolean dataChanged;

    public MetaprojectBO(IDAOFactory daoFactory, IExperimentBO experimentBO, ISampleBO sampleBO, IDataBO dataBO, IMaterialBO materialBO, Session session, IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory, DataSetTypeWithoutExperimentChecker dataSetTypeChecker, IRelationshipService relationshipService) {
        super(daoFactory, session, managedPropertyEvaluatorFactory, dataSetTypeChecker, relationshipService);
        this.experimentBO = experimentBO;
        this.sampleBO = sampleBO;
        this.dataBO = dataBO;
        this.materialBO = materialBO;
    }

    @Override
    public MetaprojectPE tryFindByMetaprojectId(IMetaprojectId metaprojectId) {
        if (metaprojectId == null) {
            throw new UserFailureException("Metaproject id cannot be null");
        }
        if (metaprojectId instanceof MetaprojectIdentifierId) {
            MetaprojectIdentifierId identifierId = (MetaprojectIdentifierId)metaprojectId;
            MetaprojectIdentifier identifier = MetaprojectIdentifier.parse((String)identifierId.getIdentifier());
            return this.getMetaprojectDAO().tryFindByOwnerAndName(identifier.getMetaprojectOwnerId(), identifier.getMetaprojectName());
        }
        if (metaprojectId instanceof MetaprojectTechIdId) {
            MetaprojectTechIdId techIdId = (MetaprojectTechIdId)metaprojectId;
            return (MetaprojectPE)this.getMetaprojectDAO().tryGetByTechId(new TechId(techIdId.getTechId()), new String[0]);
        }
        throw new IllegalArgumentException("Unsupported metaproject id: " + metaprojectId);
    }

    @Override
    public void loadDataByTechId(TechId metaprojectId) {
        try {
            this.metaproject = (MetaprojectPE)this.getMetaprojectDAO().getByTechId(metaprojectId);
        }
        catch (ObjectRetrievalFailureException exception) {
            throw new UserFailureException(String.format("Metaproject with ID '%s' does not exist.", metaprojectId));
        }
        this.initChangedEntities();
        this.dataChanged = false;
    }

    @Override
    public void loadByMetaprojectId(IMetaprojectId metaprojectId) {
        this.metaproject = this.tryFindByMetaprojectId(metaprojectId);
        if (this.metaproject == null) {
            throw new UserFailureException(String.format("Metaproject with ID '%s' does not exist.", metaprojectId));
        }
        this.initChangedEntities();
        this.dataChanged = false;
    }

    @Override
    public MetaprojectPE getMetaproject() {
        return this.metaproject;
    }

    @Override
    public void save() throws UserFailureException {
        assert (this.metaproject != null) : "Can not save an undefined metaproject.";
        if (this.dataChanged) {
            for (IEntityWithMetaprojects entity : this.entitiesWithMetaproject) {
                entity.addMetaproject(this.metaproject);
            }
            try {
                this.getMetaprojectDAO().createOrUpdateMetaproject(this.metaproject, this.findPerson());
                IDynamicPropertyEvaluationScheduler indexUpdater = this.getPersistencyResources().getDynamicPropertyEvaluationScheduler();
                for (Map.Entry<Class<? extends IEntityWithMetaprojects>, List<Long>> changedEntry : this.changedEntitiesIds.entrySet()) {
                    indexUpdater.scheduleUpdate(DynamicPropertyEvaluationOperation.evaluate(changedEntry.getKey(), (Collection<Long>)changedEntry.getValue()));
                }
            }
            catch (DataAccessException ex) {
                MetaprojectBO.throwException(ex, "Metaproject '" + this.metaproject.getName() + "'");
            }
            this.dataChanged = false;
        }
    }

    @Override
    public void deleteByMetaprojectId(IMetaprojectId metaprojectId, String reason) throws UserFailureException {
        this.loadByMetaprojectId(metaprojectId);
        this.getMetaprojectDAO().delete(this.metaproject);
        this.getEventDAO().persist(MetaprojectBO.createDeletionEvent(this.metaproject, this.session.tryGetPerson(), reason));
    }

    private static EventPE createDeletionEvent(MetaprojectPE metaproject, PersonPE registrator, String reason) {
        EventPE event = new EventPE();
        event.setEventType(EventType.DELETION);
        event.setEntityType(EventPE.EntityType.METAPROJECT);
        event.setIdentifiers(Collections.singletonList(metaproject.getName()));
        event.setDescription(metaproject.getName());
        event.setRegistrator(registrator);
        event.setReason(reason);
        return event;
    }

    @Override
    public void define(String ownerId, IMetaprojectRegistration registration) {
        if (registration == null) {
            throw new UserFailureException("Metaproject data cannot be null");
        }
        if (registration.getName() == null) {
            throw new UserFailureException("Metaproject name cannot be null");
        }
        this.metaproject = new MetaprojectPE();
        this.metaproject.setName(registration.getName());
        this.metaproject.setDescription(registration.getDescription());
        this.metaproject.setOwner(this.getPersonDAO().tryFindPersonByUserId(ownerId));
        this.metaproject.setPrivate(true);
        this.initChangedEntities();
        this.dataChanged = true;
    }

    @Override
    public void update(IMetaprojectUpdates updates) {
        if (updates == null) {
            throw new UserFailureException("Metaproject data cannot be null");
        }
        if (updates.getName() == null) {
            throw new UserFailureException("Metaproject name cannot be null");
        }
        try {
            if (!this.metaproject.getName().equals(updates.getName())) {
                this.metaproject.setName(updates.getName());
                this.addToChangedEntities(ExperimentPE.class, this.listEntityIds(EntityKind.EXPERIMENT));
                this.addToChangedEntities(SamplePE.class, this.listEntityIds(EntityKind.SAMPLE));
                this.addToChangedEntities(DataPE.class, this.listEntityIds(EntityKind.DATA_SET));
                this.addToChangedEntities(MaterialPE.class, this.listEntityIds(EntityKind.MATERIAL));
            }
            this.metaproject.setDescription(updates.getDescription());
            this.dataChanged = true;
        }
        catch (DataAccessException ex) {
            MetaprojectBO.throwException(ex, "Metaproject '" + this.metaproject.getName() + "'");
        }
    }

    @Override
    public void addExperiments(List<? extends IExperimentId> experimentIds) {
        this.addEntities(experimentIds);
    }

    @Override
    public void addSamples(List<? extends ISampleId> sampleIds) {
        this.addEntities(sampleIds);
    }

    @Override
    public void addDataSets(List<? extends IDataSetId> dataSetIds) {
        this.addEntities(dataSetIds);
    }

    @Override
    public void addMaterials(List<? extends IMaterialId> materialIds) {
        this.addEntities(materialIds);
    }

    @Override
    public void removeExperiments(List<? extends IExperimentId> experimentIds) {
        this.removeEntities(experimentIds);
    }

    @Override
    public void removeSamples(List<? extends ISampleId> sampleIds) {
        this.removeEntities(sampleIds);
    }

    @Override
    public void removeDataSets(List<? extends IDataSetId> dataSetIds) {
        this.removeEntities(dataSetIds);
    }

    @Override
    public void removeMaterials(List<? extends IMaterialId> materialIds) {
        this.removeEntities(materialIds);
    }

    private <T extends IObjectId> void addEntities(Collection<T> entityIds) {
        for (IObjectId entityId : entityIds) {
            IEntityWithMetaprojects entityPE = this.findById(entityId);
            if (entityPE == null) {
                throw new IllegalArgumentException("Entity for id: " + entityId + " doesn't exist.");
            }
            boolean canAccess = this.canAccessEntity(entityPE);
            if (!canAccess) {
                throw new AuthorizationFailureException("Cannot access entity with id " + entityId);
            }
            this.entitiesWithMetaproject.add(entityPE);
            this.addToChangedEntities(entityPE.getClass(), entityPE.getId());
        }
        this.dataChanged = true;
    }

    private <T extends IObjectId> void removeEntities(Collection<T> entityIds) {
        for (IObjectId entityId : entityIds) {
            IEntityWithMetaprojects entityPE = this.findById(entityId);
            if (entityPE == null) continue;
            entityPE.removeMetaproject(this.metaproject);
            this.addToChangedEntities(entityPE.getClass(), entityPE.getId());
        }
        this.dataChanged = true;
    }

    private IEntityWithMetaprojects findById(IObjectId entityId) {
        if (entityId instanceof IMaterialId) {
            return this.materialBO.tryFindByMaterialId((IMaterialId)entityId);
        }
        if (entityId instanceof ISampleId) {
            return this.sampleBO.tryFindBySampleId((ISampleId)entityId);
        }
        if (entityId instanceof IDataSetId) {
            return this.dataBO.tryFindByDataSetId((IDataSetId)entityId);
        }
        if (entityId instanceof IExperimentId) {
            return this.experimentBO.tryFindByExperimentId((IExperimentId)entityId);
        }
        throw new IllegalArgumentException("Unsupported entity type " + entityId.getClass());
    }

    private boolean canAccessEntity(IEntityWithMetaprojects entity) {
        AuthorizationServiceUtils authorizationUtils = new AuthorizationServiceUtils(this.getDaoFactory(), this.findPerson());
        if (entity instanceof MaterialPE) {
            return true;
        }
        if (entity instanceof ExperimentPE) {
            return authorizationUtils.canAccessExperiment((ExperimentPE)entity);
        }
        if (entity instanceof SamplePE) {
            return authorizationUtils.canAccessSample((SamplePE)entity);
        }
        if (entity instanceof DataPE) {
            return authorizationUtils.canAccessDataSet((DataPE)entity);
        }
        throw new IllegalArgumentException("Unsupported entity kind " + entity.getClass());
    }

    private Collection<Long> listEntityIds(EntityKind entityKind) {
        return this.getMetaprojectDAO().listMetaprojectEntityIds(this.metaproject.getId(), entityKind);
    }

    private void initChangedEntities() {
        this.changedEntitiesIds = new HashMap<Class<? extends IEntityWithMetaprojects>, List<Long>>();
    }

    private void addToChangedEntities(Class<? extends IEntityWithMetaprojects> entityClass, Long entityId) {
        List<Long> ids = this.changedEntitiesIds.get(entityClass);
        if (ids == null) {
            ids = new ArrayList<Long>();
            this.changedEntitiesIds.put(entityClass, ids);
        }
        ids.add(entityId);
    }

    private void addToChangedEntities(Class<? extends IEntityWithMetaprojects> entityClass, Collection<Long> entityIds) {
        for (Long entityId : entityIds) {
            this.addToChangedEntities(entityClass, entityId);
        }
    }
}

