/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.business.bo;

import ch.systemsx.cisd.openbis.generic.server.business.IRelationshipService;
import ch.systemsx.cisd.openbis.generic.server.business.bo.util.DataSetTypeWithoutExperimentChecker;
import ch.systemsx.cisd.openbis.generic.server.business.bo.util.SampleUtils;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SamplePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.Session;
import ch.systemsx.cisd.openbis.generic.shared.util.EntityHelper;
import java.util.ArrayList;
import java.util.List;

public class NewDataSetToSampleExperimentAssignmentManager {
    private final DataSetTypeWithoutExperimentChecker dataSetTypeChecker;
    private final List<DataSetSampleExperiment> assignments = new ArrayList<DataSetSampleExperiment>();

    public NewDataSetToSampleExperimentAssignmentManager(DataSetTypeWithoutExperimentChecker dataSetTypeChecker) {
        this.dataSetTypeChecker = dataSetTypeChecker;
    }

    public void performAssignment(IRelationshipService relationshipService, Session session) {
        for (DataSetSampleExperiment assignment : this.assignments) {
            assignment.assignDataSet(relationshipService, session);
        }
    }

    public void assignDataSetAndRelatedComponents(DataPE dataSet, SamplePE sample, ExperimentPE experiment) {
        this.assignDataSetAndRelatedComponents(dataSet, dataSet, sample, experiment);
    }

    private void assignDataSetAndRelatedComponents(DataPE dataSet, DataPE rootDataSet, SamplePE sample, ExperimentPE experiment) {
        String dataSetTypeCode = dataSet.getDataSetType().getCode();
        if (experiment == null && !this.dataSetTypeChecker.isDataSetTypeWithoutExperiment(dataSetTypeCode)) {
            throw SampleUtils.createWrongSampleException(dataSet, sample, "the new sample is not connected to any experiment and the data set type (" + dataSetTypeCode + ") doesn't match one of the following regular expressions: " + this.dataSetTypeChecker.getRegularExpressions());
        }
        if (rootDataSet == dataSet) {
            this.assignments.add(new DataSetSampleExperiment(dataSet, sample, experiment));
        }
        SamplePE rootSample = rootDataSet.tryGetSample();
        ExperimentPE rootExperiment = this.getExperimentOf(rootDataSet);
        List<DataPE> components = dataSet.getContainedDataSets();
        for (DataPE component : components) {
            SamplePE componentSample = component.tryGetSample();
            ExperimentPE componentExperiment = this.getExperimentOf(component);
            if (!EntityHelper.equalEntities(rootSample, componentSample) && componentSample != null || !EntityHelper.equalEntities(rootExperiment, componentExperiment)) continue;
            SamplePE newSample = componentSample == null && experiment != null ? null : sample;
            this.assignments.add(new DataSetSampleExperiment(component, newSample, experiment));
            this.assignDataSetAndRelatedComponents(component, rootDataSet, sample, experiment);
        }
    }

    private ExperimentPE getExperimentOf(DataPE data) {
        SamplePE sample = data.tryGetSample();
        return sample == null ? data.getExperiment() : sample.getExperiment();
    }

    private static class DataSetSampleExperiment {
        private DataPE dataSet;
        private SamplePE sample;
        private ExperimentPE experiment;

        DataSetSampleExperiment(DataPE dataSet, SamplePE sample, ExperimentPE experiment) {
            this.dataSet = dataSet;
            this.sample = sample;
            this.experiment = experiment;
        }

        void assignDataSet(IRelationshipService relationshipService, Session session) {
            if (!EntityHelper.equalEntities(this.dataSet.tryGetSample(), this.sample)) {
                relationshipService.assignDataSetToSample(session, this.dataSet, this.sample);
            }
            if (!EntityHelper.equalEntities(this.dataSet.getExperiment(), this.experiment)) {
                relationshipService.assignDataSetToExperiment(session, this.dataSet, this.experiment);
            }
        }
    }
}

