/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.business.bo;

import ch.systemsx.cisd.common.collection.CollectionUtils;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.server.business.IRelationshipService;
import ch.systemsx.cisd.openbis.generic.server.business.bo.AbstractBusinessObject;
import ch.systemsx.cisd.openbis.generic.server.business.bo.IProjectBO;
import ch.systemsx.cisd.openbis.generic.server.business.bo.util.DataSetTypeWithoutExperimentChecker;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDeletionDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.deletion.EntityHistoryCreator;
import ch.systemsx.cisd.openbis.generic.server.util.SpaceIdentifierHelper;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.id.project.IProjectId;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.id.project.ProjectIdentifierId;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.id.project.ProjectPermIdId;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.id.project.ProjectTechIdId;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewAttachment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewProject;
import ch.systemsx.cisd.openbis.generic.shared.dto.AttachmentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DeletedExperimentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DeletionPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.EventPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.EventType;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.IModifierAndModificationDateBean;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ProjectPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ProjectUpdatesDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.Session;
import ch.systemsx.cisd.openbis.generic.shared.dto.SpacePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ProjectIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ProjectIdentifierFactory;
import ch.systemsx.cisd.openbis.generic.shared.dto.properties.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.IManagedPropertyEvaluatorFactory;
import ch.systemsx.cisd.openbis.generic.shared.util.HibernateUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.hibernate.SharedSessionContract;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.ObjectRetrievalFailureException;

public final class ProjectBO
extends AbstractBusinessObject
implements IProjectBO {
    private ProjectPE project;
    private boolean dataChanged;
    private final List<AttachmentPE> attachments = new ArrayList<AttachmentPE>();
    private EntityHistoryCreator historyCreator;
    private static final String propertyHistoryQuery = "SELECT 1 as a, 1 as b, 1 as c, 1 as d, 1 as e, 1 as f, 1 as g, 1 as h, 1 as i FROM materials WHERE id = -1 and id IN (:entityIds)";
    private static final String ENTITY_TYPE = "case when h.space_id is not null then 'SPACE' when h.expe_id is not null then 'EXPERIMENT' else 'UNKNOWN' end as entity_type";
    private static final String relationshipHistoryQuery = "SELECT p.perm_id, h.relation_type, h.entity_perm_id, case when h.space_id is not null then 'SPACE' when h.expe_id is not null then 'EXPERIMENT' else 'UNKNOWN' end as entity_type, pers.user_id, h.valid_from_timestamp, h.valid_until_timestamp FROM projects p, project_relationships_history h, persons pers WHERE p.id = h.main_proj_id AND h.main_proj_id IN (:entityIds) AND h.pers_id_author = pers.id ORDER BY 1, valid_from_timestamp";
    public static final String sqlAttributesHistory = "SELECT p.id, p.code, p.perm_id, p.description, p.registration_timestamp, r.user_id as registrator FROM projects p JOIN persons r on p.pers_id_registerer = r.id WHERE p.id IN (:entityIds)";

    public ProjectBO(IDAOFactory daoFactory, Session session, IRelationshipService relationshipService, IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory, DataSetTypeWithoutExperimentChecker dataSetTypeChecker, EntityHistoryCreator historyCreator) {
        super(daoFactory, session, managedPropertyEvaluatorFactory, dataSetTypeChecker, relationshipService);
        this.historyCreator = historyCreator;
    }

    private ProjectPE createProject(NewProject newProject, String leaderIdOrNull) {
        ProjectPE result = new ProjectPE();
        ProjectIdentifier projectIdentifier = new ProjectIdentifierFactory(newProject.getIdentifier()).createIdentifier();
        SpacePE group = SpaceIdentifierHelper.tryGetSpace(projectIdentifier, this.session.tryGetPerson(), this);
        result.setSpace(group);
        result.setRegistrator(this.findPerson());
        result.setPermId(this.getOrCreatePermID(newProject));
        result.setCode(projectIdentifier.getProjectCode());
        result.setDescription(newProject.getDescription());
        if (leaderIdOrNull != null) {
            PersonPE leader = this.getPersonDAO().tryFindPersonByUserId(leaderIdOrNull);
            if (leader == null) {
                throw new UserFailureException("Person '%s' not found in the database.");
            }
            result.setProjectLeader(leader);
        }
        this.addAttachments(result, newProject.getAttachments(), this.attachments);
        return result;
    }

    @Override
    public final void save() {
        assert (this.project != null) : "Can not save an undefined project.";
        if (this.dataChanged) {
            try {
                this.getProjectDAO().createProject(this.project, this.findPerson());
            }
            catch (DataAccessException ex) {
                ProjectBO.throwException(ex, "Project '" + this.project.getCode() + "'");
            }
            this.dataChanged = false;
        }
        this.saveAttachment(this.project, this.attachments);
    }

    @Override
    public final ProjectPE getProject() {
        return this.project;
    }

    @Override
    public ProjectPE tryFindByProjectId(IProjectId projectId) {
        if (projectId == null) {
            throw new IllegalArgumentException("Project id cannot be null");
        }
        if (projectId instanceof ProjectIdentifierId) {
            ProjectIdentifierId identifierId = (ProjectIdentifierId)projectId;
            ProjectIdentifier identifier = new ProjectIdentifierFactory(identifierId.getIdentifier()).createIdentifier();
            return this.tryFindByIdentifier(identifier);
        }
        if (projectId instanceof ProjectPermIdId) {
            ProjectPermIdId permIdId = (ProjectPermIdId)projectId;
            return this.getProjectDAO().tryGetByPermID(permIdId.getPermId());
        }
        if (projectId instanceof ProjectTechIdId) {
            ProjectTechIdId techIdId = (ProjectTechIdId)projectId;
            return (ProjectPE)this.getProjectDAO().tryGetByTechId(new TechId(techIdId.getTechId()), new String[0]);
        }
        throw new IllegalArgumentException("Unsupported project id: " + projectId);
    }

    private ProjectPE tryFindByIdentifier(ProjectIdentifier identifier) {
        return this.getProjectDAO().tryFindProject(identifier.getSpaceCode(), identifier.getProjectCode());
    }

    @Override
    public void define(NewProject newProject, String creatorId) throws UserFailureException {
        assert (newProject != null) : "Unspecified new project.";
        assert (newProject.getIdentifier() != null) : "Unspecified project identifier.";
        this.project = this.createProject(newProject, creatorId);
        this.dataChanged = true;
    }

    @Override
    public void loadByProjectIdentifier(ProjectIdentifier identifier) {
        String spaceCode = identifier.getSpaceCode();
        String projectCode = identifier.getProjectCode();
        this.project = this.getProjectDAO().tryFindProject(spaceCode, projectCode);
        if (this.project == null) {
            throw new UserFailureException(String.format("Project '%s' does not exist.", identifier));
        }
        this.dataChanged = false;
    }

    @Override
    public void loadByPermId(String permId) {
        this.project = this.getProjectDAO().tryGetByPermID(permId);
        if (this.project == null) {
            throw new UserFailureException(String.format("Project with PERM_ID '%s' does not exist.", permId));
        }
        this.dataChanged = false;
    }

    @Override
    public void loadDataByTechId(TechId projectId) {
        try {
            this.project = (ProjectPE)this.getProjectDAO().getByTechId(projectId);
        }
        catch (ObjectRetrievalFailureException exception) {
            throw new UserFailureException(String.format("Project with ID '%s' does not exist.", projectId));
        }
        this.dataChanged = false;
    }

    @Override
    public final void addAttachment(AttachmentPE attachment) {
        assert (this.project != null) : "no project has been loaded";
        this.prepareAttachment((IModifierAndModificationDateBean)this.project, attachment);
        this.attachments.add(attachment);
    }

    @Override
    public AttachmentPE tryGetProjectFileAttachment(String filename, Integer versionOrNull) {
        AttachmentPE att;
        this.checkProjectLoaded();
        this.project.ensureAttachmentsLoaded();
        AttachmentPE attachmentPE = att = versionOrNull == null ? this.getAttachment(filename) : this.getAttachment(filename, versionOrNull);
        if (att != null) {
            HibernateUtils.initialize(att.getAttachmentContent());
            return att;
        }
        return null;
    }

    @Override
    public AttachmentPE getProjectFileAttachment(String filename, Integer versionOrNull) {
        AttachmentPE attachment = this.tryGetProjectFileAttachment(filename, versionOrNull);
        if (attachment != null) {
            return attachment;
        }
        throw new UserFailureException("Attachment '" + filename + "' " + (versionOrNull == null ? "(latest version)" : "(version '" + versionOrNull + "')") + " not found in project '" + this.project.getIdentifier() + "'.");
    }

    private AttachmentPE getAttachment(String filename, int version) {
        Set<AttachmentPE> attachmentsSet = this.project.getAttachments();
        for (AttachmentPE att : attachmentsSet) {
            if (!att.getFileName().equals(filename) || att.getVersion() != version) continue;
            return att;
        }
        return null;
    }

    private AttachmentPE getAttachment(String filename) {
        AttachmentPE latest = null;
        Set<AttachmentPE> attachmentsSet = this.project.getAttachments();
        for (AttachmentPE att : attachmentsSet) {
            if (!att.getFileName().equals(filename) || latest != null && latest.getVersion() >= att.getVersion()) continue;
            latest = att;
        }
        return latest;
    }

    private void checkProjectLoaded() {
        if (this.project == null) {
            throw new IllegalStateException("Unloaded project.");
        }
    }

    @Override
    public final void enrichWithAttachments() {
        if (this.project != null) {
            this.project.ensureAttachmentsLoaded();
        }
    }

    @Override
    public void update(ProjectUpdatesDTO updates) {
        this.loadDataByTechId(updates.getTechId());
        if (updates.getVersion() != this.project.getVersion()) {
            ProjectBO.throwModifiedEntityException("Project");
        }
        this.project.setDescription(updates.getDescription());
        for (NewAttachment attachment : updates.getAttachments()) {
            this.attachments.add(this.prepareAttachment((IModifierAndModificationDateBean)this.project, attachment));
        }
        String groupCode = updates.getSpaceCode();
        if (groupCode != null && !groupCode.equals(this.project.getSpace().getCode())) {
            this.relationshipService.assignProjectToSpace(this.session, this.project, this.findGroup(groupCode));
        }
        this.dataChanged = true;
        this.reindex(ExperimentPE.class, this.project.getExperiments());
    }

    private SpacePE findGroup(String groupCode) {
        SpacePE group = this.getSpaceDAO().tryFindSpaceByCode(groupCode);
        if (group == null) {
            throw UserFailureException.fromTemplate((String)"No space with the name '%s' found!", (Object[])new Object[]{groupCode});
        }
        return group;
    }

    @Override
    public void deleteByTechId(TechId projectId, String reason) throws UserFailureException {
        this.loadDataByTechId(projectId);
        try {
            ArrayList<String> codes = new ArrayList<String>();
            ArrayList<String> trashedCodes = new ArrayList<String>();
            List<ExperimentPE> experiments = this.getExperimentDAO().listExperimentsWithProperties(Collections.singletonList(this.project), false, false);
            for (ExperimentPE experiment : experiments) {
                codes.add(experiment.getCode());
            }
            IDeletionDAO deletionDAO = this.getDeletionDAO();
            List deletionPEs = deletionDAO.listAllEntities();
            ArrayList<TechId> ids = new ArrayList<TechId>();
            for (DeletionPE deletion : deletionPEs) {
                ids.add(new TechId(deletion.getId()));
            }
            List<TechId> deletedExperimentIds = deletionDAO.findTrashedExperimentIds(ids);
            List deletedExperiments = (List)ProjectBO.cast(deletionDAO.listDeletedEntities(EntityKind.EXPERIMENT, deletedExperimentIds));
            for (DeletedExperimentPE deletedExperiment : deletedExperiments) {
                if (deletedExperiment.getProject().getId() != this.project.getId()) continue;
                trashedCodes.add(deletedExperiment.getCode());
            }
            if (!codes.isEmpty() || !trashedCodes.isEmpty()) {
                StringBuilder builder = new StringBuilder();
                if (!codes.isEmpty()) {
                    builder.append("the following experiments still exist: ");
                    builder.append(CollectionUtils.abbreviate(codes, (int)10));
                }
                if (!trashedCodes.isEmpty()) {
                    if (!codes.isEmpty()) {
                        builder.append("\nIn addition ");
                    }
                    builder.append("the following experiments are in the trash can: ");
                    builder.append(CollectionUtils.abbreviate(trashedCodes, (int)10));
                }
                throw new UserFailureException("Project '" + this.project.getCode() + "' can not be deleted because " + builder);
            }
            List<Long> idsToDelete = Collections.singletonList(projectId.getId());
            String content = this.historyCreator.apply((SharedSessionContract)this.getSessionFactory().getCurrentSession(), idsToDelete, propertyHistoryQuery, relationshipHistoryQuery, sqlAttributesHistory, Arrays.asList(this.project), null, this.session.tryGetPerson());
            this.getProjectDAO().delete(this.project);
            this.getEventDAO().persist(ProjectBO.createDeletionEvent(this.project, this.session.tryGetPerson(), reason, content));
        }
        catch (DataAccessException ex) {
            ProjectBO.throwException(ex, String.format("Project '%s'", this.project.getCode()));
        }
    }

    public static EventPE createDeletionEvent(ProjectPE project, PersonPE registrator, String reason, String content) {
        EventPE event = new EventPE();
        event.setEventType(EventType.DELETION);
        event.setEntityType(EventPE.EntityType.PROJECT);
        event.setIdentifiers(Collections.singletonList(project.getPermId()));
        event.setDescription(ProjectBO.getDeletionDescription(project));
        event.setReason(reason);
        event.setRegistrator(registrator);
        event.setContent(content);
        return event;
    }

    private static final <T> T cast(Object object) {
        return (T)object;
    }

    private static String getDeletionDescription(ProjectPE project) {
        return String.format("%s", project.getIdentifier());
    }
}

