/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.business.bo;

import ch.systemsx.cisd.common.collection.TableMap;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.server.business.IRelationshipService;
import ch.systemsx.cisd.openbis.generic.server.business.bo.AbstractBusinessObject;
import ch.systemsx.cisd.openbis.generic.server.business.bo.IRoleAssignmentTable;
import ch.systemsx.cisd.openbis.generic.server.business.bo.util.DataSetTypeWithoutExperimentChecker;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.util.KeyExtractorFactory;
import ch.systemsx.cisd.openbis.generic.server.util.SpaceIdentifierHelper;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Grantee;
import ch.systemsx.cisd.openbis.generic.shared.dto.AuthorizationGroupPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.NewRoleAssignment;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ProjectPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.RoleAssignmentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.Session;
import ch.systemsx.cisd.openbis.generic.shared.dto.SpacePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ProjectIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SpaceIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.IManagedPropertyEvaluatorFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataIntegrityViolationException;

public final class RoleAssignmentTable
extends AbstractBusinessObject
implements IRoleAssignmentTable {
    private List<RoleAssignmentPE> roleAssignments;
    private TableMap<String, PersonPE> personsByUserId;
    private TableMap<String, AuthorizationGroupPE> authorizationGroupsByCode;

    public RoleAssignmentTable(IDAOFactory daoFactory, Session session, IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory, DataSetTypeWithoutExperimentChecker dataSetTypeChecker, IRelationshipService relationshipService) {
        super(daoFactory, session, managedPropertyEvaluatorFactory, dataSetTypeChecker, relationshipService);
    }

    private final PersonPE getPerson(String userId) {
        PersonPE person;
        if (this.personsByUserId == null) {
            this.personsByUserId = new TableMap(this.getPersonDAO().listPersons(), KeyExtractorFactory.getPersonByUserIdKeyExtractor());
        }
        if ((person = (PersonPE)this.personsByUserId.tryGet((Object)userId)) == null) {
            throw UserFailureException.fromTemplate((String)"No person could be found for user id '%s'", (Object[])new Object[]{userId});
        }
        return person;
    }

    private final AuthorizationGroupPE getAuthorizationGroup(String authGroupId) {
        AuthorizationGroupPE authGroup;
        if (this.authorizationGroupsByCode == null) {
            this.authorizationGroupsByCode = new TableMap(this.getAuthorizationGroupDAO().list(), KeyExtractorFactory.getAuthorizationGroupByCodeKeyExtractor());
        }
        if ((authGroup = (AuthorizationGroupPE)this.authorizationGroupsByCode.tryGet((Object)authGroupId)) == null) {
            throw UserFailureException.fromTemplate((String)"No authorization group could be found for code '%s'", (Object[])new Object[]{authGroupId});
        }
        return authGroup;
    }

    @Override
    public final void add(NewRoleAssignment newRoleAssignment) {
        ProjectIdentifier projectIdentifier;
        if (this.roleAssignments == null) {
            this.roleAssignments = new ArrayList<RoleAssignmentPE>();
        }
        RoleAssignmentPE roleAssignment = new RoleAssignmentPE();
        if (newRoleAssignment.getSpaceIdentifier() != null && newRoleAssignment.getProjectIdentifier() != null) {
            throw UserFailureException.fromTemplate((String)"Role assignment can have either space or project specified but not both. Space was '%s'. Project was '%s'.", (Object[])new Object[]{newRoleAssignment.getSpaceIdentifier(), newRoleAssignment.getProjectIdentifier()});
        }
        SpaceIdentifier groupIdentifier = newRoleAssignment.getSpaceIdentifier();
        if (groupIdentifier != null) {
            SpacePE group = SpaceIdentifierHelper.tryGetSpace(groupIdentifier, this.session.tryGetPerson(), this);
            if (group == null) {
                throw UserFailureException.fromTemplate((String)"Specified space '%s' could not be found", (Object[])new Object[]{groupIdentifier});
            }
            roleAssignment.setSpace(group);
        }
        if ((projectIdentifier = newRoleAssignment.getProjectIdentifier()) != null) {
            List<ProjectPE> projects = this.getProjectDAO().tryFindProjects(Arrays.asList(projectIdentifier));
            if (projects == null || projects.isEmpty()) {
                throw UserFailureException.fromTemplate((String)"Specified project '%s' could not be found", (Object[])new Object[]{projectIdentifier});
            }
            roleAssignment.setProject(projects.get(0));
        }
        roleAssignment.setRegistrator(this.findPerson());
        roleAssignment.setRole(newRoleAssignment.getRole());
        if (Grantee.GranteeType.PERSON.equals((Object)newRoleAssignment.getGrantee().getType())) {
            this.getPerson(newRoleAssignment.getGrantee().getCode()).addRoleAssignment(roleAssignment);
        } else {
            this.getAuthorizationGroup(newRoleAssignment.getGrantee().getCode().toUpperCase()).addRoleAssignment(roleAssignment);
        }
        this.roleAssignments.add(roleAssignment);
    }

    @Override
    public final void save() throws UserFailureException {
        assert (this.roleAssignments != null) : "Role assignments unspecified";
        for (RoleAssignmentPE roleAssignment : this.roleAssignments) {
            try {
                this.getRoleAssignmentDAO().createRoleAssignment(roleAssignment);
            }
            catch (DataIntegrityViolationException ex) {
                RoleAssignmentTable.throwException((DataAccessException)((Object)ex), "Role assignment");
            }
        }
    }
}

