/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.business.bo;

import ch.systemsx.cisd.openbis.generic.server.business.bo.EntityCodeGenerator;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import java.util.Arrays;
import java.util.List;
import net.lemnik.eodsql.BaseQuery;
import net.lemnik.eodsql.QueryTool;
import net.lemnik.eodsql.Select;

public class SampleCodeGeneratorByType
extends EntityCodeGenerator {
    private final MaxQuery maxQuery = (MaxQuery)QueryTool.getManagedQuery(MaxQuery.class);

    public SampleCodeGeneratorByType(IDAOFactory daoFactory) {
        super(daoFactory);
    }

    @Override
    public List<String> generateCodes(String codePrefix, EntityKind entityKind, int numberOfCodes) {
        if (codePrefix == null) {
            throw new IllegalArgumentException("codePrefix can't be null.");
        }
        int maxCode = this.maxQuery.getMaxCode(codePrefix);
        String[] codes = new String[numberOfCodes];
        for (int i = 0; i < numberOfCodes; ++i) {
            String code;
            while (this.isCodeUsed(code = codePrefix + ++maxCode, entityKind)) {
            }
            codes[i] = code;
        }
        return Arrays.asList(codes);
    }

    public static interface MaxQuery
    extends BaseQuery {
        @Select(sql="SELECT max(substr(code, length(?{1})+1)::int) FROM samples_all WHERE UPPER(code) similar to UPPER(?{1}) || '[1234567890]+'")
        public int getMaxCode(String var1);
    }
}

