/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.business.bo;

import ch.systemsx.cisd.common.collection.IKeyExtractor;
import ch.systemsx.cisd.common.collection.IValidator;
import ch.systemsx.cisd.common.collection.TableMap;
import ch.systemsx.cisd.common.exceptions.ExceptionUtils;
import ch.systemsx.cisd.openbis.generic.server.authorization.validator.SamplePropertyAccessValidator;
import ch.systemsx.cisd.openbis.generic.server.business.IDataStoreServiceFactory;
import ch.systemsx.cisd.openbis.generic.server.business.IRelationshipService;
import ch.systemsx.cisd.openbis.generic.server.business.bo.AbstractBusinessObject;
import ch.systemsx.cisd.openbis.generic.server.business.bo.ISearchDomainSearcher;
import ch.systemsx.cisd.openbis.generic.server.business.bo.util.DataSetTypeWithoutExperimentChecker;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.shared.IDataStoreService;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.AbstractEntitySearchResultLocation;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.DataSetFileSearchResultLocation;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.EntityPropertySearchResultLocation;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.ISearchDomainResultLocation;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.SearchDomain;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.SearchDomainSearchResult;
import ch.systemsx.cisd.openbis.generic.shared.basic.IEntityInformationHolderWithIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdentifierHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Metaproject;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SearchDomainSearchResultWithFullEntity;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataStorePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SamplePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.Session;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.IManagedPropertyEvaluatorFactory;
import ch.systemsx.cisd.openbis.generic.shared.translator.DataSetTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.ExperimentTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.SampleTranslator;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SearchDomainSearcher
extends AbstractBusinessObject
implements ISearchDomainSearcher {
    private static final Map<Long, Set<Metaproject>> EMPTY_METAPROJECTS = Collections.emptyMap();
    private static final IKeyExtractor<String, IEntityInformationHolderWithIdentifier> PERM_ID_EXTRACTOR = new IKeyExtractor<String, IEntityInformationHolderWithIdentifier>(){

        public String getKey(IEntityInformationHolderWithIdentifier e) {
            return e.getPermId();
        }
    };
    private final IDataStoreServiceFactory dssFactory;

    public SearchDomainSearcher(IDAOFactory daoFactory, Session session, IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory, DataSetTypeWithoutExperimentChecker dataSetTypeChecker, IRelationshipService relationshipService, IDataStoreServiceFactory dssFactory) {
        super(daoFactory, session, managedPropertyEvaluatorFactory, dataSetTypeChecker, relationshipService);
        this.dssFactory = dssFactory;
    }

    @Override
    public List<SearchDomain> listAvailableSearchDomains() {
        ArrayList<SearchDomain> result = new ArrayList<SearchDomain>();
        List<DataStorePE> stores = this.getDataStoreDAO().listDataStores();
        for (DataStorePE dataStore : stores) {
            IDataStoreService service = SearchDomainSearcher.tryGetDataStoreService(dataStore, this.dssFactory);
            if (service == null) continue;
            try {
                result.addAll(service.listAvailableSearchDomains(dataStore.getSessionToken()));
            }
            catch (RuntimeException e) {
                Throwable causingException = ExceptionUtils.getEndOfChain((Throwable)e);
                if (causingException instanceof ConnectException) continue;
                throw e;
            }
        }
        return result;
    }

    @Override
    public List<SearchDomainSearchResultWithFullEntity> searchForEntitiesWithSequences(String preferredSearchDomainOrNull, String sequenceSnippet, Map<String, String> optionalParametersOrNull) {
        List<SearchDomainSearchResult> searchResults = this.askAllDataStoreServers(preferredSearchDomainOrNull, sequenceSnippet, optionalParametersOrNull);
        return this.enrichWithEntities(searchResults);
    }

    private List<SearchDomainSearchResult> askAllDataStoreServers(String preferredSearchDomainOrNull, String sequenceSnippet, Map<String, String> optionalParametersOrNull) {
        ArrayList<SearchDomainSearchResult> result = new ArrayList<SearchDomainSearchResult>();
        List<DataStorePE> stores = this.getDataStoreDAO().listDataStores();
        for (DataStorePE dataStore : stores) {
            IDataStoreService service = SearchDomainSearcher.tryGetDataStoreService(dataStore, this.dssFactory);
            if (service == null) continue;
            result.addAll(service.searchForEntitiesWithSequences(dataStore.getSessionToken(), preferredSearchDomainOrNull, sequenceSnippet, optionalParametersOrNull));
        }
        Collections.sort(result, Collections.reverseOrder());
        return result;
    }

    private List<SearchDomainSearchResultWithFullEntity> enrichWithEntities(List<SearchDomainSearchResult> searchResults) {
        Map<EntityLoader, List<String>> map = this.separate(searchResults);
        Map<EntityLoader, TableMap<String, IEntityInformationHolderWithIdentifier>> result = this.loadEntities(map);
        ArrayList<SearchDomainSearchResultWithFullEntity> enrichedResults = new ArrayList<SearchDomainSearchResultWithFullEntity>();
        for (SearchDomainSearchResult searchResult : searchResults) {
            ISearchDomainResultLocation location = searchResult.getResultLocation();
            Selector selector = new Selector(location);
            EntityLoader loader = selector.getLoader();
            IEntityInformationHolderWithIdentifier entity = (IEntityInformationHolderWithIdentifier)result.get((Object)loader).tryGet((Object)selector.getPermId());
            SearchDomainSearchResultWithFullEntity searchResultWithEntity = new SearchDomainSearchResultWithFullEntity();
            searchResultWithEntity.setSearchResult(searchResult);
            searchResultWithEntity.setEntity(entity);
            if (entity != null) {
                String code = entity.getCode();
                String type = entity.getEntityType().getCode();
                if (location instanceof AbstractEntitySearchResultLocation) {
                    AbstractEntitySearchResultLocation entityLocation = (AbstractEntitySearchResultLocation)location;
                    entityLocation.setCode(code);
                    entityLocation.setEntityType(type);
                }
            }
            enrichedResults.add(searchResultWithEntity);
        }
        return enrichedResults;
    }

    private Map<EntityLoader, List<String>> separate(List<SearchDomainSearchResult> searchResults) {
        EnumMap<EntityLoader, List<String>> map = new EnumMap<EntityLoader, List<String>>(EntityLoader.class);
        for (SearchDomainSearchResult searchResult : searchResults) {
            ISearchDomainResultLocation resultLocation = searchResult.getResultLocation();
            Selector selector = new Selector(resultLocation);
            EntityLoader loader = selector.getLoader();
            ArrayList<String> list = (ArrayList<String>)map.get((Object)loader);
            if (list == null) {
                list = new ArrayList<String>();
                map.put(loader, list);
            }
            list.add(selector.getPermId());
        }
        return map;
    }

    private Map<EntityLoader, TableMap<String, IEntityInformationHolderWithIdentifier>> loadEntities(Map<EntityLoader, List<String>> map) {
        EnumMap<EntityLoader, TableMap<String, IEntityInformationHolderWithIdentifier>> result = new EnumMap<EntityLoader, TableMap<String, IEntityInformationHolderWithIdentifier>>(EntityLoader.class);
        Set<Map.Entry<EntityLoader, List<String>>> entrySet = map.entrySet();
        SamplePropertyAccessValidator samplePropertyAccessValidator = new SamplePropertyAccessValidator(this.session, this.getDaoFactory());
        for (Map.Entry<EntityLoader, List<String>> entry : entrySet) {
            EntityLoader loader = entry.getKey();
            List<String> permIds = entry.getValue();
            List<IEntityInformationHolderWithIdentifier> entities = loader.loadEntities(this, this.managedPropertyEvaluatorFactory, samplePropertyAccessValidator, permIds);
            result.put(loader, (TableMap<String, IEntityInformationHolderWithIdentifier>)new TableMap(entities, PERM_ID_EXTRACTOR));
        }
        return result;
    }

    private static final class Selector {
        private EntityLoader loader = EntityLoader.DATA_SET;
        private String permId = null;

        Selector(ISearchDomainResultLocation resultLocation) {
            if (resultLocation instanceof DataSetFileSearchResultLocation) {
                this.permId = ((DataSetFileSearchResultLocation)resultLocation).getPermId();
            } else if (resultLocation instanceof EntityPropertySearchResultLocation) {
                EntityPropertySearchResultLocation location = (EntityPropertySearchResultLocation)resultLocation;
                this.permId = location.getPermId();
                this.loader = EntityLoader.valueOf(location.getEntityKind().toString());
            }
        }

        EntityLoader getLoader() {
            return this.loader;
        }

        String getPermId() {
            return this.permId;
        }
    }

    private static enum EntityLoader {
        SAMPLE{

            @Override
            public List<? extends IEntityInformationHolderWithIdentifier> doLoadEntities(IDAOFactory daoFactory, IManagedPropertyEvaluatorFactory evaluatorFactory, IValidator<IIdentifierHolder> samplePropertyAccessValidator, List<String> permIds) {
                List<SamplePE> samples = daoFactory.getSampleDAO().listByPermID(permIds);
                return SampleTranslator.translate(samples, "", EMPTY_METAPROJECTS, evaluatorFactory, samplePropertyAccessValidator);
            }
        }
        ,
        DATA_SET{

            @Override
            public List<? extends IEntityInformationHolderWithIdentifier> doLoadEntities(IDAOFactory daoFactory, IManagedPropertyEvaluatorFactory evaluatorFactory, IValidator<IIdentifierHolder> samplePropertyAccessValidator, List<String> permIds) {
                List<DataPE> dataSets = daoFactory.getDataDAO().listByCode(new HashSet<String>(permIds));
                return DataSetTranslator.translate(dataSets, "", "", EMPTY_METAPROJECTS, evaluatorFactory, samplePropertyAccessValidator);
            }
        }
        ,
        EXPERIMENT{

            @Override
            public List<? extends IEntityInformationHolderWithIdentifier> doLoadEntities(IDAOFactory daoFactory, IManagedPropertyEvaluatorFactory evaluatorFactory, IValidator<IIdentifierHolder> samplePropertyAccessValidator, List<String> permIds) {
                List<ExperimentPE> experiments = daoFactory.getExperimentDAO().listByPermID(permIds);
                return ExperimentTranslator.translate(experiments, "", EMPTY_METAPROJECTS, evaluatorFactory, samplePropertyAccessValidator);
            }
        }
        ,
        MATERIAL{

            @Override
            public List<? extends IEntityInformationHolderWithIdentifier> doLoadEntities(IDAOFactory daoFactory, IManagedPropertyEvaluatorFactory evaluatorFactory, IValidator<IIdentifierHolder> samplePropertyAccessValidator, List<String> permIds) {
                throw new UnsupportedOperationException();
            }
        };


        public List<IEntityInformationHolderWithIdentifier> loadEntities(IDAOFactory daoFactory, IManagedPropertyEvaluatorFactory evaluatorFactory, IValidator<IIdentifierHolder> samplePropertyAccessValidator, List<String> permIds) {
            ArrayList<IEntityInformationHolderWithIdentifier> result = new ArrayList<IEntityInformationHolderWithIdentifier>();
            List<? extends IEntityInformationHolderWithIdentifier> entities = this.doLoadEntities(daoFactory, evaluatorFactory, samplePropertyAccessValidator, permIds);
            for (IEntityInformationHolderWithIdentifier iEntityInformationHolderWithIdentifier : entities) {
                result.add(iEntityInformationHolderWithIdentifier);
            }
            return result;
        }

        public abstract List<? extends IEntityInformationHolderWithIdentifier> doLoadEntities(IDAOFactory var1, IManagedPropertyEvaluatorFactory var2, IValidator<IIdentifierHolder> var3, List<String> var4);
    }
}

