/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.business.bo;

import ch.systemsx.cisd.common.collection.CollectionUtils;
import ch.systemsx.cisd.common.exceptions.AuthorizationFailureException;
import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.server.authorization.AuthorizationDataProvider;
import ch.systemsx.cisd.openbis.generic.server.authorization.DefaultAccessController;
import ch.systemsx.cisd.openbis.generic.server.authorization.RoleWithIdentifier;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.DataPEPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.ExperimentPEPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.PersistentEntityPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.SamplePEPredicate;
import ch.systemsx.cisd.openbis.generic.server.batch.BatchOperationExecutor;
import ch.systemsx.cisd.openbis.generic.server.batch.IBatchOperation;
import ch.systemsx.cisd.openbis.generic.server.business.IRelationshipService;
import ch.systemsx.cisd.openbis.generic.server.business.bo.AbstractBusinessObject;
import ch.systemsx.cisd.openbis.generic.server.business.bo.ICommonBusinessObjectFactory;
import ch.systemsx.cisd.openbis.generic.server.business.bo.ITrashBO;
import ch.systemsx.cisd.openbis.generic.server.business.bo.datasetlister.IDatasetLister;
import ch.systemsx.cisd.openbis.generic.server.business.bo.samplelister.ISampleLister;
import ch.systemsx.cisd.openbis.generic.server.business.bo.util.DataSetTypeWithoutExperimentChecker;
import ch.systemsx.cisd.openbis.generic.server.business.bo.util.DataSetUtils;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDeletionDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.ISampleDAO;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.DataSetFetchOption;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdAndCodeHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdentifierHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetArchivingStatus;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ListOrSearchSampleCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PhysicalDataSet;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DeletionPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SamplePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.Session;
import ch.systemsx.cisd.openbis.generic.shared.dto.properties.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.IManagedPropertyEvaluatorFactory;
import ch.systemsx.cisd.openbis.generic.shared.util.HibernateUtils;
import ch.systemsx.cisd.openbis.generic.shared.util.RelationshipUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.springframework.dao.DataAccessException;

public class TrashBO
extends AbstractBusinessObject
implements ITrashBO {
    static final EnumSet<DataSetFetchOption> DATA_SET_FETCH_OPTIONS = EnumSet.of(DataSetFetchOption.EXPERIMENT, DataSetFetchOption.SAMPLE);
    private final ICommonBusinessObjectFactory boFactory;
    private DeletionPE deletion;

    public TrashBO(IDAOFactory daoFactory, ICommonBusinessObjectFactory boFactory, Session session, IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory, DataSetTypeWithoutExperimentChecker dataSetTypeChecker, IRelationshipService relationshipService) {
        super(daoFactory, session, managedPropertyEvaluatorFactory, dataSetTypeChecker, relationshipService);
        this.boFactory = boFactory;
    }

    @Override
    public DeletionPE getDeletion() {
        return this.deletion;
    }

    @Override
    public void createDeletion(String reason) {
        try {
            this.deletion = new DeletionPE();
            this.deletion.setReason(reason);
            this.deletion.setRegistrator(this.session.tryGetPerson());
            this.getDeletionDAO().create(this.deletion);
        }
        catch (DataAccessException ex) {
            TrashBO.throwException(ex, "Deletion");
        }
    }

    @Override
    public void trashDataSets(List<TechId> dataSetIds) {
        assert (this.deletion != null);
        IDatasetLister datasetLister = this.boFactory.createDatasetLister(this.session);
        final HashSet<TechId> experimentIds = new HashSet<TechId>();
        final HashSet<TechId> sampleIds = new HashSet<TechId>();
        for (AbstractExternalData dataSet : this.listDataSets(datasetLister, dataSetIds)) {
            DataSetType dataSetType = dataSet.getDataSetType();
            if (dataSetType.isDeletionDisallow()) {
                throw new UserFailureException("Data set " + dataSet.getCode() + " can not be deleted because it isn't allowed by its data set type " + dataSetType.getCode() + ".");
            }
            Sample sample = dataSet.getSample();
            if (sample != null) {
                sampleIds.add(new TechId((IIdAndCodeHolder)sample));
            }
            if (dataSet.getExperiment() == null) continue;
            experimentIds.add(new TechId((IIdAndCodeHolder)dataSet.getExperiment()));
        }
        this.assertDataSetDeletionBusinessRules(experimentIds, sampleIds, dataSetIds);
        TrashOperationsManager trashManager = new TrashOperationsManager(this.session, this.deletion, this, this.getTransactionTimeStamp());
        this.trashDataSets(trashManager, dataSetIds, true, new IDataSetFilter(){

            @Override
            public List<TechId> filter(List<AbstractExternalData> dataSets) {
                ArrayList<TechId> filtered = new ArrayList<TechId>();
                for (AbstractExternalData dataSet : dataSets) {
                    Sample sample = dataSet.getSample();
                    Experiment experiment = dataSet.getExperiment();
                    if (!this.contains(sampleIds, sample) && !this.contains(experimentIds, experiment)) continue;
                    filtered.add(new TechId((IIdAndCodeHolder)dataSet));
                }
                return filtered;
            }

            private boolean contains(Set<TechId> ids, IIdAndCodeHolder entity) {
                return entity != null && ids.contains(new TechId(HibernateUtils.getId((IIdHolder)entity)));
            }
        });
        trashManager.trash();
    }

    @Override
    public void trashExperiments(List<TechId> experimentIds) {
        assert (this.deletion != null);
        TrashOperationsManager trashManager = new TrashOperationsManager(this.session, this.deletion, this, this.getTransactionTimeStamp());
        trashManager.addTrashOperation(EntityKind.EXPERIMENT, experimentIds, true);
        LinkedHashSet<TechId> eIds = new LinkedHashSet<TechId>(experimentIds);
        Set<TechId> dependentSampleIds = this.trashExperimentDependentSamples(trashManager, eIds);
        this.trashExperimentDependentDataSets(trashManager, eIds, dependentSampleIds);
        trashManager.trash();
    }

    @Override
    public void trashSamples(List<TechId> sampleIds) {
        assert (this.deletion != null);
        TrashOperationsManager trashManager = new TrashOperationsManager(this.session, this.deletion, this, this.getTransactionTimeStamp());
        Set<TechId> allSampleIds = this.trashSamples(trashManager, sampleIds, CascadeSampleDependentComponents.TRUE, true);
        Set<TechId> experimentsOfSamples = this.getExperimentsOfSamples(sampleIds);
        this.trashSampleDependentDataSets(trashManager, experimentsOfSamples, allSampleIds);
        trashManager.trash();
    }

    private Set<TechId> getExperimentsOfSamples(List<TechId> sampleIds) {
        HashSet<TechId> experimentIds = new HashSet<TechId>();
        ISampleLister sampleLister = this.boFactory.createSampleLister(this.session);
        List<Sample> samples = sampleLister.list(new ListOrSearchSampleCriteria(TechId.asLongs(sampleIds)));
        for (Sample sample : samples) {
            Experiment experiment = sample.getExperiment();
            if (experiment == null) continue;
            experimentIds.add(new TechId((IIdAndCodeHolder)experiment));
        }
        return experimentIds;
    }

    private Set<TechId> trashSamples(TrashOperationsManager trashManager, List<TechId> sampleIds, CascadeSampleDependentComponents cascadeType, boolean isOriginalDeletion) {
        assert (this.deletion != null);
        LinkedHashSet<TechId> allSampleIds = new LinkedHashSet<TechId>(sampleIds);
        trashManager.addTrashOperation(EntityKind.SAMPLE, sampleIds, isOriginalDeletion);
        if (cascadeType == CascadeSampleDependentComponents.TRUE) {
            allSampleIds.addAll(this.trashSampleDependentComponents(trashManager, sampleIds));
        }
        return allSampleIds;
    }

    private void trashDataSets(TrashOperationsManager trashManager, List<TechId> dataSetIds, boolean isOriginalDeletion, IDataSetFilter filterOrNull) {
        assert (this.deletion != null);
        if (dataSetIds.isEmpty()) {
            return;
        }
        IDatasetLister datasetLister = this.boFactory.createDatasetLister(this.session);
        List<TechId> allDeletables = DataSetUtils.getAllDeletableComponentsRecursively(dataSetIds, isOriginalDeletion, datasetLister, this);
        List<AbstractExternalData> dataSets = this.listDataSets(datasetLister, allDeletables);
        this.checkForNonDeletableDataSets(dataSets);
        if (filterOrNull != null) {
            allDeletables = filterOrNull.filter(dataSets);
        }
        ArrayList<TechId> deletableOriginals = new ArrayList<TechId>(dataSetIds);
        deletableOriginals.retainAll(allDeletables);
        if (isOriginalDeletion) {
            allDeletables.removeAll(deletableOriginals);
            trashManager.addTrashOperation(EntityKind.DATA_SET, deletableOriginals, true);
        }
        trashManager.addTrashOperation(EntityKind.DATA_SET, allDeletables, false);
    }

    private void checkForNonDeletableDataSets(List<AbstractExternalData> dataSets) {
        TreeMap<DataSetArchivingStatus, ArrayList<String>> statusToCodesMap = new TreeMap<DataSetArchivingStatus, ArrayList<String>>();
        for (AbstractExternalData dataSet : dataSets) {
            PhysicalDataSet physicalDataSet;
            DataSetArchivingStatus archivingStatus;
            if (!(dataSet instanceof PhysicalDataSet) || (archivingStatus = (physicalDataSet = (PhysicalDataSet)dataSet).getStatus()).isDeletable()) continue;
            ArrayList<String> codes = (ArrayList<String>)statusToCodesMap.get((Object)archivingStatus);
            if (codes == null) {
                codes = new ArrayList<String>();
                statusToCodesMap.put(archivingStatus, codes);
            }
            codes.add(dataSet.getCode());
        }
        StringBuilder builder = new StringBuilder();
        Set entrySet = statusToCodesMap.entrySet();
        for (Map.Entry entry : entrySet) {
            builder.append("\n Status: ").append(entry.getKey()).append(", data sets: ");
            builder.append(entry.getValue());
        }
        if (builder.length() > 0) {
            throw new UserFailureException("Deletion not possible because the following data sets are not deletable:" + builder);
        }
    }

    private Set<TechId> trashSampleDependentComponents(TrashOperationsManager trashManager, List<TechId> sampleIds) {
        final ISampleDAO sampleDAO = this.getSampleDAO();
        AbstractQueryBatchOperation batchOperation = new AbstractQueryBatchOperation(EntityKind.SAMPLE, sampleIds, "listSampleIdsByContainerIds"){

            @Override
            public Collection<TechId> listAction(List<TechId> entities) {
                return sampleDAO.listSampleIdsByContainerIds(entities);
            }
        };
        BatchOperationExecutor.executeInBatches(batchOperation);
        return this.trashSamples(trashManager, batchOperation.getResults(), CascadeSampleDependentComponents.FALSE, false);
    }

    private void trashSampleDependentDataSets(TrashOperationsManager trashManager, Set<TechId> experimentsOfSamples, Set<TechId> sampleIds) {
        AbstractQueryBatchOperation batchOperation = new AbstractQueryBatchOperation(EntityKind.DATA_SET, new ArrayList<TechId>(sampleIds), "listDataSetIdsBySampleIds"){

            public List<TechId> listAction(List<TechId> entities) {
                List<TechId> ids = TrashBO.this.getDataDAO().listDataSetIdsBySampleIds(entities);
                return ids;
            }
        };
        BatchOperationExecutor.executeInBatches(batchOperation);
        List<TechId> dataSetIds = batchOperation.getResults();
        this.assertDataSetDeletionBusinessRules(experimentsOfSamples, sampleIds, dataSetIds);
        this.trashDataSets(trashManager, dataSetIds, false, new DataSetFilter(sampleIds, new IIdHolderProvider(){

            @Override
            public IIdHolder getIdHolder(AbstractExternalData dataSet) {
                return dataSet.getSample();
            }
        }));
    }

    private Set<TechId> trashExperimentDependentSamples(TrashOperationsManager trashManager, Set<TechId> experimentIds) {
        AbstractQueryBatchOperation batchOperation = new AbstractQueryBatchOperation(EntityKind.SAMPLE, new ArrayList<TechId>(experimentIds), "listSampleIdsByExperimentIds"){

            public List<TechId> listAction(List<TechId> entities) {
                return TrashBO.this.getSampleDAO().listSampleIdsByExperimentIds(entities);
            }
        };
        BatchOperationExecutor.executeInBatches(batchOperation);
        List<TechId> sampleIds = batchOperation.getResults();
        return this.trashSamples(trashManager, sampleIds, CascadeSampleDependentComponents.TRUE, false);
    }

    private void trashExperimentDependentDataSets(TrashOperationsManager trashManager, Set<TechId> experimentIds, Set<TechId> dependentSampleIds) {
        AbstractQueryBatchOperation batchOperation = new AbstractQueryBatchOperation(EntityKind.DATA_SET, new ArrayList<TechId>(experimentIds), "listDataSetIdsByExperimentIds"){

            public List<TechId> listAction(List<TechId> entities) {
                return TrashBO.this.getDataDAO().listDataSetIdsByExperimentIds(entities);
            }
        };
        BatchOperationExecutor.executeInBatches(batchOperation);
        List<TechId> dataSetIds = batchOperation.getResults();
        this.assertDataSetDeletionBusinessRules(experimentIds, dependentSampleIds, dataSetIds);
        this.trashDataSets(trashManager, dataSetIds, false, new DataSetFilter(experimentIds, new IIdHolderProvider(){

            @Override
            public IIdHolder getIdHolder(AbstractExternalData dataSet) {
                return dataSet.getExperiment();
            }
        }));
    }

    private void assertDataSetDeletionBusinessRules(Set<TechId> experimentIds, Set<TechId> sampleIdes, List<TechId> dataSetIds) {
        IDatasetLister datasetLister = this.boFactory.createDatasetLister(this.session);
        Map<Long, Set<Long>> containerIds = datasetLister.listContainerIds(TechId.asLongs(dataSetIds));
        if (containerIds.isEmpty()) {
            return;
        }
        LinkedHashSet<Long> allRelatedDataSets = new LinkedHashSet<Long>();
        this.addIds(allRelatedDataSets, containerIds);
        LinkedHashSet eIds = new LinkedHashSet(TechId.asLongs(experimentIds));
        LinkedHashSet sIds = new LinkedHashSet(TechId.asLongs(sampleIdes));
        ArrayList<Long> ids = new ArrayList<Long>(allRelatedDataSets);
        List<AbstractExternalData> relatedDataSets = this.listDataSets(datasetLister, TechId.createList(ids));
        StringBuilder builder = new StringBuilder();
        int numberOfForeignDataSets = 0;
        for (AbstractExternalData relatedDataSet : relatedDataSets) {
            if (numberOfForeignDataSets >= 10) break;
            Sample sample = relatedDataSet.getSample();
            Experiment experiment = relatedDataSet.getExperiment();
            if (sample != null) {
                if (sIds.contains(sample.getId())) continue;
                HibernateUtils.initialize(sample);
                this.addTo(builder, "sample " + sample.getIdentifier(), relatedDataSet, containerIds);
                ++numberOfForeignDataSets;
                continue;
            }
            if (experiment == null || eIds.contains(experiment.getId())) continue;
            HibernateUtils.initialize(experiment);
            this.addTo(builder, "experiment " + experiment.getIdentifier(), relatedDataSet, containerIds);
            ++numberOfForeignDataSets;
        }
        if (numberOfForeignDataSets > 0) {
            throw new UserFailureException(builder.toString().trim());
        }
    }

    private void addTo(StringBuilder builder, String entityDescription, AbstractExternalData dataSet, Map<Long, Set<Long>> containerIds) {
        String findOriginalDataSet = this.findOriginalDataSet(containerIds, dataSet);
        builder.append("The data set " + findOriginalDataSet + " is a component of the data set " + dataSet.getCode() + " which belongs to the " + entityDescription + " which is outside the deletion set.\n");
    }

    private String findOriginalDataSet(Map<Long, Set<Long>> relations, AbstractExternalData dataSet) {
        Set<Map.Entry<Long, Set<Long>>> entrySet = relations.entrySet();
        for (Map.Entry<Long, Set<Long>> entry : entrySet) {
            if (!entry.getValue().contains(dataSet.getId())) continue;
            return ((DataPE)this.getDataDAO().getByTechId(new TechId(entry.getKey()))).getCode();
        }
        return null;
    }

    private void addIds(Set<Long> ids, Map<Long, Set<Long>> mappedIds) {
        for (Set<Long> set : mappedIds.values()) {
            ids.addAll(set);
        }
    }

    private List<AbstractExternalData> listDataSets(IDatasetLister datasetLister, List<TechId> dataSetIds) {
        return datasetLister.listByDatasetIds(TechId.asLongs(dataSetIds), DATA_SET_FETCH_OPTIONS);
    }

    @Override
    public void revertDeletion(TechId deletionId) {
        try {
            this.deletion = (DeletionPE)this.getDeletionDAO().getByTechId(deletionId);
            this.getDeletionDAO().revert(this.deletion, this.session.tryGetPerson());
        }
        catch (DataAccessException ex) {
            TrashBO.throwException(ex, "Deletion");
        }
    }

    private static abstract class AbstractQueryBatchOperation
    implements IBatchOperation<TechId> {
        private final EntityKind entityKind;
        private final List<TechId> entityIds;
        private final String operationName;
        private final Set<TechId> results = new LinkedHashSet<TechId>();

        public AbstractQueryBatchOperation(EntityKind entityKind, List<TechId> entityIds, String operationName) {
            this.entityKind = entityKind;
            this.entityIds = entityIds;
            this.operationName = operationName;
        }

        public abstract Collection<TechId> listAction(List<TechId> var1);

        @Override
        public void execute(List<TechId> entities) {
            this.results.addAll(this.listAction(entities));
        }

        @Override
        public List<TechId> getAllEntities() {
            return this.entityIds;
        }

        @Override
        public String getEntityName() {
            return this.entityKind.getLabel();
        }

        @Override
        public String getOperationName() {
            return this.operationName;
        }

        public List<TechId> getResults() {
            return new ArrayList<TechId>(this.results);
        }
    }

    private static class TrashBatchOperation
    implements IBatchOperation<TechId> {
        private final EntityKind entityKind;
        private final List<TechId> entityIds;
        private final DeletionPE deletion;
        private final IDeletionDAO deletionDAO;
        private final boolean isOriginalDeletion;

        public TrashBatchOperation(EntityKind entityKind, List<TechId> entityIds, DeletionPE deletion, IDeletionDAO deletionDAO, boolean isOriginalDeletion) {
            this.entityKind = entityKind;
            this.entityIds = entityIds;
            this.deletion = deletion;
            this.deletionDAO = deletionDAO;
            this.isOriginalDeletion = isOriginalDeletion;
        }

        @Override
        public void execute(List<TechId> entities) {
            this.deletionDAO.trash(this.entityKind, entities, this.deletion, this.isOriginalDeletion);
        }

        @Override
        public List<TechId> getAllEntities() {
            return this.entityIds;
        }

        @Override
        public String getEntityName() {
            return this.entityKind.getLabel();
        }

        @Override
        public String getOperationName() {
            return "trash";
        }

        public String toString() {
            return this.getOperationName() + (this.isOriginalDeletion ? " original " : " dependent ") + (Object)((Object)this.entityKind) + " " + this.getEntityName() + " " + this.entityIds;
        }
    }

    private static final class TrashOperationsManager {
        private final Session session;
        private final DeletionPE deletion;
        private final IDAOFactory daoFactory;
        private final Map<EntityKind, Set<TechId>> entityIdsByKind = new HashMap<EntityKind, Set<TechId>>();
        private final List<TrashBatchOperation> operations = new ArrayList<TrashBatchOperation>();
        private final PersonPE person;
        private final List<RoleWithIdentifier> allowedRoles;
        private final ExperimentPEPredicate experimentPredicate;
        private final SamplePEPredicate samplesPredicate;
        private final DataPEPredicate dataSetPredicate;
        private final Date modificationTimestamp;

        TrashOperationsManager(Session session, DeletionPE deletion, IDAOFactory daoFactory, Date modificationTimestamp) {
            EntityKind[] values;
            this.session = session;
            this.deletion = deletion;
            this.daoFactory = daoFactory;
            this.modificationTimestamp = modificationTimestamp;
            for (EntityKind entityKind : values = EntityKind.values()) {
                this.entityIdsByKind.put(entityKind, new HashSet());
            }
            this.person = session.tryGetPerson();
            this.allowedRoles = DefaultAccessController.getUserRoles(this.person);
            this.experimentPredicate = new ExperimentPEPredicate();
            this.experimentPredicate.init(new AuthorizationDataProvider(daoFactory));
            this.samplesPredicate = new SamplePEPredicate();
            this.samplesPredicate.init(new AuthorizationDataProvider(daoFactory));
            this.dataSetPredicate = new DataPEPredicate();
            this.dataSetPredicate.init(new AuthorizationDataProvider(daoFactory));
        }

        void addTrashOperation(EntityKind entityKind, List<TechId> entityIds, boolean isOriginalDeletion) {
            if (!entityIds.isEmpty()) {
                List ids = TechId.asLongs(entityIds);
                if (entityKind == EntityKind.EXPERIMENT) {
                    List<ExperimentPE> experiments = this.daoFactory.getExperimentDAO().listByIDs(ids);
                    this.assertAuthorization(this.experimentPredicate, experiments, "experiments");
                } else if (entityKind == EntityKind.SAMPLE) {
                    List<SamplePE> samples = this.daoFactory.getSampleDAO().listByIDs(ids);
                    this.assertAuthorization(this.samplesPredicate, samples, "samples");
                } else if (entityKind == EntityKind.DATA_SET) {
                    List<DataPE> dataSets = this.daoFactory.getDataDAO().listByIDs(ids);
                    this.assertAuthorization(this.dataSetPredicate, dataSets, "data sets");
                }
                this.entityIdsByKind.get((Object)entityKind).addAll(entityIds);
                IDeletionDAO deletionDAO = this.daoFactory.getDeletionDAO();
                this.operations.add(0, new TrashBatchOperation(entityKind, entityIds, this.deletion, deletionDAO, isOriginalDeletion));
            }
        }

        private void assertAuthorization(PersistentEntityPredicate entityPredicate, List<? extends IIdentifierHolder> entities, String entityKindName) {
            ArrayList<String> identifiers = new ArrayList<String>();
            String errorMessage = "";
            for (IIdentifierHolder iIdentifierHolder : entities) {
                Status status = entityPredicate.evaluate(this.person, this.allowedRoles, iIdentifierHolder);
                if (status.isOK()) continue;
                identifiers.add(iIdentifierHolder.getIdentifier());
                errorMessage = status.tryGetErrorMessage();
            }
            if (!identifiers.isEmpty()) {
                throw new AuthorizationFailureException("Can not delete " + entityKindName + " " + CollectionUtils.abbreviate(identifiers, (int)10) + " because user " + errorMessage);
            }
        }

        void trash() {
            this.updateModificationDateAndModifierOfRelatedProjectsOfExperiments();
            this.updateModificationDateAndModifierOfRelatedEntitiesOfSamples();
            this.updateModificationDateAndModifierOfRelatedEntitiesOfDataSets();
            for (TrashBatchOperation operation : this.operations) {
                BatchOperationExecutor.executeInBatches(operation);
            }
        }

        private void updateModificationDateAndModifierOfRelatedProjectsOfExperiments() {
            List ids = TechId.asLongs((Collection)this.entityIdsByKind.get((Object)EntityKind.EXPERIMENT));
            if (!ids.isEmpty()) {
                List<ExperimentPE> experiments = this.daoFactory.getExperimentDAO().listByIDs(ids);
                RelationshipUtils.updateModificationDateAndModifierOfRelatedProjectsOfExperiments(experiments, this.session, this.modificationTimestamp);
            }
        }

        private void updateModificationDateAndModifierOfRelatedEntitiesOfSamples() {
            List ids = TechId.asLongs((Collection)this.entityIdsByKind.get((Object)EntityKind.SAMPLE));
            if (!ids.isEmpty()) {
                List<SamplePE> samples = this.daoFactory.getSampleDAO().listByIDs(ids);
                RelationshipUtils.updateModificationDateAndModifierOfRelatedEntitiesOfSamples(samples, this.session, this.modificationTimestamp);
            }
        }

        private void updateModificationDateAndModifierOfRelatedEntitiesOfDataSets() {
            List ids = TechId.asLongs((Collection)this.entityIdsByKind.get((Object)EntityKind.DATA_SET));
            if (!ids.isEmpty()) {
                List<DataPE> dataSets = this.daoFactory.getDataDAO().listByIDs(ids);
                RelationshipUtils.updateModificationDateAndModifierOfRelatedEntitiesOfDataSets(dataSets, this.session, this.modificationTimestamp);
            }
        }
    }

    private static final class DataSetFilter
    implements IDataSetFilter {
        private Set<Long> ids;
        private IIdHolderProvider idHolderProvider;

        DataSetFilter(Collection<TechId> ids, IIdHolderProvider idHolderProvider) {
            this.ids = new LinkedHashSet<Long>(TechId.asLongs(ids));
            this.idHolderProvider = idHolderProvider;
        }

        @Override
        public List<TechId> filter(List<AbstractExternalData> dataSets) {
            ArrayList<TechId> deletableDataSets = new ArrayList<TechId>();
            for (AbstractExternalData dataSet : dataSets) {
                IIdHolder entity = this.idHolderProvider.getIdHolder(dataSet);
                if (entity == null || !this.ids.contains(entity.getId())) continue;
                deletableDataSets.add(new TechId(dataSet.getId()));
            }
            return deletableDataSets;
        }
    }

    private static interface IIdHolderProvider {
        public IIdHolder getIdHolder(AbstractExternalData var1);
    }

    private static interface IDataSetFilter {
        public List<TechId> filter(List<AbstractExternalData> var1);
    }

    private static enum CascadeSampleDependentComponents {
        TRUE,
        FALSE;

    }
}

