/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.business.bo;

import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.common.collection.IKeyExtractor;
import ch.systemsx.cisd.common.collection.TableMap;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.server.business.IRelationshipService;
import ch.systemsx.cisd.openbis.generic.server.business.bo.AbstractBusinessObject;
import ch.systemsx.cisd.openbis.generic.server.business.bo.IVocabularyBO;
import ch.systemsx.cisd.openbis.generic.server.business.bo.InternalVocabularyAuthorization;
import ch.systemsx.cisd.openbis.generic.server.business.bo.util.DataSetTypeWithoutExperimentChecker;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.DynamicPropertyEvaluationOperation;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IEntityPropertyTypeDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.util.KeyExtractorFactory;
import ch.systemsx.cisd.openbis.generic.shared.basic.ICodeHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IVocabularyUpdates;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewVocabulary;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.UpdatedVocabularyTerm;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.VocabularyTerm;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.VocabularyTermBatchUpdateDetails;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.VocabularyTermReplacement;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.EntityPropertyPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.EventPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.EventType;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.IEntityInformationWithPropertiesHolder;
import ch.systemsx.cisd.openbis.generic.shared.dto.IEntityPropertiesHolder;
import ch.systemsx.cisd.openbis.generic.shared.dto.MaterialPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.NewVocabularyTerm;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SamplePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.Session;
import ch.systemsx.cisd.openbis.generic.shared.dto.VocabularyPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.VocabularyTermPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.VocabularyTermWithStats;
import ch.systemsx.cisd.openbis.generic.shared.dto.VocabularyUpdatesDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.properties.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.IManagedPropertyEvaluatorFactory;
import ch.systemsx.cisd.openbis.generic.shared.util.HibernateUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.DataRetrievalFailureException;

public class VocabularyBO
extends AbstractBusinessObject
implements IVocabularyBO {
    private static final String UNSPECIFIED_VOCABULARY = "Unspecified vocabulary";
    private static final int MAX_NUMBER_OF_INVAID_TERMS_IN_ERROR_MESSAGE = 10;
    private VocabularyPE vocabularyPE;
    private Map<Class<? extends IEntityInformationWithPropertiesHolder>, List<Long>> changedEntitiesMap = new HashMap<Class<? extends IEntityInformationWithPropertiesHolder>, List<Long>>();

    public VocabularyBO(IDAOFactory daoFactory, Session session, IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory, DataSetTypeWithoutExperimentChecker dataSetTypeChecker, IRelationshipService relationshipService) {
        super(daoFactory, session, managedPropertyEvaluatorFactory, dataSetTypeChecker, relationshipService);
    }

    @Private
    VocabularyBO(IDAOFactory daoFactory, Session session, VocabularyPE vocabulary, IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory, DataSetTypeWithoutExperimentChecker dataSetTypeChecker, IRelationshipService relationshipService) {
        super(daoFactory, session, managedPropertyEvaluatorFactory, dataSetTypeChecker, relationshipService);
        this.vocabularyPE = vocabulary;
    }

    @Override
    public final void define(NewVocabulary vocabulary) throws UserFailureException {
        assert (vocabulary != null) : "Unspecified vocabulary.";
        this.vocabularyPE = new VocabularyPE();
        this.vocabularyPE.setCode(vocabulary.getCode());
        this.vocabularyPE.setRegistrator(this.findPerson());
        this.vocabularyPE.setDescription(vocabulary.getDescription());
        this.vocabularyPE.setChosenFromList(vocabulary.isChosenFromList());
        this.vocabularyPE.setURLTemplate(vocabulary.getURLTemplate());
        this.vocabularyPE.setManagedInternally(vocabulary.isManagedInternally());
        new InternalVocabularyAuthorization().canCreateVocabulary(this.session, this.vocabularyPE);
        Long currentTermOrdinal = 1L;
        for (VocabularyTerm term : vocabulary.getTerms()) {
            Long l = currentTermOrdinal;
            Long l2 = currentTermOrdinal = Long.valueOf(currentTermOrdinal + 1L);
            this.addTerm(term, l, term.isOfficial());
        }
    }

    private List<VocabularyTermPE> addNewTerms(List<VocabularyTerm> newTerms, Long previousTermOrdinal, boolean isOfficial) {
        Long currentTermOrdinal;
        assert (this.vocabularyPE != null) : "Unspecified vocabulary";
        if (previousTermOrdinal == null) {
            currentTermOrdinal = this.getVocabularyTermDAO().getMaximumOrdinal(this.vocabularyPE) + 1L;
        } else {
            currentTermOrdinal = previousTermOrdinal + 1L;
            this.increaseVocabularyTermOrdinals(currentTermOrdinal, newTerms.size());
        }
        ArrayList<VocabularyTermPE> results = new ArrayList<VocabularyTermPE>();
        for (VocabularyTerm newTerm : newTerms) {
            Long l = currentTermOrdinal;
            Long l2 = currentTermOrdinal = Long.valueOf(currentTermOrdinal + 1L);
            VocabularyTermPE result = this.addTerm(newTerm, l, isOfficial);
            results.add(result);
        }
        return results;
    }

    @Override
    public List<VocabularyTermPE> addNewTerms(List<VocabularyTerm> newTermCodes, Long previousTermOrdinal) {
        return this.addNewTerms(newTermCodes, previousTermOrdinal, true);
    }

    @Override
    public VocabularyTermPE addNewUnofficialTerm(String code, String label, String description, Long previousTermOrdinal) {
        Long currentTermOrdinal;
        assert (this.vocabularyPE != null) : "Unspecified vocabulary";
        assert (code != null) : "Unspecified vocabulary term code";
        if (previousTermOrdinal == null) {
            currentTermOrdinal = this.getVocabularyTermDAO().getMaximumOrdinal(this.vocabularyPE) + 1L;
        } else {
            currentTermOrdinal = previousTermOrdinal + 1L;
            this.increaseVocabularyTermOrdinals(currentTermOrdinal, 1);
        }
        return this.addTerm(code, description, label, currentTermOrdinal, false);
    }

    private void increaseVocabularyTermOrdinals(Long startOrdinal, int increment) {
        this.getVocabularyTermDAO().increaseVocabularyTermOrdinals(this.vocabularyPE, startOrdinal, increment);
    }

    private VocabularyTermPE addTerm(String code, String description, String label, Long ordinal, Boolean isOfficial) {
        PersonPE user;
        VocabularyTermPE existingTermPE = this.vocabularyPE.tryGetVocabularyTerm(code);
        if (existingTermPE != null && (user = this.session.tryGetPerson()) != null && user.isSystemUser() && this.vocabularyPE.isManagedInternally()) {
            existingTermPE.setDescription(description);
            existingTermPE.setLabel(label);
            existingTermPE.setOrdinal(ordinal);
            existingTermPE.setOfficial(isOfficial);
            this.getVocabularyTermDAO().updateRegistrator(existingTermPE, user);
            return existingTermPE;
        }
        VocabularyTermPE vocabularyTermPE = new VocabularyTermPE();
        vocabularyTermPE.setCode(code);
        vocabularyTermPE.setDescription(description);
        if (label != null && label.length() > 0) {
            vocabularyTermPE.setLabel(label);
        }
        vocabularyTermPE.setRegistrator(this.findPerson());
        vocabularyTermPE.setOrdinal(ordinal);
        vocabularyTermPE.setOfficial(isOfficial);
        new InternalVocabularyAuthorization().canCreateTerm(this.session, this.vocabularyPE, vocabularyTermPE);
        this.vocabularyPE.addTerm(vocabularyTermPE);
        return vocabularyTermPE;
    }

    private VocabularyTermPE addTerm(VocabularyTerm term, Long ordinal, Boolean isOfficial) {
        return this.addTerm(term.getCode(), term.getDescription(), term.getLabel(), ordinal, isOfficial);
    }

    @Override
    public void delete(List<VocabularyTerm> termsToBeDeleted, List<VocabularyTermReplacement> termsToBeReplaced) {
        assert (this.vocabularyPE != null) : "Unspecified vocabulary";
        Set<VocabularyTermPE> terms = this.vocabularyPE.getTerms();
        IKeyExtractor keyExtractor = KeyExtractorFactory.createCodeKeyExtractor();
        TableMap termsMap = new TableMap(terms, keyExtractor);
        HashSet remainingTerms = new HashSet(termsMap.keySet());
        for (VocabularyTerm termToBeDeleted : termsToBeDeleted) {
            remainingTerms.remove(termToBeDeleted.getCode());
        }
        for (VocabularyTermReplacement termToBeReplaced : termsToBeReplaced) {
            remainingTerms.remove(termToBeReplaced.getTerm().getCode());
        }
        for (VocabularyTermReplacement termToBeReplaced : termsToBeReplaced) {
            String code = termToBeReplaced.getTerm().getCode();
            Long id = termToBeReplaced.getTerm().getId();
            String replacement = termToBeReplaced.getReplacementCode();
            VocabularyTermPE term = (VocabularyTermPE)termsMap.tryGet((Object)replacement);
            if (term == null || !remainingTerms.contains(replacement)) {
                throw new IllegalArgumentException("Invalid vocabulary replacement because of unknown replacement: " + termToBeReplaced);
            }
            for (EntityKind entityKind : EntityKind.values()) {
                IEntityPropertyTypeDAO dao = this.getEntityPropertyTypeDAO(entityKind);
                List<EntityPropertyPE> properties = dao.listPropertiesByVocabularyTerm(id);
                for (EntityPropertyPE entityProperty : properties) {
                    this.addToChangedEntities(entityProperty.getEntity());
                    entityProperty.setVocabularyTerm(term);
                }
                try {
                    dao.updateProperties(properties);
                }
                catch (DataAccessException e) {
                    VocabularyBO.throwException(e, "Couldn't replace in " + entityKind.toString().toLowerCase() + "s vocabulary term '" + code + "' by '" + term.getCode() + "'.");
                }
            }
        }
        for (VocabularyTerm termToBeDeleted : termsToBeDeleted) {
            this.removeTerm((TableMap<String, VocabularyTermPE>)termsMap, termToBeDeleted.getCode());
        }
        for (VocabularyTermReplacement termToBeReplaced : termsToBeReplaced) {
            this.removeTerm((TableMap<String, VocabularyTermPE>)termsMap, termToBeReplaced.getTerm().getCode());
        }
    }

    private void removeTerm(TableMap<String, VocabularyTermPE> termsMap, String termCode) {
        VocabularyTermPE term = (VocabularyTermPE)termsMap.remove((Object)termCode);
        new InternalVocabularyAuthorization().canDeleteTerm(this.session, this.vocabularyPE, term);
        term.setVocabulary(null);
    }

    @Override
    public void save() throws UserFailureException {
        assert (this.vocabularyPE != null) : "Unspecified vocabulary";
        try {
            StringBuilder builder = new StringBuilder();
            int numberOfInvalidTerms = 0;
            for (VocabularyTermPE term : this.vocabularyPE.getTerms()) {
                try {
                    this.getVocabularyTermDAO().validate(term);
                }
                catch (DataIntegrityViolationException ex) {
                    if (++numberOfInvalidTerms > 10) continue;
                    builder.append('\n').append(ex.getMessage());
                }
            }
            if (builder.length() > 0) {
                builder.insert(0, "Invalid terms:");
                int additionalTerms = numberOfInvalidTerms - 10;
                if (additionalTerms > 0) {
                    builder.append("\n").append("and ").append(additionalTerms);
                    builder.append(" more invalid terms.");
                }
                throw new UserFailureException("Invalid terms:" + builder);
            }
            this.getVocabularyDAO().createOrUpdateVocabulary(this.vocabularyPE);
            this.reindexChangedEntities();
        }
        catch (DataAccessException e) {
            VocabularyBO.throwException(e, String.format("Vocabulary '%s'.", this.vocabularyPE.getCode()));
        }
    }

    @Override
    public void update(IVocabularyUpdates updates) {
        this.loadDataByTechId(TechId.create((IIdHolder)updates));
        if (!this.vocabularyPE.getModificationDate().equals(updates.getModificationDate())) {
            VocabularyBO.throwModifiedEntityException("Vocabulary");
        }
        new InternalVocabularyAuthorization().canUpdateVocabulary(this.session, this.vocabularyPE);
        this.vocabularyPE.setCode(updates.getCode());
        this.vocabularyPE.setDescription(updates.getDescription());
        this.vocabularyPE.setURLTemplate(updates.getURLTemplate());
        this.vocabularyPE.setChosenFromList(updates.isChosenFromList());
        this.validateAndSave();
    }

    @Override
    public void update(VocabularyUpdatesDTO updates) {
        boolean updateNeeded;
        this.loadDataByTechId(TechId.create((IIdHolder)updates));
        boolean bl = updateNeeded = !new EqualsBuilder().append((Object)this.vocabularyPE.getCode(), (Object)updates.getCode()).append((Object)this.vocabularyPE.getDescription(), (Object)updates.getDescription()).append((Object)this.vocabularyPE.getURLTemplate(), (Object)updates.getUrlTemplate()).append(this.vocabularyPE.isManagedInternally(), updates.isManagedInternally()).isEquals();
        if (updateNeeded) {
            new InternalVocabularyAuthorization().canUpdateVocabulary(this.session, this.vocabularyPE);
            this.vocabularyPE.setCode(updates.getCode());
            this.vocabularyPE.setDescription(updates.getDescription());
            this.vocabularyPE.setURLTemplate(updates.getUrlTemplate());
            this.vocabularyPE.setChosenFromList(updates.isChosenFromList());
            this.vocabularyPE.setManagedInternally(updates.isManagedInternally());
            new InternalVocabularyAuthorization().canUpdateVocabulary(this.session, this.vocabularyPE);
        }
        for (NewVocabularyTerm t : updates.getNewTerms()) {
            this.addTerm(t.getCode(), t.getDescription(), t.getLabel(), t.getOrdinal(), true);
        }
        this.validateAndSave();
    }

    private void validateAndSave() {
        this.getVocabularyDAO().validateAndSaveUpdatedEntity(this.vocabularyPE);
    }

    @Override
    public final VocabularyPE getVocabulary() {
        assert (this.vocabularyPE != null) : "Unspecified vocabulary";
        return this.vocabularyPE;
    }

    protected final VocabularyPE tryGetVocabulary() {
        return this.vocabularyPE;
    }

    @Override
    public List<VocabularyTermWithStats> countTermsUsageStatistics() {
        assert (this.vocabularyPE != null) : "Unspecified vocabulary";
        this.enrichWithTerms();
        Set<VocabularyTermPE> terms = this.vocabularyPE.getTerms();
        return this.createTermsWithStatistics(terms);
    }

    private List<VocabularyTermWithStats> createTermsWithStatistics(Set<VocabularyTermPE> terms) {
        ArrayList<VocabularyTermWithStats> results = new ArrayList<VocabularyTermWithStats>();
        for (VocabularyTermPE term : terms) {
            results.add(new VocabularyTermWithStats(term));
        }
        Collections.sort(results);
        for (EntityKind entityKind : EntityKind.values()) {
            this.getEntityPropertyTypeDAO(entityKind).fillTermUsageStatistics(results, this.vocabularyPE);
        }
        return results;
    }

    @Override
    public void load(String vocabularyCode) throws UserFailureException {
        this.tryLoad(vocabularyCode);
        if (this.vocabularyPE == null) {
            throw UserFailureException.fromTemplate((String)"Vocabulary '%s' does not exist.", (Object[])new Object[]{vocabularyCode});
        }
    }

    public void tryLoad(String vocabularyCode) throws UserFailureException {
        this.vocabularyPE = this.getVocabularyDAO().tryFindVocabularyByCode(vocabularyCode);
    }

    @Override
    public void loadDataByTechId(TechId vocabularyId) {
        try {
            this.vocabularyPE = (VocabularyPE)this.getVocabularyDAO().getByTechId(vocabularyId);
        }
        catch (DataRetrievalFailureException exception) {
            throw new UserFailureException(exception.getMessage());
        }
    }

    @Override
    public Set<VocabularyTermPE> enrichWithTerms() {
        HibernateUtils.initialize(this.vocabularyPE.getTerms());
        return this.vocabularyPE.getTerms();
    }

    @Override
    public void deleteByTechId(TechId vocabularyId, String reason) throws UserFailureException {
        this.loadDataByTechId(vocabularyId);
        new InternalVocabularyAuthorization().canDeleteVocabulary(this.session, this.vocabularyPE);
        try {
            this.getVocabularyDAO().delete(this.vocabularyPE);
            this.getEventDAO().persist(VocabularyBO.createDeletionEvent(this.vocabularyPE, this.session.tryGetPerson(), reason));
        }
        catch (DataAccessException ex) {
            VocabularyBO.throwException(ex, String.format("Vocabulary '%s'", this.vocabularyPE.getCode()));
        }
    }

    public static EventPE createDeletionEvent(VocabularyPE vocabularyPE, PersonPE registrator, String reason) {
        EventPE event = new EventPE();
        event.setEventType(EventType.DELETION);
        event.setEntityType(EventPE.EntityType.VOCABULARY);
        event.setIdentifiers(Collections.singletonList(vocabularyPE.getCode()));
        event.setDescription(VocabularyBO.getDeletionDescription(vocabularyPE));
        event.setReason(reason);
        event.setRegistrator(registrator);
        return event;
    }

    private static String getDeletionDescription(VocabularyPE vocabularyPE) {
        return String.format("%s", vocabularyPE.getCode());
    }

    @Override
    public void updateTerms(List<VocabularyTerm> terms) {
        assert (this.vocabularyPE != null) : "Unspecified vocabulary";
        this.checkAllTermsPresent(this.vocabularyPE.getTerms(), terms);
        Map<String, UpdatedVocabularyTerm> newTermsMap = this.prepareUpdateMap(terms);
        this.updateExistingTermsAndRemoveFromMap(newTermsMap);
        this.addNewTerms(newTermsMap);
    }

    private Map<String, UpdatedVocabularyTerm> prepareUpdateMap(List<VocabularyTerm> terms) {
        HashMap<String, UpdatedVocabularyTerm> newTermsMap = new HashMap<String, UpdatedVocabularyTerm>();
        LinkedHashSet<String> multipliedCodes = new LinkedHashSet<String>();
        for (VocabularyTerm v : terms) {
            UpdatedVocabularyTerm previousTermOrNull = newTermsMap.put(v.getCode(), (UpdatedVocabularyTerm)v);
            if (previousTermOrNull == null) continue;
            multipliedCodes.add(v.getCode());
        }
        if (multipliedCodes.size() > 0) {
            throw new UserFailureException(String.format("Mulitiple rows found for terms: [%s]", StringUtils.join(multipliedCodes, (String)",")));
        }
        return newTermsMap;
    }

    private void updateExistingTermsAndRemoveFromMap(Map<String, UpdatedVocabularyTerm> newTermsMap) {
        for (VocabularyTermPE oldTerm : this.vocabularyPE.getTerms()) {
            String code = oldTerm.getCode();
            UpdatedVocabularyTerm update = newTermsMap.get(code);
            VocabularyTermBatchUpdateDetails batchUpdateDetails = update.getBatchUpdateDetails();
            new InternalVocabularyAuthorization().canUpdateTerm(this.session, this.vocabularyPE, oldTerm);
            if (batchUpdateDetails.isDescriptionUpdateRequested()) {
                oldTerm.setDescription(update.getDescription());
            }
            if (batchUpdateDetails.isLabelUpdateRequested()) {
                oldTerm.setLabel(update.getLabel());
            }
            oldTerm.setOrdinal(update.getOrdinal());
            this.makeSystemInternalIfSystemUser(oldTerm);
            newTermsMap.remove(code);
        }
    }

    private void addNewTerms(Map<String, UpdatedVocabularyTerm> newTermsMap) {
        for (VocabularyTerm vocabularyTerm : newTermsMap.values()) {
            this.addTerm(vocabularyTerm, vocabularyTerm.getOrdinal(), vocabularyTerm.isOfficial());
        }
    }

    private void checkAllTermsPresent(Set<VocabularyTermPE> oldTerms, List<VocabularyTerm> newTerms) {
        Collection<String> undetected = this.convert(oldTerms);
        undetected.removeAll(this.convert(newTerms));
        if (undetected.size() > 0) {
            throw new UserFailureException(String.format("Missing vocabulary terms: [%s]", StringUtils.join(undetected, (String)",")));
        }
    }

    private <T extends ICodeHolder> Collection<String> convert(Collection<T> terms) {
        ArrayList<String> list = new ArrayList<String>();
        for (ICodeHolder t : terms) {
            list.add(t.getCode());
        }
        return list;
    }

    private void addToChangedEntities(IEntityPropertiesHolder entity) {
        Class entityClass;
        if (entity instanceof ExperimentPE) {
            entityClass = ExperimentPE.class;
        } else if (entity instanceof SamplePE) {
            entityClass = SamplePE.class;
        } else if (entity instanceof DataPE) {
            entityClass = DataPE.class;
        } else if (entity instanceof MaterialPE) {
            entityClass = MaterialPE.class;
        } else {
            throw new IllegalArgumentException("Unsupported entity class: " + entity.getClass());
        }
        List<Long> ids = this.changedEntitiesMap.get(entityClass);
        if (ids == null) {
            ids = new ArrayList<Long>();
            this.changedEntitiesMap.put(entityClass, ids);
        }
        ids.add(entity.getId());
    }

    private void reindexChangedEntities() {
        if (!this.changedEntitiesMap.isEmpty()) {
            for (Map.Entry<Class<? extends IEntityInformationWithPropertiesHolder>, List<Long>> entry : this.changedEntitiesMap.entrySet()) {
                Class<? extends IEntityInformationWithPropertiesHolder> key = entry.getKey();
                EntityKind entityKind = this.getEntityKind(key.getClass());
                IEntityPropertyTypeDAO entityPropertyTypeDAO = this.getEntityPropertyTypeDAO(entityKind);
                entityPropertyTypeDAO.updateEntityModificationTimestamps(entry.getValue());
                this.getPersistencyResources().getDynamicPropertyEvaluationScheduler().scheduleUpdate(DynamicPropertyEvaluationOperation.evaluate(entry.getKey(), (Collection<Long>)entry.getValue()));
            }
        }
    }

    private EntityKind getEntityKind(Class clazz) {
        if (clazz.isInstance(ExperimentPE.class)) {
            return EntityKind.EXPERIMENT;
        }
        if (clazz.isInstance(SamplePE.class)) {
            return EntityKind.SAMPLE;
        }
        if (clazz.isInstance(DataPE.class)) {
            return EntityKind.DATA_SET;
        }
        if (clazz.isInstance(MaterialPE.class)) {
            return EntityKind.DATA_SET;
        }
        throw new IllegalArgumentException("Unsupported entity class: " + clazz);
    }
}

