/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.business.bo;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.server.business.IRelationshipService;
import ch.systemsx.cisd.openbis.generic.server.business.bo.AbstractBusinessObject;
import ch.systemsx.cisd.openbis.generic.server.business.bo.IVocabularyTermBO;
import ch.systemsx.cisd.openbis.generic.server.business.bo.InternalVocabularyAuthorization;
import ch.systemsx.cisd.openbis.generic.server.business.bo.util.DataSetTypeWithoutExperimentChecker;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IVocabularyTermUpdates;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.VocabularyTerm;
import ch.systemsx.cisd.openbis.generic.shared.dto.Session;
import ch.systemsx.cisd.openbis.generic.shared.dto.VocabularyTermPE;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.IManagedPropertyEvaluatorFactory;
import java.util.List;
import org.springframework.dao.DataRetrievalFailureException;

public final class VocabularyTermBO
extends AbstractBusinessObject
implements IVocabularyTermBO {
    private VocabularyTermPE vocabularyTermPE;

    public VocabularyTermBO(IDAOFactory daoFactory, Session session, IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory, DataSetTypeWithoutExperimentChecker dataSetTypeChecker, IRelationshipService relationshipService) {
        super(daoFactory, session, managedPropertyEvaluatorFactory, dataSetTypeChecker, relationshipService);
    }

    @Override
    public void update(IVocabularyTermUpdates updates) {
        this.loadDataByTechId(TechId.create((IIdHolder)updates));
        if (!this.vocabularyTermPE.getModificationDate().equals(updates.getModificationDate())) {
            VocabularyTermBO.throwModifiedEntityException("Vocabulary term");
        }
        new InternalVocabularyAuthorization().canUpdateTerm(this.session, this.vocabularyTermPE.getVocabulary(), this.vocabularyTermPE);
        this.vocabularyTermPE.setDescription(updates.getDescription());
        this.vocabularyTermPE.setLabel(updates.getLabel());
        if (!this.vocabularyTermPE.getOrdinal().equals(updates.getOrdinal())) {
            this.increaseVocabularyTermOrdinals(updates.getOrdinal());
            this.vocabularyTermPE.setOrdinal(updates.getOrdinal());
        }
        this.makeSystemInternalIfSystemUser(this.vocabularyTermPE);
        this.validateAndSave();
    }

    private void increaseVocabularyTermOrdinals(Long fromOrdinal) {
        this.getVocabularyTermDAO().increaseVocabularyTermOrdinals(this.vocabularyTermPE.getVocabulary(), fromOrdinal, 1);
    }

    private void validateAndSave() {
        this.getVocabularyTermDAO().validateAndSaveUpdatedEntity(this.vocabularyTermPE);
    }

    @Override
    public final VocabularyTermPE getVocabularyTerm() {
        assert (this.vocabularyTermPE != null) : "Vocabulary term not defined.";
        return this.vocabularyTermPE;
    }

    private void loadDataByTechId(TechId vocabularyTermId) {
        try {
            this.vocabularyTermPE = (VocabularyTermPE)this.getVocabularyTermDAO().getByTechId(vocabularyTermId);
        }
        catch (DataRetrievalFailureException exception) {
            throw new UserFailureException(exception.getMessage());
        }
    }

    @Override
    public void makeOfficial(List<VocabularyTerm> termsToBeOfficial) {
        for (VocabularyTerm term : termsToBeOfficial) {
            this.makeOfficial(term);
        }
    }

    private void makeOfficial(VocabularyTerm term) {
        this.loadDataByTechId(TechId.create((IIdHolder)term));
        new InternalVocabularyAuthorization().canUpdateTerm(this.session, this.vocabularyTermPE.getVocabulary(), this.vocabularyTermPE);
        this.vocabularyTermPE.setOfficial(true);
        this.makeSystemInternalIfSystemUser(this.vocabularyTermPE);
        this.validateAndSave();
    }
}

