/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.business.bo.common;

import ch.systemsx.cisd.openbis.generic.server.business.bo.common.AbstractBatchIterator;
import ch.systemsx.cisd.openbis.generic.server.business.bo.common.CodeRecord;
import ch.systemsx.cisd.openbis.generic.server.business.bo.common.GenericEntityPropertyRecord;
import ch.systemsx.cisd.openbis.generic.server.business.bo.common.IEntityPropertiesEnricher;
import ch.systemsx.cisd.openbis.generic.server.business.bo.common.IEntityPropertiesHolderResolver;
import ch.systemsx.cisd.openbis.generic.server.business.bo.common.IEntityPropertySetListingQuery;
import ch.systemsx.cisd.openbis.generic.server.business.bo.common.IPropertyListingQuery;
import ch.systemsx.cisd.openbis.generic.server.business.bo.common.MaterialEntityPropertyRecord;
import ch.systemsx.cisd.openbis.generic.server.business.bo.common.SampleEntityPropertyRecord;
import ch.systemsx.cisd.openbis.generic.server.business.bo.common.VocabularyTermRecord;
import ch.systemsx.cisd.openbis.generic.shared.basic.BasicConstant;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractEntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.GenericEntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IEntityPropertiesHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Material;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MaterialEntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MaterialType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PropertyType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleEntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ScriptType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.VocabularyTerm;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.VocabularyTermEntityProperty;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayList;

public final class EntityPropertiesEnricher
implements IEntityPropertiesEnricher {
    private final IPropertyListingQuery query;
    private final IEntityPropertySetListingQuery propertySetQuery;

    public EntityPropertiesEnricher(IPropertyListingQuery query, IEntityPropertySetListingQuery setQuery) {
        this.query = query;
        this.propertySetQuery = this.createEfficientIterator(setQuery);
    }

    private IEntityPropertySetListingQuery createEfficientIterator(final IEntityPropertySetListingQuery setQuery) {
        return new IEntityPropertySetListingQuery(){
            private static final int BATCH_SIZE = 50000;

            @Override
            public Iterable<GenericEntityPropertyRecord> getEntityPropertyGenericValues(LongSet entityIDs) {
                return new AbstractBatchIterator<GenericEntityPropertyRecord>(entityIDs, 50000){

                    @Override
                    protected Iterable<GenericEntityPropertyRecord> createUnefficientIterator(LongSet ids) {
                        return setQuery.getEntityPropertyGenericValues(ids);
                    }
                };
            }
        };
    }

    @Override
    public void enrich(LongSet entityIDs, IEntityPropertiesHolderResolver entities) {
        ArrayList<GenericEntityPropertyRecord> records = new ArrayList<GenericEntityPropertyRecord>();
        LongOpenHashSet vocaTermIds = new LongOpenHashSet();
        LongOpenHashSet materialIds = new LongOpenHashSet();
        LongOpenHashSet sampleIds = new LongOpenHashSet();
        for (GenericEntityPropertyRecord record : this.propertySetQuery.getEntityPropertyGenericValues(entityIDs)) {
            records.add(record);
            if (record.cvte_id != null) {
                vocaTermIds.add((Object)record.cvte_id);
            }
            if (record.mate_prop_id != null) {
                materialIds.add((Object)record.mate_prop_id);
            }
            if (record.samp_prop_id == null) continue;
            sampleIds.add((Object)record.samp_prop_id);
        }
        Long2ObjectMap<VocabularyTerm> vocabularyTerms = this.getVocabularyTerms((LongSet)vocaTermIds);
        Long2ObjectMap<Material> materials = this.getMaterials((LongSet)materialIds);
        Long2ObjectMap<Sample> samples = this.getSamples((LongSet)sampleIds);
        Long2ObjectMap<PropertyType> propertyTypes = this.getPropertyTypes();
        for (GenericEntityPropertyRecord val : records) {
            AbstractEntityProperty property;
            if (val.cvte_id != null) {
                property = new VocabularyTermEntityProperty();
                property.setVocabularyTerm((VocabularyTerm)vocabularyTerms.get((Object)val.cvte_id));
            } else if (val.mate_prop_id != null) {
                property = new MaterialEntityProperty();
                property.setMaterial((Material)materials.get((Object)val.mate_prop_id));
            } else if (val.samp_prop_id != null) {
                property = new SampleEntityProperty();
                property.setSample((Sample)samples.get((Object)val.samp_prop_id));
            } else {
                property = new GenericEntityProperty();
                property.setValue(val.value);
                property.setScriptable(val.script_id != null);
                property.setDynamic(ScriptType.DYNAMIC_PROPERTY.name().equals(val.script_type));
            }
            property.setPropertyType((PropertyType)propertyTypes.get(val.prty_id));
            property.setOrdinal(val.ordinal);
            IEntityPropertiesHolder entity = entities.get(val.entity_id);
            entity.getProperties().add(property);
        }
    }

    private Long2ObjectMap<PropertyType> getPropertyTypes() {
        PropertyType[] types = this.query.getPropertyTypes();
        Long2ObjectOpenHashMap propertyTypeMap = new Long2ObjectOpenHashMap(types.length);
        for (PropertyType t : types) {
            propertyTypeMap.put(t.getId(), (Object)t);
        }
        propertyTypeMap.trim();
        return propertyTypeMap;
    }

    private Long2ObjectMap<String> getVocabularyURLs() {
        CodeRecord[] vocabURLs = this.query.getVocabularyURLTemplates();
        Long2ObjectOpenHashMap vocabularyURLMap = new Long2ObjectOpenHashMap(vocabURLs.length);
        for (CodeRecord vocabURL : vocabURLs) {
            vocabularyURLMap.put(vocabURL.id, (Object)vocabURL.code);
        }
        vocabularyURLMap.trim();
        return vocabularyURLMap;
    }

    private Long2ObjectMap<MaterialType> getMaterialTypes() {
        CodeRecord[] typeCodes = this.query.getMaterialTypes();
        Long2ObjectOpenHashMap materialTypeMap = new Long2ObjectOpenHashMap(typeCodes.length);
        for (CodeRecord t : typeCodes) {
            MaterialType type = new MaterialType();
            type.setCode(t.code);
            materialTypeMap.put(t.id, (Object)type);
        }
        materialTypeMap.trim();
        return materialTypeMap;
    }

    private Long2ObjectMap<SampleType> getSampleTypes() {
        CodeRecord[] typeCodes = this.query.getSampleTypeIdsAndCode();
        Long2ObjectOpenHashMap sampleTypeMap = new Long2ObjectOpenHashMap(typeCodes.length);
        for (CodeRecord t : typeCodes) {
            SampleType type = new SampleType();
            type.setCode(t.code);
            sampleTypeMap.put(t.id, (Object)type);
        }
        sampleTypeMap.trim();
        return sampleTypeMap;
    }

    private Long2ObjectMap<VocabularyTerm> getVocabularyTerms(LongSet vocaTermIds) {
        Long2ObjectMap<String> vocabularyURLMap = null;
        Long2ObjectOpenHashMap map = new Long2ObjectOpenHashMap();
        if (!vocaTermIds.isEmpty()) {
            for (VocabularyTermRecord record : this.query.getVocabularyTerms(vocaTermIds)) {
                if (vocabularyURLMap == null) {
                    vocabularyURLMap = this.getVocabularyURLs();
                }
                VocabularyTerm vocabularyTerm = new VocabularyTerm();
                vocabularyTerm.setCode(record.code);
                vocabularyTerm.setLabel(record.label);
                vocabularyTerm.setDescription(record.description);
                vocabularyTerm.setOrdinal(record.ordinal);
                String template = (String)vocabularyURLMap.get(record.covo_id);
                if (template != null) {
                    String url = template.replaceAll(BasicConstant.DEPRECATED_VOCABULARY_URL_TEMPLATE_TERM_PATTERN, record.code);
                    url = url.replaceAll(BasicConstant.VOCABULARY_URL_TEMPLATE_TERM_PATTERN, record.code);
                    vocabularyTerm.setUrl(url);
                }
                map.put(record.id, (Object)vocabularyTerm);
            }
        }
        return map;
    }

    private Long2ObjectMap<Material> getMaterials(LongSet materialIds) {
        Long2ObjectMap<MaterialType> materialTypes = null;
        Long2ObjectOpenHashMap map = new Long2ObjectOpenHashMap();
        if (!materialIds.isEmpty()) {
            for (MaterialEntityPropertyRecord record : this.query.getMaterials(materialIds)) {
                if (materialTypes == null) {
                    materialTypes = this.getMaterialTypes();
                }
                Material material = new Material();
                material.setCode(record.code);
                material.setMaterialType((MaterialType)((Object)materialTypes.get(record.maty_id)));
                material.setId(record.id);
                map.put(record.id, (Object)material);
            }
        }
        return map;
    }

    private Long2ObjectMap<Sample> getSamples(LongSet sampleIds) {
        Long2ObjectMap<SampleType> sampleTypes = null;
        Long2ObjectOpenHashMap map = new Long2ObjectOpenHashMap();
        if (!sampleIds.isEmpty()) {
            for (SampleEntityPropertyRecord record : this.query.getBasicSamples(sampleIds)) {
                if (sampleTypes == null) {
                    sampleTypes = this.getSampleTypes();
                }
                Sample sample = new Sample();
                sample.setCode(record.code);
                sample.setSampleType((SampleType)sampleTypes.get(record.saty_id));
                sample.setId(record.id);
                sample.setPermId(record.perm_id);
                map.put(record.id, (Object)sample);
            }
        }
        return map;
    }
}

