/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.business.bo.common;

import ch.systemsx.cisd.common.db.mapper.LongSetMapper;
import ch.systemsx.cisd.openbis.generic.server.business.bo.common.CodeRecord;
import ch.systemsx.cisd.openbis.generic.server.business.bo.common.MaterialEntityPropertyRecord;
import ch.systemsx.cisd.openbis.generic.server.business.bo.common.PropertyTypeDataObjectBinding;
import ch.systemsx.cisd.openbis.generic.server.business.bo.common.SampleEntityPropertyRecord;
import ch.systemsx.cisd.openbis.generic.server.business.bo.common.VocabularyTermRecord;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PropertyType;
import it.unimi.dsi.fastutil.longs.LongSet;
import net.lemnik.eodsql.DataIterator;
import net.lemnik.eodsql.Select;

public interface IPropertyListingQuery {
    public static final int FETCH_SIZE = 1000;

    @Select(sql="select pt.id as pt_id, pt.code as pt_code, dt.code as dt_code,      pt.label as pt_label, pt.is_managed_internally, pt.schema, pt.transformation    from property_types pt join data_types dt on pt.daty_id=dt.id", resultSetBinding=PropertyTypeDataObjectBinding.class)
    public PropertyType[] getPropertyTypes();

    @Select(value="select id, source_uri as code from controlled_vocabularies")
    public CodeRecord[] getVocabularyURLTemplates();

    @Select(value="select id, code from material_types")
    public CodeRecord[] getMaterialTypes();

    @Select(value="select id, code from sample_types")
    public CodeRecord[] getSampleTypeIdsAndCode();

    @Select(sql="SELECT id, covo_id, code, label, ordinal, description FROM controlled_vocabulary_terms WHERE id = any(?{1})", parameterBindings={LongSetMapper.class}, fetchSize=1000)
    public DataIterator<VocabularyTermRecord> getVocabularyTerms(LongSet var1);

    @Select(sql="SELECT id, code, maty_id FROM materials WHERE id = any(?{1})", parameterBindings={LongSetMapper.class}, fetchSize=1000)
    public DataIterator<MaterialEntityPropertyRecord> getMaterials(LongSet var1);

    @Select(sql="SELECT id, code, perm_id, saty_id FROM samples WHERE id = any(?{1})", parameterBindings={LongSetMapper.class}, fetchSize=1000)
    public DataIterator<SampleEntityPropertyRecord> getBasicSamples(LongSet var1);
}

