/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.business.bo.datasetlister;

import ch.rinn.restrictions.Friend;
import ch.systemsx.cisd.common.collection.IKeyExtractor;
import ch.systemsx.cisd.common.collection.TableMap;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.common.types.BooleanOrUnknown;
import ch.systemsx.cisd.openbis.generic.server.business.bo.common.CodeRecord;
import ch.systemsx.cisd.openbis.generic.server.business.bo.common.EntityPropertiesEnricher;
import ch.systemsx.cisd.openbis.generic.server.business.bo.common.GenericEntityPropertyRecord;
import ch.systemsx.cisd.openbis.generic.server.business.bo.common.IEntityPropertiesEnricher;
import ch.systemsx.cisd.openbis.generic.server.business.bo.common.IEntityPropertiesHolderResolver;
import ch.systemsx.cisd.openbis.generic.server.business.bo.common.entity.AbstractLister;
import ch.systemsx.cisd.openbis.generic.server.business.bo.common.entity.SecondaryEntityDAO;
import ch.systemsx.cisd.openbis.generic.server.business.bo.datasetlister.ContentCopyRecord;
import ch.systemsx.cisd.openbis.generic.server.business.bo.datasetlister.DataSetTypeRecord;
import ch.systemsx.cisd.openbis.generic.server.business.bo.datasetlister.DataStoreRecord;
import ch.systemsx.cisd.openbis.generic.server.business.bo.datasetlister.DatasetCodeWithShareIdRecord;
import ch.systemsx.cisd.openbis.generic.server.business.bo.datasetlister.DatasetListerDAO;
import ch.systemsx.cisd.openbis.generic.server.business.bo.datasetlister.DatasetLocationNodeRecord;
import ch.systemsx.cisd.openbis.generic.server.business.bo.datasetlister.DatasetRecord;
import ch.systemsx.cisd.openbis.generic.server.business.bo.datasetlister.DatasetRelationRecord;
import ch.systemsx.cisd.openbis.generic.server.business.bo.datasetlister.ExternalDataManagementSystemRecord;
import ch.systemsx.cisd.openbis.generic.server.business.bo.datasetlister.IDatasetLister;
import ch.systemsx.cisd.openbis.generic.server.business.bo.datasetlister.IDatasetListingQuery;
import ch.systemsx.cisd.openbis.generic.server.business.bo.fetchoptions.common.MetaProjectWithEntityId;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDataDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IRelationshipTypeDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.RelationshipUtils;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.util.KeyExtractorFactory;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.DataSetFetchOption;
import ch.systemsx.cisd.openbis.generic.shared.basic.PermlinkUtilities;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ArchiverDataSetCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Code;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ContainerDataSet;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetArchivingStatus;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataStore;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseInstance;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatasetLocation;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatasetLocationNode;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Deletion;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ExternalDataManagementSystem;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ExternalDataManagementSystemType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.FileFormatType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.FileSystemContentCopy;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IContentCopy;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IDatasetLocationNode;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IEntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.LinkDataSet;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.LinkDataSetLocation;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.LocatorType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Metaproject;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PhysicalDataSet;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TrackingDataSetCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.UrlContentCopy;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataSetShareId;
import ch.systemsx.cisd.openbis.generic.shared.translator.DataStoreTranslator;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.lemnik.eodsql.DataIterator;
import org.apache.commons.lang3.time.DateUtils;

@Friend(toClasses={DatasetRecord.class, DatasetRelationRecord.class, DataStoreRecord.class, DatasetCodeWithShareIdRecord.class, IDatasetListingQuery.class})
public class DatasetLister
extends AbstractLister
implements IDatasetLister {
    public static final EnumSet<DataSetFetchOption> SUPPORTED_DATASET_FETCH_OPTIONS = EnumSet.of(DataSetFetchOption.BASIC, new DataSetFetchOption[]{DataSetFetchOption.EXPERIMENT, DataSetFetchOption.SAMPLE, DataSetFetchOption.PROPERTIES, DataSetFetchOption.CHILDREN, DataSetFetchOption.PARENTS, DataSetFetchOption.PROPERTIES_OF_PARENTS, DataSetFetchOption.PROPERTIES_OF_CHILDREN, DataSetFetchOption.CONTAINER, DataSetFetchOption.CONTAINED, DataSetFetchOption.METAPROJECTS});
    public static final EnumSet<DataSetFetchOption> DEFAULT_DATASET_FETCH_OPTIONS = EnumSet.of(DataSetFetchOption.BASIC, new DataSetFetchOption[]{DataSetFetchOption.EXPERIMENT, DataSetFetchOption.SAMPLE, DataSetFetchOption.PROPERTIES, DataSetFetchOption.PARENTS, DataSetFetchOption.CONTAINER, DataSetFetchOption.CONTAINED, DataSetFetchOption.METAPROJECTS});
    private final String baseIndexURL;
    private final Long userId;
    private final IDatasetListingQuery query;
    private final IEntityPropertiesEnricher propertiesEnricher;
    private final SecondaryEntityDAO referencedEntityDAO;
    private final IDataDAO dataDAO;
    private final Long2ObjectMap<DataSetType> dataSetTypes = new Long2ObjectOpenHashMap();
    private final Long2ObjectMap<DataStore> dataStores = new Long2ObjectOpenHashMap();
    private final Map<Long, FileFormatType> fileFormatTypes = new HashMap<Long, FileFormatType>();
    private final Map<Long, LocatorType> locatorTypes = new HashMap<Long, LocatorType>();
    private final Long2ObjectMap<ExternalDataManagementSystem> externalDataManagementSystems = new Long2ObjectOpenHashMap();
    private IRelationshipTypeDAO relationshipTypeDAO;

    public static IDatasetLister create(IDAOFactory daoFactory, String baseIndexURL, Long userId) {
        DatasetListerDAO dao = DatasetListerDAO.create(daoFactory);
        SecondaryEntityDAO referencedEntityDAO = SecondaryEntityDAO.create(daoFactory);
        IDataDAO dataDAO = daoFactory.getDataDAO();
        IRelationshipTypeDAO relationshipTypeDAO = daoFactory.getRelationshipTypeDAO();
        return DatasetLister.create(dao, referencedEntityDAO, dataDAO, relationshipTypeDAO, baseIndexURL, userId);
    }

    static IDatasetLister create(DatasetListerDAO dao, SecondaryEntityDAO referencedEntityDAO, IDataDAO dataDAO, IRelationshipTypeDAO relationshipTypeDAO, String baseIndexURL, Long userId) {
        IDatasetListingQuery query = dao.getQuery();
        EntityPropertiesEnricher propertiesEnricher = new EntityPropertiesEnricher(query, dao.getPropertySetQuery());
        return new DatasetLister(dao.getDatabaseInstanceId(), dao.getDatabaseInstance(), query, propertiesEnricher, referencedEntityDAO, dataDAO, relationshipTypeDAO, baseIndexURL, userId);
    }

    DatasetLister(long databaseInstanceId, DatabaseInstance databaseInstance, IDatasetListingQuery query, IEntityPropertiesEnricher propertiesEnricher, SecondaryEntityDAO referencedEntityDAO, IDataDAO dataDAO, IRelationshipTypeDAO relationshipTypeDAO, String baseIndexURL, Long userId) {
        super(referencedEntityDAO);
        assert (databaseInstance != null);
        assert (query != null);
        this.query = query;
        this.propertiesEnricher = propertiesEnricher;
        this.referencedEntityDAO = referencedEntityDAO;
        this.dataDAO = dataDAO;
        this.relationshipTypeDAO = relationshipTypeDAO;
        this.baseIndexURL = baseIndexURL;
        this.userId = userId;
    }

    private void checkFetchOptions(EnumSet<DataSetFetchOption> datasetFetchOptions) {
        EnumSet<DataSetFetchOption> work = EnumSet.copyOf(datasetFetchOptions);
        work.removeAll(SUPPORTED_DATASET_FETCH_OPTIONS);
        if (!work.isEmpty()) {
            throw new IllegalArgumentException("Currently only " + SUPPORTED_DATASET_FETCH_OPTIONS + " fetch options are supported by this method");
        }
    }

    @Override
    public List<AbstractExternalData> listBySampleTechId(TechId sampleId, boolean showOnlyDirectlyConnected) {
        if (showOnlyDirectlyConnected) {
            return this.enrichDatasets((Iterable<DatasetRecord>)this.query.getDatasetsForSample(sampleId.getId()));
        }
        LongSet sampleIds = this.referencedEntityDAO.getSampleDescendantIdsAndSelf(sampleId.getId());
        LongOpenHashSet results = new LongOpenHashSet();
        LongOpenHashSet currentLayer = new LongOpenHashSet(this.query.getDatasetIdsForSamples(sampleIds));
        while (!currentLayer.isEmpty()) {
            Long relationshipTypeId = this.getParentChildRelationshipTypeId();
            LongOpenHashSet nextLayer = new LongOpenHashSet(this.query.getDatasetChildrenIds((LongSet)currentLayer, relationshipTypeId));
            results.addAll((LongCollection)currentLayer);
            nextLayer.removeAll((LongCollection)results);
            currentLayer = nextLayer;
        }
        return this.listByDatasetIds((Collection<Long>)results);
    }

    @Override
    public List<AbstractExternalData> listBySampleIds(Collection<Long> sampleIds) {
        return this.listBySampleIds(sampleIds, DEFAULT_DATASET_FETCH_OPTIONS);
    }

    @Override
    public List<AbstractExternalData> listBySampleIds(Collection<Long> sampleIds, EnumSet<DataSetFetchOption> datasetFetchOptions) {
        this.checkFetchOptions(datasetFetchOptions);
        LongOpenHashSet ids = new LongOpenHashSet();
        for (Long id : sampleIds) {
            ids.add((Object)id);
        }
        return this.enrichDatasets((Iterable<DatasetRecord>)this.query.getDatasetsForSamples((LongSet)ids), datasetFetchOptions);
    }

    @Override
    public List<AbstractExternalData> listByExperimentTechId(TechId experimentId, boolean showOnlyDirectlyConnected) {
        DataIterator<DatasetRecord> dataSets;
        if (showOnlyDirectlyConnected) {
            dataSets = this.query.getDatasetsForExperiment(experimentId.getId());
        } else {
            Long relationshipTypeId = this.getParentChildRelationshipTypeId();
            dataSets = this.query.getDataSetsForExperimentAndDescendents(experimentId.getId(), relationshipTypeId);
        }
        return this.enrichDatasets((Iterable<DatasetRecord>)dataSets);
    }

    @Override
    public List<AbstractExternalData> listByMetaprojectId(Long metaprojectId) {
        DataIterator<DatasetRecord> dataSets = this.query.getDatasetsForMetaproject(metaprojectId);
        return this.enrichDatasets((Iterable<DatasetRecord>)dataSets);
    }

    @Override
    public Map<Long, Set<Long>> listParentIds(Collection<Long> dataSetIDs) {
        return this.listParentIds(dataSetIDs, this.getParentChildRelationshipTypeId());
    }

    @Override
    public Map<Long, Set<Long>> listContainerIds(Collection<Long> dataSetIDs) {
        return this.listParentIds(dataSetIDs, this.getContainerComponentRelationshipTypeId());
    }

    private Map<Long, Set<Long>> listParentIds(Collection<Long> dataSetIDs, Long relationshipTypeId) {
        LongOpenHashSet ids = new LongOpenHashSet();
        for (Long id : dataSetIDs) {
            ids.add(id);
        }
        DataIterator<DatasetRelationRecord> relationships = this.query.listParentDataSetIds((LongSet)ids, relationshipTypeId);
        LinkedHashMap<Long, Set<Long>> map = new LinkedHashMap<Long, Set<Long>>();
        for (DatasetRelationRecord relationship : relationships) {
            LinkedHashSet<Long> parents = (LinkedHashSet<Long>)map.get(relationship.data_id_child);
            if (parents == null) {
                parents = new LinkedHashSet<Long>();
                map.put(relationship.data_id_child, parents);
            }
            parents.add(relationship.data_id_parent);
        }
        return map;
    }

    @Override
    public Map<Long, Set<Long>> listChildrenIds(Collection<Long> dataSetIDs) {
        return this.listChilderenIds(dataSetIDs, this.getParentChildRelationshipTypeId());
    }

    @Override
    public Map<Long, Set<Long>> listComponetIds(Collection<Long> dataSetIDs) {
        return this.listChilderenIds(dataSetIDs, this.getContainerComponentRelationshipTypeId());
    }

    private Map<Long, Set<Long>> listChilderenIds(Collection<Long> dataSetIDs, Long relationshipTypeId) {
        LongOpenHashSet ids = new LongOpenHashSet();
        for (Long id : dataSetIDs) {
            ids.add(id);
        }
        DataIterator<DatasetRelationRecord> relationships = this.query.listChildrenDataSetIds((LongSet)ids, relationshipTypeId);
        LinkedHashMap<Long, Set<Long>> map = new LinkedHashMap<Long, Set<Long>>();
        for (DatasetRelationRecord relationship : relationships) {
            LinkedHashSet<Long> children = (LinkedHashSet<Long>)map.get(relationship.data_id_parent);
            if (children == null) {
                children = new LinkedHashSet<Long>();
                map.put(relationship.data_id_parent, children);
            }
            children.add(relationship.data_id_child);
        }
        return map;
    }

    @Override
    public Map<Sample, List<AbstractExternalData>> listAllDataSetsFor(List<Sample> samples) {
        TableMap samplesByID = new TableMap(samples, (IKeyExtractor)new IKeyExtractor<Long, Sample>(){

            public Long getKey(Sample e) {
                return e.getId();
            }
        });
        HashMap<Sample, List<AbstractExternalData>> result = new HashMap<Sample, List<AbstractExternalData>>();
        HashSet<Long> sampleIDs = new HashSet<Long>();
        for (Sample sample : samples) {
            result.put(sample, new ArrayList());
            sampleIDs.add(sample.getId());
        }
        List<AbstractExternalData> rootDataSets = this.listBySampleIds(sampleIDs, EnumSet.of(DataSetFetchOption.BASIC, DataSetFetchOption.PROPERTIES));
        this.addChildren(rootDataSets);
        for (AbstractExternalData dataSet : rootDataSets) {
            Sample sample = (Sample)samplesByID.tryGet((Object)dataSet.getSample().getId());
            assert (sample != null);
            ((List)result.get(sample)).add(dataSet);
        }
        return result;
    }

    private void addChildren(List<AbstractExternalData> dataSets) {
        HashMap<Long, AbstractExternalData> dataSetsByID = new HashMap<Long, AbstractExternalData>();
        for (AbstractExternalData dataSet : dataSets) {
            dataSetsByID.put(dataSet.getId(), dataSet);
        }
        Map<Long, Set<Long>> childrenIDs = this.listChildrenIds(dataSetsByID.keySet());
        Set<Map.Entry<Long, Set<Long>>> entrySet = childrenIDs.entrySet();
        HashMap<Long, HashSet<Long>> child2ParentsMap = new HashMap<Long, HashSet<Long>>();
        HashSet<Long> childIDs = new HashSet<Long>();
        for (Map.Entry<Long, Set<Long>> entry : entrySet) {
            Set<Long> value = entry.getValue();
            Long parentID = entry.getKey();
            for (Long childId : value) {
                childIDs.add(childId);
                HashSet<Long> parents = (HashSet<Long>)child2ParentsMap.get(childId);
                if (parents == null) {
                    parents = new HashSet<Long>(1);
                    child2ParentsMap.put(childId, parents);
                }
                parents.add(parentID);
            }
        }
        if (!childIDs.isEmpty()) {
            List<AbstractExternalData> children = this.listByDatasetIds(childIDs, EnumSet.of(DataSetFetchOption.BASIC, DataSetFetchOption.PROPERTIES));
            for (AbstractExternalData child : children) {
                Set parentIDs = (Set)child2ParentsMap.get(child.getId());
                for (Long parentID : parentIDs) {
                    AbstractExternalData dataSet = (AbstractExternalData)dataSetsByID.get(parentID);
                    Collection<AbstractExternalData> childList = dataSet.getChildren();
                    if (childList == null) {
                        childList = new ArrayList<AbstractExternalData>(1);
                        dataSet.setChildren(childList);
                    }
                    childList.add(child);
                }
            }
            this.addChildren(children);
        }
    }

    @Override
    public List<AbstractExternalData> listByChildTechId(TechId childDatasetId) {
        return this.enrichDatasets((Iterable<DatasetRecord>)this.query.getParentsOf((LongSet)new LongOpenHashSet(Arrays.asList(childDatasetId.getId())), this.getParentChildRelationshipTypeId()));
    }

    @Override
    public List<AbstractExternalData> listByComponentTechId(TechId componentDatasetId) {
        return this.enrichDatasets((Iterable<DatasetRecord>)this.query.getParentsOf((LongSet)new LongOpenHashSet(Arrays.asList(componentDatasetId.getId())), this.getContainerComponentRelationshipTypeId()));
    }

    @Override
    public List<AbstractExternalData> listByContainerTechId(TechId containerDatasetId) {
        return this.enrichDatasets((Iterable<DatasetRecord>)this.query.getChildrenOf((LongSet)new LongOpenHashSet(Arrays.asList(containerDatasetId.getId())), this.getContainerComponentRelationshipTypeId()));
    }

    @Override
    public List<AbstractExternalData> listByParentTechIds(Collection<Long> parentDatasetIds) {
        return this.enrichDatasets((Iterable<DatasetRecord>)this.query.getChildrenOf((LongSet)new LongOpenHashSet(parentDatasetIds), this.getParentChildRelationshipTypeId()));
    }

    @Override
    public List<AbstractExternalData> listByDatasetIds(Collection<Long> datasetIds) {
        return this.listByDatasetIds(datasetIds, DEFAULT_DATASET_FETCH_OPTIONS);
    }

    @Override
    public List<AbstractExternalData> listByDatasetIds(Collection<Long> datasetIds, EnumSet<DataSetFetchOption> datasetFetchOptions) {
        this.checkFetchOptions(datasetFetchOptions);
        return this.enrichDatasets((Iterable<DatasetRecord>)this.query.getDatasets((LongSet)new LongOpenHashSet(datasetIds)), datasetFetchOptions);
    }

    @Override
    public List<AbstractExternalData> listByDatasetCode(Collection<String> datasetCodes) {
        return this.listByDatasetCode(datasetCodes, DEFAULT_DATASET_FETCH_OPTIONS);
    }

    @Override
    public List<AbstractExternalData> listByDatasetCode(Collection<String> datasetCodes, EnumSet<DataSetFetchOption> datasetFetchOptions) {
        this.checkFetchOptions(datasetFetchOptions);
        String[] codes = datasetCodes.toArray(new String[datasetCodes.size()]);
        DataIterator<DatasetRecord> datasets = this.query.getDatasets(codes);
        return this.enrichDatasets((Iterable<DatasetRecord>)datasets, datasetFetchOptions);
    }

    @Override
    public List<AbstractExternalData> listByDataStore(long dataStoreID) {
        return this.listByDataStore(dataStoreID, DEFAULT_DATASET_FETCH_OPTIONS);
    }

    @Override
    public List<AbstractExternalData> listByDataStore(long dataStoreID, EnumSet<DataSetFetchOption> datasetFetchOptions) {
        this.checkFetchOptions(datasetFetchOptions);
        return this.enrichDatasets((Iterable<DatasetRecord>)this.query.getDatasetsByDataStoreId(dataStoreID), datasetFetchOptions);
    }

    @Override
    public List<AbstractExternalData> listByDataStore(long dataStoreID, int limit, EnumSet<DataSetFetchOption> datasetFetchOptions) {
        this.checkFetchOptions(datasetFetchOptions);
        List<AbstractExternalData> data = null;
        int multiplier = 1;
        int lastSize = 0;
        while (data == null || ((AbstractExternalData)data.get(0)).getRegistrationDate().equals(((AbstractExternalData)data.get(data.size() - 1)).getRegistrationDate()) && lastSize != data.size()) {
            lastSize = data != null ? data.size() : 0;
            data = this.orderByDate(this.enrichDatasets(this.handleDegenerateRegistrationTimestamp(this.query.getDatasetsByDataStoreId(dataStoreID, limit * multiplier), dataStoreID), datasetFetchOptions));
            multiplier <<= 1;
        }
        return data;
    }

    @Override
    public List<AbstractExternalData> listByDataStore(long dataStoreID, Date youngerThan, int limit, EnumSet<DataSetFetchOption> datasetFetchOptions) {
        this.checkFetchOptions(datasetFetchOptions);
        return this.orderByDate(this.enrichDatasets(this.handleDegenerateRegistrationTimestamp(this.query.getDatasetsByDataStoreId(dataStoreID, youngerThan, limit), dataStoreID), datasetFetchOptions));
    }

    @Override
    public List<AbstractExternalData> listByArchivingStatus(long dataStoreID, DataSetArchivingStatus archivingStatus, Boolean presentInArchive, EnumSet<DataSetFetchOption> datasetFetchOptions) {
        this.checkFetchOptions(datasetFetchOptions);
        List<DatasetRecord> dataSets = null;
        if (archivingStatus != null) {
            String statusAsString = archivingStatus.name();
            dataSets = presentInArchive != null ? this.query.getDatasetsByDataStoreIdWithArchivingStatusAndPressentInArchive(dataStoreID, statusAsString, presentInArchive) : this.query.getDatasetsByDataStoreIdWithArchivingStatus(dataStoreID, statusAsString);
        } else if (presentInArchive != null) {
            dataSets = this.query.getDatasetsByDataStoreIdWithPressentInArchive(dataStoreID, presentInArchive);
        } else {
            throw new UserFailureException("Neither archiving status nor present in archive flag are specified.");
        }
        return this.orderByCode(this.enrichDatasets(dataSets, datasetFetchOptions));
    }

    @Override
    public List<AbstractExternalData> listByDataStoreWithUnknownSize(long dataStoreID, int limit, String dataSetCodeLowerLimit, EnumSet<DataSetFetchOption> datasetFetchOptions) {
        this.checkFetchOptions(datasetFetchOptions);
        List<DatasetRecord> dataSets = dataSetCodeLowerLimit == null ? this.query.getDatasetsByDataStoreIdWithUnknownSize(dataStoreID, limit) : this.query.getDatasetsByDataStoreIdWithUnknownSize(dataStoreID, limit, dataSetCodeLowerLimit);
        return this.orderByCode(this.enrichDatasets(dataSets, datasetFetchOptions));
    }

    private Iterable<DatasetRecord> handleDegenerateRegistrationTimestamp(List<DatasetRecord> list, long dataStoreID) {
        if (list.isEmpty()) {
            return list;
        }
        Date youngestDate = list.get((int)(list.size() - 1)).registration_timestamp;
        List<DatasetRecord> youngestRecords = this.query.getDatasetsByDataStoreId(dataStoreID, youngestDate);
        if (youngestRecords.size() > 1) {
            Long2ObjectOpenHashMap datasetMap = new Long2ObjectOpenHashMap(list.size() + youngestRecords.size());
            for (DatasetRecord dr : list) {
                datasetMap.put(dr.id, (Object)dr);
            }
            for (DatasetRecord dr : youngestRecords) {
                datasetMap.put(dr.id, (Object)dr);
            }
            return datasetMap.values();
        }
        return list;
    }

    private List<AbstractExternalData> orderByDate(List<AbstractExternalData> list) {
        Collections.sort(list, new Comparator<AbstractExternalData>(){

            @Override
            public int compare(AbstractExternalData o1, AbstractExternalData o2) {
                return o1.getRegistrationDate().compareTo(o2.getRegistrationDate());
            }
        });
        return list;
    }

    private List<AbstractExternalData> orderByCode(List<AbstractExternalData> list) {
        Collections.sort(list, new Comparator<AbstractExternalData>(){

            @Override
            public int compare(AbstractExternalData o1, AbstractExternalData o2) {
                return o1.getCode().compareTo(o2.getCode());
            }
        });
        return list;
    }

    @Override
    public List<DataSetShareId> listAllDataSetShareIdsByDataStore(long dataStoreID) {
        ArrayList<DataSetShareId> results = new ArrayList<DataSetShareId>();
        DataIterator<DatasetCodeWithShareIdRecord> records = this.query.getAllDatasetsWithShareIdsByDataStoreId(dataStoreID);
        for (DatasetCodeWithShareIdRecord record : records) {
            DataSetShareId dataSetShareId = new DataSetShareId();
            dataSetShareId.setDataSetCode(record.code);
            dataSetShareId.setShareId(record.share_id);
            results.add(dataSetShareId);
        }
        return results;
    }

    @Override
    public List<AbstractExternalData> listByTrackingCriteria(TrackingDataSetCriteria criteria) {
        DataIterator<DatasetRecord> dataSets;
        String sampleType = criteria.getConnectedSampleTypeCode();
        long lastSeenDataSetId = criteria.getLastSeenDataSetId();
        if (sampleType == null) {
            dataSets = this.query.getNewDataSets(lastSeenDataSetId);
        } else {
            Long sampleTypeId = this.referencedEntityDAO.getSampleTypeIdForSampleTypeCode(sampleType);
            dataSets = this.query.getNewDataSetsForSampleType(sampleTypeId, lastSeenDataSetId);
        }
        if (criteria.shouldResultBeEnriched()) {
            return this.enrichDatasets((Iterable<DatasetRecord>)dataSets);
        }
        this.loadSmallConnectedTables();
        List<DatasetRecord> datasetRecords = DatasetLister.asList(dataSets);
        Long2ObjectMap<AbstractExternalData> datasetMap = this.createPrimaryDatasets(datasetRecords);
        return DatasetLister.asList(datasetMap);
    }

    @Override
    public List<AbstractExternalData> listByArchiverCriteria(String dataStoreCode, ArchiverDataSetCriteria criteria) {
        this.loadSmallConnectedTables();
        Long dataStoreId = this.extractDataStoreId(dataStoreCode);
        Date lastAccessDate = this.extractLastAccessDate(criteria);
        String dataSetTypeCodeOrNull = criteria.tryGetDataSetTypeCode();
        boolean presentInArchive = criteria.isPresentInArchive();
        if (this.dataDAO.isAccessTimestampEnabled()) {
            if (dataSetTypeCodeOrNull == null) {
                return this.enrichDatasets((Iterable<DatasetRecord>)this.query.getAvailableExtDatasAccessedBefore(dataStoreId, lastAccessDate, presentInArchive));
            }
            Long dataSetTypeId = this.extractDataSetTypeId(dataSetTypeCodeOrNull);
            return this.enrichDatasets((Iterable<DatasetRecord>)this.query.getAvailableExtDatasAccessedBeforeWithDataSetType(dataStoreId, lastAccessDate, presentInArchive, dataSetTypeId));
        }
        if (dataSetTypeCodeOrNull == null) {
            return this.enrichDatasets((Iterable<DatasetRecord>)this.query.getAvailableExtDatasRegisteredBefore(dataStoreId, lastAccessDate, presentInArchive));
        }
        Long dataSetTypeId = this.extractDataSetTypeId(dataSetTypeCodeOrNull);
        return this.enrichDatasets((Iterable<DatasetRecord>)this.query.getAvailableExtDatasRegisteredBeforeWithDataSetType(dataStoreId, lastAccessDate, presentInArchive, dataSetTypeId));
    }

    private Date extractLastAccessDate(ArchiverDataSetCriteria criteria) {
        return DateUtils.addDays((Date)new Date(), (int)(-criteria.getOlderThan()));
    }

    private Long extractDataStoreId(String dataStoreCode) {
        for (Map.Entry entry : this.dataStores.entrySet()) {
            if (!dataStoreCode.equalsIgnoreCase(((DataStore)((Object)entry.getValue())).getCode())) continue;
            return (Long)entry.getKey();
        }
        throw new UserFailureException("Data store '" + dataStoreCode + "' unknown.");
    }

    private Long extractDataSetTypeId(String dataSetTypeCode) {
        for (Map.Entry entry : this.dataSetTypes.entrySet()) {
            if (!dataSetTypeCode.equalsIgnoreCase(((DataSetType)((Object)entry.getValue())).getCode())) continue;
            return (Long)entry.getKey();
        }
        throw new UserFailureException("Data Set type '" + dataSetTypeCode + "' unknown.");
    }

    private List<AbstractExternalData> enrichDatasets(Iterable<DatasetRecord> datasets) {
        return this.enrichDatasets(datasets, DEFAULT_DATASET_FETCH_OPTIONS);
    }

    private List<AbstractExternalData> enrichDatasets(Iterable<DatasetRecord> datasets, EnumSet<DataSetFetchOption> fetchOptions) {
        this.loadSmallConnectedTables();
        List<DatasetRecord> datasetRecords = DatasetLister.asList(datasets);
        Long2ObjectMap<AbstractExternalData> datasetMap = this.createPrimaryDatasets(datasetRecords);
        if (fetchOptions.contains(DataSetFetchOption.EXPERIMENT)) {
            this.enrichWithExperiments(datasetMap);
        }
        if (fetchOptions.contains(DataSetFetchOption.PROPERTIES) || fetchOptions.contains(DataSetFetchOption.PROPERTIES_OF_PROPERTIES)) {
            this.enrichWithProperties(datasetMap);
        }
        if (fetchOptions.contains(DataSetFetchOption.SAMPLE)) {
            this.enrichWithSamples(datasetMap);
        }
        if (fetchOptions.contains(DataSetFetchOption.CONTAINER)) {
            this.enrichWithContainers(datasetMap);
        }
        if (fetchOptions.contains(DataSetFetchOption.CONTAINED)) {
            this.enrichWithContainedDataSets(datasetMap);
        }
        if (fetchOptions.contains(DataSetFetchOption.PARENTS)) {
            this.enrichWithParents(datasetMap, fetchOptions.contains(DataSetFetchOption.PROPERTIES_OF_PARENTS));
        }
        if (fetchOptions.contains(DataSetFetchOption.CHILDREN)) {
            this.enrichWithChildren(datasetMap, fetchOptions.contains(DataSetFetchOption.PROPERTIES_OF_CHILDREN));
        }
        if (this.userId != null && fetchOptions.contains(DataSetFetchOption.METAPROJECTS)) {
            this.enrichWithMetaProjects(datasetMap);
        }
        return DatasetLister.asList(datasetMap);
    }

    private void enrichWithMetaProjects(Long2ObjectMap<AbstractExternalData> datasetMap) {
        LongOpenHashSet set = new LongOpenHashSet();
        set.addAll((LongCollection)datasetMap.keySet());
        for (MetaProjectWithEntityId metaProject : this.query.getMetaprojects((LongSet)set, this.userId)) {
            Metaproject mp = new Metaproject();
            mp.setId(metaProject.id);
            mp.setCreationDate(metaProject.creation_date);
            mp.setDescription(metaProject.description);
            mp.setIdentifier("/" + metaProject.owner_name + "/" + metaProject.name);
            mp.setName(metaProject.name);
            mp.setOwnerId(metaProject.owner_name);
            mp.setPrivate(metaProject.is_private.booleanValue());
            AbstractExternalData data = (AbstractExternalData)datasetMap.get((Object)metaProject.entity_id);
            if (data == null) continue;
            Collection<Metaproject> mps = data.getMetaprojects();
            if (mps == null) {
                mps = new HashSet<Metaproject>();
                data.setMetaprojects(mps);
            }
            mps.add(mp);
        }
    }

    private void enrichWithSamples(Long2ObjectMap<AbstractExternalData> datasetMap) {
        LongSet ids = DatasetLister.extractSampleIds(datasetMap);
        Long2ObjectMap<Sample> samples = this.referencedEntityDAO.getSamples(ids);
        for (AbstractExternalData dataset : datasetMap.values()) {
            if (dataset.getSample() == null) continue;
            long sampleId = dataset.getSample().getId();
            Sample sample = (Sample)samples.get(sampleId);
            dataset.setSample(sample);
        }
    }

    private static LongSet extractSampleIds(Long2ObjectMap<AbstractExternalData> datasetMap) {
        LongOpenHashSet ids = new LongOpenHashSet();
        for (AbstractExternalData dataset : datasetMap.values()) {
            if (dataset.getSample() == null) continue;
            long sampleId = dataset.getSample().getId();
            ids.add(sampleId);
        }
        return ids;
    }

    private static LongSet extractExperimentIds(Long2ObjectMap<AbstractExternalData> datasetMap) {
        LongOpenHashSet ids = new LongOpenHashSet();
        for (AbstractExternalData dataset : datasetMap.values()) {
            Experiment experiment = dataset.getExperiment();
            if (experiment == null) continue;
            ids.add((Object)experiment.getId());
        }
        return ids;
    }

    private void enrichWithExperiments(Long2ObjectMap<AbstractExternalData> datasetMap) {
        LongSet ids = DatasetLister.extractExperimentIds(datasetMap);
        Long2ObjectMap<Experiment> experiments = this.referencedEntityDAO.getExperiments(ids);
        for (AbstractExternalData dataset : datasetMap.values()) {
            if (dataset.getExperiment() == null) continue;
            long experimentId = dataset.getExperiment().getId();
            dataset.setExperiment((Experiment)experiments.get(experimentId));
        }
    }

    private static <T> List<T> asList(Iterable<T> items) {
        ArrayList<T> result = new ArrayList<T>();
        for (T item : items) {
            result.add(item);
        }
        return result;
    }

    private void enrichWithProperties(final Long2ObjectMap<AbstractExternalData> resultMap) {
        this.propertiesEnricher.enrich(resultMap.keySet(), new IEntityPropertiesHolderResolver(){

            @Override
            public AbstractExternalData get(long id) {
                return (AbstractExternalData)resultMap.get(id);
            }
        });
    }

    private void enrichWithParents(Long2ObjectMap<AbstractExternalData> datasetMap, boolean withProperties) {
        Map<Long, Set<Long>> parentIdsMap = this.listParentIds((Collection<Long>)datasetMap.keySet());
        HashSet<Long> allParentIds = new HashSet<Long>();
        for (Set<Long> parentIds : parentIdsMap.values()) {
            allParentIds.addAll(parentIds);
        }
        DataIterator<DatasetRecord> parentIterator = this.query.getDatasets((LongSet)new LongOpenHashSet(allParentIds));
        if (parentIterator != null) {
            Long2ObjectOpenHashMap parentDatasetMap = withProperties ? new Long2ObjectOpenHashMap() : null;
            Long2ObjectMap<AbstractExternalData> parentMap = this.createPrimaryDatasets((Iterable<DatasetRecord>)parentIterator);
            for (Map.Entry<Long, Set<Long>> parentIdsEntry : parentIdsMap.entrySet()) {
                Long datasetId = parentIdsEntry.getKey();
                Set<Long> parentIds = parentIdsEntry.getValue();
                AbstractExternalData dataset = (AbstractExternalData)datasetMap.get((Object)datasetId);
                ArrayList<AbstractExternalData> parents = new ArrayList<AbstractExternalData>();
                for (Long parentId : parentIds) {
                    AbstractExternalData parent = (AbstractExternalData)parentMap.get((Object)parentId);
                    if (parent == null) continue;
                    parents.add(parent);
                    if (parentDatasetMap == null) continue;
                    parentDatasetMap.put((Object)parentId, (Object)parent);
                }
                dataset.setParents(parents);
            }
            if (parentDatasetMap != null) {
                this.enrichWithProperties((Long2ObjectMap<AbstractExternalData>)parentDatasetMap);
            }
        }
    }

    private void enrichWithChildren(Long2ObjectMap<AbstractExternalData> datasetMap, boolean withProperties) {
        Map<Long, Set<Long>> childrenIdsMap = this.listChildrenIds((Collection<Long>)datasetMap.keySet());
        HashSet<Long> allChildrenIds = new HashSet<Long>();
        for (Set<Long> childrenIds : childrenIdsMap.values()) {
            allChildrenIds.addAll(childrenIds);
        }
        DataIterator<DatasetRecord> childrenIterator = this.query.getDatasets((LongSet)new LongOpenHashSet(allChildrenIds));
        if (childrenIterator != null) {
            Long2ObjectOpenHashMap childrenDatasetMap = withProperties ? new Long2ObjectOpenHashMap() : null;
            Long2ObjectMap<AbstractExternalData> childrenMap = this.createPrimaryDatasets((Iterable<DatasetRecord>)childrenIterator);
            for (Map.Entry<Long, Set<Long>> childrenIdsEntry : childrenIdsMap.entrySet()) {
                Long datasetId = childrenIdsEntry.getKey();
                Set<Long> childrenIds = childrenIdsEntry.getValue();
                AbstractExternalData dataset = (AbstractExternalData)datasetMap.get((Object)datasetId);
                ArrayList<AbstractExternalData> children = new ArrayList<AbstractExternalData>();
                for (Long childId : childrenIds) {
                    AbstractExternalData child = (AbstractExternalData)childrenMap.get((Object)childId);
                    if (child == null) continue;
                    children.add(child);
                    if (childrenDatasetMap == null) continue;
                    childrenDatasetMap.put((Object)childId, (Object)child);
                }
                dataset.setChildren(children);
            }
            if (childrenDatasetMap != null) {
                this.enrichWithProperties((Long2ObjectMap<AbstractExternalData>)childrenDatasetMap);
            }
        }
    }

    private void enrichWithContainers(Long2ObjectMap<AbstractExternalData> datasetMap) {
        HashSet<Long> containersNotLoaded = new HashSet<Long>();
        Long relationshipTypeId = this.getContainerComponentRelationshipTypeId();
        List<DatasetRelationRecord> relationshipRecords = DatasetLister.asList(this.query.listParentDataSetIds(datasetMap.keySet(), relationshipTypeId));
        for (DatasetRelationRecord datasetRelationRecord : relationshipRecords) {
            AbstractExternalData component = (AbstractExternalData)datasetMap.get(datasetRelationRecord.data_id_child);
            assert (component != null);
            long containerId = datasetRelationRecord.data_id_parent;
            AbstractExternalData container = (AbstractExternalData)datasetMap.get(containerId);
            if (container != null) {
                this.addContainer(component, container, datasetRelationRecord);
                continue;
            }
            containersNotLoaded.add(containerId);
        }
        if (containersNotLoaded.isEmpty()) {
            return;
        }
        TableMap<Long, AbstractExternalData> containersSecondPassMap = this.loadDataSetsByIds(containersNotLoaded);
        for (DatasetRelationRecord datasetRelationRecord : relationshipRecords) {
            AbstractExternalData component = (AbstractExternalData)datasetMap.get(datasetRelationRecord.data_id_child);
            AbstractExternalData container = (AbstractExternalData)containersSecondPassMap.tryGet((Object)datasetRelationRecord.data_id_parent);
            if (container == null) continue;
            this.addContainer(component, container, datasetRelationRecord);
        }
    }

    private void enrichWithContainedDataSets(Long2ObjectMap<AbstractExternalData> datasetMap) {
        LongOpenHashSet componentsNotLoaded = new LongOpenHashSet();
        Long relationshipTypeId = this.getContainerComponentRelationshipTypeId();
        List<DatasetRelationRecord> relationshipRecords = DatasetLister.asList(this.query.listChildrenDataSetIds(datasetMap.keySet(), relationshipTypeId));
        for (DatasetRelationRecord datasetRelationRecord : relationshipRecords) {
            AbstractExternalData container = (AbstractExternalData)datasetMap.get(datasetRelationRecord.data_id_parent);
            assert (container != null);
            long componentId = datasetRelationRecord.data_id_child;
            AbstractExternalData component = (AbstractExternalData)datasetMap.get(componentId);
            if (component != null) {
                this.addContainer(component, container, datasetRelationRecord);
                continue;
            }
            componentsNotLoaded.add(componentId);
        }
        if (componentsNotLoaded.isEmpty()) {
            return;
        }
        Long2ObjectMap<AbstractExternalData> datasets = this.createPrimaryDatasets((Iterable<DatasetRecord>)this.query.getDatasets((LongSet)componentsNotLoaded));
        for (DatasetRelationRecord datasetRelationRecord : relationshipRecords) {
            AbstractExternalData container = (AbstractExternalData)datasetMap.get(datasetRelationRecord.data_id_parent);
            AbstractExternalData component = (AbstractExternalData)datasets.get(datasetRelationRecord.data_id_child);
            if (component == null) continue;
            this.addContainer(component, container, datasetRelationRecord);
        }
    }

    private TableMap<Long, AbstractExternalData> loadDataSetsByIds(Set<Long> dataSetIds) {
        List<AbstractExternalData> dataSets = this.listByDatasetIds(dataSetIds);
        return new TableMap(dataSets, KeyExtractorFactory.createIdKeyExtractor());
    }

    private void addContainer(AbstractExternalData component, AbstractExternalData container, DatasetRelationRecord record) {
        if (!container.isContainer()) {
            throw new IllegalStateException("Data set '" + container.getCode() + "' is not a container data set.");
        }
        component.addContainer(container.tryGetAsContainerDataSet(), record.ordinal);
    }

    private static <T> List<T> asList(Long2ObjectMap<T> items) {
        ArrayList result = new ArrayList();
        result.addAll(items.values());
        return result;
    }

    private Long2ObjectMap<AbstractExternalData> createPrimaryDatasets(Iterable<DatasetRecord> records) {
        Long2ObjectOpenHashMap datasets = new Long2ObjectOpenHashMap();
        LongOpenHashSet ids = new LongOpenHashSet();
        for (DatasetRecord record : records) {
            ids.add(record.id);
            AbstractExternalData dataSetOrNull = null;
            if (record.data_set_kind.equals(DataSetKind.CONTAINER.name())) {
                dataSetOrNull = this.convertToContainerDataSet(record);
            } else if (record.data_set_kind.equals(DataSetKind.LINK.name())) {
                dataSetOrNull = this.convertToLinkDataSet(record);
            } else if (record.location != null) {
                dataSetOrNull = this.convertToDataSet(record);
            }
            if (dataSetOrNull == null) continue;
            this.enrichWithDeletion(dataSetOrNull, record);
            datasets.put(record.id, (Object)dataSetOrNull);
        }
        return datasets;
    }

    private void enrichWithDeletion(AbstractExternalData dataSet, DatasetRecord row) {
        if (row.del_id != null) {
            Deletion deletion = new Deletion();
            dataSet.setDeletion(deletion);
        }
    }

    private PhysicalDataSet convertToDataSet(DatasetRecord record) {
        PhysicalDataSet dataSet = new PhysicalDataSet();
        this.convertStandardAttributes(dataSet, record);
        dataSet.setComplete(this.resolve(record.is_complete));
        dataSet.setStatus(record.status == null ? null : DataSetArchivingStatus.valueOf(record.status));
        dataSet.setPresentInArchive(record.present_in_archive == null ? false : record.present_in_archive);
        dataSet.setSpeedHint(record.speed_hint == null ? -50 : record.speed_hint);
        dataSet.setShareId(record.share_id);
        dataSet.setFileFormatType(record.ffty_id == null ? null : this.fileFormatTypes.get(record.ffty_id));
        dataSet.setStorageConfirmation(record.storage_confirmation == null ? false : record.storage_confirmation);
        dataSet.setLocation(record.location);
        dataSet.setSize(record.size);
        dataSet.setLocatorType(record.loty_id == null ? null : this.locatorTypes.get(record.loty_id));
        dataSet.setPostRegistered(record.is_post_registered);
        dataSet.setH5Folders(record.h5_folders);
        dataSet.setH5arFolders(record.h5ar_folders);
        dataSet.setArchivingRequested(record.archiving_requested);
        return dataSet;
    }

    private ContainerDataSet convertToContainerDataSet(DatasetRecord record) {
        ContainerDataSet containerDataSet = new ContainerDataSet();
        this.convertStandardAttributes(containerDataSet, record);
        return containerDataSet;
    }

    private LinkDataSet convertToLinkDataSet(DatasetRecord record) {
        LinkDataSet linkDataSet = new LinkDataSet();
        this.convertStandardAttributes(linkDataSet, record);
        List<ContentCopyRecord> copyRecords = this.query.getContentCopiesOf(record.id);
        ArrayList<IContentCopy> copies = new ArrayList<IContentCopy>();
        for (ContentCopyRecord copyRecord : copyRecords) {
            if (copyRecord.external_code != null) {
                copies.add(new UrlContentCopy(copyRecord.edms_code, copyRecord.edms_label, copyRecord.edms_address, copyRecord.external_code));
                linkDataSet.setExternalCode(copyRecord.external_code);
            } else {
                copies.add(new FileSystemContentCopy(copyRecord.edms_code, copyRecord.edms_label, copyRecord.edms_address, copyRecord.edms_address, copyRecord.path, copyRecord.hash, copyRecord.repository_id));
            }
            linkDataSet.setExternalDataManagementSystem((ExternalDataManagementSystem)this.externalDataManagementSystems.get((Object)copyRecord.edms_id));
        }
        linkDataSet.setCopies(copies);
        return linkDataSet;
    }

    private void convertStandardAttributes(AbstractExternalData dataSet, DatasetRecord record) {
        dataSet.setCode(record.code);
        dataSet.setVersion(record.version);
        dataSet.setDataSetType((DataSetType)((Object)this.dataSetTypes.get(record.dsty_id)));
        dataSet.setId(record.id);
        dataSet.setPermlink(PermlinkUtilities.createPermlinkURL(this.baseIndexURL, EntityKind.DATA_SET, record.code));
        dataSet.setId(record.id);
        dataSet.setDataProducerCode(record.data_producer_code);
        dataSet.setDataStore((DataStore)((Object)this.dataStores.get(record.dast_id)));
        dataSet.setDerived(record.is_derived);
        dataSet.setProductionDate(record.production_timestamp);
        dataSet.setRegistrationDate(record.registration_timestamp);
        dataSet.setRegistrator(this.getOrCreateActor(record.pers_id_registerer));
        dataSet.setModificationDate(record.modification_timestamp);
        dataSet.setModifier(this.getOrCreateActor(record.pers_id_modifier));
        if (this.dataDAO.isAccessTimestampEnabled()) {
            dataSet.setAccessTimestamp(record.access_timestamp);
        } else {
            dataSet.setAccessTimestamp(record.modification_timestamp);
        }
        dataSet.setDataSetProperties(new ArrayList<IEntityProperty>());
        if (record.samp_id != null) {
            Sample sample = new Sample();
            sample.setId(record.samp_id);
            dataSet.setSample(sample);
        }
        if (record.expe_id != null) {
            Experiment experiment = new Experiment();
            experiment.setId(record.expe_id);
            dataSet.setExperiment(experiment);
        }
    }

    private Boolean resolve(String booleanRepresentative) {
        if (booleanRepresentative == null) {
            return null;
        }
        return BooleanOrUnknown.tryToResolve((BooleanOrUnknown)BooleanOrUnknown.valueOf((String)booleanRepresentative));
    }

    private void loadSmallConnectedTables() {
        this.dataSetTypes.clear();
        for (DataSetTypeRecord dataSetTypeRecord : this.query.getDatasetTypes()) {
            this.dataSetTypes.put(dataSetTypeRecord.id, (Object)this.createDataSetType(dataSetTypeRecord));
        }
        this.fileFormatTypes.clear();
        for (CodeRecord codeRecord : this.query.getFileFormatTypes()) {
            this.fileFormatTypes.put(codeRecord.id, DatasetLister.createFileFormatType(codeRecord));
        }
        this.locatorTypes.clear();
        for (CodeRecord codeRecord : this.query.getLocatorTypes()) {
            this.locatorTypes.put(codeRecord.id, DatasetLister.createLocatorType(codeRecord));
        }
        this.dataStores.clear();
        for (CodeRecord codeRecord : this.query.getDataStores()) {
            this.dataStores.put(((DataStoreRecord)codeRecord).id, (Object)DatasetLister.createDataStore((DataStoreRecord)codeRecord));
        }
        this.externalDataManagementSystems.clear();
        for (CodeRecord codeRecord : this.query.getExternalDataManagementSystems()) {
            this.externalDataManagementSystems.put(((ExternalDataManagementSystemRecord)codeRecord).id, (Object)DatasetLister.createExternalDataManagementSystem((ExternalDataManagementSystemRecord)codeRecord));
        }
    }

    private static void setCode(Code<?> codeHolder, CodeRecord codeRecord) {
        codeHolder.setCode(codeRecord.code);
    }

    private static DataStore createDataStore(DataStoreRecord codeRecord) {
        DataStore result = new DataStore();
        DatasetLister.setCode(result, codeRecord);
        result.setHostUrl(codeRecord.download_url);
        String downloadUrl = DataStoreTranslator.translateDownloadUrl(codeRecord.download_url);
        result.setDownloadUrl(downloadUrl);
        return result;
    }

    private static ExternalDataManagementSystem createExternalDataManagementSystem(ExternalDataManagementSystemRecord edmsRecord) {
        ExternalDataManagementSystem result = new ExternalDataManagementSystem();
        result.setId(Long.valueOf(edmsRecord.id));
        result.setCode(edmsRecord.code);
        result.setLabel(edmsRecord.label);
        result.setUrlTemplate(edmsRecord.address);
        result.setAddress(edmsRecord.address);
        result.setAddressType(ExternalDataManagementSystemType.valueOf((String)edmsRecord.addressType));
        result.setOpenBIS(ExternalDataManagementSystemType.OPENBIS.equals((Object)result.getAddressType()));
        return result;
    }

    private static LocatorType createLocatorType(CodeRecord codeRecord) {
        LocatorType result = new LocatorType();
        DatasetLister.setCode(result, codeRecord);
        return result;
    }

    private static FileFormatType createFileFormatType(CodeRecord codeRecord) {
        FileFormatType result = new FileFormatType();
        DatasetLister.setCode(result, codeRecord);
        return result;
    }

    private DataSetType createDataSetType(DataSetTypeRecord record) {
        DataSetType result = new DataSetType();
        DatasetLister.setCode(result, record);
        result.setDeletionDisallow(record.deletion_disallow);
        return result;
    }

    @Override
    public Map<Long, GenericEntityPropertyRecord> fetchProperties(List<Long> ids, String propertyTypeCode) {
        DataIterator<GenericEntityPropertyRecord> queryResult = this.query.getEntityPropertyGenericValues((LongSet)new LongOpenHashSet(ids), propertyTypeCode);
        HashMap<Long, GenericEntityPropertyRecord> result = new HashMap<Long, GenericEntityPropertyRecord>();
        for (GenericEntityPropertyRecord record : queryResult) {
            result.put(record.entity_id, record);
        }
        return result;
    }

    @Override
    public IDatasetLocationNode listLocationsByDatasetCode(String datasetCode) {
        List<DatasetLocationNodeRecord> records = this.loadRawLocationData(datasetCode);
        HashMap<Key, DatasetLocationNode> nodeMap = new HashMap<Key, DatasetLocationNode>();
        HashMap<Long, List<DatasetLocationNode>> containerMap = new HashMap<Long, List<DatasetLocationNode>>();
        DatasetLocationNode rootNode = null;
        for (DatasetLocationNodeRecord record : records) {
            DatasetLocation location;
            if (record.link_info == null) {
                location = new DatasetLocation();
                location.setDataSetLocation(record.location);
            } else {
                location = new LinkDataSetLocation();
            }
            location.setDatasetCode(record.code);
            location.setDataStoreCode(record.data_store_code);
            location.setDataStoreUrl(record.data_store_url);
            location.setOrderInContainer(record.ordinal);
            DatasetLocationNode node = new DatasetLocationNode(location);
            if (datasetCode.equals(record.code)) {
                rootNode = node;
            }
            nodeMap.put(new Key(record.container_id, record.id), node);
            if (record.location != null) continue;
            ArrayList<DatasetLocationNode> list = (ArrayList<DatasetLocationNode>)containerMap.get(record.id);
            if (list == null) {
                list = new ArrayList<DatasetLocationNode>();
                containerMap.put(record.id, list);
            }
            list.add(node);
        }
        this.linkContainedData(records, nodeMap, containerMap);
        return rootNode;
    }

    private void linkContainedData(List<DatasetLocationNodeRecord> records, Map<Key, DatasetLocationNode> nodeMap, Map<Long, List<DatasetLocationNode>> containerMap) {
        for (DatasetLocationNodeRecord record : records) {
            Long containerId = record.container_id;
            Long componentId = record.id;
            DatasetLocationNode componentNode = nodeMap.get(new Key(containerId, componentId));
            if (containerId == null) continue;
            List<DatasetLocationNode> containers = containerMap.get(containerId);
            for (DatasetLocationNode containerNode : containers) {
                containerNode.addContained(componentNode);
            }
        }
    }

    private List<DatasetLocationNodeRecord> loadRawLocationData(String datasetCode) {
        Long relationshipTypeId = this.getContainerComponentRelationshipTypeId();
        DataIterator<DatasetLocationNodeRecord> queryResult = this.query.listLocationsByDatasetCode(datasetCode, relationshipTypeId);
        ArrayList<DatasetLocationNodeRecord> result = new ArrayList<DatasetLocationNodeRecord>();
        for (DatasetLocationNodeRecord datasetLocationNodeRecord : queryResult) {
            result.add(datasetLocationNodeRecord);
        }
        return result;
    }

    private Long getParentChildRelationshipTypeId() {
        return RelationshipUtils.getParentChildRelationshipType(this.relationshipTypeDAO).getId();
    }

    private Long getContainerComponentRelationshipTypeId() {
        return RelationshipUtils.getContainerComponentRelationshipType(this.relationshipTypeDAO).getId();
    }

    @Override
    public List<String> listContainedCodes(String datasetCode) {
        LinkedList<String> result = new LinkedList<String>();
        Long relationshipTypeId = this.getContainerComponentRelationshipTypeId();
        DataIterator<String> queryResult = this.query.getContainedDataSetCodes(datasetCode, relationshipTypeId);
        for (String containedCode : queryResult) {
            result.add(containedCode);
        }
        queryResult.close();
        return result;
    }

    @Override
    public List<AbstractExternalData> listByMetaprojectIdAndArchivalState(Long metaprojectId, boolean isArchived) {
        DataIterator<DatasetRecord> dataSets = this.query.getDatasetsForMetaprojectAndArchivalState(metaprojectId, isArchived);
        return this.enrichDatasets((Iterable<DatasetRecord>)dataSets);
    }

    private static final class Key {
        private Long componentId;
        private Long containerId;

        Key(Long containerId, Long componentId) {
            this.containerId = containerId;
            this.componentId = componentId;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Key)) {
                return false;
            }
            Key key = (Key)obj;
            return this.isEqual(this.containerId, key.containerId) && this.isEqual(this.componentId, key.componentId);
        }

        private boolean isEqual(Long n1OrNull, Long n2OrNull) {
            return n1OrNull == null ? n1OrNull == n2OrNull : n1OrNull.equals(n2OrNull);
        }

        public int hashCode() {
            return (this.containerId == null ? 0 : this.containerId.intValue()) * 37 + (this.componentId == null ? 0 : this.componentId.intValue());
        }
    }
}

