/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.business.bo.datasetlister;

import ch.rinn.restrictions.Friend;
import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.openbis.generic.server.business.bo.common.AbstractDAO;
import ch.systemsx.cisd.openbis.generic.server.business.bo.common.GenericEntityPropertyRecord;
import ch.systemsx.cisd.openbis.generic.server.business.bo.common.IEntityPropertySetListingQuery;
import ch.systemsx.cisd.openbis.generic.server.business.bo.datasetlister.IDatasetListingQuery;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import it.unimi.dsi.fastutil.longs.LongSet;
import net.lemnik.eodsql.QueryTool;

@Friend(toClasses={IDatasetListingQuery.class})
public final class DatasetListerDAO
extends AbstractDAO {
    private final IDatasetListingQuery query;
    private final IEntityPropertySetListingQuery propertySetQuery;

    public static DatasetListerDAO create(IDAOFactory daoFactory) {
        IDatasetListingQuery query = (IDatasetListingQuery)QueryTool.getManagedQuery(IDatasetListingQuery.class);
        return DatasetListerDAO.create(daoFactory, query);
    }

    @Private
    static DatasetListerDAO create(IDAOFactory daoFactory, IDatasetListingQuery query) {
        return new DatasetListerDAO(query);
    }

    DatasetListerDAO(IDatasetListingQuery query) {
        this.query = query;
        this.propertySetQuery = DatasetListerDAO.asEntityPropertySetListingQuery(query);
    }

    IDatasetListingQuery getQuery() {
        return this.query;
    }

    IEntityPropertySetListingQuery getPropertySetQuery() {
        return this.propertySetQuery;
    }

    private static IEntityPropertySetListingQuery asEntityPropertySetListingQuery(final IDatasetListingQuery query) {
        return new IEntityPropertySetListingQuery(){

            @Override
            public Iterable<GenericEntityPropertyRecord> getEntityPropertyGenericValues(LongSet entityIDs) {
                return query.getEntityPropertyGenericValues(entityIDs);
            }
        };
    }
}

