/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.business.bo.datasetlister;

import ch.rinn.restrictions.Friend;
import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.common.db.mapper.LongSetMapper;
import ch.systemsx.cisd.common.db.mapper.StringArrayMapper;
import ch.systemsx.cisd.openbis.generic.server.business.bo.common.CodeRecord;
import ch.systemsx.cisd.openbis.generic.server.business.bo.common.GenericEntityPropertyRecord;
import ch.systemsx.cisd.openbis.generic.server.business.bo.common.IPropertyListingQuery;
import ch.systemsx.cisd.openbis.generic.server.business.bo.datasetlister.ContentCopyRecord;
import ch.systemsx.cisd.openbis.generic.server.business.bo.datasetlister.DataSetTypeRecord;
import ch.systemsx.cisd.openbis.generic.server.business.bo.datasetlister.DataStoreRecord;
import ch.systemsx.cisd.openbis.generic.server.business.bo.datasetlister.DatasetCodeWithShareIdRecord;
import ch.systemsx.cisd.openbis.generic.server.business.bo.datasetlister.DatasetLocationNodeRecord;
import ch.systemsx.cisd.openbis.generic.server.business.bo.datasetlister.DatasetRecord;
import ch.systemsx.cisd.openbis.generic.server.business.bo.datasetlister.DatasetRelationRecord;
import ch.systemsx.cisd.openbis.generic.server.business.bo.datasetlister.ExternalDataManagementSystemRecord;
import ch.systemsx.cisd.openbis.generic.server.business.bo.fetchoptions.common.MetaProjectWithEntityId;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.Date;
import java.util.List;
import net.lemnik.eodsql.BaseQuery;
import net.lemnik.eodsql.DataIterator;
import net.lemnik.eodsql.Select;
import net.lemnik.eodsql.TypeMapper;

@Private
@Friend(toClasses={DataStoreRecord.class})
public interface IDatasetListingQuery
extends BaseQuery,
IPropertyListingQuery {
    public static final String EXTERNAL_DATA_COLUMNS = "external_data.location, external_data.ffty_id, external_data.loty_id, external_data.cvte_id_stor_fmt, external_data.is_complete, external_data.cvte_id_store, external_data.status, external_data.share_id, external_data.size, external_data.present_in_archive, external_data.speed_hint, external_data.storage_confirmation, external_data.h5_folders, external_data.h5ar_folders, external_data.archiving_requested";
    public static final String SELECT_ALL = "select data.*, external_data.location, external_data.ffty_id, external_data.loty_id, external_data.cvte_id_stor_fmt, external_data.is_complete, external_data.cvte_id_store, external_data.status, external_data.share_id, external_data.size, external_data.present_in_archive, external_data.speed_hint, external_data.storage_confirmation, external_data.h5_folders, external_data.h5ar_folders, external_data.archiving_requested, link_data.id as link_data_id, content_copies.external_code, content_copies.edms_id, prdq.id IS NULL as is_post_registered from data left outer join external_data on data.id = external_data.id left outer join link_data on data.id = link_data.id left outer join post_registration_dataset_queue prdq on data.id = prdq.ds_id left outer join content_copies on data.id = content_copies.data_id";
    public static final String SELECT_ALL_EXTERNAL_DATAS = "select data.*, external_data.location, external_data.ffty_id, external_data.loty_id, external_data.cvte_id_stor_fmt, external_data.is_complete, external_data.cvte_id_store, external_data.status, external_data.share_id, external_data.size, external_data.present_in_archive, external_data.speed_hint, external_data.storage_confirmation, external_data.h5_folders, external_data.h5ar_folders, external_data.archiving_requested, prdq.id IS NULL as is_post_registered from data join external_data on data.id = external_data.id left outer join post_registration_dataset_queue prdq on data.id = prdq.ds_id ";
    public static final String ED_COLUMNS = "ed.id as external_data_id, ed.location, ed.ffty_id, ed.loty_id, ed.cvte_id_stor_fmt, ed.is_complete, ed.cvte_id_store, ed.status, ed.share_id, ed.size, ed.present_in_archive, ed.speed_hint, ed.storage_confirmation, ed.h5_folders, ed.h5ar_folders, ed.archiving_requested";

    @Select(sql="select data.*, external_data.location, external_data.ffty_id, external_data.loty_id, external_data.cvte_id_stor_fmt, external_data.is_complete, external_data.cvte_id_store, external_data.status, external_data.share_id, external_data.size, external_data.present_in_archive, external_data.speed_hint, external_data.storage_confirmation, external_data.h5_folders, external_data.h5ar_folders, external_data.archiving_requested, link_data.id as link_data_id, content_copies.external_code, content_copies.edms_id, prdq.id IS NULL as is_post_registered from data left outer join external_data on data.id = external_data.id left outer join link_data on data.id = link_data.id left outer join post_registration_dataset_queue prdq on data.id = prdq.ds_id left outer join content_copies on data.id = content_copies.data_id WHERE data.expe_id = ?{1}")
    public DataIterator<DatasetRecord> getDatasetsForExperiment(long var1);

    @Select(sql="select data.*, external_data.location, external_data.ffty_id, external_data.loty_id, external_data.cvte_id_stor_fmt, external_data.is_complete, external_data.cvte_id_store, external_data.status, external_data.share_id, external_data.size, external_data.present_in_archive, external_data.speed_hint, external_data.storage_confirmation, external_data.h5_folders, external_data.h5ar_folders, external_data.archiving_requested, link_data.id as link_data_id, content_copies.external_code, content_copies.edms_id, prdq.id IS NULL as is_post_registered from data left outer join external_data on data.id = external_data.id left outer join link_data on data.id = link_data.id left outer join post_registration_dataset_queue prdq on data.id = prdq.ds_id left outer join content_copies on data.id = content_copies.data_id JOIN metaproject_assignments ma ON data.id=ma.data_id WHERE ma.mepr_id = ?{1}")
    public DataIterator<DatasetRecord> getDatasetsForMetaproject(long var1);

    @Select(sql="select data.*, external_data.location, external_data.ffty_id, external_data.loty_id, external_data.cvte_id_stor_fmt, external_data.is_complete, external_data.cvte_id_store, external_data.status, external_data.share_id, external_data.size, external_data.present_in_archive, external_data.speed_hint, external_data.storage_confirmation, external_data.h5_folders, external_data.h5ar_folders, external_data.archiving_requested, link_data.id as link_data_id, content_copies.external_code, content_copies.edms_id, prdq.id IS NULL as is_post_registered from data left outer join external_data on data.id = external_data.id left outer join link_data on data.id = link_data.id left outer join post_registration_dataset_queue prdq on data.id = prdq.ds_id left outer join content_copies on data.id = content_copies.data_id JOIN metaproject_assignments ma ON data.id=ma.data_id WHERE ma.mepr_id = ?{1} AND external_data.present_in_archive = ?{2}")
    public DataIterator<DatasetRecord> getDatasetsForMetaprojectAndArchivalState(long var1, boolean var3);

    @Select(sql="with recursive connected_data as ( select d.*,ed.id as external_data_id, ed.location, ed.ffty_id, ed.loty_id, ed.cvte_id_stor_fmt, ed.is_complete, ed.cvte_id_store, ed.status, ed.share_id, ed.size, ed.present_in_archive, ed.speed_hint, ed.storage_confirmation, ed.h5_folders, ed.h5ar_folders, ed.archiving_requested, ld.id as link_data_id, prdq.id IS NULL as is_post_registered from data as d left outer join external_data as ed on d.id = ed.id left outer join link_data as ld on d.id = ld.id left outer join post_registration_dataset_queue prdq on d.id = prdq.ds_id where expe_id = ?{1}    or samp_id in (with recursive connected_samples as                     (select id from samples where expe_id = ?{1}                      union all select s.id from connected_samples as cs                                        inner join sample_relationships as sr on sr.sample_id_parent = cs.id                                        left join samples as s on s.id = sr.sample_id_child)                   select * from connected_samples) union all select d.*, ed.id as external_data_id, ed.location, ed.ffty_id, ed.loty_id, ed.cvte_id_stor_fmt, ed.is_complete, ed.cvte_id_store, ed.status, ed.share_id, ed.size, ed.present_in_archive, ed.speed_hint, ed.storage_confirmation, ed.h5_folders, ed.h5ar_folders, ed.archiving_requested,  ld.id, prdq.id IS NULL as is_post_registered from connected_data as cd                        inner join data_set_relationships as dr on dr.data_id_parent = cd.id                        left join data as d on d.id = dr.data_id_child                        left outer join external_data as ed on d.id = ed.id                       left outer join link_data as ld on d.id = ld.id left outer join post_registration_dataset_queue prdq on d.id = prdq.ds_id where dr.relationship_id = ?{2}) select * from connected_data")
    public DataIterator<DatasetRecord> getDataSetsForExperimentAndDescendents(long var1, long var3);

    @Select(sql="select data.*, external_data.location, external_data.ffty_id, external_data.loty_id, external_data.cvte_id_stor_fmt, external_data.is_complete, external_data.cvte_id_store, external_data.status, external_data.share_id, external_data.size, external_data.present_in_archive, external_data.speed_hint, external_data.storage_confirmation, external_data.h5_folders, external_data.h5ar_folders, external_data.archiving_requested, link_data.id as link_data_id, content_copies.external_code, content_copies.edms_id, prdq.id IS NULL as is_post_registered from data left outer join external_data on data.id = external_data.id left outer join link_data on data.id = link_data.id left outer join post_registration_dataset_queue prdq on data.id = prdq.ds_id left outer join content_copies on data.id = content_copies.data_id WHERE data.samp_id=?{1}", fetchSize=1000)
    public DataIterator<DatasetRecord> getDatasetsForSample(long var1);

    @Select(sql="select data.*, external_data.location, external_data.ffty_id, external_data.loty_id, external_data.cvte_id_stor_fmt, external_data.is_complete, external_data.cvte_id_store, external_data.status, external_data.share_id, external_data.size, external_data.present_in_archive, external_data.speed_hint, external_data.storage_confirmation, external_data.h5_folders, external_data.h5ar_folders, external_data.archiving_requested, link_data.id as link_data_id, content_copies.external_code, content_copies.edms_id, prdq.id IS NULL as is_post_registered from data left outer join external_data on data.id = external_data.id left outer join link_data on data.id = link_data.id left outer join post_registration_dataset_queue prdq on data.id = prdq.ds_id left outer join content_copies on data.id = content_copies.data_id WHERE data.samp_id = any(?{1})", parameterBindings={LongSetMapper.class}, fetchSize=1000)
    public DataIterator<DatasetRecord> getDatasetsForSamples(LongSet var1);

    @Select(sql="select data.*, external_data.location, external_data.ffty_id, external_data.loty_id, external_data.cvte_id_stor_fmt, external_data.is_complete, external_data.cvte_id_store, external_data.status, external_data.share_id, external_data.size, external_data.present_in_archive, external_data.speed_hint, external_data.storage_confirmation, external_data.h5_folders, external_data.h5ar_folders, external_data.archiving_requested, link_data.id as link_data_id, content_copies.external_code, content_copies.edms_id, prdq.id IS NULL as is_post_registered from data left outer join external_data on data.id = external_data.id left outer join link_data on data.id = link_data.id left outer join post_registration_dataset_queue prdq on data.id = prdq.ds_id left outer join content_copies on data.id = content_copies.data_id WHERE data.id > ?{1}", fetchSize=1000)
    public DataIterator<DatasetRecord> getNewDataSets(long var1);

    @Select(sql="select data.*, external_data.location, external_data.ffty_id, external_data.loty_id, external_data.cvte_id_stor_fmt, external_data.is_complete, external_data.cvte_id_store, external_data.status, external_data.share_id, external_data.size, external_data.present_in_archive, external_data.speed_hint, external_data.storage_confirmation, external_data.h5_folders, external_data.h5ar_folders, external_data.archiving_requested, link_data.id as link_data_id, content_copies.external_code, content_copies.edms_id, prdq.id IS NULL as is_post_registered from data left outer join external_data on data.id = external_data.id left outer join link_data on data.id = link_data.id left outer join post_registration_dataset_queue prdq on data.id = prdq.ds_id left outer join content_copies on data.id = content_copies.data_id WHERE data.id > ?{2} AND data.samp_id IN (SELECT id FROM samples s WHERE s.saty_id=?{1})", fetchSize=1000)
    public DataIterator<DatasetRecord> getNewDataSetsForSampleType(long var1, long var3);

    @Select(sql="select data.*, external_data.location, external_data.ffty_id, external_data.loty_id, external_data.cvte_id_stor_fmt, external_data.is_complete, external_data.cvte_id_store, external_data.status, external_data.share_id, external_data.size, external_data.present_in_archive, external_data.speed_hint, external_data.storage_confirmation, external_data.h5_folders, external_data.h5ar_folders, external_data.archiving_requested, prdq.id IS NULL as is_post_registered from data join external_data on data.id = external_data.id left outer join post_registration_dataset_queue prdq on data.id = prdq.ds_id     WHERE data.dast_id = ?{1} AND external_data.status = 'AVAILABLE'     AND data.registration_timestamp < ?{2} AND external_data.present_in_archive=?{3}", fetchSize=1000)
    public DataIterator<DatasetRecord> getAvailableExtDatasRegisteredBefore(long var1, Date var3, boolean var4);

    @Select(sql="select data.*, external_data.location, external_data.ffty_id, external_data.loty_id, external_data.cvte_id_stor_fmt, external_data.is_complete, external_data.cvte_id_store, external_data.status, external_data.share_id, external_data.size, external_data.present_in_archive, external_data.speed_hint, external_data.storage_confirmation, external_data.h5_folders, external_data.h5ar_folders, external_data.archiving_requested, prdq.id IS NULL as is_post_registered from data join external_data on data.id = external_data.id left outer join post_registration_dataset_queue prdq on data.id = prdq.ds_id     WHERE data.dast_id = ?{1} AND external_data.status = 'AVAILABLE'     AND data.registration_timestamp < ?{2} AND external_data.present_in_archive=?{3}     AND data.dsty_id = ?{4}", fetchSize=1000)
    public DataIterator<DatasetRecord> getAvailableExtDatasRegisteredBeforeWithDataSetType(long var1, Date var3, boolean var4, long var5);

    @Select(sql="select data.*, external_data.location, external_data.ffty_id, external_data.loty_id, external_data.cvte_id_stor_fmt, external_data.is_complete, external_data.cvte_id_store, external_data.status, external_data.share_id, external_data.size, external_data.present_in_archive, external_data.speed_hint, external_data.storage_confirmation, external_data.h5_folders, external_data.h5ar_folders, external_data.archiving_requested, prdq.id IS NULL as is_post_registered from data join external_data on data.id = external_data.id left outer join post_registration_dataset_queue prdq on data.id = prdq.ds_id     WHERE data.dast_id = ?{1} AND external_data.status = 'AVAILABLE'     AND data.access_timestamp < ?{2} AND external_data.present_in_archive=?{3}", fetchSize=1000)
    public DataIterator<DatasetRecord> getAvailableExtDatasAccessedBefore(long var1, Date var3, boolean var4);

    @Select(sql="select data.*, external_data.location, external_data.ffty_id, external_data.loty_id, external_data.cvte_id_stor_fmt, external_data.is_complete, external_data.cvte_id_store, external_data.status, external_data.share_id, external_data.size, external_data.present_in_archive, external_data.speed_hint, external_data.storage_confirmation, external_data.h5_folders, external_data.h5ar_folders, external_data.archiving_requested, prdq.id IS NULL as is_post_registered from data join external_data on data.id = external_data.id left outer join post_registration_dataset_queue prdq on data.id = prdq.ds_id     WHERE data.dast_id = ?{1} AND external_data.status = 'AVAILABLE'     AND data.access_timestamp < ?{2} AND external_data.present_in_archive=?{3}     AND data.dsty_id = ?{4}", fetchSize=1000)
    public DataIterator<DatasetRecord> getAvailableExtDatasAccessedBeforeWithDataSetType(long var1, Date var3, boolean var4, long var5);

    @Select(sql="select id from data where data.samp_id=?{1}", fetchSize=1000)
    public DataIterator<Long> getDatasetIdsForSample(long var1);

    @Select(sql="select id from data where data.samp_id = any(?{1})", parameterBindings={LongSetMapper.class}, fetchSize=1000)
    public DataIterator<Long> getDatasetIdsForSamples(LongSet var1);

    @Select(sql="select * from data_set_relationships where data_id_child = any(?{1}) and relationship_id = ?{2}", parameterBindings={LongSetMapper.class}, fetchSize=1000)
    public DataIterator<DatasetRelationRecord> listParentDataSetIds(LongSet var1, long var2);

    @Select(sql="select * from data_set_relationships where data_id_parent = any(?{1}) and relationship_id = ?{2}", parameterBindings={LongSetMapper.class}, fetchSize=1000)
    public DataIterator<DatasetRelationRecord> listChildrenDataSetIds(LongSet var1, long var2);

    @Select(sql="select data.*, external_data.location, external_data.ffty_id, external_data.loty_id, external_data.cvte_id_stor_fmt, external_data.is_complete, external_data.cvte_id_store, external_data.status, external_data.share_id, external_data.size, external_data.present_in_archive, external_data.speed_hint, external_data.storage_confirmation, external_data.h5_folders, external_data.h5ar_folders, external_data.archiving_requested, link_data.id as link_data_id, content_copies.external_code, content_copies.edms_id, prdq.id IS NULL as is_post_registered from data left outer join external_data on data.id = external_data.id left outer join link_data on data.id = link_data.id left outer join post_registration_dataset_queue prdq on data.id = prdq.ds_id left outer join content_copies on data.id = content_copies.data_id where data.id in (select data_id_child from data_set_relationships where data_id_parent = any(?{1}) and relationship_id = ?{2})", parameterBindings={LongSetMapper.class}, fetchSize=1000)
    public DataIterator<DatasetRecord> getChildrenOf(LongSet var1, Long var2);

    @Select(sql="select data.*, external_data.location, external_data.ffty_id, external_data.loty_id, external_data.cvte_id_stor_fmt, external_data.is_complete, external_data.cvte_id_store, external_data.status, external_data.share_id, external_data.size, external_data.present_in_archive, external_data.speed_hint, external_data.storage_confirmation, external_data.h5_folders, external_data.h5ar_folders, external_data.archiving_requested, link_data.id as link_data_id, content_copies.external_code, content_copies.edms_id, prdq.id IS NULL as is_post_registered from data left outer join external_data on data.id = external_data.id left outer join link_data on data.id = link_data.id left outer join post_registration_dataset_queue prdq on data.id = prdq.ds_id left outer join content_copies on data.id = content_copies.data_id where data.id in (select data_id_parent from data_set_relationships where data_id_child = any(?{1}) and relationship_id = ?{2})", parameterBindings={LongSetMapper.class}, fetchSize=1000)
    public DataIterator<DatasetRecord> getParentsOf(LongSet var1, Long var2);

    @Select(value="select data.*, external_data.location, external_data.ffty_id, external_data.loty_id, external_data.cvte_id_stor_fmt, external_data.is_complete, external_data.cvte_id_store, external_data.status, external_data.share_id, external_data.size, external_data.present_in_archive, external_data.speed_hint, external_data.storage_confirmation, external_data.h5_folders, external_data.h5ar_folders, external_data.archiving_requested, link_data.id as link_data_id, content_copies.external_code, content_copies.edms_id, prdq.id IS NULL as is_post_registered from data left outer join external_data on data.id = external_data.id left outer join link_data on data.id = link_data.id left outer join post_registration_dataset_queue prdq on data.id = prdq.ds_id left outer join content_copies on data.id = content_copies.data_id where data.id=?{1}")
    public DatasetRecord getDataset(long var1);

    @Select(sql="select data.*, external_data.location, external_data.ffty_id, external_data.loty_id, external_data.cvte_id_stor_fmt, external_data.is_complete, external_data.cvte_id_store, external_data.status, external_data.share_id, external_data.size, external_data.present_in_archive, external_data.speed_hint, external_data.storage_confirmation, external_data.h5_folders, external_data.h5ar_folders, external_data.archiving_requested, link_data.id as link_data_id, content_copies.external_code, content_copies.edms_id, prdq.id IS NULL as is_post_registered from data left outer join external_data on data.id = external_data.id left outer join link_data on data.id = link_data.id left outer join post_registration_dataset_queue prdq on data.id = prdq.ds_id left outer join content_copies on data.id = content_copies.data_id", fetchSize=1000)
    public DataIterator<DatasetRecord> getDatasets();

    @Select(sql="select id, code, deletion_disallow from data_set_types")
    public DataSetTypeRecord[] getDatasetTypes();

    @Select(sql="select id, code, download_url from data_stores")
    public DataStoreRecord[] getDataStores();

    @Select(sql="select id, code from file_format_types")
    public CodeRecord[] getFileFormatTypes();

    @Select(sql="select id, code from locator_types")
    public CodeRecord[] getLocatorTypes();

    @Select(sql="select id, code, label, address, address_type as addressType from external_data_management_systems")
    public ExternalDataManagementSystemRecord[] getExternalDataManagementSystems();

    @Select(sql="select data.*, external_data.location, external_data.ffty_id, external_data.loty_id, external_data.cvte_id_stor_fmt, external_data.is_complete, external_data.cvte_id_store, external_data.status, external_data.share_id, external_data.size, external_data.present_in_archive, external_data.speed_hint, external_data.storage_confirmation, external_data.h5_folders, external_data.h5ar_folders, external_data.archiving_requested, link_data.id as link_data_id, content_copies.external_code, content_copies.edms_id, prdq.id IS NULL as is_post_registered from data left outer join external_data on data.id = external_data.id left outer join link_data on data.id = link_data.id left outer join post_registration_dataset_queue prdq on data.id = prdq.ds_id left outer join content_copies on data.id = content_copies.data_id where data.id = any(?{1})", parameterBindings={LongSetMapper.class}, fetchSize=1000)
    public DataIterator<DatasetRecord> getDatasets(LongSet var1);

    @Select(sql="select data.*, external_data.location, external_data.ffty_id, external_data.loty_id, external_data.cvte_id_stor_fmt, external_data.is_complete, external_data.cvte_id_store, external_data.status, external_data.share_id, external_data.size, external_data.present_in_archive, external_data.speed_hint, external_data.storage_confirmation, external_data.h5_folders, external_data.h5ar_folders, external_data.archiving_requested, link_data.id as link_data_id, content_copies.external_code, content_copies.edms_id, prdq.id IS NULL as is_post_registered from data left outer join external_data on data.id = external_data.id left outer join link_data on data.id = link_data.id left outer join post_registration_dataset_queue prdq on data.id = prdq.ds_id left outer join content_copies on data.id = content_copies.data_id where data.code = any(?{1})", parameterBindings={StringArrayMapper.class}, fetchSize=1000)
    public DataIterator<DatasetRecord> getDatasets(String[] var1);

    @Select(sql="select data.*, external_data.location, external_data.ffty_id, external_data.loty_id, external_data.cvte_id_stor_fmt, external_data.is_complete, external_data.cvte_id_store, external_data.status, external_data.share_id, external_data.size, external_data.present_in_archive, external_data.speed_hint, external_data.storage_confirmation, external_data.h5_folders, external_data.h5ar_folders, external_data.archiving_requested, prdq.id IS NULL as is_post_registered from data join external_data on data.id = external_data.id left outer join post_registration_dataset_queue prdq on data.id = prdq.ds_id  where data.dast_id = ?{1}", fetchSize=1000)
    public DataIterator<DatasetRecord> getDatasetsByDataStoreId(long var1);

    @Select(sql="select data.*, external_data.location, external_data.ffty_id, external_data.loty_id, external_data.cvte_id_stor_fmt, external_data.is_complete, external_data.cvte_id_store, external_data.status, external_data.share_id, external_data.size, external_data.present_in_archive, external_data.speed_hint, external_data.storage_confirmation, external_data.h5_folders, external_data.h5ar_folders, external_data.archiving_requested, prdq.id IS NULL as is_post_registered from data join external_data on data.id = external_data.id left outer join post_registration_dataset_queue prdq on data.id = prdq.ds_id  where data.dast_id = ?{1} order by registration_timestamp limit ?{2}", fetchSize=1000)
    public List<DatasetRecord> getDatasetsByDataStoreId(long var1, int var3);

    @Select(sql="select data.*, external_data.location, external_data.ffty_id, external_data.loty_id, external_data.cvte_id_stor_fmt, external_data.is_complete, external_data.cvte_id_store, external_data.status, external_data.share_id, external_data.size, external_data.present_in_archive, external_data.speed_hint, external_data.storage_confirmation, external_data.h5_folders, external_data.h5ar_folders, external_data.archiving_requested, prdq.id IS NULL as is_post_registered from data join external_data on data.id = external_data.id left outer join post_registration_dataset_queue prdq on data.id = prdq.ds_id  where data.dast_id = ?{1} and registration_timestamp > ?{2} order by registration_timestamp limit ?{3}", fetchSize=1000)
    public List<DatasetRecord> getDatasetsByDataStoreId(long var1, Date var3, int var4);

    @Select(sql="select data.*, external_data.location, external_data.ffty_id, external_data.loty_id, external_data.cvte_id_stor_fmt, external_data.is_complete, external_data.cvte_id_store, external_data.status, external_data.share_id, external_data.size, external_data.present_in_archive, external_data.speed_hint, external_data.storage_confirmation, external_data.h5_folders, external_data.h5ar_folders, external_data.archiving_requested, prdq.id IS NULL as is_post_registered from data join external_data on data.id = external_data.id left outer join post_registration_dataset_queue prdq on data.id = prdq.ds_id  where data.dast_id = ?{1} and registration_timestamp = ?{2} order by registration_timestamp", fetchSize=1000)
    public List<DatasetRecord> getDatasetsByDataStoreId(long var1, Date var3);

    @Select(sql="select data.*, external_data.location, external_data.ffty_id, external_data.loty_id, external_data.cvte_id_stor_fmt, external_data.is_complete, external_data.cvte_id_store, external_data.status, external_data.share_id, external_data.size, external_data.present_in_archive, external_data.speed_hint, external_data.storage_confirmation, external_data.h5_folders, external_data.h5ar_folders, external_data.archiving_requested, prdq.id IS NULL as is_post_registered from data join external_data on data.id = external_data.id left outer join post_registration_dataset_queue prdq on data.id = prdq.ds_id  where data.dast_id = ?{1} and size is null order by data.code limit ?{2}", fetchSize=1000)
    public List<DatasetRecord> getDatasetsByDataStoreIdWithUnknownSize(long var1, int var3);

    @Select(sql="select data.*, external_data.location, external_data.ffty_id, external_data.loty_id, external_data.cvte_id_stor_fmt, external_data.is_complete, external_data.cvte_id_store, external_data.status, external_data.share_id, external_data.size, external_data.present_in_archive, external_data.speed_hint, external_data.storage_confirmation, external_data.h5_folders, external_data.h5ar_folders, external_data.archiving_requested, prdq.id IS NULL as is_post_registered from data join external_data on data.id = external_data.id left outer join post_registration_dataset_queue prdq on data.id = prdq.ds_id  where data.dast_id = ?{1} and size is null and data.code > ?{3} order by data.code limit ?{2}", fetchSize=1000)
    public List<DatasetRecord> getDatasetsByDataStoreIdWithUnknownSize(long var1, int var3, String var4);

    @Select(sql="select data.*, external_data.location, external_data.ffty_id, external_data.loty_id, external_data.cvte_id_stor_fmt, external_data.is_complete, external_data.cvte_id_store, external_data.status, external_data.share_id, external_data.size, external_data.present_in_archive, external_data.speed_hint, external_data.storage_confirmation, external_data.h5_folders, external_data.h5ar_folders, external_data.archiving_requested, prdq.id IS NULL as is_post_registered from data join external_data on data.id = external_data.id left outer join post_registration_dataset_queue prdq on data.id = prdq.ds_id  where data.dast_id = ?{1} and external_data.status = ?{2}", fetchSize=1000)
    public List<DatasetRecord> getDatasetsByDataStoreIdWithArchivingStatus(long var1, String var3);

    @Select(sql="select data.*, external_data.location, external_data.ffty_id, external_data.loty_id, external_data.cvte_id_stor_fmt, external_data.is_complete, external_data.cvte_id_store, external_data.status, external_data.share_id, external_data.size, external_data.present_in_archive, external_data.speed_hint, external_data.storage_confirmation, external_data.h5_folders, external_data.h5ar_folders, external_data.archiving_requested, prdq.id IS NULL as is_post_registered from data join external_data on data.id = external_data.id left outer join post_registration_dataset_queue prdq on data.id = prdq.ds_id  where data.dast_id = ?{1} and external_data.present_in_archive = ?{2}", fetchSize=1000)
    public List<DatasetRecord> getDatasetsByDataStoreIdWithPressentInArchive(long var1, Boolean var3);

    @Select(sql="select data.*, external_data.location, external_data.ffty_id, external_data.loty_id, external_data.cvte_id_stor_fmt, external_data.is_complete, external_data.cvte_id_store, external_data.status, external_data.share_id, external_data.size, external_data.present_in_archive, external_data.speed_hint, external_data.storage_confirmation, external_data.h5_folders, external_data.h5ar_folders, external_data.archiving_requested, prdq.id IS NULL as is_post_registered from data join external_data on data.id = external_data.id left outer join post_registration_dataset_queue prdq on data.id = prdq.ds_id  where data.dast_id = ?{1} and external_data.status = ?{2} and external_data.present_in_archive = ?{3}", fetchSize=1000)
    public List<DatasetRecord> getDatasetsByDataStoreIdWithArchivingStatusAndPressentInArchive(long var1, String var3, Boolean var4);

    @Select(sql="SELECT code, share_id FROM data_all LEFT OUTER JOIN external_data ON data_all.id = external_data.id WHERE data_all.dast_id = ?{1}", fetchSize=1000)
    public DataIterator<DatasetCodeWithShareIdRecord> getAllDatasetsWithShareIdsByDataStoreId(long var1);

    @Select(sql="select data_id_child from data_set_relationships where data_id_parent = any(?{1}) and relationship_id = ?{2}", parameterBindings={LongSetMapper.class}, fetchSize=1000)
    public DataIterator<Long> getDatasetChildrenIds(LongSet var1, long var2);

    @Select(sql="select comp.code from data as comp join data_set_relationships as r on r.data_id_child = comp.id join data as cont on r.data_id_parent = cont.id where cont.code = ?{1} and relationship_id = ?{2}", fetchSize=1000)
    public DataIterator<String> getContainedDataSetCodes(String var1, long var2);

    @Select(sql="SELECT pr.ds_id as entity_id, etpt.prty_id, etpt.script_id, pr.value,            pr.cvte_id, pr.mate_prop_id, pr.samp_prop_id, sc.script_type       FROM data_set_properties pr      JOIN data_set_type_property_types etpt ON pr.dstpt_id=etpt.id      LEFT OUTER JOIN scripts sc ON etpt.script_id = sc.id     WHERE pr.ds_id = any(?{1})", parameterBindings={LongSetMapper.class}, fetchSize=1000)
    public DataIterator<GenericEntityPropertyRecord> getEntityPropertyGenericValues(LongSet var1);

    @Select(sql="SELECT pr.ds_id as entity_id, etpt.prty_id, etpt.script_id, pr.value       FROM data_set_properties pr      JOIN data_set_type_property_types etpt ON pr.dstpt_id=etpt.id      JOIN property_types pt ON etpt.prty_id=pt.id     WHERE pr.value is not null AND pr.ds_id = any(?{1}) AND pt.code = ?{2}", parameterBindings={LongSetMapper.class, TypeMapper.class}, fetchSize=1000)
    public DataIterator<GenericEntityPropertyRecord> getEntityPropertyGenericValues(LongSet var1, String var2);

    @Select(sql="with recursive connected_data(id,code,container_id,ordinal,dast_id,location,link_info) as (  select distinct d.id,d.code,nullif(r.data_id_parent,d.id),nullif(r.ordinal,r.ordinal),d.dast_id,ed.location,ld.id  from data as d left outer join external_data as ed on ed.id = d.id  left outer join link_data as ld on ld.id = d.id  left outer join data_set_relationships as r on r.data_id_parent=d.id  where d.code = ?{1}  union all    select distinct d.id,d.code,r.data_id_parent,r.ordinal,d.dast_id,ed.location,ld.id    from connected_data as cd inner join data_set_relationships as r on r.data_id_parent=cd.id    inner join data as d on r.data_id_child=d.id left outer join external_data as ed on ed.id = d.id left outer join link_data as ld on ld.id = d.id    where r.relationship_id = ?{2}) select cd.id,cd.code,cd.container_id,cd.ordinal,cd.location,d.code as data_store_code, d.remote_url as data_store_url, cd.link_info from connected_data as cd join data_stores as d on cd.dast_id = d.id", fetchSize=1000)
    public DataIterator<DatasetLocationNodeRecord> listLocationsByDatasetCode(String var1, long var2);

    @Select(sql="select m.id as id, m.name as name, m.description as description, p.user_id as owner_name,  m.private as is_private, m.creation_date as creation_date, ma.data_id as entity_id  from metaprojects m, metaproject_assignments ma, persons p  where ma.data_id = any(?{1}) and m.owner = ?{2} and m.id = ma.mepr_id and m.owner = p.id", parameterBindings={LongSetMapper.class}, fetchSize=1000)
    public List<MetaProjectWithEntityId> getMetaprojects(LongSet var1, Long var2);

    @Select(sql="SELECT edms.id AS edms_id, edms.code AS edms_code, edms.label AS edms_label, edms.address AS edms_address,  cc.external_code AS external_code, cc.path as path, cc.git_commit_hash AS hash, cc.git_repository_id AS repository_id  FROM content_copies cc, external_data_management_systems edms  WHERE cc.edms_id = edms.id AND cc.data_id = ?{1}")
    public List<ContentCopyRecord> getContentCopiesOf(long var1);
}

