/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.business.bo.fetchoptions.datasetlister;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.server.business.bo.fetchoptions.datasetlister.DataSetDownloadRecord;
import ch.systemsx.cisd.openbis.generic.server.business.bo.fetchoptions.datasetlister.DataSetRecord;
import ch.systemsx.cisd.openbis.generic.server.business.bo.fetchoptions.datasetlister.DataSetRelationRecord;
import ch.systemsx.cisd.openbis.generic.server.business.bo.fetchoptions.datasetlister.IDataSetLister;
import ch.systemsx.cisd.openbis.generic.server.business.bo.fetchoptions.datasetlister.IDataSetListingQuery;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IAuthorizationDAOFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IRelationshipTypeDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.RelationshipUtils;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.DataSet;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.DataSetFetchOption;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.DataSetFetchOptions;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.DataStoreURLForDataSets;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.EntityRegistrationDetails;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseInstance;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ExternalDataManagementSystem;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ExternalDataManagementSystemType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.FetchOption;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.LinkDataSetUrl;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifier;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import net.lemnik.eodsql.QueryTool;
import org.apache.commons.lang3.StringUtils;

public class DataSetLister
implements IDataSetLister {
    private IDataSetListingQuery query;
    private IRelationshipTypeDAO relationshipTypeDAO;

    public DataSetLister(IAuthorizationDAOFactory daoFactory, PersonPE person) {
        this((IDataSetListingQuery)QueryTool.getManagedQuery(IDataSetListingQuery.class), daoFactory, person);
    }

    public DataSetLister(IDataSetListingQuery query, IAuthorizationDAOFactory daoFactory, PersonPE person) {
        this.relationshipTypeDAO = daoFactory.getRelationshipTypeDAO();
        if (query == null) {
            throw new IllegalArgumentException("Query was null");
        }
        if (person == null) {
            throw new IllegalArgumentException("Person was null");
        }
        this.query = query;
    }

    @Override
    public List<DataSet> getDataSetMetaData(List<String> dataSetCodes, DataSetFetchOptions dataSetFetchOptions) {
        if (dataSetCodes == null) {
            throw new IllegalArgumentException("DataSetCodes were null");
        }
        if (dataSetFetchOptions == null) {
            throw new IllegalArgumentException("DataSetFetchOptions were null");
        }
        if (!dataSetFetchOptions.isSubsetOf((FetchOption[])new DataSetFetchOption[]{DataSetFetchOption.BASIC, DataSetFetchOption.PARENTS, DataSetFetchOption.CHILDREN, DataSetFetchOption.METAPROJECTS})) {
            throw new IllegalArgumentException("Currently only " + DataSetFetchOption.BASIC + "," + DataSetFetchOption.PARENTS + ", and " + DataSetFetchOption.CHILDREN + " and " + DataSetFetchOption.METAPROJECTS + " fetch options are supported by this method");
        }
        String[] dataSetCodesArray = dataSetCodes.toArray(new String[dataSetCodes.size()]);
        List<DataSetRecord> dataSetRecords = this.query.getDataSetMetaData(dataSetCodesArray);
        List<DataSet.DataSetInitializer> dataSetInitializers = this.createDataSetInitializers(dataSetRecords, dataSetCodesArray);
        this.injectContainerStubs(dataSetInitializers);
        if (dataSetFetchOptions.isSupersetOf((FetchOption[])new DataSetFetchOption[]{DataSetFetchOption.PARENTS})) {
            this.enrichDataSetInitializersWithParents(dataSetInitializers, dataSetCodesArray);
        }
        if (dataSetFetchOptions.isSupersetOf((FetchOption[])new DataSetFetchOption[]{DataSetFetchOption.CHILDREN})) {
            this.enrichDataSetInitializersWithChildren(dataSetInitializers, dataSetCodesArray);
        }
        return this.createDataSets(dataSetInitializers, dataSetFetchOptions);
    }

    private void injectContainerStubs(List<DataSet.DataSetInitializer> dataSetInitializers) {
        List containers;
        LongOpenHashSet ids = new LongOpenHashSet();
        for (DataSet.DataSetInitializer dataSetInitializer : dataSetInitializers) {
            ids.add((Object)dataSetInitializer.getId());
        }
        HashMap containersByComponents = new HashMap();
        List<DataSetRecord> dataSetsWithContainer = this.query.getContainers((LongSet)ids, RelationshipUtils.getContainerComponentRelationshipType(this.relationshipTypeDAO).getId());
        for (DataSetRecord dataSetRecord : dataSetsWithContainer) {
            containers = (ArrayList<DataSetRecord>)containersByComponents.get(dataSetRecord.ds_id);
            if (containers == null) {
                containers = new ArrayList<DataSetRecord>();
                containersByComponents.put(dataSetRecord.ds_id, containers);
            }
            containers.add(dataSetRecord);
        }
        for (DataSet.DataSetInitializer dataSetInitializer : dataSetInitializers) {
            containers = (List)containersByComponents.get(dataSetInitializer.getId());
            if (containers == null) continue;
            ArrayList<DataSet> containerDataSets = new ArrayList<DataSet>();
            for (DataSetRecord container : containers) {
                DataSet.DataSetInitializer containerInitializer = new DataSet.DataSetInitializer();
                containerInitializer.setStub(true);
                containerInitializer.setId(container.ctnr_id);
                containerInitializer.setCode(container.ctnr_code);
                containerDataSets.add(new DataSet(containerInitializer));
            }
            dataSetInitializer.setContainerDataSets(containerDataSets);
        }
    }

    private List<DataSet> createDataSets(List<DataSet.DataSetInitializer> dataSetInitializers, DataSetFetchOptions dataSetFetchOptions) {
        ArrayList<DataSet> dataSets = new ArrayList<DataSet>(dataSetInitializers.size());
        for (DataSet.DataSetInitializer dataSetInitializer : dataSetInitializers) {
            DataSet dataSet = new DataSet(dataSetInitializer);
            dataSet.setFetchOptions(dataSetFetchOptions);
            dataSets.add(dataSet);
        }
        return dataSets;
    }

    private List<DataSet.DataSetInitializer> createDataSetInitializers(List<DataSetRecord> dataSetRecords, String[] dataSetCodes) {
        if (dataSetRecords != null) {
            HashMap<String, DataSet.DataSetInitializer> dataSetMap = new HashMap<String, DataSet.DataSetInitializer>();
            for (DataSetRecord dataSetRecord : dataSetRecords) {
                DataSet.DataSetInitializer dataSet = this.createDataSetInitializer(dataSetRecord);
                dataSetMap.put(dataSet.getCode(), dataSet);
            }
            ArrayList<DataSet.DataSetInitializer> dataSetList = new ArrayList<DataSet.DataSetInitializer>(dataSetMap.size());
            for (String dataSetCode : dataSetCodes) {
                DataSet.DataSetInitializer dataSet = (DataSet.DataSetInitializer)dataSetMap.get(dataSetCode);
                if (dataSet == null) {
                    throw new UserFailureException("Unknown data set " + dataSetCode);
                }
                dataSetList.add(dataSet);
            }
            return dataSetList;
        }
        return Collections.emptyList();
    }

    private DataSet.DataSetInitializer createDataSetInitializer(DataSetRecord dataSet) {
        ExperimentIdentifier experimentIdentifier = null;
        if (dataSet.ex_code != null) {
            experimentIdentifier = new ExperimentIdentifier(dataSet.spe_code, dataSet.pre_code, dataSet.ex_code);
        }
        DataSet.DataSetInitializer initializer = new DataSet.DataSetInitializer();
        initializer.setId(dataSet.ds_id);
        initializer.setCode(dataSet.ds_code);
        initializer.setDataSetTypeCode(dataSet.dt_code);
        initializer.setContainerDataSet(DataSetKind.CONTAINER.name().equals(dataSet.ds_data_set_kind));
        initializer.setStorageConfirmed(dataSet.ed_sc == null || dataSet.ed_sc != false);
        initializer.setStub(false);
        if (!initializer.isContainerDataSet()) {
            initializer.setPostRegistered(dataSet.ds_is_post_registered.booleanValue());
        }
        initializer.setLinkDataSet(DataSetKind.LINK.name().equals(dataSet.ds_data_set_kind));
        if (initializer.isLinkDataSet()) {
            initializer.setExternalDataSetCode(dataSet.ld_external_code);
            LinkDataSetUrl linkDataSetUrl = new LinkDataSetUrl(dataSet.ld_external_code, dataSet.edms_address);
            initializer.setExternalDataSetLink(linkDataSetUrl.toString());
            DatabaseInstance db = new DatabaseInstance();
            db.setId(dataSet.die_id);
            db.setCode(dataSet.die_code);
            db.setUuid(dataSet.die_uuid);
            ExternalDataManagementSystem edms = new ExternalDataManagementSystem();
            edms.setId(dataSet.edms_id);
            edms.setCode(dataSet.edms_code);
            edms.setLabel(dataSet.edms_label);
            edms.setUrlTemplate(dataSet.edms_address);
            edms.setAddress(dataSet.edms_address);
            edms.setDatabaseInstance(db);
            edms.setAddressType(ExternalDataManagementSystemType.valueOf((String)dataSet.edms_address_type));
            edms.setOpenBIS(ExternalDataManagementSystemType.OPENBIS.equals((Object)edms.getAddressType()));
            initializer.setExternalDataManagementSystem(edms);
        }
        initializer.setRegistrationDetails(this.createDataSetRegistrationDetails(dataSet));
        if (experimentIdentifier != null) {
            initializer.setExperimentIdentifier(experimentIdentifier.toString());
        }
        if (dataSet.sa_identifier != null) {
            initializer.setSampleIdentifierOrNull(dataSet.sa_identifier);
        }
        return initializer;
    }

    private EntityRegistrationDetails createDataSetRegistrationDetails(DataSetRecord dataSet) {
        EntityRegistrationDetails.EntityRegistrationDetailsInitializer initializer = new EntityRegistrationDetails.EntityRegistrationDetailsInitializer();
        initializer.setUserId(dataSet.pe_user_id);
        initializer.setFirstName(dataSet.pe_first_name);
        initializer.setLastName(dataSet.pe_last_name);
        initializer.setEmail(dataSet.pe_email);
        initializer.setModifierUserId(dataSet.mod_user_id);
        initializer.setModifierFirstName(dataSet.mod_first_name);
        initializer.setModifierLastName(dataSet.mod_last_name);
        initializer.setModifierEmail(dataSet.mod_email);
        initializer.setRegistrationDate(dataSet.ds_registration_timestamp);
        initializer.setModificationDate(dataSet.ds_modification_timestamp);
        initializer.setAccessTimestamp(dataSet.access_timestamp);
        return new EntityRegistrationDetails(initializer);
    }

    private void enrichDataSetInitializersWithParents(List<DataSet.DataSetInitializer> dataSetInitializers, String[] dataSetCodes) {
        Long relationshipTypeId = this.getParentChildRelationshipType();
        List<DataSetRelationRecord> dataSetRelations = this.query.getDataSetParentsCodes(dataSetCodes, relationshipTypeId);
        if (dataSetRelations != null && !dataSetRelations.isEmpty()) {
            List<String> parentCodes;
            HashMap<String, LinkedList<String>> childCodeToParentCodesMap = new HashMap<String, LinkedList<String>>();
            for (DataSetRelationRecord dataSetRelation : dataSetRelations) {
                parentCodes = (LinkedList<String>)childCodeToParentCodesMap.get(dataSetRelation.dc_code);
                if (parentCodes == null) {
                    parentCodes = new LinkedList<String>();
                    childCodeToParentCodesMap.put(dataSetRelation.dc_code, (LinkedList<String>)parentCodes);
                }
                parentCodes.add(dataSetRelation.dp_code);
            }
            for (DataSet.DataSetInitializer dataSetInitializer : dataSetInitializers) {
                parentCodes = (List)childCodeToParentCodesMap.get(dataSetInitializer.getCode());
                dataSetInitializer.setParentCodes(parentCodes);
            }
        }
    }

    private void enrichDataSetInitializersWithChildren(List<DataSet.DataSetInitializer> dataSetInitializers, String[] dataSetCodes) {
        Long relationshipTypeId = this.getParentChildRelationshipType();
        List<DataSetRelationRecord> dataSetRelations = this.query.getDataSetChildrenCodes(dataSetCodes, relationshipTypeId);
        if (dataSetRelations != null && !dataSetRelations.isEmpty()) {
            List<String> childrenCodes;
            HashMap<String, LinkedList<String>> parentCodeToChildrenCodesMap = new HashMap<String, LinkedList<String>>();
            for (DataSetRelationRecord dataSetRelation : dataSetRelations) {
                childrenCodes = (LinkedList<String>)parentCodeToChildrenCodesMap.get(dataSetRelation.dp_code);
                if (childrenCodes == null) {
                    childrenCodes = new LinkedList<String>();
                    parentCodeToChildrenCodesMap.put(dataSetRelation.dp_code, (LinkedList<String>)childrenCodes);
                }
                childrenCodes.add(dataSetRelation.dc_code);
            }
            for (DataSet.DataSetInitializer dataSetInitializer : dataSetInitializers) {
                childrenCodes = (List)parentCodeToChildrenCodesMap.get(dataSetInitializer.getCode());
                dataSetInitializer.setChildrenCodes(childrenCodes);
            }
        }
    }

    private Long getParentChildRelationshipType() {
        return RelationshipUtils.getParentChildRelationshipType(this.relationshipTypeDAO).getId();
    }

    @Override
    public List<DataStoreURLForDataSets> getDataStoreDownloadURLs(List<String> dataSetCodes) {
        String[] dataSetCodesArray = dataSetCodes.toArray(new String[dataSetCodes.size()]);
        List<DataSetDownloadRecord> records = this.query.getDownloadURLs(dataSetCodesArray);
        ArrayList<DataStoreURLForDataSets> result = new ArrayList<DataStoreURLForDataSets>(records.size());
        for (DataSetDownloadRecord r : records) {
            String[] dataSetCodeArray = StringUtils.split((String)r.data_set_codes.substring(1, r.data_set_codes.length() - 1), (char)',');
            result.add(new DataStoreURLForDataSets(r.url, dataSetCodeArray));
        }
        return result;
    }

    @Override
    public List<DataStoreURLForDataSets> getDataStoreRemoteURLs(List<String> dataSetCodes) {
        String[] dataSetCodesArray = dataSetCodes.toArray(new String[dataSetCodes.size()]);
        List<DataSetDownloadRecord> records = this.query.getRemoteURLs(dataSetCodesArray);
        ArrayList<DataStoreURLForDataSets> result = new ArrayList<DataStoreURLForDataSets>(records.size());
        for (DataSetDownloadRecord r : records) {
            String[] dataSetCodeArray = StringUtils.split((String)r.data_set_codes.substring(1, r.data_set_codes.length() - 1), (char)',');
            result.add(new DataStoreURLForDataSets(r.url, dataSetCodeArray));
        }
        return result;
    }
}

