/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.business.bo.managed_property;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdentifierHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MaterialIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.IEntityWithMetaprojects;
import ch.systemsx.cisd.openbis.generic.shared.dto.MaterialPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ProjectPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SamplePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SamplePropertyPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SpacePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ProjectIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifierFactory;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.EntityLinkElementTranslator;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.api.IEntityInformationProvider;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.api.IEntityLinkElement;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="entity-information-provider")
public class EntityInformationProvider
implements IEntityInformationProvider {
    private final IDAOFactory daoFactory;

    @Autowired
    public EntityInformationProvider(IDAOFactory daoFactory) {
        assert (daoFactory != null);
        this.daoFactory = daoFactory;
    }

    @Override
    public String getIdentifier(IEntityLinkElement entityLink) {
        EntityKind entityKind = EntityLinkElementTranslator.translate(entityLink.getEntityLinkKind());
        String permId = entityLink.getPermId();
        return this.getIdentifier(entityKind, permId);
    }

    private String getIdentifier(EntityKind entityKind, String permId) {
        IEntityWithMetaprojects identifierHolderOrNull = null;
        switch (entityKind) {
            case EXPERIMENT: {
                identifierHolderOrNull = this.daoFactory.getExperimentDAO().tryGetByPermID(permId);
                break;
            }
            case SAMPLE: {
                identifierHolderOrNull = this.daoFactory.getSampleDAO().tryToFindByPermID(permId);
                break;
            }
            case DATA_SET: {
                identifierHolderOrNull = this.daoFactory.getDataDAO().tryToFindDataSetByCode(permId);
                break;
            }
            case MATERIAL: {
                MaterialIdentifier idOrNull = MaterialIdentifier.tryParseIdentifier(permId);
                if (idOrNull == null) {
                    return null;
                }
                final MaterialPE materialOrNull = this.daoFactory.getMaterialDAO().tryFindMaterial(idOrNull);
                if (materialOrNull == null) {
                    return null;
                }
                identifierHolderOrNull = new IIdentifierHolder(){

                    public String getIdentifier() {
                        return new MaterialIdentifier(materialOrNull.getCode(), materialOrNull.getEntityType().getCode()).print();
                    }
                };
            }
        }
        return identifierHolderOrNull == null ? null : identifierHolderOrNull.getIdentifier();
    }

    private SpacePE tryGetSpaceByCode(String spaceCode) {
        SpacePE space = this.daoFactory.getSpaceDAO().tryFindSpaceByCode(spaceCode);
        if (space == null) {
            throw UserFailureException.fromTemplate((String)"space '%s' doesn't exist ", (Object[])new Object[]{spaceCode});
        }
        return space;
    }

    private ProjectPE tryGetProjectByCode(String spaceCode, String projectCode) {
        ProjectPE project = this.daoFactory.getProjectDAO().tryFindProject(spaceCode, projectCode);
        if (project == null) {
            throw new UserFailureException("Project /" + spaceCode + "/" + projectCode + " doesn't exist.");
        }
        return project;
    }

    @Override
    public String getSamplePermId(String spaceCode, String sampleCode) {
        SpacePE space = this.tryGetSpaceByCode(spaceCode);
        SamplePE sample = this.daoFactory.getSampleDAO().tryFindByCodeAndSpace(sampleCode, space);
        return sample != null ? sample.getPermId() : null;
    }

    @Override
    public String getProjectSamplePermId(String spaceCode, String projectCode, String sampleCode) {
        ProjectPE project = this.tryGetProjectByCode(spaceCode, projectCode);
        SamplePE sample = this.daoFactory.getSampleDAO().tryfindByCodeAndProject(sampleCode, project);
        return sample != null ? sample.getPermId() : null;
    }

    @Override
    public String getSamplePermId(String sampleIdentifier) {
        SampleIdentifier identifier = SampleIdentifierFactory.parse(sampleIdentifier);
        String sampleCode = identifier.getSampleCode();
        if (identifier.isProjectLevel()) {
            ProjectIdentifier projectIdentifier = identifier.getProjectLevel();
            String spaceCode = projectIdentifier.getSpaceCode();
            String projectCode = projectIdentifier.getProjectCode();
            return this.getProjectSamplePermId(spaceCode, projectCode, sampleCode);
        }
        if (identifier.isSpaceLevel()) {
            String spaceCode = identifier.getSpaceLevel().getSpaceCode();
            return this.getSamplePermId(spaceCode, sampleCode);
        }
        SamplePE sample = this.daoFactory.getSampleDAO().tryFindByCodeAndDatabaseInstance(sampleCode);
        return sample != null ? sample.getPermId() : null;
    }

    private List<String> getSamplesPermIds(List<SamplePE> samples) {
        if (samples == null) {
            return new ArrayList<String>(0);
        }
        ArrayList<String> samplePermIds = new ArrayList<String>(samples.size());
        for (SamplePE sample : samples) {
            samplePermIds.add(sample.getPermId());
        }
        return samplePermIds;
    }

    private SamplePE getSampleByPermId(String permId) {
        SamplePE sample = this.daoFactory.getSampleDAO().tryToFindByPermID(permId);
        if (sample == null) {
            throw UserFailureException.fromTemplate((String)"sample '%s' doesn't exist", (Object[])new Object[]{permId});
        }
        return sample;
    }

    @Override
    public List<String> getSampleParentPermIds(String spaceCode, String sampleCode) {
        SpacePE space = this.tryGetSpaceByCode(spaceCode);
        SamplePE sample = this.daoFactory.getSampleDAO().tryFindByCodeAndSpace(sampleCode, space);
        if (sample == null) {
            throw UserFailureException.fromTemplate((String)"sample '%s' doesn't exist in space %s", (Object[])new Object[]{sampleCode, spaceCode});
        }
        return this.getSamplesPermIds(sample.getParents());
    }

    @Override
    public List<String> getProjectSampleParentPermIds(String spaceCode, String projectCode, String sampleCode) {
        ProjectPE project = this.tryGetProjectByCode(spaceCode, projectCode);
        SamplePE sample = this.daoFactory.getSampleDAO().tryfindByCodeAndProject(sampleCode, project);
        if (sample == null) {
            throw new UserFailureException("Sample /" + spaceCode + "/" + projectCode + "/" + sampleCode + " doesn't exist.");
        }
        return this.getSamplesPermIds(sample.getParents());
    }

    @Override
    public List<String> getSampleParentPermIds(String permId) {
        return this.getSamplesPermIds(this.getSampleByPermId(permId).getParents());
    }

    @Override
    public String getSamplePropertyValue(String permId, String propertyCode) {
        SamplePE sample = this.getSampleByPermId(permId);
        for (SamplePropertyPE property : sample.getProperties()) {
            if (!propertyCode.equalsIgnoreCase(property.getEntityTypePropertyType().getPropertyType().getCode())) continue;
            return property.getValue();
        }
        return "";
    }
}

