/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.business.bo.materiallister;

import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.common.db.mapper.LongSetMapper;
import ch.systemsx.cisd.common.db.mapper.StringArrayMapper;
import ch.systemsx.cisd.openbis.generic.server.business.bo.common.GenericEntityPropertyRecord;
import ch.systemsx.cisd.openbis.generic.server.business.bo.common.IPropertyListingQuery;
import ch.systemsx.cisd.openbis.generic.server.business.bo.fetchoptions.common.MetaProjectWithEntityId;
import ch.systemsx.cisd.openbis.generic.server.business.bo.materiallister.MaterialRecord;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.List;
import net.lemnik.eodsql.BaseQuery;
import net.lemnik.eodsql.DataIterator;
import net.lemnik.eodsql.Select;

@Private
public interface IMaterialListingQuery
extends BaseQuery,
IPropertyListingQuery {
    public static final String SELECT_MATERIALS = "select m.id, m.code, m.maty_id, m.registration_timestamp, m.modification_timestamp, m.pers_id_registerer from materials m";
    public static final String SELECT_MATERIALS_WHERE = "select m.id, m.code, m.maty_id, m.registration_timestamp, m.modification_timestamp, m.pers_id_registerer from materials m where";

    @Select(sql="select mate_id from material_properties where mate_prop_id = any(?{1})", parameterBindings={LongSetMapper.class}, fetchSize=1000)
    public DataIterator<Long> getMaterialIdsByMaterialProperties(LongSet var1);

    @Select(sql="select m.id, m.code, m.maty_id, m.registration_timestamp, m.modification_timestamp, m.pers_id_registerer from materials m where m.maty_id=?{1} order by m.code", fetchSize=1000)
    public DataIterator<MaterialRecord> getMaterialsForMaterialType(long var1);

    @Select(sql="select m.id, m.code, m.maty_id, m.registration_timestamp, m.modification_timestamp, m.pers_id_registerer from materials m where m.id = any(?{1}) order by m.code", parameterBindings={LongSetMapper.class}, fetchSize=1000)
    public DataIterator<MaterialRecord> getMaterialsForMaterialTypeWithIds(LongSet var1);

    @Select(sql="select m.id, m.code, m.maty_id, m.registration_timestamp, m.modification_timestamp, m.pers_id_registerer from materials m where m.code = any(?{1}) order by m.code", parameterBindings={StringArrayMapper.class}, fetchSize=1000)
    public DataIterator<MaterialRecord> getMaterialsForMaterialCodes(String[] var1);

    @Select(sql="select m.id, m.code, m.maty_id, m.registration_timestamp, m.modification_timestamp, m.pers_id_registerer from materials m JOIN metaproject_assignments ma ON m.id=ma.mate_id WHERE ma.mepr_id=?{1} order by m.code", fetchSize=1000)
    public DataIterator<MaterialRecord> getMaterialsForMetaprojectId(long var1);

    @Select(sql="SELECT pr.mate_id as entity_id, etpt.prty_id, etpt.script_id, pr.value,            pr.cvte_id, pr.mate_prop_id, sc.script_type       FROM material_properties pr      JOIN material_type_property_types etpt ON pr.mtpt_id=etpt.id      LEFT OUTER JOIN scripts sc ON etpt.script_id = sc.id     WHERE pr.mate_id = any(?{1})", parameterBindings={LongSetMapper.class}, fetchSize=1000)
    public DataIterator<GenericEntityPropertyRecord> getEntityPropertyGenericValues(LongSet var1);

    @Select(sql="select m.id as id, m.name as name, m.description as description, p.user_id as owner_name,  m.private as is_private, m.creation_date as creation_date, ma.mate_id as entity_id  from metaprojects m, metaproject_assignments ma, persons p  where ma.mate_id = any(?{1}) and m.owner = ?{2} and m.id = ma.mepr_id and m.owner = p.id", parameterBindings={LongSetMapper.class}, fetchSize=1000)
    public List<MetaProjectWithEntityId> getMetaprojects(LongSet var1, Long var2);
}

