/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.business.bo.samplelister;

import ch.rinn.restrictions.Friend;
import ch.systemsx.cisd.common.collection.IValidator;
import ch.systemsx.cisd.openbis.generic.server.business.bo.common.entity.SecondaryEntityDAO;
import ch.systemsx.cisd.openbis.generic.server.business.bo.samplelister.ISampleLister;
import ch.systemsx.cisd.openbis.generic.server.business.bo.samplelister.ISampleListingQuery;
import ch.systemsx.cisd.openbis.generic.server.business.bo.samplelister.SampleListerDAO;
import ch.systemsx.cisd.openbis.generic.server.business.bo.samplelister.SampleListingWorker;
import ch.systemsx.cisd.openbis.generic.server.business.bo.samplelister.SampleRecord;
import ch.systemsx.cisd.openbis.generic.server.business.bo.samplelister.SampleRelationRecord;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ListOrSearchSampleCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample;
import ch.systemsx.cisd.openbis.generic.shared.dto.SampleRelationshipSkeleton;
import ch.systemsx.cisd.openbis.generic.shared.dto.SampleSkeleton;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.lemnik.eodsql.DataIterator;

@Friend(toClasses={ISampleListingQuery.class, SampleRecord.class, SampleRelationRecord.class})
public class SampleLister
implements ISampleLister {
    private final SampleListerDAO dao;
    private final SecondaryEntityDAO referencedEntityDAO;
    private final String baseIndexURL;
    private final Long userId;

    public static SampleLister create(IDAOFactory daoFactory, String baseIndexURL, Long userId) {
        SampleListerDAO sampleListerDAO = SampleListerDAO.create(daoFactory);
        SecondaryEntityDAO referencedEntityDAO = SecondaryEntityDAO.create(daoFactory);
        return new SampleLister(baseIndexURL, sampleListerDAO, referencedEntityDAO, userId);
    }

    private SampleLister(String baseIndexURL, SampleListerDAO dao, SecondaryEntityDAO referencedEntityDAO, Long userId) {
        this.baseIndexURL = baseIndexURL;
        this.dao = dao;
        this.referencedEntityDAO = referencedEntityDAO;
        this.userId = userId;
    }

    @Override
    public List<Sample> list(ListOrSearchSampleCriteria criteria) {
        return SampleListingWorker.create(criteria, this.baseIndexURL, this.dao, this.referencedEntityDAO, this.userId).load();
    }

    @Override
    public long getRelationshipTypeID(String code) {
        return SampleListingWorker.getRelationId(this.dao.getQuery(), code);
    }

    @Override
    public List<SampleSkeleton> listSampleBy(IValidator<SampleSkeleton> criteria) {
        DataIterator<SampleRecord> sampleSkeletons = this.dao.getQuery().getSampleSkeletons();
        ArrayList<SampleSkeleton> result = new ArrayList<SampleSkeleton>();
        for (SampleRecord sampleRecord : sampleSkeletons) {
            SampleSkeleton sampleSkeleton = new SampleSkeleton();
            sampleSkeleton.setId(sampleRecord.id);
            sampleSkeleton.setExperimentID(sampleRecord.expe_id);
            sampleSkeleton.setSpaceID(sampleRecord.space_id);
            sampleSkeleton.setTypeID(sampleRecord.saty_id);
            if (!criteria.isValid((Object)sampleSkeleton)) continue;
            result.add(sampleSkeleton);
        }
        return result;
    }

    @Override
    public List<SampleRelationshipSkeleton> listSampleRelationshipsBy(IValidator<SampleRelationshipSkeleton> criteria) {
        DataIterator<SampleRelationRecord> records = this.dao.getQuery().getSampleRelationshipSkeletons();
        ArrayList<SampleRelationshipSkeleton> result = new ArrayList<SampleRelationshipSkeleton>();
        for (SampleRelationRecord record : records) {
            SampleRelationshipSkeleton skeleton = new SampleRelationshipSkeleton();
            skeleton.setRelationshipTypeID(record.relationship_id);
            skeleton.setParentSampleID(record.sample_id_parent);
            skeleton.setChildSampleID(record.sample_id_child);
            if (!criteria.isValid((Object)skeleton)) continue;
            result.add(skeleton);
        }
        return result;
    }

    @Override
    public Map<Long, Set<Long>> getChildToParentsIdsMap(Collection<Long> childrenIds) {
        LongOpenHashSet ids = new LongOpenHashSet();
        for (Long id : childrenIds) {
            ids.add(id);
        }
        long relationshipTypeID = this.getRelationshipTypeID("$PARENT_CHILD");
        DataIterator<SampleRelationRecord> relationships = this.dao.getQuery().getParentRelations(relationshipTypeID, (LongSet)ids);
        LinkedHashMap<Long, Set<Long>> map = new LinkedHashMap<Long, Set<Long>>();
        for (SampleRelationRecord relationship : relationships) {
            LinkedHashSet<Long> parents = (LinkedHashSet<Long>)map.get(relationship.sample_id_child);
            if (parents == null) {
                parents = new LinkedHashSet<Long>();
                map.put(relationship.sample_id_child, parents);
            }
            parents.add(relationship.sample_id_parent);
        }
        return map;
    }

    @Override
    public Map<Long, Set<Long>> getParentToChildrenIdsMap(Collection<Long> parentIds) {
        LongOpenHashSet ids = new LongOpenHashSet();
        for (Long id : parentIds) {
            ids.add(id);
        }
        long relationshipTypeID = this.getRelationshipTypeID("$PARENT_CHILD");
        DataIterator<SampleRelationRecord> relationships = this.dao.getQuery().getChildrenRelations(relationshipTypeID, (LongSet)ids);
        LinkedHashMap<Long, Set<Long>> map = new LinkedHashMap<Long, Set<Long>>();
        for (SampleRelationRecord relationship : relationships) {
            LinkedHashSet<Long> children = (LinkedHashSet<Long>)map.get(relationship.sample_id_parent);
            if (children == null) {
                children = new LinkedHashSet<Long>();
                map.put(relationship.sample_id_parent, children);
            }
            children.add(relationship.sample_id_child);
        }
        return map;
    }

    @Override
    public Collection<TechId> listSamplesByMaterialProperties(Collection<TechId> materialIds) {
        ISampleListingQuery query = this.dao.getQuery();
        LongOpenHashSet ids = new LongOpenHashSet((Collection)TechId.asLongs(materialIds));
        DataIterator<Long> result = query.getSampleIdsByMaterialProperties((LongSet)ids);
        HashSet<TechId> sampleIds = new HashSet<TechId>();
        for (Long sampleId : result) {
            sampleIds.add(new TechId(sampleId));
        }
        return sampleIds;
    }

    public Set<Long> listChildrenIdsSet(Collection<Long> parentIds) {
        LongOpenHashSet ids = new LongOpenHashSet();
        for (Long id : parentIds) {
            ids.add(id);
        }
        long relationshipTypeID = this.getRelationshipTypeID("$PARENT_CHILD");
        DataIterator<Long> resultIterator = this.dao.getQuery().getChildrenIds(relationshipTypeID, (LongSet)ids);
        return new LongOpenHashSet(resultIterator);
    }
}

