/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.business.bo.samplelister;

import ch.rinn.restrictions.Friend;
import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.openbis.generic.server.business.bo.common.AbstractDAO;
import ch.systemsx.cisd.openbis.generic.server.business.bo.common.GenericEntityPropertyRecord;
import ch.systemsx.cisd.openbis.generic.server.business.bo.common.IEntityPropertySetListingQuery;
import ch.systemsx.cisd.openbis.generic.server.business.bo.samplelister.ISampleListingQuery;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import it.unimi.dsi.fastutil.longs.LongSet;
import net.lemnik.eodsql.QueryTool;

@Friend(toClasses={ISampleListingQuery.class})
public final class SampleListerDAO
extends AbstractDAO {
    private final ISampleListingQuery query;
    private final IEntityPropertySetListingQuery propertySetQuery;

    public static SampleListerDAO create(IDAOFactory daoFactory) {
        ISampleListingQuery query = (ISampleListingQuery)QueryTool.getManagedQuery(ISampleListingQuery.class);
        return SampleListerDAO.create(daoFactory, query);
    }

    @Private
    static SampleListerDAO create(IDAOFactory daoFactory, ISampleListingQuery query) {
        return new SampleListerDAO(query);
    }

    SampleListerDAO(ISampleListingQuery query) {
        this.query = query;
        this.propertySetQuery = SampleListerDAO.asEntityPropertySetListingQuery(query);
    }

    ISampleListingQuery getQuery() {
        return this.query;
    }

    IEntityPropertySetListingQuery getPropertySetQuery() {
        return this.propertySetQuery;
    }

    private static IEntityPropertySetListingQuery asEntityPropertySetListingQuery(final ISampleListingQuery query) {
        return new IEntityPropertySetListingQuery(){

            @Override
            public Iterable<GenericEntityPropertyRecord> getEntityPropertyGenericValues(LongSet entityIDs) {
                return query.getEntityPropertyGenericValues(entityIDs);
            }
        };
    }
}

