/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.business.bo.samplelister;

import ch.rinn.restrictions.Friend;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.openbis.generic.server.business.bo.common.EntityPropertiesEnricher;
import ch.systemsx.cisd.openbis.generic.server.business.bo.common.IEntityPropertiesEnricher;
import ch.systemsx.cisd.openbis.generic.server.business.bo.common.IEntityPropertiesHolderResolver;
import ch.systemsx.cisd.openbis.generic.server.business.bo.common.entity.AbstractLister;
import ch.systemsx.cisd.openbis.generic.server.business.bo.common.entity.ExperimentProjectSpaceCodeRecord;
import ch.systemsx.cisd.openbis.generic.server.business.bo.common.entity.SecondaryEntityDAO;
import ch.systemsx.cisd.openbis.generic.server.business.bo.fetchoptions.common.MetaProjectWithEntityId;
import ch.systemsx.cisd.openbis.generic.server.business.bo.samplelister.ISampleListingQuery;
import ch.systemsx.cisd.openbis.generic.server.business.bo.samplelister.SampleListerDAO;
import ch.systemsx.cisd.openbis.generic.server.business.bo.samplelister.SampleRecord;
import ch.systemsx.cisd.openbis.generic.server.business.bo.samplelister.SampleRelationRecord;
import ch.systemsx.cisd.openbis.generic.shared.basic.CodeConverter;
import ch.systemsx.cisd.openbis.generic.shared.basic.PermlinkUtilities;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseInstance;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Deletion;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IEntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ListOrSearchSampleCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Metaproject;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Project;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Space;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.IdentifierHelper;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import net.lemnik.eodsql.DataIterator;
import org.apache.commons.lang3.time.StopWatch;
import org.apache.log4j.Logger;

@Friend(toClasses={ExperimentProjectSpaceCodeRecord.class, SampleRecord.class, SampleRelationRecord.class, ISampleListingQuery.class})
final class SampleListingWorker
extends AbstractLister {
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, SampleListingWorker.class);
    private final ListOrSearchSampleCriteria criteria;
    private final String baseIndexURL;
    private final List<Sample> sampleList = new ArrayList<Sample>(1000);
    private final ISampleListingQuery query;
    private final IEntityPropertiesEnricher samplePropertiesEnricherOrNull;
    private final SecondaryEntityDAO referencedEntityDAO;
    private final Long2ObjectOpenHashMap<SampleType> sampleTypes = new Long2ObjectOpenHashMap();
    private final Long2ObjectMap<Project> projects = new Long2ObjectOpenHashMap();
    private final LongSet idsOfSamplesAwaitingParentResolution = new LongOpenHashSet();
    private final List<RelatedSampleRecord> samplesAwaitingParentResolution = new ArrayList<RelatedSampleRecord>();
    private final Long2ObjectMap<RelatedSampleRecord> samplesAwaitingContainerResolution = new Long2ObjectOpenHashMap();
    private final LongSet idsOfRequestedContainerSamples = new LongOpenHashSet();
    private final LongSet idsOfRequestedParentSamples = new LongOpenHashSet();
    private boolean singleSampleTypeMode;
    private boolean enrichDependentSamples;
    private int maxSampleParentResolutionDepth;
    private final Long2ObjectMap<Sample> sampleMap = new Long2ObjectOpenHashMap();
    private final Long2ObjectMap<Space> spaceMap = new Long2ObjectOpenHashMap();
    private final long parentRelationhipTypeId;
    private final Long userId;

    public static SampleListingWorker create(ListOrSearchSampleCriteria criteria, String baseIndexURL, SampleListerDAO dao, SecondaryEntityDAO referencedEntityDAO, Long userId) {
        ISampleListingQuery query = dao.getQuery();
        EntityPropertiesEnricher propertiesEnricher = new EntityPropertiesEnricher(query, dao.getPropertySetQuery());
        return new SampleListingWorker(criteria, baseIndexURL, dao.getDatabaseInstanceId(), dao.getDatabaseInstance(), query, propertiesEnricher, referencedEntityDAO, userId);
    }

    SampleListingWorker(ListOrSearchSampleCriteria criteria, String baseIndexURL, long databaseInstanceId, DatabaseInstance databaseInstance, ISampleListingQuery query, IEntityPropertiesEnricher samplePropertiesEnricherOrNull, SecondaryEntityDAO referencedEntityDAO, Long userId) {
        super(referencedEntityDAO);
        assert (criteria != null);
        assert (baseIndexURL != null);
        assert (databaseInstance != null);
        assert (query != null);
        this.criteria = criteria;
        this.baseIndexURL = baseIndexURL;
        this.query = query;
        this.samplePropertiesEnricherOrNull = samplePropertiesEnricherOrNull;
        this.enrichDependentSamples = criteria.isEnrichDependentSamplesWithProperties();
        this.referencedEntityDAO = referencedEntityDAO;
        this.parentRelationhipTypeId = SampleListingWorker.getRelationId(query, "$PARENT_CHILD");
        this.userId = userId;
    }

    static long getRelationId(ISampleListingQuery query, String fullRelationCode) {
        return query.getRelationshipTypeId(CodeConverter.tryToDatabase(fullRelationCode), CodeConverter.isInternalNamespace(fullRelationCode));
    }

    public List<Sample> load() {
        StopWatch watch = new StopWatch();
        watch.start();
        this.loadGroups();
        this.loadSampleTypes();
        this.retrievePrimaryBasicSamples(this.tryGetIteratorForSamplesByIds());
        this.retrievePrimaryBasicSamples(this.tryGetIteratorForSamplesByCodes());
        this.retrievePrimaryBasicSamples(this.tryGetIteratorForContainerSamplesByCodes());
        this.retrievePrimaryBasicSamples(this.tryGetIteratorForSamplesByPermIds());
        this.retrievePrimaryBasicSamples(this.tryGetIteratorForContainerSamplesByPermIds());
        this.retrievePrimaryBasicSamples(this.tryGetIteratorForSpaceSamples());
        this.retrievePrimaryBasicSamples(this.tryGetIteratorForSharedSamples());
        this.retrievePrimaryBasicSamples(this.tryGetIteratorForExperimentSamples());
        this.retrievePrimaryBasicSamples(this.tryGetIteratorForContainedSamples());
        this.retrievePrimaryBasicSamples(this.tryGetIteratorForParentSamples());
        this.retrievePrimaryBasicSamples(this.tryGetIteratorForChildSamples());
        this.retrievePrimaryBasicSamples(this.tryGetIteratorForNewTrackedProcessedSamples());
        this.retrievePrimaryBasicSamples(this.tryGetIteratorForNewTrackedToBeProcessedSamples());
        this.retrievePrimaryBasicSamples(this.tryGetIteratorForMetaprojectSamples());
        if (operationLog.isDebugEnabled()) {
            watch.stop();
            operationLog.debug((Object)String.format("Basic retrieval of %d samples took %s s", this.sampleList.size(), watch.toString()));
            watch.reset();
            watch.start();
        }
        if (!this.enrichDependentSamples) {
            this.enrichRetrievedSamplesWithProperties(watch);
        }
        this.retrieveDependentSamplesRecursively(true);
        this.resolveParents();
        this.resolveContainers();
        if (this.enrichDependentSamples) {
            this.enrichRetrievedSamplesWithProperties(watch);
        }
        this.enrichWithMetaProjects();
        return this.sampleList;
    }

    private void enrichWithMetaProjects() {
        for (MetaProjectWithEntityId metaProject : this.query.getMetaprojects(this.sampleMap.keySet(), this.userId)) {
            Metaproject mp = new Metaproject();
            mp.setId(metaProject.id);
            mp.setCreationDate(metaProject.creation_date);
            mp.setDescription(metaProject.description);
            mp.setIdentifier("/" + metaProject.owner_name + "/" + metaProject.name);
            mp.setName(metaProject.name);
            mp.setOwnerId(metaProject.owner_name);
            mp.setPrivate(metaProject.is_private.booleanValue());
            Sample sample = (Sample)this.sampleMap.get((Object)metaProject.entity_id);
            if (sample == null) continue;
            Collection<Metaproject> mps = sample.getMetaprojects();
            if (mps == null) {
                mps = new HashSet<Metaproject>();
                sample.setMetaprojects(mps);
            }
            mps.add(mp);
        }
    }

    private static void log(StopWatch watch, String message) {
        if (operationLog.isDebugEnabled()) {
            watch.stop();
            operationLog.debug((Object)String.format("%s took %s s", message, watch.toString()));
            watch.reset();
            watch.start();
        }
    }

    private void enrichRetrievedSamplesWithProperties(StopWatch watch) {
        if (this.samplePropertiesEnricherOrNull != null) {
            this.samplePropertiesEnricherOrNull.enrich(this.sampleMap.keySet(), new IEntityPropertiesHolderResolver(){

                @Override
                public Sample get(long id) {
                    return (Sample)SampleListingWorker.this.sampleMap.get(id);
                }
            });
            SampleListingWorker.log(watch, "Enrichment with properties");
        }
    }

    private void loadGroups() {
        Space[] spaces;
        for (Space space : spaces = this.referencedEntityDAO.getAllSpaces()) {
            this.spaceMap.put((Object)space.getId(), (Object)space);
        }
    }

    private void loadSampleTypes() {
        SampleType sampleTypeOrNull = this.tryGetSingleModeSampleType();
        this.singleSampleTypeMode = sampleTypeOrNull != null;
        for (SampleType type : this.query.getSampleTypes()) {
            this.sampleTypes.put(type.getId(), (Object)type);
            if (this.singleSampleTypeMode) continue;
            this.maxSampleParentResolutionDepth = Math.max(this.maxSampleParentResolutionDepth, type.getGeneratedFromHierarchyDepth());
        }
        this.sampleTypes.trim();
        if (this.singleSampleTypeMode) {
            this.maxSampleParentResolutionDepth = sampleTypeOrNull.getGeneratedFromHierarchyDepth();
        }
    }

    private Project createAndSaveProject(long projectId) {
        Project project = this.referencedEntityDAO.tryGetProject(projectId);
        this.projects.put(projectId, (Object)project);
        return project;
    }

    private SampleType tryGetSingleModeSampleType() {
        SampleType sampleTypeOrNull = this.criteria.getSampleType();
        return sampleTypeOrNull == null || sampleTypeOrNull.isAllTypesCode() ? null : sampleTypeOrNull;
    }

    private long getSampleTypeId() {
        SampleType sampleTypeOrNull = this.tryGetSingleModeSampleType();
        assert (sampleTypeOrNull != null);
        return sampleTypeOrNull.getId();
    }

    private Iterable<SampleRecord> tryGetIteratorForSamplesByIds() {
        Collection<Long> ids = this.criteria.getSampleIds();
        if (ids == null) {
            return null;
        }
        return this.query.getSamples((LongSet)new LongOpenHashSet(ids));
    }

    private Iterable<SampleRecord> tryGetIteratorForSamplesByCodes() {
        if (this.criteria.isSearchForContainerSamplesOnly()) {
            return null;
        }
        String[] codes = this.criteria.trySampleCodes();
        if (codes == null) {
            return null;
        }
        return this.query.getSamplesForCodes(codes);
    }

    private Iterable<SampleRecord> tryGetIteratorForContainerSamplesByCodes() {
        if (!this.criteria.isSearchForContainerSamplesOnly()) {
            return null;
        }
        String[] codes = this.criteria.trySampleCodes();
        if (codes == null) {
            return null;
        }
        return this.query.getContainerSamplesForCodes(codes);
    }

    private Iterable<SampleRecord> tryGetIteratorForSamplesByPermIds() {
        if (this.criteria.isSearchForContainerSamplesOnly()) {
            return null;
        }
        String[] permIds = this.criteria.trySamplePermIds();
        if (permIds == null) {
            return null;
        }
        return this.query.getSamplesForPermIds(permIds);
    }

    private Iterable<SampleRecord> tryGetIteratorForContainerSamplesByPermIds() {
        if (!this.criteria.isSearchForContainerSamplesOnly()) {
            return null;
        }
        String[] permIds = this.criteria.trySamplePermIds();
        if (permIds == null) {
            return null;
        }
        return this.query.getContainerSamplesForPermIds(permIds);
    }

    private Iterable<SampleRecord> tryGetIteratorForSpaceSamples() {
        if (!this.criteria.isIncludeSpace()) {
            return null;
        }
        if (this.criteria.isExcludeWithoutExperiment()) {
            if (this.singleSampleTypeMode) {
                return this.getSpaceSampleForSampleTypeWithExperiment();
            }
            return this.getSpaceSamplesWithExperiment();
        }
        if (this.singleSampleTypeMode) {
            return this.getSpaceSamplesForSampleType();
        }
        return this.getSpaceSamples();
    }

    private DataIterator<SampleRecord> getSpaceSamples() {
        String groupCode = this.criteria.getSpaceCode();
        if (groupCode == null) {
            return this.query.getAllListableSpaceSamples();
        }
        return this.query.getListableSpaceSamples(groupCode);
    }

    private Iterable<SampleRecord> getSpaceSamplesForSampleType() {
        long sampleTypeId = this.getSampleTypeId();
        String groupCode = this.criteria.getSpaceCode();
        if (groupCode == null) {
            return this.query.getAllSpaceSamplesForSampleType(sampleTypeId);
        }
        return this.query.getSpaceSamplesForSampleType(groupCode, sampleTypeId);
    }

    private DataIterator<SampleRecord> getSpaceSamplesWithExperiment() {
        String groupCode = this.criteria.getSpaceCode();
        if (groupCode == null) {
            return this.query.getAllSpaceSamplesWithExperiment();
        }
        return this.query.getSpaceSamplesWithExperiment(groupCode);
    }

    private DataIterator<SampleRecord> getSpaceSampleForSampleTypeWithExperiment() {
        long sampleTypeId = this.getSampleTypeId();
        String groupCode = this.criteria.getSpaceCode();
        if (groupCode == null) {
            return this.query.getAllSpaceSamplesForSampleTypeWithExperiment(sampleTypeId);
        }
        return this.query.getSpaceSamplesForSampleTypeWithExperiment(groupCode, sampleTypeId);
    }

    private Iterable<SampleRecord> tryGetIteratorForExperimentSamples() {
        TechId experimentTechId = this.criteria.getExperimentId();
        if (experimentTechId == null) {
            return null;
        }
        if (this.criteria.isOnlyDirectlyConnected()) {
            return this.query.getListableSamplesForExperiment(experimentTechId.getId());
        }
        return this.query.getListableSamplesAndDescendentsForExperiment(experimentTechId.getId());
    }

    private Iterable<SampleRecord> tryGetIteratorForMetaprojectSamples() {
        Long metaprojectId = this.criteria.getMetaprojectId();
        if (metaprojectId == null) {
            return null;
        }
        return this.query.getSamplesForMetaproject(metaprojectId);
    }

    private Iterable<SampleRecord> tryGetIteratorForContainedSamples() {
        Collection<Long> containerTechId = this.criteria.getContainerSampleIds();
        if (containerTechId == null) {
            return null;
        }
        return this.query.getSamplesForContainer((LongSet)new LongOpenHashSet(containerTechId));
    }

    private Iterable<SampleRecord> tryGetIteratorForChildSamples() {
        TechId parentTechId = this.criteria.getParentSampleId();
        if (parentTechId == null) {
            return null;
        }
        return this.query.getChildrenSamplesForParent(this.parentRelationhipTypeId, parentTechId.getId());
    }

    private Iterable<SampleRecord> tryGetIteratorForParentSamples() {
        Collection<Long> ids = this.criteria.getChildrenSampleIds();
        if (ids.isEmpty()) {
            return null;
        }
        return this.query.getParentSamplesForChildren(this.parentRelationhipTypeId, (LongSet)new LongOpenHashSet(ids));
    }

    private Iterable<SampleRecord> tryGetIteratorForSharedSamples() {
        if (!this.criteria.isIncludeInstance()) {
            return null;
        }
        if (this.singleSampleTypeMode) {
            long sampleTypeId = this.getSampleTypeId();
            return this.query.getSharedSamplesForSampleType(sampleTypeId);
        }
        return this.query.getListableSharedSamples();
    }

    private Iterable<SampleRecord> tryGetIteratorForNewTrackedProcessedSamples() {
        if (this.criteria.getSampleTypeCode() == null) {
            return null;
        }
        long sampleTypeId = this.referencedEntityDAO.getSampleTypeIdForSampleTypeCode(this.criteria.getSampleTypeCode());
        String propertyTypeCode = this.criteria.getPropertyTypeCode();
        String propertyValue = this.criteria.getPropertyValue();
        return this.query.getSamplesWithPropertyValue(sampleTypeId, propertyTypeCode, propertyValue, (LongSet)new LongOpenHashSet(this.criteria.getAlreadyTrackedSampleIds()));
    }

    private Iterable<SampleRecord> tryGetIteratorForNewTrackedToBeProcessedSamples() {
        if (this.criteria.getSampleTypeCode() == null) {
            return null;
        }
        long sampleTypeId = this.referencedEntityDAO.getSampleTypeIdForSampleTypeCode(this.criteria.getSampleTypeCode());
        String propertyTypeCode = this.criteria.getPropertyTypeCode();
        String propertyValue = this.criteria.getPropertyValue();
        return this.query.getSamplesWithControlledVocabularyWithPropertyValue(sampleTypeId, propertyTypeCode, propertyValue, (LongSet)new LongOpenHashSet(this.criteria.getAlreadyTrackedSampleIds()));
    }

    private void retrievePrimaryBasicSamples(Iterable<SampleRecord> sampleIteratorOrNull) {
        assert (this.sampleList != null);
        this.retrieveBasicSamples(sampleIteratorOrNull, this.sampleList);
    }

    private void retrieveDependentBasicSamples(Iterable<SampleRecord> sampleIteratorOrNull) {
        this.retrieveBasicSamples(sampleIteratorOrNull, null);
    }

    private void retrieveBasicSamples(Iterable<SampleRecord> sampleIteratorOrNull, List<Sample> sampleListOrNull) {
        if (sampleIteratorOrNull == null) {
            return;
        }
        boolean primarySample = sampleListOrNull != null;
        ArrayList<SampleRecord> records = new ArrayList<SampleRecord>();
        LongOpenHashSet expIds = new LongOpenHashSet();
        for (SampleRecord row : sampleIteratorOrNull) {
            records.add(row);
            if (row.expe_id == null) continue;
            expIds.add((Object)row.expe_id);
        }
        Long2ObjectMap<Experiment> experimentsById = this.referencedEntityDAO.getExperiments((LongSet)expIds);
        for (SampleRecord row : records) {
            Sample sampleOrNull = this.tryCreateSample(row, experimentsById, primarySample);
            if (sampleOrNull == null) continue;
            this.sampleMap.put((Object)sampleOrNull.getId(), (Object)sampleOrNull);
            if (sampleListOrNull == null) continue;
            sampleListOrNull.add(sampleOrNull);
        }
    }

    private Sample tryCreateSample(SampleRecord row, Long2ObjectMap<Experiment> experimentsById, boolean primarySample) {
        Sample sample = new Sample();
        sample.setId(row.id);
        sample.setPermId(row.perm_id);
        sample.setVersion(row.version);
        sample.setCode(IdentifierHelper.convertCode(row.code, null));
        sample.setSubCode(IdentifierHelper.convertSubCode(row.code));
        sample.setSampleType((SampleType)this.sampleTypes.get(row.saty_id));
        if (row.proj_id != null) {
            Project project = this.getOrCreateProject(row);
            this.setProject(sample, project);
            this.setSpace(sample, project.getSpace());
        } else if (row.space_id == null) {
            this.setDatabaseInstance(sample);
        } else {
            Space spaceOrNull = (Space)this.spaceMap.get((Object)row.space_id);
            if (spaceOrNull != null) {
                this.setSpace(sample, (Space)this.spaceMap.get((Object)row.space_id));
            } else {
                return null;
            }
        }
        this.enrichWithDeletion(sample, row);
        if (primarySample || this.enrichDependentSamples) {
            sample.setProperties(new ArrayList<IEntityProperty>());
            sample.setPermlink(PermlinkUtilities.createPermlinkURL(this.baseIndexURL, EntityKind.SAMPLE, row.perm_id));
            sample.setRegistrationDate(row.registration_timestamp);
            sample.setModificationDate(row.modification_timestamp);
            sample.setRegistrator(this.getOrCreateActor(row.pers_id_registerer));
            sample.setModifier(this.getOrCreateActor(row.pers_id_modifier));
            if (row.expe_id != null) {
                sample.setExperiment((Experiment)experimentsById.get((Object)row.expe_id));
            }
        }
        if (this.maxSampleParentResolutionDepth > 0 && !this.idsOfSamplesAwaitingParentResolution.contains(row.id)) {
            this.idsOfSamplesAwaitingParentResolution.add(row.id);
        }
        if (row.samp_id_part_of != null) {
            if (!this.samplesAwaitingContainerResolution.containsKey(row.id)) {
                this.samplesAwaitingContainerResolution.put(row.id, (Object)new RelatedSampleRecord(sample, row.samp_id_part_of));
            }
            this.addRelatedContainerSampleToRequested(row.samp_id_part_of);
        }
        return sample;
    }

    private void enrichWithDeletion(Sample sample, SampleRecord row) {
        if (row.del_id != null) {
            Deletion deletion = new Deletion();
            sample.setDeletion(deletion);
        }
    }

    private void setProject(Sample sample, Project project) {
        sample.setProject(project);
        sample.setSpace(project.getSpace());
        sample.setIdentifier(IdentifierHelper.createSampleIdentifier(sample).toString());
    }

    private void setSpace(Sample sample, Space space) {
        sample.setSpace(space);
        sample.setIdentifier(IdentifierHelper.createSampleIdentifier(sample).toString());
    }

    private void setDatabaseInstance(Sample sample) {
        sample.setIdentifier(IdentifierHelper.createSampleIdentifier(sample).toString());
    }

    private void addRelatedContainerSampleToRequested(long containerId) {
        this.idsOfRequestedContainerSamples.add(containerId);
    }

    private void addRelatedParentSampleToRequested(long parentId) {
        this.idsOfRequestedParentSamples.add(parentId);
    }

    private Project getOrCreateProject(SampleRecord row) {
        Project project = (Project)this.projects.get((Object)row.proj_id);
        if (project == null) {
            project = this.createAndSaveProject(row.proj_id);
        }
        return project;
    }

    private void retrieveDependentSamplesRecursively(boolean primary) {
        if (primary) {
            this.addParentsToRequested();
        }
        this.idsOfRequestedContainerSamples.removeAll((LongCollection)this.sampleMap.keySet());
        this.idsOfRequestedParentSamples.removeAll((LongCollection)this.sampleMap.keySet());
        if (this.idsOfRequestedContainerSamples.size() + this.idsOfRequestedParentSamples.size() == 0) {
            return;
        }
        this.retrieveDependentBasicSamples((Iterable<SampleRecord>)this.query.getSamples(this.idsOfRequestedContainerSamples));
        this.retrieveDependentBasicSamples((Iterable<SampleRecord>)this.query.getSamples(this.idsOfRequestedParentSamples));
        this.retrieveDependentSamplesRecursively(false);
    }

    private void addParentsToRequested() {
        DataIterator<SampleRelationRecord> parentRelations = this.query.getParentRelations(this.parentRelationhipTypeId, this.idsOfSamplesAwaitingParentResolution);
        for (SampleRelationRecord relation : parentRelations) {
            this.samplesAwaitingParentResolution.add(new RelatedSampleRecord((Sample)this.sampleMap.get(relation.sample_id_child), relation.sample_id_parent));
            this.addRelatedParentSampleToRequested(relation.sample_id_parent);
        }
    }

    private void resolveParents() {
        for (RelatedSampleRecord record : this.samplesAwaitingParentResolution) {
            Sample parent = (Sample)this.sampleMap.get(record.relatedSampleId);
            record.sample.addParent(parent);
        }
    }

    private void resolveContainers() {
        for (Long2ObjectMap.Entry e : this.samplesAwaitingContainerResolution.long2ObjectEntrySet()) {
            RelatedSampleRecord record = (RelatedSampleRecord)e.getValue();
            Sample container = (Sample)this.sampleMap.get(record.relatedSampleId);
            record.sample.setContainer(container);
            record.sample.setCode(IdentifierHelper.convertCode(record.sample.getSubCode(), container.getCode()));
            record.sample.setIdentifier(IdentifierHelper.createSampleIdentifier(record.sample).toString());
        }
    }

    private static class RelatedSampleRecord {
        Sample sample;
        long relatedSampleId;

        RelatedSampleRecord(Sample sample, long relatedSampleId) {
            this.sample = sample;
            this.relatedSampleId = relatedSampleId;
        }
    }
}

