/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.business.bo.util;

import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.lang3.StringUtils;

public class DataSetTypeWithoutExperimentChecker {
    public static final String PROPERTY_KEY = "data-set-types-with-no-experiment-needed";
    private final String regularExpressions;
    private List<Pattern> patternsForDataSetTypesWithoutExperiment = new ArrayList<Pattern>();

    public DataSetTypeWithoutExperimentChecker(Properties properties) {
        this(properties.getProperty(PROPERTY_KEY));
    }

    public DataSetTypeWithoutExperimentChecker(String regularExpressions) {
        this.regularExpressions = regularExpressions;
        if (StringUtils.isNotBlank((CharSequence)regularExpressions)) {
            String[] splittedRegexes;
            for (String regex : splittedRegexes = regularExpressions.split(",")) {
                try {
                    this.patternsForDataSetTypesWithoutExperiment.add(Pattern.compile(regex.trim()));
                }
                catch (PatternSyntaxException ex) {
                    throw new ConfigurationFailureException("Invalid regular expression in property 'data-set-types-with-no-experiment-needed': " + regex, (Throwable)ex);
                }
            }
        }
    }

    public String getRegularExpressions() {
        return this.regularExpressions;
    }

    public boolean isDataSetTypeWithoutExperiment(String dataSetTypeCode) {
        for (Pattern pattern : this.patternsForDataSetTypesWithoutExperiment) {
            if (!pattern.matcher(dataSetTypeCode).matches()) continue;
            return true;
        }
        return false;
    }
}

