/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.business.bo.util;

import ch.systemsx.cisd.openbis.generic.server.business.bo.datasetlister.IDatasetLister;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDataDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IRelationshipTypeDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.RelationshipUtils;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DataSetUtils {
    public static List<TechId> getAllDeletableComponentsRecursively(List<TechId> dataSetIds, boolean isOriginalDeletion, IDatasetLister datasetLister, IDAOFactory daoFactory) {
        HashSet dataSetIdsAsSet = new HashSet(TechId.asLongs(dataSetIds));
        Set<TechId> allIds = DataSetUtils.getAllPotentiallyDeletableComponentsRecursively(dataSetIds, daoFactory);
        if (allIds.isEmpty()) {
            return new ArrayList<TechId>();
        }
        List allIdsAsLongs = TechId.asLongs(allIds);
        Map<Long, Set<Long>> containerIds = datasetLister.listContainerIds(allIdsAsLongs);
        for (Long id : allIdsAsLongs) {
            if (containerIds.containsKey(id) && (!isOriginalDeletion || !dataSetIdsAsSet.contains(id))) continue;
            containerIds.put(id, Collections.emptySet());
        }
        List<Vertex> graph = DataSetUtils.createGraph(containerIds);
        ArrayList<TechId> result = new ArrayList<TechId>();
        for (Vertex vertex : graph) {
            if (!vertex.isInsideAndAllAncestorContainersAreInside()) continue;
            result.add(new TechId(vertex.id));
        }
        return result;
    }

    private static Set<TechId> getAllPotentiallyDeletableComponentsRecursively(List<TechId> dataSetIds, IDAOFactory daoFactory) {
        IRelationshipTypeDAO relationshipTypeDAO = daoFactory.getRelationshipTypeDAO();
        Long relationshipTypeId = RelationshipUtils.getContainerComponentRelationshipType(relationshipTypeDAO).getId();
        IDataDAO dataDAO = daoFactory.getDataDAO();
        LinkedHashSet<TechId> allIds = new LinkedHashSet<TechId>();
        Set<TechId> containedDataSetIds = new LinkedHashSet<TechId>();
        containedDataSetIds.addAll(dataSetIds);
        while (allIds.addAll(containedDataSetIds)) {
            containedDataSetIds = dataDAO.findChildrenIds(containedDataSetIds, relationshipTypeId);
        }
        return allIds;
    }

    private static List<Vertex> createGraph(Map<Long, Set<Long>> containerIdsByComponentIds) {
        LinkedHashMap<Long, Vertex> verticesById = new LinkedHashMap<Long, Vertex>();
        Set<Long> componentIds = containerIdsByComponentIds.keySet();
        Set<Map.Entry<Long, Set<Long>>> entrySet = containerIdsByComponentIds.entrySet();
        for (Map.Entry<Long, Set<Long>> entry : entrySet) {
            Long componentId = entry.getKey();
            Vertex componentVertex = DataSetUtils.getOrCreateVertex(componentId, componentIds, verticesById);
            Set<Long> containerIds = entry.getValue();
            for (Long containerId : containerIds) {
                Vertex containerVertex = DataSetUtils.getOrCreateVertex(containerId, componentIds, verticesById);
                componentVertex.addContainer(containerVertex);
            }
        }
        ArrayList<Vertex> graph = new ArrayList<Vertex>(verticesById.values());
        Collections.sort(graph);
        return graph;
    }

    private static Vertex getOrCreateVertex(Long id, Set<Long> componentIds, Map<Long, Vertex> verticesById) {
        Vertex vertex = verticesById.get(id);
        if (vertex == null) {
            vertex = new Vertex(id, componentIds.contains(id));
            verticesById.put(id, vertex);
        }
        return vertex;
    }

    private static final class Vertex
    implements Comparable<Vertex> {
        private final Long id;
        private final boolean inside;
        private Set<Vertex> containers = new HashSet<Vertex>();

        Vertex(Long id, boolean inside) {
            this.id = id;
            this.inside = inside;
        }

        boolean isInsideAndAllAncestorContainersAreInside() {
            if (!this.inside) {
                return false;
            }
            for (Vertex container : this.containers) {
                if (container.isInsideAndAllAncestorContainersAreInside()) continue;
                return false;
            }
            return true;
        }

        void addContainer(Vertex container) {
            this.containers.add(container);
        }

        @Override
        public int compareTo(Vertex v) {
            return this.id.intValue() - v.id.intValue();
        }
    }
}

