/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.business.bo.util;

import ch.systemsx.cisd.openbis.generic.shared.dto.ProjectPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SpacePE;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public final class SampleOwner {
    private ProjectPE projectOrNull;
    private SpacePE spaceOrNull;

    public SampleOwner(ProjectPE projectOrNull) {
        this.projectOrNull = projectOrNull;
        if (projectOrNull != null) {
            this.spaceOrNull = projectOrNull.getSpace();
        }
    }

    public SampleOwner(SpacePE spaceOrNull) {
        this.spaceOrNull = spaceOrNull;
    }

    public static SampleOwner createProject(ProjectPE project) {
        return new SampleOwner(project);
    }

    public static SampleOwner createSpace(SpacePE group) {
        return new SampleOwner(group);
    }

    public static SampleOwner createDatabaseInstance() {
        return new SampleOwner((SpacePE)null);
    }

    public boolean isProjectLevel() {
        return this.projectOrNull != null;
    }

    public boolean isSpaceLevel() {
        return this.projectOrNull == null && this.spaceOrNull != null;
    }

    public boolean isDatabaseInstanceLevel() {
        return this.projectOrNull == null && this.spaceOrNull == null;
    }

    public ProjectPE tryGetProject() {
        return this.projectOrNull;
    }

    public SpacePE tryGetSpace() {
        return this.spaceOrNull;
    }

    public String toString() {
        if (this.isProjectLevel()) {
            return "project: " + this.projectOrNull;
        }
        if (this.isSpaceLevel()) {
            return "space: " + this.spaceOrNull;
        }
        return "db instance";
    }

    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SampleOwner)) {
            return false;
        }
        SampleOwner that = (SampleOwner)obj;
        EqualsBuilder builder = new EqualsBuilder();
        builder.append((Object)this.projectOrNull, (Object)that.tryGetProject());
        builder.append((Object)this.spaceOrNull, (Object)that.tryGetSpace());
        return builder.isEquals();
    }

    public final int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.projectOrNull);
        builder.append((Object)this.spaceOrNull);
        return builder.toHashCode();
    }
}

