/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.business.bo.util;

import ch.systemsx.cisd.common.exceptions.InternalErr;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.server.business.bo.util.SampleOwner;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IAuthorizationDAOFactory;
import ch.systemsx.cisd.openbis.generic.server.util.SpaceIdentifierHelper;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ProjectPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SpacePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.exception.UndefinedSpaceException;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleOwnerIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SpaceIdentifier;

public class SampleOwnerFinder {
    private final IAuthorizationDAOFactory daoFactory;
    private final PersonPE personPE;

    public SampleOwnerFinder(IAuthorizationDAOFactory daoFactory, PersonPE personPE) {
        assert (daoFactory != null) : "Unspecified DAOFactory";
        assert (personPE != null) : "Unspecified person";
        this.daoFactory = daoFactory;
        this.personPE = personPE;
    }

    public SampleOwner figureSampleOwner(SampleOwnerIdentifier owner) {
        SampleOwner ownerId = this.tryFigureSampleOwner(owner);
        if (ownerId == null) {
            throw UserFailureException.fromTemplate((String)"Incorrect space or database name in '%s'", (Object[])new Object[]{owner});
        }
        return ownerId;
    }

    public SampleOwner tryFigureSampleOwner(SampleOwnerIdentifier owner) {
        if (owner.isDatabaseInstanceLevel()) {
            return this.tryFigureSampleDatabaseOwner();
        }
        if (owner.isSpaceLevel()) {
            return this.tryFigureSampleGroupOwner(owner);
        }
        if (owner.isProjectLevel()) {
            return this.tryFigureSampleProjectOwner(owner);
        }
        throw InternalErr.error();
    }

    private SampleOwner tryFigureSampleProjectOwner(SampleOwnerIdentifier owner) {
        ProjectPE project = SpaceIdentifierHelper.tryGetProject(owner.getProjectLevel(), this.personPE, this.daoFactory);
        return project == null ? null : SampleOwner.createProject(project);
    }

    private SampleOwner tryFigureSampleGroupOwner(SampleOwnerIdentifier owner) {
        if (owner.isInsideHomeSpace()) {
            return this.createHomeGroupOwner(owner);
        }
        SpaceIdentifier spaceIdentifier = owner.getSpaceLevel();
        return this.tryFindAbsoluteGroupOwner(spaceIdentifier);
    }

    private SampleOwner tryFigureSampleDatabaseOwner() {
        return SampleOwner.createDatabaseInstance();
    }

    private SampleOwner tryFindAbsoluteGroupOwner(SpaceIdentifier spaceIdentifier) {
        SpacePE group = SpaceIdentifierHelper.tryGetSpace(spaceIdentifier, this.personPE, this.daoFactory);
        if (group == null) {
            return null;
        }
        return SampleOwner.createSpace(group);
    }

    private SampleOwner createHomeGroupOwner(SampleOwnerIdentifier identifier) {
        SpacePE homeGroup = this.personPE.getHomeSpace();
        if (homeGroup == null) {
            throw new UndefinedSpaceException();
        }
        return SampleOwner.createSpace(homeGroup);
    }
}

