/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.business.bo.util;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ProjectPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SamplePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SpacePE;

public class SampleUtils {
    public static void setSamplesSpace(ExperimentPE experiment, SpacePE space) {
        for (SamplePE sample : experiment.getSamples()) {
            if (sample.getSpace() == null) continue;
            sample.setSpace(space);
        }
    }

    public static UserFailureException createWrongSampleException(DataPE data, SamplePE sample, String reason) {
        return UserFailureException.fromTemplate((String)"The dataset '%s' cannot be connected to the sample '%s' because %s.", (Object[])new Object[]{data.getCode(), sample == null ? "?" : sample.getIdentifier(), reason});
    }

    public static void assertProjectSamplesEnabled(SamplePE samplePE, ProjectPE project) {
        if (!SamplePE.projectSamplesEnabled) {
            throw new UserFailureException("Can not assign sample " + samplePE.getIdentifier() + " to project " + project.getIdentifier() + " because project samples are not enabled.");
        }
    }
}

