/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.business.search;

import ch.systemsx.cisd.openbis.generic.server.business.bo.datasetlister.IDatasetLister;
import ch.systemsx.cisd.openbis.generic.server.business.search.AbstractSearchManager;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IHibernateSearchDAO;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetAttributeSearchFieldKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DetailedSearchCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DetailedSearchCriterion;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DetailedSearchField;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DetailedSearchSubCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.translator.DtoConverters;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.dao.DataAccessException;

public class DataSetSearchManager
extends AbstractSearchManager<IDatasetLister> {
    private final AbstractSearchManager.IRelationshipHandler CHILDREN_RELATIONSHIP_HANDLER = new AbstractSearchManager.IRelationshipHandler(){

        @Override
        public Collection<Long> findRelatedIdsByCriteria(String userId, DetailedSearchCriteria criteria, List<DetailedSearchSubCriteria> otherSubCriterias) {
            return DataSetSearchManager.this.findDataSetIds(userId, criteria, otherSubCriterias);
        }

        @Override
        public Map<Long, Set<Long>> listIdsToRelatedIds(Collection<Long> dataSetIds) {
            return ((IDatasetLister)DataSetSearchManager.this.lister).listChildrenIds(dataSetIds);
        }

        @Override
        public Map<Long, Set<Long>> listRelatedIdsToIds(Collection<Long> childrenDataSetIds) {
            return ((IDatasetLister)DataSetSearchManager.this.lister).listParentIds(childrenDataSetIds);
        }
    };
    private final AbstractSearchManager.IRelationshipHandler PARENT_RELATIONSHIP_HANDLER = new AbstractSearchManager.IRelationshipHandler(){

        @Override
        public Collection<Long> findRelatedIdsByCriteria(String userId, DetailedSearchCriteria criteria, List<DetailedSearchSubCriteria> otherSubCriterias) {
            return DataSetSearchManager.this.findDataSetIds(userId, criteria, otherSubCriterias);
        }

        @Override
        public Map<Long, Set<Long>> listIdsToRelatedIds(Collection<Long> dataSetIds) {
            return ((IDatasetLister)DataSetSearchManager.this.lister).listParentIds(dataSetIds);
        }

        @Override
        public Map<Long, Set<Long>> listRelatedIdsToIds(Collection<Long> parentDataSetIds) {
            return ((IDatasetLister)DataSetSearchManager.this.lister).listChildrenIds(parentDataSetIds);
        }
    };
    private final AbstractSearchManager.IRelationshipHandler CONTAINER_RELATIONSHIP_HANDLER = new AbstractSearchManager.IRelationshipHandler(){

        @Override
        public Collection<Long> findRelatedIdsByCriteria(String userId, DetailedSearchCriteria criteria, List<DetailedSearchSubCriteria> otherSubCriterias) {
            return DataSetSearchManager.this.findDataSetIds(userId, criteria, otherSubCriterias);
        }

        @Override
        public Map<Long, Set<Long>> listIdsToRelatedIds(Collection<Long> dataSetIds) {
            return ((IDatasetLister)DataSetSearchManager.this.lister).listContainerIds(dataSetIds);
        }

        @Override
        public Map<Long, Set<Long>> listRelatedIdsToIds(Collection<Long> parentDataSetIds) {
            return ((IDatasetLister)DataSetSearchManager.this.lister).listComponetIds(parentDataSetIds);
        }
    };

    public DataSetSearchManager(IHibernateSearchDAO searchDAO, IDatasetLister lister) {
        super(searchDAO, lister);
    }

    public List<AbstractExternalData> searchForDataSets(String userId, DetailedSearchCriteria criteria) throws DataAccessException {
        return ((IDatasetLister)this.lister).listByDatasetIds(this.searchForDataSetIds(userId, criteria));
    }

    public Collection<Long> searchForDataSetIds(String userId, DetailedSearchCriteria criteria) {
        DetailedSearchCriteria parentCriteria = new DetailedSearchCriteria();
        DetailedSearchCriteria childCriteria = new DetailedSearchCriteria();
        DetailedSearchCriteria containerCriteria = new DetailedSearchCriteria();
        ArrayList<DetailedSearchSubCriteria> otherSubCriterias = new ArrayList<DetailedSearchSubCriteria>();
        this.groupDataSetSubCriteria(criteria.getSubCriterias(), parentCriteria, childCriteria, containerCriteria, otherSubCriterias);
        boolean hasMainCriteria = false == criteria.getCriteria().isEmpty() || false == otherSubCriterias.isEmpty();
        boolean hasParentCriteria = false == parentCriteria.isEmpty();
        boolean hasChildCriteria = false == childCriteria.isEmpty();
        boolean hasContainerCriteria = false == containerCriteria.isEmpty();
        Collection<Long> dataSetIds = null;
        if (!(!hasMainCriteria && (hasMainCriteria || hasParentCriteria || hasChildCriteria || hasContainerCriteria) || (dataSetIds = this.findDataSetIds(userId, criteria, otherSubCriterias)) != null)) {
            dataSetIds = Collections.emptyList();
        }
        if (hasParentCriteria) {
            dataSetIds = this.filterSearchResultsBySubcriteria(userId, dataSetIds, parentCriteria, this.PARENT_RELATIONSHIP_HANDLER);
        }
        if (hasChildCriteria) {
            dataSetIds = this.filterSearchResultsBySubcriteria(userId, dataSetIds, childCriteria, this.CHILDREN_RELATIONSHIP_HANDLER);
        }
        if (hasContainerCriteria) {
            dataSetIds = this.filterSearchResultsBySubcriteria(userId, dataSetIds, containerCriteria, this.CONTAINER_RELATIONSHIP_HANDLER);
        }
        Collection<Long> result = this.restrictResultSetIfNecessary(dataSetIds);
        return result;
    }

    private List<Long> findDataSetIds(String userId, DetailedSearchCriteria criteria, List<DetailedSearchSubCriteria> otherSubCriterias) {
        if (criteria.getCriteria().isEmpty() && otherSubCriterias.isEmpty()) {
            criteria.getCriteria().add(new DetailedSearchCriterion(DetailedSearchField.createAttributeField(DataSetAttributeSearchFieldKind.CODE), "*"));
        }
        List<Long> dataSetIds = this.searchDAO.searchForEntityIds(userId, criteria, DtoConverters.convertEntityKind(EntityKind.DATA_SET));
        return dataSetIds;
    }

    private void groupDataSetSubCriteria(List<DetailedSearchSubCriteria> allSubCriterias, DetailedSearchCriteria parentCriteria, DetailedSearchCriteria childCriteria, DetailedSearchCriteria containerCriteria, List<DetailedSearchSubCriteria> otherSubCriterias) {
        parentCriteria.setCriteria(new ArrayList<DetailedSearchCriterion>());
        childCriteria.setCriteria(new ArrayList<DetailedSearchCriterion>());
        containerCriteria.setCriteria(new ArrayList<DetailedSearchCriterion>());
        block5: for (DetailedSearchSubCriteria subCriteria : allSubCriterias) {
            switch (subCriteria.getTargetEntityKind()) {
                case DATA_SET_PARENT: {
                    this.mergeSubCriteria(parentCriteria, subCriteria);
                    continue block5;
                }
                case DATA_SET_CHILD: {
                    this.mergeSubCriteria(childCriteria, subCriteria);
                    continue block5;
                }
                case DATA_SET_CONTAINER: {
                    this.mergeSubCriteria(containerCriteria, subCriteria);
                    continue block5;
                }
            }
            otherSubCriterias.add(subCriteria);
        }
    }
}

