/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.business.search.sort;

import ch.systemsx.cisd.openbis.generic.server.business.search.sort.IEntitySearchResult;
import ch.systemsx.cisd.openbis.generic.server.business.search.sort.ISearchResultSorter;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DetailedSearchCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DetailedSearchCriterion;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;

public class SearchResultSorterByScore
implements ISearchResultSorter {
    @Override
    public void sort(List<? extends IEntitySearchResult> entitiesToSort, DetailedSearchCriteria criteria) {
        if (criteria == null || criteria.getCriteria() == null || criteria.getCriteria().isEmpty()) {
            return;
        }
        ArrayList<Pattern> partialMatchTerms = new ArrayList<Pattern>();
        ArrayList<String> exactMatchTerms = new ArrayList<String>();
        ArrayList<Boost> boosts = new ArrayList<Boost>();
        for (DetailedSearchCriterion criterion : criteria.getCriteria()) {
            String[] stringArray;
            partialMatchTerms.add(this.getPartialMatchTerm(criterion.getValue()));
            exactMatchTerms.add(this.getExactMatchTerm(criterion.getValue()));
            boosts.add(this.getBoostForCriterion(criterion, 10));
            for (String splitIndex : stringArray = criterion.getValue().replace("*", " ").replace("?", " ").replaceAll("\\s+", " ").trim().split(" ")) {
                partialMatchTerms.add(this.getPartialMatchTerm(splitIndex));
                exactMatchTerms.add(this.getExactMatchTerm(splitIndex));
                boosts.add(this.getBoostForCriterion(criterion, 1));
            }
        }
        final HashMap<IEntitySearchResult, Integer> scores = new HashMap<IEntitySearchResult, Integer>();
        for (IEntitySearchResult iEntitySearchResult : entitiesToSort) {
            int score = this.getScore(iEntitySearchResult, partialMatchTerms, exactMatchTerms, boosts);
            scores.put(iEntitySearchResult, score);
        }
        Collections.sort(entitiesToSort, new Comparator<IEntitySearchResult>(){

            @Override
            public int compare(IEntitySearchResult o1, IEntitySearchResult o2) {
                Integer score2;
                Integer score1 = (Integer)scores.get(o1);
                int result = -score1.compareTo(score2 = (Integer)scores.get(o2));
                if (result == 0) {
                    return o1.getCode().compareTo(o2.getCode());
                }
                return result;
            }
        });
    }

    private int getScore(IEntitySearchResult entity, List<Pattern> partialMatchTerms, List<String> exactMatchTerms, List<Boost> boosts) {
        int score = 0;
        for (int i = 0; i < exactMatchTerms.size(); ++i) {
            Pattern partialTerm = partialMatchTerms.get(i);
            String exactTerm = exactMatchTerms.get(i);
            Boost boost = boosts.get(i);
            if (this.isPartialMatch(entity.getCode(), partialTerm)) {
                score += 100000 * boost.getCodeBoost();
                if (this.isExactMatch(entity.getCode(), exactTerm)) {
                    score += 1000000 * boost.getCodeBoost();
                }
            }
            if (this.isExactMatch(entity.getTypeCode(), exactTerm)) {
                score += 1000 * boost.getTypeCodeBoost();
            }
            if (entity.getProperties() == null || entity.getProperties().keySet() == null) continue;
            for (String propertykey : entity.getProperties().keySet()) {
                String propertyValue = entity.getProperties().get(propertykey);
                if (!this.isPartialMatch(propertyValue, partialTerm)) continue;
                score += 100 * boost.getPropertyBoost(propertykey);
                if (!this.isExactMatch(propertyValue, exactTerm)) continue;
                score += 10000 * boost.getPropertyBoost(propertykey);
            }
        }
        return score;
    }

    public Boost getBoostForCriterion(DetailedSearchCriterion criterion, int boost) {
        switch (criterion.getField().getKind()) {
            case ANY_FIELD: {
                return new Boost(boost, boost, boost, boost, null);
            }
            case ANY_PROPERTY: {
                return new Boost(0, 0, boost, boost, null);
            }
            case PROPERTY: {
                return new Boost(0, 0, 0, boost, criterion.getField().getPropertyCode());
            }
            case ATTRIBUTE: {
                if (criterion.getField().getAttributeCode().equalsIgnoreCase("code")) {
                    return new Boost(boost, 0, 0, 0, null);
                }
                if (criterion.getField().getAttributeCode().equalsIgnoreCase("sample_type") || criterion.getField().getAttributeCode().equalsIgnoreCase("data_set_type") || criterion.getField().getAttributeCode().equalsIgnoreCase("material_type") || criterion.getField().getAttributeCode().equalsIgnoreCase("experiment_type")) {
                    return new Boost(0, boost, 0, 0, null);
                }
                return new Boost(boost, boost, boost, boost, null);
            }
            case REGISTRATOR: {
                return new Boost(boost, boost, boost, boost, null);
            }
        }
        return new Boost(boost, boost, boost, boost, null);
    }

    public Pattern getPartialMatchTerm(String term) {
        return Pattern.compile(("*" + term + "*").replace("*", ".*").replace("?", ".?"), 2);
    }

    public String getExactMatchTerm(String term) {
        return term.replace("*", "").replace("?", "");
    }

    public boolean isExactMatch(String value, String term) {
        if (value != null && term != null) {
            return value.equalsIgnoreCase(term);
        }
        return false;
    }

    public boolean isPartialMatch(String value, Pattern pattern) {
        if (value != null && pattern != null) {
            return pattern.matcher(value).matches();
        }
        return false;
    }

    private static class Boost {
        private int codeBoost;
        private int typeCodeBoost;
        private int propertyBoost;
        private int propertyDefaultBoost;
        private String propertyName;

        public Boost(int codeBoost, int typeCodeBoost, int propertyDefaultBoost, int propertyBoost, String propertyName) {
            this.codeBoost = codeBoost;
            this.typeCodeBoost = typeCodeBoost;
            this.propertyDefaultBoost = propertyDefaultBoost;
            this.propertyBoost = propertyBoost;
            this.propertyName = propertyName;
        }

        public int getCodeBoost() {
            return this.codeBoost;
        }

        public int getTypeCodeBoost() {
            return this.typeCodeBoost;
        }

        public int getPropertyBoost(String propertyNameToBoost) {
            if (this.propertyName != null && this.propertyName.equals(propertyNameToBoost)) {
                return this.propertyBoost;
            }
            return this.propertyDefaultBoost;
        }
    }
}

